/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import com.astrolink.CanvasGame;
import com.astrolink.Common;
import com.astrolink.MidletPuzzle;
import com.astrolink.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

class CanvasMenu
extends Canvas {
    public int state;
    public static final int MENU = 0;
    public static final int HELP = 1;
    public static final int ABOUT = 2;
    public static final int SETTING = 3;
    public static final int MODE = 4;
    public static final String NAME_GAME = "puzzle";
    public int numMenu;
    public int numGameMenu;
    public int indexMenu;
    public int indexMode;
    public int widthFocus;
    public int heightFocus;
    public int heightTitle;
    public int titleX;
    public int menuX;
    public int menuY;
    public int completeX;
    public int completeY;
    public static boolean isPassLevel;
    public static int curMode;
    public static boolean[] completeMode;
    public static boolean hasMusic;
    public static int typeTheme;
    public int indexSelectSetting;
    public int lastIndexSelectSetting;
    int numSetting = 4;
    int widthSelectSetting;
    int distanceMenu;

    public CanvasMenu() {
        this.setFullScreenMode(true);
        CanvasMenu.setMode();
        this.numMenu = ResourceManager.imgMenu.length;
        this.numGameMenu = ResourceManager.imgGameMenu.length;
        this.distanceMenu = Common.HEIGHT / (this.numMenu + 1);
        this.widthFocus = ResourceManager.imgFocus.getWidth();
        this.heightFocus = ResourceManager.imgFocus.getHeight();
        this.heightTitle = ResourceManager.imgGameTitle.getHeight();
        this.menuX = Common.HALF_WIDTH;
        this.menuY = this.distanceMenu;
        this.completeX = Common.WIDTH + this.widthFocus + ResourceManager.imgCompleted.getWidth() >>> 1;
        this.completeY = this.menuY;
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, Common.WIDTH, Common.HEIGHT);
        try {
            g.drawImage(ResourceManager.imgBackground, 0, 0, 20);
            switch (this.state) {
                case 0: {
                    for (int i = 0; i < this.numMenu; ++i) {
                        g.drawImage(ResourceManager.imgMenu[i], this.menuX, this.menuY + i * this.distanceMenu, 3);
                    }
                    g.drawImage(ResourceManager.imgFocus, this.menuX, this.menuY + this.indexMenu * this.distanceMenu, 3);
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.numGameMenu; ++i) {
                        if (Common.PASS_MODE[i]) {
                            if (completeMode[i]) {
                                g.drawImage(ResourceManager.imgCompleted, this.completeX, this.completeY + i * this.distanceMenu, 3);
                            }
                            g.drawImage(ResourceManager.imgGameMenuFocus[i], this.menuX, this.menuY + i * this.distanceMenu, 3);
                            g.drawImage(ResourceManager.imgLight, this.menuX, this.menuY + i * this.distanceMenu, 3);
                            continue;
                        }
                        g.drawImage(ResourceManager.imgGameMenu[i], this.menuX, this.menuY + i * this.distanceMenu, 3);
                        g.drawImage(ResourceManager.imgShade, this.menuX, this.menuY + i * this.distanceMenu, 3);
                    }
                    g.drawImage(ResourceManager.imgFocus, this.menuX, this.menuY + this.indexMode * this.distanceMenu, 3);
                    g.drawImage(ResourceManager.imgBack, Common.WIDTH, Common.HEIGHT, 40);
                    break;
                }
                case 1: {
                    g.drawImage(ResourceManager.imgHelp, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                    g.drawImage(ResourceManager.imgBack, Common.WIDTH, Common.HEIGHT, 40);
                    break;
                }
                case 2: {
                    g.drawImage(ResourceManager.imgAbout, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                    g.drawImage(ResourceManager.imgBack, Common.WIDTH, Common.HEIGHT, 40);
                    break;
                }
                case 3: {
                    g.drawImage(ResourceManager.imgSetting, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                    g.drawImage(ResourceManager.imgOK, 0, Common.HEIGHT, 36);
                    g.drawImage(ResourceManager.imgBack, Common.WIDTH, Common.HEIGHT, 40);
                    g.drawImage(ResourceManager.imgFocusSetting, Common.X_SETTING[this.indexSelectSetting], Common.Y_SETTING[this.indexSelectSetting], 20);
                    if (!hasMusic) break;
                    g.drawImage(ResourceManager.imgSelectSetting, Common.X_SETTING[0], Common.Y_SETTING[0], 20);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean pointArea(int pointX, int pointY, int x, int y, int width, int height) {
        boolean isIn = false;
        if (pointX >= x && pointX <= x + width && pointY >= y && pointY <= y + height) {
            isIn = true;
        }
        return isIn;
    }

    protected void pointerReleased(int x, int y) {
        switch (this.state) {
            case 4: {
                if (CanvasMenu.pointArea(x, y, Common.WIDTH - 50, Common.HEIGHT - 50, 50, 50)) {
                    this.keyReleased(Common.KEY_SOFT_RIGHT);
                    break;
                }
                int index = (y + this.distanceMenu / 2) / this.distanceMenu - 1;
                if (index < 0) {
                    index = 0;
                }
                if (!Common.PASS_MODE[index]) break;
                this.indexMode = index;
                this.repaint();
                this.keyReleased(Common.KEY_FIRE);
                break;
            }
            case 0: {
                this.indexMenu = (y + this.distanceMenu / 2) / this.distanceMenu - 1;
                if (this.indexMenu < 0) {
                    this.indexMenu = 0;
                }
                this.repaint();
                this.keyReleased(Common.KEY_FIRE);
                break;
            }
            case 1: 
            case 2: {
                this.keyReleased(Common.KEY_SOFT_RIGHT);
                break;
            }
            case 3: {
                if (CanvasMenu.pointArea(x, y, Common.WIDTH - 50, Common.HEIGHT - 50, 50, 50)) {
                    this.keyReleased(Common.KEY_SOFT_RIGHT);
                    break;
                }
                if (CanvasMenu.pointArea(x, y, 0, Common.HEIGHT - 50, 50, 50)) {
                    this.keyReleased(Common.KEY_SOFT_LEFT);
                    break;
                }
                if (CanvasMenu.pointArea(x, y, Common.X_SETTING[0], Common.Y_SETTING[0], this.widthSelectSetting, this.widthSelectSetting)) {
                    this.indexSelectSetting = 0;
                    this.keyReleased(Common.KEY_FIRE);
                    break;
                }
                if (CanvasMenu.pointArea(x, y, Common.X_SETTING[1], Common.Y_SETTING[1], this.widthSelectSetting, this.widthSelectSetting)) {
                    this.indexSelectSetting = 1;
                    this.keyReleased(Common.KEY_FIRE);
                    break;
                }
                if (CanvasMenu.pointArea(x, y, Common.X_SETTING[2], Common.Y_SETTING[2], this.widthSelectSetting, this.widthSelectSetting)) {
                    this.indexSelectSetting = 2;
                    this.keyReleased(Common.KEY_FIRE);
                    break;
                }
                if (!CanvasMenu.pointArea(x, y, Common.X_SETTING[3], Common.Y_SETTING[3], this.widthSelectSetting, this.widthSelectSetting)) break;
                this.indexSelectSetting = 3;
                this.keyReleased(Common.KEY_FIRE);
            }
        }
    }

    protected void keyReleased(int key) {
        if (key == Common.KEY_UP || key == 50) {
            switch (this.state) {
                case 0: {
                    --this.indexMenu;
                    if (this.indexMenu < 0) {
                        this.indexMenu = this.numMenu - 1;
                    }
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.indexMode > 0) {
                        --this.indexMode;
                    }
                    this.repaint();
                    break;
                }
                case 3: {
                    this.repaint();
                }
            }
        } else if (key == Common.KEY_DOWN || key == 56) {
            switch (this.state) {
                case 0: {
                    ++this.indexMenu;
                    if (this.indexMenu >= this.numMenu) {
                        this.indexMenu = 0;
                    }
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.indexMode >= this.numGameMenu - 1 || !Common.PASS_MODE[this.indexMode + 1]) break;
                    ++this.indexMode;
                    this.repaint();
                    break;
                }
                case 3: {
                    this.repaint();
                }
            }
        } else if (key == Common.KEY_FIRE || key == 53) {
            block10 : switch (this.state) {
                case 0: {
                    if (hasMusic) {
                        CanvasGame.playHit();
                    }
                    switch (this.indexMenu) {
                        case 0: {
                            this.state = 4;
                            this.repaint();
                            break block10;
                        }
                        case 1: {
                            this.lastIndexSelectSetting = this.indexSelectSetting;
                            ResourceManager.loadSetting();
                            this.widthSelectSetting = ResourceManager.imgSelectSetting.getWidth();
                            this.state = 3;
                            this.repaint();
                            break block10;
                        }
                        case 2: {
                            ResourceManager.loadHelp();
                            this.state = 1;
                            this.repaint();
                            break block10;
                        }
                        case 3: {
                            ResourceManager.loadAbout();
                            this.state = 2;
                            this.repaint();
                            break block10;
                        }
                        case 4: {
                            MidletPuzzle.midlet.quitApp();
                        }
                    }
                    break;
                }
                case 4: {
                    if (hasMusic) {
                        CanvasGame.playHit();
                    }
                    curMode = this.indexMode;
                    ResourceManager.loadSelectLevel();
                    MidletPuzzle.midlet.showSelectLevel();
                    break;
                }
                case 3: {
                    if (this.indexSelectSetting == 0) {
                        hasMusic = !hasMusic;
                    } else {
                        typeTheme = this.indexSelectSetting - 1;
                    }
                    this.repaint();
                }
            }
        } else if (key == Common.KEY_SOFT_LEFT) {
            switch (this.state) {
                case 4: {
                    break;
                }
                case 3: {
                    this.state = 0;
                    CanvasMenu.saveData(NAME_GAME);
                    if (this.lastIndexSelectSetting != this.indexSelectSetting) {
                        ResourceManager.resetIsOK();
                        ResourceManager.loadMainMenu();
                    }
                    this.repaint();
                }
            }
        } else if (key == Common.KEY_SOFT_RIGHT) {
            switch (this.state) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.state = 0;
                    this.repaint();
                }
            }
        }
    }

    public static final void passLevel(int index) {
        if (!Common.PASS_LEVEL[index]) {
            Common.PASS_LEVEL[index] = true;
            CanvasMenu.saveData(NAME_GAME);
            CanvasMenu.setMode();
        }
    }

    public static final void setMode() {
        int j;
        int i;
        if (Common.PASS_MODE == null) {
            Common.PASS_MODE = new boolean[5];
        }
        for (i = 0; i < 5; ++i) {
            Common.PASS_MODE[i] = true;
        }
        completeMode = new boolean[5];
        block1: for (i = 0; i < 5; ++i) {
            CanvasMenu.completeMode[i] = true;
            for (j = 0; j < 20; ++j) {
                if (Common.PASS_LEVEL[i * 20 + j]) continue;
                CanvasMenu.completeMode[i] = false;
                continue block1;
            }
        }
        block3: for (i = 0; i < 4; ++i) {
            for (j = 0; j < 20; ++j) {
                if (Common.PASS_LEVEL[i * 20 + j]) continue;
                Common.PASS_MODE[i + 1] = false;
                continue block3;
            }
        }
    }

    public static final void saveData(String name) {
        try {
            RecordStore _Record = RecordStore.openRecordStore((String)name, (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeBoolean(hasMusic);
            dos.writeInt(typeTheme);
            for (int i = 0; i < 100; ++i) {
                dos.writeBoolean(Common.PASS_LEVEL[i]);
            }
            byte[] data = bos.toByteArray();
            if (_Record.getNumRecords() > 0) {
                _Record.setRecord(1, data, 0, data.length);
            } else {
                _Record.addRecord(data, 0, data.length);
            }
            data = null;
            dos.close();
            bos.close();
            dos = null;
            bos = null;
            _Record.closeRecordStore();
            _Record = null;
        }
        catch (Exception e) {
            System.out.println("Save Record Error!");
        }
    }

    public static final void loadData(String name) {
        try {
            RecordStore _Record = RecordStore.openRecordStore((String)name, (boolean)true);
            if (_Record.getNumRecords() > 0) {
                byte[] data = _Record.getRecord(1);
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bis);
                Common.PASS_LEVEL = new boolean[100];
                hasMusic = dis.readBoolean();
                typeTheme = dis.readInt();
                for (int i = 0; i < 100; ++i) {
                    Common.PASS_LEVEL[i] = dis.readBoolean();
                }
                data = null;
                dis.close();
                bis.close();
                dis = null;
                Object var3_4 = null;
            } else {
                Common.PASS_LEVEL = new boolean[100];
                hasMusic = true;
                typeTheme = 0;
            }
            _Record.closeRecordStore();
            _Record = null;
        }
        catch (Exception e) {
            System.out.println("Load Record Error!");
        }
    }
}

