/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLInputFormat;
import com.sun.lwuit.html.MultiComboBox;
import com.sun.lwuit.html.NamedCommand;
import com.sun.lwuit.html.OptionItem;
import com.sun.lwuit.plaf.UIManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class HTMLForm {
    private static final String DEFAULT_SUBMIT_TEXT = "Submit";
    private static final String DEFAULT_RESET_TEXT = "Clear";
    Hashtable comps = new Hashtable();
    Hashtable defaultValues = new Hashtable();
    Vector defaultCheckedButtons = new Vector();
    Vector defaultUncheckedButtons = new Vector();
    Hashtable inputFormats = new Hashtable();
    Hashtable buttonGroups = new Hashtable();
    HTMLComponent htmlC;
    String action;
    String encType;
    boolean isPostMethod;
    boolean hasSubmitButton;
    NamedCommand submitCommand;
    NamedCommand resetCommand;

    HTMLForm(HTMLComponent htmlC, String action, String method, String encType) {
        int linkProps;
        this.htmlC = htmlC;
        this.action = htmlC.convertURL(action);
        this.encType = encType;
        if (htmlC.getHTMLCallback() != null && ((linkProps = htmlC.getHTMLCallback().getLinkProperties(htmlC, this.action)) & 2) != 0) {
            this.action = null;
        }
        this.isPostMethod = method != null && method.equalsIgnoreCase("post");
        this.submitCommand = new NamedCommand(HTMLForm.getDefaultSubmitText(), this, true);
        this.resetCommand = new NamedCommand(HTMLForm.getDefaultResetText(), this, false);
    }

    static String getDefaultSubmitText() {
        return UIManager.getInstance().localize("html.submit", DEFAULT_SUBMIT_TEXT);
    }

    static String getDefaultResetText() {
        return UIManager.getInstance().localize("html.reset", DEFAULT_RESET_TEXT);
    }

    Command getSubmitCommand() {
        return this.submitCommand;
    }

    Command getResetCommand() {
        return this.resetCommand;
    }

    void setSubmitText(String text) {
        this.submitCommand.setCommandName(text);
    }

    void setResetText(String text) {
        this.resetCommand.setCommandName(text);
    }

    void addInput(String key, Object input, String defaultValue) {
        String autoVal;
        if (defaultValue != null) {
            this.defaultValues.put(input, defaultValue);
        }
        if (key == null) {
            return;
        }
        this.comps.put(key, input);
        if (this.htmlC.getHTMLCallback() != null && input instanceof TextArea && (autoVal = this.htmlC.getHTMLCallback().getAutoComplete(this.htmlC, this.action, key)) != null) {
            ((TextArea)input).setText(autoVal);
        }
    }

    void setInputFormat(TextArea ta, HTMLInputFormat inputFormat) {
        this.inputFormats.put(ta, inputFormat);
    }

    void setDefaultValue(Object input, Object defaultValue) {
        if (input != null && defaultValue != null) {
            this.defaultValues.put(input, defaultValue);
        }
    }

    void addCheckBox(String key, CheckBox cb, String value) {
        if (cb.isSelected()) {
            this.defaultCheckedButtons.addElement(cb);
        } else {
            this.defaultUncheckedButtons.addElement(cb);
        }
        if (key == null) {
            return;
        }
        Hashtable<CheckBox, String> internal = (Hashtable<CheckBox, String>)this.comps.get(key);
        if (internal == null) {
            internal = new Hashtable<CheckBox, String>();
            this.comps.put(key, internal);
        }
        internal.put(cb, value);
    }

    void addRadioButton(String key, RadioButton rb, String value) {
        if (rb.isSelected()) {
            this.defaultCheckedButtons.addElement(rb);
        } else {
            this.defaultUncheckedButtons.addElement(rb);
        }
        if (key == null) {
            return;
        }
        Hashtable<RadioButton, String> internal = (Hashtable<RadioButton, String>)this.comps.get(key);
        ButtonGroup group = null;
        if (internal == null) {
            internal = new Hashtable<RadioButton, String>();
            this.comps.put(key, internal);
            group = new ButtonGroup();
            this.buttonGroups.put(key, group);
        } else {
            group = (ButtonGroup)this.buttonGroups.get(key);
        }
        group.add(rb);
        internal.put(rb, value);
    }

    int getNumFields() {
        return this.comps.size();
    }

    void submit() {
        if (this.action == null) {
            return;
        }
        boolean error = false;
        String url = this.action;
        String params = null;
        if (this.comps.size() > 0) {
            params = "";
            Enumeration e = this.comps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object input = this.comps.get(key);
                key = this.encodeString(key);
                String value = "";
                if (input instanceof String) {
                    value = this.encodeString((String)input);
                    params = params + key + "=" + value + "&";
                    continue;
                }
                if (input instanceof Hashtable) {
                    Hashtable options = (Hashtable)input;
                    Enumeration e2 = options.keys();
                    while (e2.hasMoreElements()) {
                        Button b = (Button)e2.nextElement();
                        if (!b.isSelected()) continue;
                        params = params + key + "=" + this.encodeString((String)options.get(b)) + "&";
                    }
                    continue;
                }
                if (input instanceof TextArea) {
                    TextArea tf = (TextArea)input;
                    String text = tf.getText();
                    String errorMsg = null;
                    HTMLInputFormat inputFormat = (HTMLInputFormat)this.inputFormats.get(tf);
                    if (inputFormat != null && !inputFormat.verifyString(text)) {
                        errorMsg = UIManager.getInstance().localize("html.format.errordesc", "Malformed text. Correct value: ") + inputFormat.toString();
                        error = true;
                    }
                    if (this.htmlC.getHTMLCallback() != null) {
                        int type = 0;
                        if ((tf.getConstraint() & 0x10000) != 0) {
                            type = 1;
                        }
                        text = this.htmlC.getHTMLCallback().fieldSubmitted(this.htmlC, tf, url, key, text, type, errorMsg);
                    }
                    if (errorMsg != null) continue;
                    params = params + key + "=" + this.encodeString(text) + "&";
                    continue;
                }
                if (input instanceof ComboBox) {
                    Object item = ((ComboBox)input).getSelectedItem();
                    if (!(item instanceof OptionItem)) continue;
                    value = ((OptionItem)item).getValue();
                    params = params + key + "=" + this.encodeString(value) + "&";
                    continue;
                }
                if (!(input instanceof MultiComboBox)) continue;
                Vector selected = ((MultiComboBox)input).getSelected();
                for (int i = 0; i < selected.size(); ++i) {
                    Object item = selected.elementAt(i);
                    if (!(item instanceof OptionItem)) continue;
                    value = ((OptionItem)item).getValue();
                    params = params + key + "=" + this.encodeString(value) + "&";
                }
            }
            if (params.endsWith("&")) {
                params = params.substring(0, params.length() - 1);
            }
        }
        if (!error) {
            DocumentInfo docInfo = new DocumentInfo(url, params, this.isPostMethod);
            if (this.encType != null && !this.encType.equals("")) {
                docInfo.setEncoding(this.encType);
            }
            this.htmlC.setPage(docInfo);
        }
    }

    private String encodeString(String str) {
        if (str == null) {
            return "";
        }
        String encodedStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~') {
                encodedStr = encodedStr + c;
                continue;
            }
            if (c > '\u0080' && c < '\uffff') {
                int firstLiteral = c / 256;
                int secLiteral = c % 256;
                if (c < '\u07ff') {
                    firstLiteral = 192 + (firstLiteral << 2) + (secLiteral >> 6);
                    secLiteral = 128 + secLiteral % 192;
                    encodedStr = encodedStr + "%" + Integer.toHexString(firstLiteral).toUpperCase() + "%" + Integer.toHexString(secLiteral).toUpperCase();
                    continue;
                }
                firstLiteral = 224 + (firstLiteral >> 4);
                secLiteral = 128 + (firstLiteral % 16 << 2) + (secLiteral >> 6);
                int thirdLiteral = 128 + secLiteral % 192;
                encodedStr = encodedStr + "%" + Integer.toHexString(firstLiteral).toUpperCase() + "%" + Integer.toHexString(secLiteral).toUpperCase() + "%" + Integer.toHexString(thirdLiteral).toUpperCase();
                continue;
            }
            String prefix = "%";
            if (c < '\u0010') {
                prefix = prefix + "0";
            }
            encodedStr = encodedStr + prefix + Integer.toHexString(c).toUpperCase();
        }
        return encodedStr;
    }

    void reset() {
        Button b;
        Enumeration<Object> e = this.defaultValues.keys();
        while (e.hasMoreElements()) {
            Object defVal;
            Object input = e.nextElement();
            if (input instanceof TextArea) {
                defVal = (String)this.defaultValues.get(input);
                if (defVal == null) {
                    defVal = "";
                }
                ((TextArea)input).setText((String)defVal);
                continue;
            }
            if (!(input instanceof ComboBox)) continue;
            defVal = (OptionItem)this.defaultValues.get(input);
            ComboBox combo = (ComboBox)input;
            if (defVal != null) {
                combo.setSelectedItem(defVal);
                continue;
            }
            if (combo.size() <= 0) continue;
            combo.setSelectedIndex(0);
        }
        e = this.defaultCheckedButtons.elements();
        while (e.hasMoreElements()) {
            b = (Button)e.nextElement();
            if (b.isSelected()) continue;
            this.setButton(b, true);
        }
        e = this.defaultUncheckedButtons.elements();
        while (e.hasMoreElements()) {
            b = (Button)e.nextElement();
            if (!b.isSelected()) continue;
            this.setButton(b, false);
        }
    }

    private void setButton(Button button, boolean checked) {
        if (button instanceof RadioButton) {
            ((RadioButton)button).setSelected(checked);
        } else {
            ((CheckBox)button).setSelected(checked);
        }
    }
}

