/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class RMSBackup
extends MIDlet
implements CommandListener {
    private Display display;
    private Form form;
    private Command commandExit = new Command("Exit", 2, 0);
    private Command commandAbout = new Command("About", 8, 0);
    private Command commandBackup = new Command("Backup", 8, 0);
    private Command commandRepair = new Command("Repair", 8, 0);
    private TextField archive;

    public RMSBackup() {
        this.display = Display.getDisplay((MIDlet)this);
        this.form = new Form("RMSBackup");
        this.form.addCommand(this.commandExit);
        this.form.addCommand(this.commandAbout);
        this.form.addCommand(this.commandBackup);
        this.form.addCommand(this.commandRepair);
        this.form.setCommandListener((CommandListener)this);
        this.archive = new TextField("Archive:", "/c:/other/" + this.getAppProperty("MIDlet-Name") + ".rms", 255, 0);
        this.form.append((Item)this.archive);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.form);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    private void quitApp() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.commandExit) {
            this.quitApp();
        } else if (command == this.commandBackup) {
            this.store();
        } else if (command == this.commandRepair) {
            this.restore();
        } else if (command == this.commandAbout) {
            Alert alert = new Alert("About");
            alert.setTimeout(-2);
            alert.setString("RMSBackuper\r\nMedvedev O.V.\r\nt. Severodvinsk, 2007");
            this.display.setCurrent(alert, (Displayable)this.form);
        }
    }

    private void store() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://" + this.archive.getString()), (int)3);
            if (fileConnection.exists()) {
                fileConnection.delete();
            }
            fileConnection.create();
            DataOutputStream dataOutputStream = fileConnection.openDataOutputStream();
            dataOutputStream.writeInt(1380799232);
            String[] stringArray = RecordStore.listRecordStores();
            if (stringArray != null) {
                dataOutputStream.writeInt(stringArray.length);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    RecordStore recordStore = RecordStore.openRecordStore((String)stringArray[i2], (boolean)false);
                    dataOutputStream.writeUTF(recordStore.getName());
                    int n = recordStore.getNextRecordID();
                    dataOutputStream.writeInt(n);
                    for (int i3 = 1; i3 < n; ++i3) {
                        try {
                            byte[] byArray = new byte[recordStore.getRecordSize(i3)];
                            recordStore.getRecord(i3, byArray, 0);
                            dataOutputStream.writeInt(i3);
                            dataOutputStream.writeChar(43);
                            dataOutputStream.writeInt(byArray.length);
                            dataOutputStream.write(byArray);
                            byArray = null;
                            continue;
                        }
                        catch (Exception exception) {
                            dataOutputStream.writeInt(i3);
                            dataOutputStream.writeChar(45);
                        }
                    }
                    recordStore.closeRecordStore();
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.close();
            fileConnection.close();
            this.quitApp();
        }
        catch (Exception exception) {
            Alert alert = new Alert("Exception:");
            alert.setTimeout(-2);
            alert.setString(exception.getMessage());
            this.display.setCurrent(alert, (Displayable)this.form);
        }
    }

    private void restore() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://" + this.archive.getString()), (int)1);
            DataInputStream dataInputStream = fileConnection.openDataInputStream();
            if (dataInputStream.readInt() == 1380799232) {
                int n = dataInputStream.readInt();
                for (int i2 = 0; i2 < n; ++i2) {
                    String string = dataInputStream.readUTF();
                    try {
                        RecordStore.deleteRecordStore((String)string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                    int n2 = dataInputStream.readInt();
                    for (int i3 = 1; i3 < n2; ++i3) {
                        int n3 = dataInputStream.readInt();
                        char c2 = dataInputStream.readChar();
                        int n4 = recordStore.addRecord(null, 0, 0);
                        if (c2 == '+') {
                            int n5 = dataInputStream.readInt();
                            byte[] byArray = new byte[n5];
                            dataInputStream.read(byArray);
                            recordStore.setRecord(n4, byArray, 0, byArray.length);
                            continue;
                        }
                        recordStore.deleteRecord(n4);
                    }
                    recordStore.closeRecordStore();
                }
            }
            dataInputStream.close();
            fileConnection.close();
            this.quitApp();
        }
        catch (Exception exception) {
            Alert alert = new Alert("Exception:");
            alert.setTimeout(-2);
            alert.setString(exception.getMessage());
            this.display.setCurrent(alert, (Displayable)this.form);
        }
    }
}

