/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.PulleyJointDef;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    public Body m_ground;
    public Vec2 m_groundAnchor1;
    public Vec2 m_groundAnchor2;
    public Vec2 m_localAnchor1;
    public Vec2 m_localAnchor2;
    public Vec2 m_u1;
    public Vec2 m_u2;
    public float m_constant;
    public float m_ratio;
    public float m_maxLength1;
    public float m_maxLength2;
    public float m_pulleyMass;
    public float m_limitMass1;
    public float m_limitMass2;
    public float m_force;
    public float m_limitForce1;
    public float m_limitForce2;
    public float m_positionImpulse;
    public float m_limitPositionImpulse1;
    public float m_limitPositionImpulse2;
    public int m_state;
    public int m_limitState1;
    public int m_limitState2;

    public PulleyJoint(PulleyJointDef def) {
        super(def);
        this.m_ground = this.m_body1.m_world.getGroundBody();
        this.m_groundAnchor1 = def.groundAnchor1.sub(this.m_ground.m_xf.position);
        this.m_groundAnchor2 = def.groundAnchor2.sub(this.m_ground.m_xf.position);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_u1 = new Vec2();
        this.m_u2 = new Vec2();
        this.m_ratio = def.ratio;
        this.m_constant = def.length1 + this.m_ratio * def.length2;
        this.m_maxLength1 = Math.min(def.maxLength1, this.m_constant - this.m_ratio * 2.0f);
        this.m_maxLength2 = Math.min(def.maxLength2, (this.m_constant - 2.0f) / this.m_ratio);
        this.m_force = 0.0f;
        this.m_limitForce1 = 0.0f;
        this.m_limitForce2 = 0.0f;
    }

    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
        Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
        Vec2 p1 = b1.m_sweep.c.add(r1);
        Vec2 p2 = b2.m_sweep.c.add(r2);
        Vec2 s1 = this.m_ground.m_xf.position.add(this.m_groundAnchor1);
        Vec2 s2 = this.m_ground.m_xf.position.add(this.m_groundAnchor2);
        this.m_u1 = p1.sub(s1);
        this.m_u2 = p2.sub(s2);
        float length1 = this.m_u1.length();
        float length2 = this.m_u2.length();
        if (length1 > 0.005f) {
            this.m_u1.mulLocal(1.0f / length1);
        } else {
            this.m_u1.setZero();
        }
        if (length2 > 0.005f) {
            this.m_u2.mulLocal(1.0f / length2);
        } else {
            this.m_u2.setZero();
        }
        float C = this.m_constant - length1 - this.m_ratio * length2;
        if (C > 0.0f) {
            this.m_state = 0;
            this.m_force = 0.0f;
        } else {
            this.m_state = 2;
            this.m_positionImpulse = 0.0f;
        }
        if (length1 < this.m_maxLength1) {
            this.m_limitState1 = 0;
            this.m_limitForce1 = 0.0f;
        } else {
            this.m_limitState1 = 2;
            this.m_limitPositionImpulse1 = 0.0f;
        }
        if (length2 < this.m_maxLength2) {
            this.m_limitState2 = 0;
            this.m_limitForce2 = 0.0f;
        } else {
            this.m_limitState2 = 2;
            this.m_limitPositionImpulse2 = 0.0f;
        }
        float cr1u1 = Vec2.cross(r1, this.m_u1);
        float cr2u2 = Vec2.cross(r2, this.m_u2);
        this.m_limitMass1 = b1.m_invMass + b1.m_invI * cr1u1 * cr1u1;
        this.m_limitMass2 = b2.m_invMass + b2.m_invI * cr2u2 * cr2u2;
        this.m_pulleyMass = this.m_limitMass1 + this.m_ratio * this.m_ratio * this.m_limitMass2;
        this.m_limitMass1 = 1.0f / this.m_limitMass1;
        this.m_limitMass2 = 1.0f / this.m_limitMass2;
        this.m_pulleyMass = 1.0f / this.m_pulleyMass;
        if (step.warmStarting) {
            Vec2 P1 = this.m_u1.mul(step.dt * (-this.m_force - this.m_limitForce1));
            Vec2 P2 = this.m_u2.mul(step.dt * (-this.m_ratio * this.m_force - this.m_limitForce2));
            b1.m_linearVelocity.addLocal(P1.mul(b1.m_invMass));
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_linearVelocity.addLocal(P2.mul(b2.m_invMass));
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
        } else {
            this.m_force = 0.0f;
            this.m_limitForce1 = 0.0f;
            this.m_limitForce2 = 0.0f;
        }
    }

    public void solveVelocityConstraints(TimeStep step) {
        float oldForce;
        float force;
        Vec2 v1;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
        Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
        if (this.m_state == 2) {
            v1 = b1.m_linearVelocity.add(Vec2.cross(b1.m_angularVelocity, r1));
            Vec2 v2 = b2.m_linearVelocity.add(Vec2.cross(b2.m_angularVelocity, r2));
            float Cdot = -Vec2.dot(this.m_u1, v1) - this.m_ratio * Vec2.dot(this.m_u2, v2);
            float force2 = -step.inv_dt * this.m_pulleyMass * Cdot;
            float oldForce2 = this.m_force;
            this.m_force = Math.max(0.0f, this.m_force + force2);
            force2 = this.m_force - oldForce2;
            Vec2 P1 = this.m_u1.mul(-step.dt * force2);
            Vec2 P2 = this.m_u2.mul(-step.dt * this.m_ratio * force2);
            b1.m_linearVelocity.x += b1.m_invMass * P1.x;
            b1.m_linearVelocity.y += b1.m_invMass * P1.y;
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_linearVelocity.x += b2.m_invMass * P2.x;
            b2.m_linearVelocity.y += b2.m_invMass * P2.y;
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
        }
        if (this.m_limitState1 == 2) {
            v1 = b1.m_linearVelocity.add(Vec2.cross(b1.m_angularVelocity, r1));
            float Cdot = -Vec2.dot(this.m_u1, v1);
            force = -step.inv_dt * this.m_limitMass1 * Cdot;
            oldForce = this.m_limitForce1;
            this.m_limitForce1 = Math.max(0.0f, this.m_limitForce1 + force);
            force = this.m_limitForce1 - oldForce;
            Vec2 P1 = this.m_u1.mul(-step.dt * force);
            b1.m_linearVelocity.x += b1.m_invMass * P1.x;
            b1.m_linearVelocity.y += b1.m_invMass * P1.y;
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
        }
        if (this.m_limitState2 == 2) {
            Vec2 v2 = b2.m_linearVelocity.add(Vec2.cross(b2.m_angularVelocity, r2));
            float Cdot = -Vec2.dot(this.m_u2, v2);
            force = -step.inv_dt * this.m_limitMass2 * Cdot;
            oldForce = this.m_limitForce2;
            this.m_limitForce2 = Math.max(0.0f, this.m_limitForce2 + force);
            force = this.m_limitForce2 - oldForce;
            Vec2 P2 = this.m_u2.mul(-step.dt * force);
            b2.m_linearVelocity.x += b2.m_invMass * P2.x;
            b2.m_linearVelocity.y += b2.m_invMass * P2.y;
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
        }
    }

    public boolean solvePositionConstraints() {
        float oldLimitPositionImpulse;
        float impulse;
        Vec2 r1;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 s1 = this.m_ground.m_xf.position.add(this.m_groundAnchor1);
        Vec2 s2 = this.m_ground.m_xf.position.add(this.m_groundAnchor2);
        float linearError = 0.0f;
        if (this.m_state == 2) {
            r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
            Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
            Vec2 p1 = b1.m_sweep.c.add(r1);
            Vec2 p2 = b2.m_sweep.c.add(r2);
            this.m_u1.set(p1.x - s1.x, p1.y - s1.y);
            this.m_u2.set(p2.x - s2.x, p2.y - s2.y);
            float length1 = this.m_u1.length();
            float length2 = this.m_u2.length();
            if (length1 > 0.005f) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            if (length2 > 0.005f) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            float C = this.m_constant - length1 - this.m_ratio * length2;
            linearError = Math.max(linearError, -C);
            C = MathUtils.clamp(C + 0.005f, -0.2f, 0.0f);
            float impulse2 = -this.m_pulleyMass * C;
            float oldImpulse = this.m_positionImpulse;
            this.m_positionImpulse = Math.max(0.0f, this.m_positionImpulse + impulse2);
            impulse2 = this.m_positionImpulse - oldImpulse;
            Vec2 P1 = this.m_u1.mul(-impulse2);
            Vec2 P2 = this.m_u2.mul(-this.m_ratio * impulse2);
            b1.m_sweep.c.x += b1.m_invMass * P1.x;
            b1.m_sweep.c.y += b1.m_invMass * P1.y;
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            b2.m_sweep.c.x += b2.m_invMass * P2.x;
            b2.m_sweep.c.y += b2.m_invMass * P2.y;
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        if (this.m_limitState1 == 2) {
            r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
            Vec2 p1 = b1.m_sweep.c.add(r1);
            this.m_u1.set(p1.x - s1.x, p1.y - s1.y);
            float length1 = this.m_u1.length();
            if (length1 > 0.005f) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            float C = this.m_maxLength1 - length1;
            linearError = Math.max(linearError, -C);
            C = MathUtils.clamp(C + 0.005f, -0.2f, 0.0f);
            impulse = -this.m_limitMass1 * C;
            oldLimitPositionImpulse = this.m_limitPositionImpulse1;
            this.m_limitPositionImpulse1 = Math.max(0.0f, this.m_limitPositionImpulse1 + impulse);
            impulse = this.m_limitPositionImpulse1 - oldLimitPositionImpulse;
            Vec2 P1 = this.m_u1.mul(-impulse);
            b1.m_sweep.c.x += b1.m_invMass * P1.x;
            b1.m_sweep.c.y += b1.m_invMass * P1.y;
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            b1.synchronizeTransform();
        }
        if (this.m_limitState2 == 2) {
            Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
            Vec2 p2 = b2.m_sweep.c.add(r2);
            this.m_u2.set(p2.x - s2.x, p2.y - s2.y);
            float length2 = this.m_u2.length();
            if (length2 > 0.005f) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            float C = this.m_maxLength2 - length2;
            linearError = Math.max(linearError, -C);
            C = MathUtils.clamp(C + 0.005f, -0.2f, 0.0f);
            impulse = -this.m_limitMass2 * C;
            oldLimitPositionImpulse = this.m_limitPositionImpulse2;
            this.m_limitPositionImpulse2 = Math.max(0.0f, this.m_limitPositionImpulse2 + impulse);
            impulse = this.m_limitPositionImpulse2 - oldLimitPositionImpulse;
            Vec2 P2 = this.m_u2.mul(-impulse);
            b2.m_sweep.c.x += b2.m_invMass * P2.x;
            b2.m_sweep.c.y += b2.m_invMass * P2.y;
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b2.synchronizeTransform();
        }
        return linearError < 0.005f;
    }

    public Vec2 getAnchor1() {
        return this.m_body1.getWorldPoint(this.m_localAnchor1);
    }

    public Vec2 getAnchor2() {
        return this.m_body2.getWorldPoint(this.m_localAnchor2);
    }

    public Vec2 getReactionForce() {
        Vec2 F = this.m_u2.mul(this.m_force);
        return F;
    }

    public float getReactionTorque() {
        return 0.0f;
    }

    public Vec2 getGroundAnchor1() {
        return this.m_ground.m_xf.position.add(this.m_groundAnchor1);
    }

    public Vec2 getGroundAnchor2() {
        return this.m_ground.m_xf.position.add(this.m_groundAnchor2);
    }

    public float getLength1() {
        Vec2 p = this.m_body1.getWorldPoint(this.m_localAnchor1);
        Vec2 s = this.m_ground.m_xf.position.add(this.m_groundAnchor1);
        Vec2 d = p.subLocal(s);
        return d.length();
    }

    public float getLength2() {
        Vec2 p = this.m_body2.getWorldPoint(this.m_localAnchor2);
        Vec2 s = this.m_ground.m_xf.position.add(this.m_groundAnchor2);
        Vec2 d = p.subLocal(s);
        return d.length();
    }

    public float getRatio() {
        return this.m_ratio;
    }
}

