/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.util.blob.BlobContainer;
import org.jbox2d.util.blob.BlobPoint;
import org.jbox2d.util.blob.BlobStructure;

public class BlobMaker {
    public static float pointRadius = 3.0f;
    public static float pointDensity = 1.0f;
    public static float pointFriction = 0.5f;

    public static void createBlob(BlobStructure s, BlobContainer c, World w) {
        BlobMaker.createBlob(s, c, w, 1.0f, 1.0f);
    }

    public static void createBlob(BlobStructure s, BlobContainer c, World w, float scaleX, float scaleY) {
        BlobMaker.createBlob(s, c, w, scaleX, scaleY, 0.0f, 0.0f);
    }

    public static void createBlob(BlobStructure s, BlobContainer c, World w, float scaleX, float scaleY, float transX, float transY) {
        int i;
        int j;
        AABB aabb = c.getAABB();
        while (transX > 0.0f) {
            transX -= scaleX;
        }
        while (transY > 0.0f) {
            transY -= scaleY;
        }
        float xMin = aabb.lowerBound.x + transX;
        float yMin = aabb.lowerBound.y + transY;
        int nWidth = (int)Math.ceil((aabb.upperBound.x - xMin) / scaleX);
        int nHeight = (int)Math.ceil((aabb.upperBound.y - yMin) / scaleY);
        int nPerCell = s.points.size();
        int nPoints = nPerCell * (nWidth += 3) * (nHeight += 3);
        System.out.println(nWidth + " " + nHeight);
        Body[] bodies = new Body[nPoints];
        CircleDef cd = new CircleDef();
        cd.radius = pointRadius;
        cd.density = pointDensity;
        cd.friction = pointFriction;
        int index = 0;
        for (j = 0; j < nHeight; ++j) {
            float yStart = yMin + transY + (float)j * scaleY;
            for (i = 0; i < nWidth; ++i) {
                float xStart = xMin + transX + (float)i * scaleX;
                for (int k = 0; k < nPerCell; ++k) {
                    Vec2 position = new Vec2(((BlobPoint)s.points.get((int)k)).position.x + xStart, ((BlobPoint)s.points.get((int)k)).position.y + yStart);
                    if (!c.containsPoint(position)) {
                        bodies[index++] = null;
                        continue;
                    }
                    BodyDef bd = new BodyDef();
                    bd.position = position;
                    bd.fixedRotation = false;
                    bd.angularDamping = 0.2f;
                    bodies[index] = w.createBody(bd);
                    bodies[index].createShape(cd);
                    bodies[index].setMassFromShapes();
                    ++index;
                }
            }
        }
        for (j = 0; j < nHeight; ++j) {
            int rowStartIndex = j * nWidth * nPerCell;
            for (i = 0; i < nWidth; ++i) {
                float damp;
                float freq;
                int b;
                int a2;
                BlobStructure.IntIntFloatFloat iiff;
                int k;
                int boxStartIndex = rowStartIndex + i * nPerCell;
                int indexUR = -(nWidth - 1) * nPerCell + boxStartIndex;
                int indexR = nPerCell + boxStartIndex;
                int indexDR = (nWidth + 1) * nPerCell + boxStartIndex;
                int indexD = nWidth * nPerCell + boxStartIndex;
                for (k = 0; k < s.connections.size(); ++k) {
                    iiff = (BlobStructure.IntIntFloatFloat)s.connections.get(k);
                    a2 = iiff.a + boxStartIndex;
                    b = iiff.b + boxStartIndex;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a2, b, freq, damp, w);
                }
                for (k = 0; k < s.connectionsR.size(); ++k) {
                    iiff = (BlobStructure.IntIntFloatFloat)s.connectionsR.get(k);
                    a2 = iiff.a + boxStartIndex;
                    b = iiff.b + indexR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a2, b, freq, damp, w);
                }
                for (k = 0; k < s.connectionsDR.size(); ++k) {
                    iiff = (BlobStructure.IntIntFloatFloat)s.connectionsDR.get(k);
                    a2 = iiff.a + boxStartIndex;
                    b = iiff.b + indexDR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a2, b, freq, damp, w);
                }
                for (k = 0; k < s.connectionsD.size(); ++k) {
                    iiff = (BlobStructure.IntIntFloatFloat)s.connectionsD.get(k);
                    a2 = iiff.a + boxStartIndex;
                    b = iiff.b + indexD;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a2, b, freq, damp, w);
                }
                for (k = 0; k < s.connectionsUR.size() && j != 0; ++k) {
                    iiff = (BlobStructure.IntIntFloatFloat)s.connectionsUR.get(k);
                    a2 = iiff.a + boxStartIndex;
                    b = iiff.b + indexUR;
                    freq = iiff.c;
                    damp = iiff.d;
                    BlobMaker.createConnection(bodies, a2, b, freq, damp, w);
                }
            }
        }
    }

    private static Joint createConnection(Body[] bodies, int a2, int b, float frequency, float damping, World w) {
        if (a2 >= bodies.length || b >= bodies.length || bodies[a2] == null || bodies[b] == null) {
            return null;
        }
        DistanceJointDef jd = new DistanceJointDef();
        jd.collideConnected = false;
        jd.dampingRatio = damping;
        jd.frequencyHz = frequency;
        jd.initialize(bodies[a2], bodies[b], bodies[a2].getPosition(), bodies[b].getPosition());
        return w.createJoint(jd);
    }
}

