/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Drawable;
import com.gn4me.waka.Game;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Tasks;
import com.gn4me.waka.menu.Element;
import com.gn4me.waka.select.Number;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MenuSuccess
implements Drawable {
    protected Vector vecElements = new Vector();
    protected int numberOfElements = -1;
    protected int spacer = 20;
    private int selectedIndex;
    private int menuX;
    private int menuY;
    private int height;
    private int width;
    private Game game = Main.currentGame;
    private Number numberNextLevel;
    private Number numberStage;

    public MenuSuccess() {
        this.creatElements();
        this.calculate();
        int n = Main.currentGame.getLevelNumber() + 1;
        if ((n %= 9) == 0) {
            n = 9;
        }
        this.numberNextLevel = new Number(n);
        this.numberStage = new Number(this.game.getNextStageNumber());
    }

    protected void calculate() {
        Element element = null;
        this.numberOfElements = this.vecElements.size();
        this.height = this.numberOfElements * (40 + this.spacer) - this.spacer;
        this.width = 215;
        this.menuX = 180 - this.width / 2;
        this.menuY = 320 - this.height / 2 + 30;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            element.setX(this.menuX);
            element.setY(this.menuY + j * (40 + this.spacer));
        }
    }

    public void paint(Graphics g) {
        int x = 180 - (Resources.WORD_LEVEL.getWidth() + this.numberNextLevel.getWidth() + 10) / 2;
        g.drawImage(Resources.WORD_LEVEL, x, this.menuY - 100, 20);
        this.numberNextLevel.setPosition(x += 10 + Resources.WORD_LEVEL.getWidth(), this.menuY - 100);
        this.numberNextLevel.paint(g);
        x = 180 - (Resources.WORD_STAGE.getWidth() + this.numberStage.getWidth() + 10) / 2;
        g.drawImage(Resources.WORD_STAGE, x, this.menuY - 150, 20);
        this.numberStage.setPosition(x += 10 + Resources.WORD_STAGE.getWidth(), this.menuY - 150);
        this.numberStage.paint(g);
        g.setColor(0xFFFFFF);
        for (int j = 0; j < this.vecElements.size(); ++j) {
            ((Element)this.vecElements.elementAt(j)).draw(g);
        }
    }

    public void creatElements() {
        Element element = null;
        element = new Element(11, Resources.MENU_PLAY_RED, null);
        element.setSelected(true);
        this.vecElements.addElement(element);
    }

    private void execute(Element element) {
        Main.menuVibrate();
        this.game.setEndTask(Tasks.startLevel(this.game.getLevelNumber() + 1));
        this.game.stop();
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        this.execute((Element)this.vecElements.elementAt(0));
    }

    public void pointerReleased(int x, int y) {
    }
}

