/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.objects;

import com.gn4me.waka.Data;
import com.gn4me.waka.objects.Box;
import com.gn4me.waka.objects.GameObject;
import com.gn4me.waka.objects.PhysicsWorld;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import org.jbox2d.common.Vec2;

public class Circle
extends GameObject {
    private int raduis;
    private Sprite sprite;
    private int lastAngle;

    public Circle(Data data, int x, int y) {
        super(data);
        this.raduis = data.width / 2;
        this.body = this.world.createCircle((float)x, y, this.raduis);
        this.sprite = new Sprite(data.image, data.image.getWidth() / 12, data.image.getHeight());
    }

    public Circle(Circle circle) {
        super(circle.getData());
        this.raduis = circle.getRaduis();
        int x = PhysicsWorld.getInstance().worldToScreenX(circle.getBody().getPosition().x);
        int y = PhysicsWorld.getInstance().worldToScreenY(circle.getBody().getPosition().y);
        this.body = this.world.createCircle((float)(x -= circle.getData().width / 2), y -= circle.getData().height / 2, this.raduis);
        this.sprite = new Sprite(this.data.image, this.data.image.getWidth() / 12, this.data.image.getHeight());
    }

    public void cycle() {
        this.setStatus();
        int angle = (int)Math.toDegrees(this.body.getAngle());
        angle *= -1;
        while (angle < 0) {
            angle += 360;
        }
        if (Math.abs((angle = (angle + 360) % 360) - this.lastAngle) < 5) {
            return;
        }
        int frameNumb = this.sprite.getFrame();
        frameNumb = angle - this.lastAngle > 0 ? ++frameNumb : --frameNumb;
        if (frameNumb > 11) {
            frameNumb = 0;
        } else if (frameNumb < 0) {
            frameNumb = 11;
        }
        this.sprite.setFrame(frameNumb);
        this.lastAngle = angle;
    }

    public void draw(Graphics g) {
        int x = this.world.worldToScreenX(this.body.getPosition().x);
        int y = this.world.worldToScreenY(this.body.getPosition().y);
        this.sprite.setPosition(x - this.data.width / 2, y - this.data.width / 2);
        this.sprite.paint(g);
        this.drawFace(g, x, y);
    }

    public Circle(Box box) {
        switch (box.getData().type) {
            case 4: {
                this.data = Data.CIRCLE_GREEN_LARGE;
                break;
            }
            case 5: {
                this.data = Data.CIRCLE_GREEN_SMALL;
                break;
            }
            case 6: {
                this.data = Data.CIRCLE_RED_LARGE;
                break;
            }
            case 7: {
                this.data = Data.CIRCLE_RED_SMALL;
            }
        }
        this.raduis = this.data.width / 2;
        this.sprite = new Sprite(this.data.image, this.data.image.getWidth() / 12, this.data.image.getHeight());
        Vec2 linearVelocity = box.getBody().getLinearVelocity();
        Vec2 position = box.getBody().getPosition();
        this.body = this.world.createCircle((float)this.raduis, linearVelocity, position);
    }

    public int getRaduis() {
        return this.raduis;
    }
}

