/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.select;

import com.gn4me.waka.Drawable;
import com.gn4me.waka.Game;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Setting;
import com.gn4me.waka.menu.MenuGame;
import com.gn4me.waka.menu.MenuSelect;
import com.gn4me.waka.select.Stage;
import javax.microedition.lcdui.Graphics;

public class LevelSelection
implements Drawable {
    private int lastAction = -1;
    private int xStart;
    private final int yStage;
    private Stage stage1;
    private Stage stage2;
    private Stage stage3;
    private Stage stage4;
    private Stage stage5;
    private Game game;
    private MenuSelect menuSelect;
    private Stage currentStage;
    private boolean levelSelected;
    private int lastX;
    private int lastXPress;

    public LevelSelection(Game game, MenuSelect menuSelect) {
        this.yStage = 180;
        this.game = game;
        this.menuSelect = menuSelect;
        this.stage1 = new Stage(this, 1);
        this.stage2 = new Stage(this, 2);
        this.stage3 = new Stage(this, 3);
        this.stage4 = new Stage(this, 4);
        this.stage5 = new Stage(this, 5);
        this.setFirstStage();
    }

    private void setFirstStage() {
        byte l = Setting.getInstance().getSavedLevel();
        if (l == 45) {
            this.setXStart(0);
            return;
        }
        if (l >= 37) {
            this.setXStart(-1440);
        } else if (l >= 28) {
            this.setXStart(-1080);
        } else if (l >= 19) {
            this.setXStart(-720);
        } else if (l >= 10) {
            this.setXStart(-360);
        } else {
            this.setXStart(0);
        }
    }

    public void paint(Graphics g) {
        this.stage1.paint(g);
        this.stage2.paint(g);
        this.stage3.paint(g);
        this.stage4.paint(g);
        this.stage5.paint(g);
        g.drawImage(Resources.SELECT_BACK_BUTTON, 10, 640 - Resources.SELECT_BACK_BUTTON.getHeight() - 20, 20);
    }

    public void pointerDragged(int x, int y) {
        this.lastAction = 1;
        int dx = x - this.lastX;
        this.xStart += dx;
        this.lastX = x;
        if (this.xStart < -1440) {
            this.setXStart(-1440);
        } else if (this.xStart > 0) {
            this.setXStart(0);
        } else {
            this.setXStart(this.xStart);
        }
    }

    public void pointerPressed(final int x, final int y) {
        if (x < 50 && y > 270 && y < 370) {
            Main.menuVibrate();
            this.xStart += 360;
            if (this.xStart < -1440) {
                this.setXStart(-1440);
            } else if (this.xStart > 0) {
                this.setXStart(0);
            } else {
                this.setXStart(this.xStart);
            }
            return;
        }
        if (x > 310 && y > 270 && y < 370) {
            Main.menuVibrate();
            this.xStart -= 360;
            if (this.xStart < -1440) {
                this.setXStart(-1440);
            } else if (this.xStart > 0) {
                this.setXStart(0);
            } else {
                this.setXStart(this.xStart);
            }
            return;
        }
        if (x < 90 && y >= 580) {
            Main.menuVibrate();
            if (this.game != null) {
                this.game.setDrawable(new MenuGame());
                System.gc();
            } else if (this.menuSelect != null) {
                this.menuSelect.executeBack();
            }
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LevelSelection levelSelection = LevelSelection.this;
                synchronized (levelSelection) {
                    if (LevelSelection.this.levelSelected) {
                        return;
                    }
                    LevelSelection.this.currentStage.pointerPressed(x, y);
                }
            }
        }.start();
        this.lastAction = 0;
        this.lastX = x;
        this.lastXPress = x;
    }

    public void pointerReleased(int x, int y) {
        if (this.lastAction == 1) {
            if (this.xStart < 0) {
                this.xStart *= -1;
            }
            int value = this.xStart % 360;
            this.xStart = x > this.lastXPress ? (this.xStart -= value) : (this.xStart += 360 - value);
            this.xStart *= -1;
            if (this.xStart < -1440) {
                this.setXStart(-1440);
            } else if (this.xStart > 0) {
                this.setXStart(0);
            } else {
                this.setXStart(this.xStart);
            }
        }
        this.lastAction = 2;
    }

    public void setXStart(int x) {
        this.xStart = x;
        this.stage1.setPosition(0 + this.xStart, 180);
        this.stage2.setPosition(360 + this.xStart, 180);
        this.stage3.setPosition(720 + this.xStart, 180);
        this.stage4.setPosition(1080 + this.xStart, 180);
        this.stage5.setPosition(1440 + this.xStart, 180);
        if (this.xStart % 360 == 0) {
            if (this.menuSelect != null) {
                this.menuSelect.setxStart(this.xStart);
            }
            switch (this.xStart) {
                case 0: {
                    this.currentStage = this.stage1;
                    break;
                }
                case -360: {
                    this.currentStage = this.stage2;
                    break;
                }
                case -720: {
                    this.currentStage = this.stage3;
                    break;
                }
                case -1080: {
                    this.currentStage = this.stage4;
                    break;
                }
                case -1440: {
                    this.currentStage = this.stage5;
                }
            }
        }
    }

    public void setLevelSelected(boolean levelSelected) {
        this.levelSelected = levelSelected;
    }
}

