/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

public class ContactID {
    public int key;
    public Features features;

    public boolean isEqual(ContactID cid) {
        return cid.features.isEqual(this.features);
    }

    public void zero() {
        this.key = 0;
        this.features.flip = 0;
        this.features.incidentEdge = 0;
        this.features.incidentVertex = 0;
        this.features.referenceEdge = 0;
    }

    public ContactID() {
        this.key = 0;
        this.features = new Features();
    }

    public ContactID(ContactID c) {
        this.key = c.key;
        this.features = new Features(c.features);
    }

    public class Features {
        public int referenceEdge;
        public int incidentEdge;
        public int incidentVertex;
        public int flip;

        public Features() {
            this.flip = 0;
            this.incidentVertex = 0;
            this.incidentEdge = 0;
            this.referenceEdge = 0;
        }

        public Features(Features f) {
            this.referenceEdge = f.referenceEdge;
            this.incidentEdge = f.incidentEdge;
            this.incidentVertex = f.incidentVertex;
            this.flip = f.flip;
        }

        public void set(Features f) {
            this.referenceEdge = f.referenceEdge;
            this.incidentEdge = f.incidentEdge;
            this.incidentVertex = f.incidentVertex;
            this.flip = f.flip;
        }

        public boolean isEqual(Features f) {
            return this.referenceEdge == f.referenceEdge && this.incidentEdge == f.incidentEdge && this.incidentVertex == f.incidentVertex && this.flip == f.flip;
        }

        public String toString() {
            String s = "Features: (" + this.flip + " ," + this.incidentEdge + " ," + this.incidentVertex + " ," + this.referenceEdge + ")";
            return s;
        }
    }
}

