/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

public class Vec2 {
    public static final boolean watchCreations = true;
    public static int creationCount = 0;
    public float x;
    public float y;

    public Vec2() {
        this(0.0f, 0.0f);
    }

    public Vec2(float x, float y) {
        ++creationCount;
        this.x = x;
        this.y = y;
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public Vec2 mul(float a2) {
        return new Vec2(this.x * a2, this.y * a2);
    }

    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    public Vec2 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2 addLocal(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vec2 subLocal(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vec2 mulLocal(float a2) {
        this.x *= a2;
        this.y *= a2;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float normalize() {
        float length = this.length();
        if (length < 1.1920929E-7f) {
            return 0.0f;
        }
        float invLength = 1.0f / length;
        this.x *= invLength;
        this.y *= invLength;
        return length;
    }

    public boolean isValid() {
        return this.x != Float.NaN && this.x != Float.NEGATIVE_INFINITY && this.x != Float.POSITIVE_INFINITY && this.y != Float.NaN && this.y != Float.NEGATIVE_INFINITY && this.y != Float.POSITIVE_INFINITY;
    }

    public Vec2 abs() {
        return new Vec2(Math.abs(this.x), Math.abs(this.y));
    }

    public Vec2 clone() {
        return new Vec2(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public static Vec2 abs(Vec2 a2) {
        return new Vec2(Math.abs(a2.x), Math.abs(a2.y));
    }

    public static float dot(Vec2 a2, Vec2 b) {
        return a2.x * b.x + a2.y * b.y;
    }

    public static float cross(Vec2 a2, Vec2 b) {
        return a2.x * b.y - a2.y * b.x;
    }

    public static Vec2 cross(Vec2 a2, float s) {
        return new Vec2(s * a2.y, -s * a2.x);
    }

    public static Vec2 cross(float s, Vec2 a2) {
        return new Vec2(-s * a2.y, s * a2.x);
    }

    public static Vec2 min(Vec2 a2, Vec2 b) {
        return new Vec2(a2.x < b.x ? a2.x : b.x, a2.y < b.y ? a2.y : b.y);
    }

    public static Vec2 max(Vec2 a2, Vec2 b) {
        return new Vec2(a2.x > b.x ? a2.x : b.x, a2.y > b.y ? a2.y : b.y);
    }
}

