/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Engine
extends Device
implements Constants,
Runnable,
CommandListener {
    public static Graphics s_g = null;
    public static final int GFX_SIZE_SMALL = 0;
    public static final int GFX_SIZE_MEDIUM = 1;
    public static final int GFX_SIZE_LARGE = 2;
    public static final char[] SCALE_VALUES = new char[]{'C', 'd', '\u0096'};
    public static final int[] CHEAT_MODE_KEYS = new int[]{4, 8, 4, 4, 8, 8, 16384};
    public static int cheatKeyIndex;
    public static int lastKeyPressed;
    public static boolean isCheatMode;
    public static String debugTimeStamp;
    private boolean resumeSound;
    public static boolean handleEvent;
    public static boolean running;
    public static boolean hideNotify;
    private static long lastTick;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_FORCE_SOUND = 1;
    public static final int EVENT_SHOW_PAUSE_SCREEN = 2;
    public static final int EVENT_SHOW_PAUSE_SCREEN_THEN_FORCE_SOUND = 3;
    public static int lastSound;
    public static boolean vibrateOn;
    public static boolean soundOn;
    public static GameWorld gameWorld;
    public static Display display;
    public static Main parent;
    public static Engine instance;
    public static Random random;
    public static int tick;
    public static int brandTick;
    public static DeviceImage[] tipsImages;
    public static DeviceImage pineconeImage;
    public static DeviceImage menuSnowUp;
    public static DeviceImage menuSnowRight;
    public static DeviceImage menuSnowDown;
    public static DeviceImage menuIce;
    public static DeviceImage[] figurinesImage;
    public static DeviceImage[] figurinesBackgroundImage;
    public static DeviceImage figurinesArrowL;
    public static DeviceImage figurinesArrowR;
    public static DeviceImage loadHill;
    public static DeviceImage loadElephant;
    public static DeviceImage loadSid;
    public static DeviceImage loadTiger;
    public static DeviceImage loadMouse;
    public static DeviceImage loadSquirrel;
    private static int loadRandomNum;
    public static DeviceImage ScrollWordArrowUp;
    public static DeviceImage ScrollWordArrowDown;
    public static Command commandSoft1;
    public static Command commandSoft2;
    public static int font;
    public static final int GS_UNUSED = -1;
    public static final int GS_INIT_APP = 0;
    public static final int GS_SPLASH = 2;
    public static final int GS_PAUSE = 4;
    public static final int GS_BRAND = 5;
    public static final int GS_END_ALL_LEVEL = 6;
    public static final int GS_MENU = 10;
    public static final int GS_LOADING = 20;
    public static final int GS_DEMO = 30;
    public static final int GS_CLOSE_GAMEWORLD = 40;
    public static final int GS_INGAME = 100;
    public static final int GS_INGAMEMENU = 110;
    public static int state;
    public static int pauseState;
    private static boolean isPainting;
    public static int debugFPS;
    public static boolean updateMenuBg;
    public static final int FULL_SCREEN_ALPHA_FADE_TO_BLACK = 0;
    public static final int FULL_SCREEN_ALPHA_FADE_TO_GAME = 1;
    public static final int FULL_SCREEN_ALPHA_FADE_DURATION = 800;
    public static int fullScreenAlphaFadeType;
    public static int fullScreenAlphaFadeTime;
    public static String[] levelName;
    public static int debugTick;
    public static int debugPaint;
    private long debugStartFPSTime;
    private int debugFramesRendered;
    private int debugAvgFPS;
    private static final int FPS_RECALC = 6;
    public boolean skipPaint;
    private static int brandIndex;
    private static final int BRAND_INDEX_GLULOGO = 0;
    private static final int BRAND_INDEX_FOXLOGO = 1;
    private static final int BRAND_INDEX_SPLASH = 2;
    private static DeviceImage BrandGluLogo;
    private static DeviceImage BrandSplash;
    private static DeviceImage BrandFoxLogo;
    private static final int BRAND_DELAY = 30;
    public static boolean bIsDemoMode;
    public static int demoMode;
    public static String demoUrl;
    public static final int maxDemoLevel = 3;
    public static boolean bIsUpsellMode;
    public static int upsellMode;
    public static String upsellUrl;
    public Menu menuLanguage;
    public String[] languageFiles;
    public static int loadingState;
    public static final int LOADING_STATE_NONE = 0;
    public static final int LOADING_STATE_LOAD_TO_GAME = 1;
    public static final int LOADING_STATE_LOAD_BACK_TO_MENU = 2;
    public static int loadingProgress;
    public static int loadingProgressDisplay;
    public static String[] loadingTextStrings;
    public static boolean reverseTooltips;
    public static final int IMG_OK = 0;
    public static final int IMG_MENU = 1;
    public static final int IMG_BACK = 2;
    public static DeviceImage endingImage1;
    public static DeviceImage endingImage2;
    public static DeviceImage endingImage3;
    public static boolean bEndingScreen;
    public static int endingScreenState;
    private static final int ENDING_DELAY = 100;
    private static int menuItemHeight;
    public static Menu menuCurrent;
    public static Menu menuMain;
    public static Menu menuNewGame;
    public static Menu menuSetting;
    public static Menu menuExit;
    public static Menu menuSound;
    public static Menu menuInGame;
    public static Menu menuDemoGetTheGame;
    public static Menu menuDemoStart;
    public static Menu menuDemoEnd;
    public static Menu menuUpsell;
    public static Menu menuHelp;
    public static Menu menuContinue;
    public static Menu menuAbout;
    public static Menu menuRestart;
    public static Menu menuBackToMenu;
    public static Menu menuFigurines;
    public static final String RMS_NAME = "iceage2";
    public static final int RMS_SETTINGS = 0;
    public static final int RMS_INFO = 1;
    public static final int RMS_FIGURINES = 2;
    public static final int NUM_SAVE_SLOT_INFO = 3;
    public static final int SAVE_SLOT_INFO_CURRENTLEVEL = 0;
    public static final int SAVE_SLOT_INFO_BONUS_LOW = 1;
    public static final int SAVE_SLOT_INFO_BONUS_HIGH = 2;
    public static byte[] saveSlotInfoBytes;
    public static final int NUM_SAVE_SLOT_FIGURINES = 5;
    public static final int SAVE_SLOT_FIGURINES_ELEPHANT = 0;
    public static final int SAVE_SLOT_FIGURINES_TIGER = 1;
    public static final int SAVE_SLOT_FIGURINES_SID = 2;
    public static final int SAVE_SLOT_FIGURINES_SQUIRREL = 3;
    public static final int SAVE_SLOT_FIGURINES_MOUSE = 4;
    public static byte[] saveSlotFigurinesBytes;
    public static boolean menuSavesSaving;
    public static String[] text;
    public static int keysPressed;
    public static int keyLatch;
    public static int keyUnmapped;
    public static int lastKey;
    public static int tickKey;
    public static boolean isDoubleKey;
    public static boolean blah;
    public static int keyRepeatTimeout;
    public static long currentMem;
    public static String currentMemMsg;
    public static int fadeState;
    public static int fadeStep;
    public static int fadeEvent;
    public static int[] fadeEventParams;
    private static int clipX;
    private static int clipY;
    private static int clipW;
    private static int clipH;

    public Engine(Main main) {
        parent = main;
        instance = this;
        display = Display.getDisplay((MIDlet)main);
        display.setCurrent((Displayable)this);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        running = true;
        state = 0;
        lastTick = System.currentTimeMillis();
        while (running) {
            long l = System.currentTimeMillis();
            try {
                if (handleEvent) {
                    this.handleEvent();
                }
                if (!hideNotify) {
                    this.tick();
                    Engine.doRepaint();
                }
                int n = 50;
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= (long)(n - 0)) continue;
                Thread.sleep((long)n - l2);
            }
            catch (Exception exception) {}
        }
        Engine.destroyGame();
    }

    private void tick() {
        try {
            ++tickKey;
            if (this.resumeSound && loadingState == 0 && state != 4) {
                boolean bl = this.resumeSound = Device.soundFunction(2) == 0;
            }
            if (keyRepeatTimeout > 0) {
                keyRepeatTimeout = Math.max(0, keyRepeatTimeout - 50);
            }
            Engine.tickFade();
            if (!Demo.isEnabled() && state == 10 && Engine.menuCurrent.type != 2 && lastKeyPressed != -1) {
                if (lastKeyPressed == CHEAT_MODE_KEYS[cheatKeyIndex]) {
                    if (++cheatKeyIndex >= CHEAT_MODE_KEYS.length) {
                        cheatKeyIndex = 0;
                        Engine.releaseAllKeys();
                        isCheatMode = !isCheatMode;
                    }
                } else {
                    cheatKeyIndex = 0;
                }
                lastKeyPressed = -1;
            }
            switch (state) {
                case 100: {
                    gameWorld.tick();
                    break;
                }
                case 5: {
                    if (Engine.fading()) break;
                    this.tickBrand();
                    break;
                }
                case 10: 
                case 110: {
                    if (Engine.fading()) break;
                    menuCurrent.tick();
                    break;
                }
                case 20: {
                    this.tickLoading();
                    break;
                }
                case 0: {
                    this.initApp();
                    break;
                }
                case 6: {
                    this.tickEndingScreen();
                    break;
                }
                case 30: {
                    Demo.tick();
                    break;
                }
                case 4: {
                    if (!Engine.hasAnyKeyPressed()) break;
                    Engine.releaseAllKeys();
                    state = pauseState;
                    if ((state == 110 || state == 10) && gameWorld != null) {
                        gameWorld.paint(s_g);
                        GameWorld.drawHud = true;
                    }
                    if (pauseState == 100 && gameWorld != null) {
                        GameWorld.drawHud = true;
                        if (!GameWorld.isObserveStyle) {
                            Engine.gameWorld.bIsFreezeTime = false;
                        }
                        GameWorld.levelTimeTick = tick + GameWorld.restTime - GameWorld.currentLevelTimeLimit;
                    }
                    if (lastSound == -1 || pauseState != 10 || GameWorld.isIGM || menuCurrent == menuDemoEnd) break;
                    Device.soundFunction(3, new int[]{131075});
                    break;
                }
                case 40: {
                    int n;
                    gameWorld = null;
                    int n2 = n = Engine.menuCurrent.type == 2 ? -1 : -1;
                    if (Demo.isEnabled() && n != -1) {
                        Demo.init(n);
                        break;
                    }
                    Engine.setMenu(menuMain);
                    state = 10;
                    menuCurrent.setCursor(0);
                }
            }
            ++tick;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        if (s_g == null) {
            s_g = graphics;
        }
        try {
            if (loadingState != 0) {
                this.paintLoading(graphics);
            } else if (Engine.fading()) {
                Engine.drawFade(graphics);
            } else {
                switch (state) {
                    case 100: {
                        gameWorld.paint(graphics);
                        break;
                    }
                    case 5: {
                        this.paintBrand(graphics);
                        break;
                    }
                    case 10: 
                    case 110: {
                        menuCurrent.paint(graphics);
                        break;
                    }
                    case 20: {
                        this.paintLoading(graphics);
                        break;
                    }
                    case 6: {
                        this.paintEndingScreen(graphics);
                        break;
                    }
                    case 30: {
                        Demo.paint(graphics);
                        break;
                    }
                    case 40: {
                        Engine.cls(graphics, 0);
                        FontMgr.drawString(font, graphics, text == null ? "..." : text[38], Device.WIDTH >> 1, Device.HEIGHT - FontMgr.charHeight[font] >> 1, 17);
                        break;
                    }
                    case 4: {
                        Engine.cls(graphics, 1133966);
                        FontMgr.drawStringAutoChangeLine(2, graphics, text[39], Device.WIDTH >> 1, Device.HEIGHT - FontMgr.charHeight[font] >> 1, 18, 17);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.paint(graphics);
    }

    public void initApp() {
        Menu.engine = this;
        this.setBackLight(true);
        tipsImages = new DeviceImage(65597).divide(3);
        this.loadRemainingMenuResources();
        try {
            Device.deviceFunction(1, "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initUIValues();
        String string = Engine.getJadValue("ms-skPos");
        if (string != null) {
            reverseTooltips = string.equals("1");
        }
        this.setLanguageSelect();
    }

    public void initGameWorld(boolean bl) {
        DeviceSound.stop(true);
        font = 0;
        menuIce = null;
        for (int i = 0; i < figurinesImage.length; ++i) {
            Engine.figurinesImage[i] = null;
            Engine.figurinesBackgroundImage[i] = null;
        }
        figurinesArrowL = null;
        figurinesArrowR = null;
        Device.soundFunction(1);
        if (gameWorld != null) {
            gameWorld = null;
            System.gc();
        }
        state = 20;
        Engine.startLoading();
        loadHill = new DeviceImage(65586);
        if (menuIce == null) {
            menuIce = new DeviceImage(65587);
        }
        switch (loadRandomNum) {
            case 0: {
                loadElephant = new DeviceImage(65585);
                break;
            }
            case 1: {
                loadTiger = new DeviceImage(65591);
                break;
            }
            case 2: {
                loadSid = new DeviceImage(65589);
                break;
            }
            case 3: {
                loadSquirrel = new DeviceImage(65590);
                break;
            }
            case 4: {
                loadMouse = new DeviceImage(65588);
                break;
            }
        }
        Engine.updateLoading(10);
        gameWorld = new GameWorld();
    }

    public static void destroyGame() {
        Device.soundFunction(1);
        parent.destroyApp(true);
        parent.notifyDestroyed();
    }

    public static void destroyGameWorld() {
        Device.soundFunction(1);
        if (gameWorld != null) {
            gameWorld.release();
            gameWorld = null;
            System.gc();
        }
    }

    public static DeviceImage[] divideSplittedImage(int n, int n2) {
        DeviceImage[] deviceImageArray = new DeviceImage[n2];
        for (int i = 0; i < n2; ++i) {
            deviceImageArray[i] = new DeviceImage(ResourceMaster.getResource(n + i));
        }
        return deviceImageArray;
    }

    public void initUIValues() {
    }

    public static void cls(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
    }

    private void loadRemainingMenuResources() {
        pineconeImage = new DeviceImage(65595);
        Device.soundFunction(0);
        this.initRMS();
        Engine.loadRMS(0);
        Engine.loadRMS(1);
        GameWorld.unlockLevelRecord = saveSlotInfoBytes[0];
        GameWorld.level = GameWorld.unlockLevelRecord;
    }

    public void setBrand() {
        boolean bl = false;
        try {
            byte[] byArray = ResourceMaster.getResourceFromJar("brand" + brandIndex + ".png");
            switch (brandIndex) {
                case 0: {
                    if (byArray != null) {
                        BrandGluLogo = new DeviceImage(byArray);
                    }
                    if (BrandGluLogo != null) break;
                    bl = true;
                    break;
                }
                case 1: {
                    BrandGluLogo = null;
                    if (byArray != null) {
                        BrandFoxLogo = new DeviceImage(byArray);
                    }
                    if (BrandFoxLogo != null) break;
                    bl = true;
                    break;
                }
                case 2: {
                    BrandFoxLogo = null;
                    if (byArray != null) {
                        BrandSplash = new DeviceImage(byArray);
                    }
                    if (BrandSplash != null) break;
                    bl = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        if (bl) {
            this.closeBrand();
        } else {
            if (state != 5) {
                state = 5;
            }
            if (BrandGluLogo != null) {
                brandTick = tick;
            }
            Engine.releaseAllKeys();
        }
    }

    private void tickBrand() {
        if (brandIndex == 2) {
            if (!DeviceSound.isSoundPlaying(true)) {
                DeviceSound.play(131075);
            }
            if (Engine.hasAnyKeyPressed()) {
                this.closeBrand();
                Engine.fadeOut(false, 0);
                Engine.loadMenuRes();
                Engine.setMenu(menuMain);
            }
        } else if ((tick - brandTick > 30 || Engine.key(16) || Engine.key(64)) && brandIndex < 2) {
            ++brandIndex;
            this.setBrand();
            brandTick = tick;
            Engine.fadeOut(false, 0);
        }
    }

    private void closeBrand() {
        BrandGluLogo = null;
        BrandFoxLogo = null;
        BrandSplash = null;
    }

    private void paintBrand(Graphics graphics) {
        Engine.cls(graphics, 1133966);
        switch (brandIndex) {
            case 0: {
                if (BrandGluLogo == null) break;
                BrandGluLogo.drawImage(graphics, Device.WIDTH - Engine.BrandGluLogo.width >> 1, Device.HEIGHT - Engine.BrandGluLogo.height >> 1);
                break;
            }
            case 1: {
                if (BrandFoxLogo == null) break;
                BrandFoxLogo.drawImage(graphics, Device.WIDTH - Engine.BrandFoxLogo.width >> 1, Device.HEIGHT - Engine.BrandFoxLogo.height >> 1);
                break;
            }
            case 2: {
                if (BrandSplash != null) {
                    BrandSplash.drawImage(graphics, Device.WIDTH - Engine.BrandSplash.width >> 1, Device.HEIGHT - Engine.BrandSplash.height >> 1);
                }
                if (tick % 30 < 15) {
                    FontMgr.drawStringAutoChangeLine(2, graphics, text[39], Device.WIDTH >> 1, Device.SPLASH_PRESS_TEXT_Y, 18, 17);
                }
                if (!bIsDemoMode) break;
                FontMgr.drawStringAutoChangeLine(2, graphics, text[85], Device.WIDTH >> 1, Device.SPLASH_DEMO_TEXT_Y, 18, 17);
            }
        }
        if (brandIndex != 2) {
            Engine.paintTooltips(graphics, 2);
        }
    }

    public void setSoundEnable() {
        try {
            Device.deviceFunction(1, text[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Device.USE_BITMAP_FONTS) {
            FontMgr.release(font);
        }
        Engine.setMenu(menuSound);
        menuCurrent.setCursor(1);
    }

    private void setLanguageSelect() {
        String string = Engine.getJadValue("ms-multiLang");
        if (string != null) {
            if (string.equals("1")) {
                try {
                    int n;
                    byte[] byArray = ResourceMaster.getResourceFromJar("multi.dat");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    int n2 = dataInputStream.readInt();
                    String[] stringArray = new String[n2];
                    this.languageFiles = new String[n2];
                    for (n = 0; n < n2; ++n) {
                        stringArray[n] = dataInputStream.readUTF();
                    }
                    for (n = 0; n < n2; ++n) {
                        this.languageFiles[n] = dataInputStream.readUTF();
                    }
                    this.menuLanguage = new Menu("", stringArray, 0);
                    byteArrayInputStream.close();
                    dataInputStream.close();
                    byteArrayInputStream = null;
                    dataInputStream = null;
                    System.gc();
                    Engine.setMenu(this.menuLanguage);
                    FontMgr.realise(2);
                }
                catch (Exception exception) {}
            } else {
                this.initLanguage(string);
                this.setSoundEnable();
            }
        } else {
            this.initLanguage("lang.dat");
            this.setSoundEnable();
        }
    }

    private void closeLanguageSelect() {
        this.languageFiles = null;
    }

    public void initLanguage(String string) {
        Engine.initText("/" + string);
        String string2 = Engine.getJadValue("MIDlet-Version");
        int n = text[25].indexOf(94);
        if (n != -1) {
            Engine.text[25] = text[25].substring(0, n) + string2 + text[25].substring(n + 1);
        }
        try {
            Device.deviceFunction(1, text[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Device.USE_BITMAP_FONTS) {
            FontMgr.realise(2);
        }
        this.initMenus();
    }

    public static void startLoading() {
        if (loadingTextStrings != null) {
            loadingTextStrings = null;
        }
        Engine.startLoading(1);
    }

    public static void startLoadingWithTip() {
        String string;
        while ((string = "LOADING TIP").length() == 0) {
        }
        Engine.startLoading(1);
    }

    public static void startLoading(int n) {
        Device.soundFunction(1, null);
        loadingState = n;
        loadingProgress = 0;
        loadingProgressDisplay = 0;
        loadRandomNum = Engine.rndPositive(5);
        if (gameWorld != null) {
            gameWorld.hideNotify();
        }
    }

    public static void updateLoading(int n) {
        Engine.updateLoading(n, false);
    }

    public static void updateLoading(int n, boolean bl) {
        if (!bl) {
            loadingProgressDisplay = loadingProgress;
        }
        loadingProgress = n;
        if (bl) {
            loadingProgressDisplay = loadingProgress;
        }
        Engine.doRepaint();
    }

    public void tickLoading() {
        if (loadingState == 1) {
            if (loadingProgressDisplay < loadingProgress) {
                gameWorld.init();
                GameWorld.drawHud = true;
                Engine.doRepaint();
            } else {
                Engine.stopLoading();
                state = 100;
                Engine.playLevelSound();
            }
        } else if (loadingState == 2) {
            if (loadingProgressDisplay < loadingProgress) {
                Engine.destroyGameWorld();
                Engine.doRepaint();
            } else {
                Engine.stopLoading();
                menuCurrent.setCursor(0);
                Engine.loadMenuRes();
                Engine.setMenuContinue();
                Engine.setMenu(menuMain);
            }
        }
    }

    public static void stopLoading() {
        loadHill = null;
        loadElephant = null;
        loadSid = null;
        loadTiger = null;
        loadMouse = null;
        loadSquirrel = null;
        menuIce = null;
        loadingState = 0;
        Engine.releaseAllKeys();
        lastTick = System.currentTimeMillis();
    }

    public void paintLoading(Graphics graphics) {
        Engine.cls(graphics, 1133966);
        for (int i = 0; i < Device.HEIGHT * 3 / 10; ++i) {
            graphics.setColor(4299224 + 256 * i);
            graphics.drawLine(0, i, Device.WIDTH, i);
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, Device.HEIGHT * 3 / 10, Device.WIDTH, Device.HEIGHT * 7 / 10);
        loadHill.drawImage(graphics, 0, Device.HEIGHT * 3 / 12);
        loadHill.drawImage(graphics, 95, Device.HEIGHT * 3 / 12);
        loadHill.drawImage(graphics, 190, Device.HEIGHT * 3 / 12);
        menuIce.drawImage(graphics, Device.WIDTH / 4, Device.HEIGHT * 2 / 10);
        switch (loadRandomNum) {
            case 0: {
                loadElephant.drawImage(graphics, Device.WIDTH / 17, Device.HEIGHT / 16);
                FontMgr.drawString(2, graphics, Engine.getText(40), Device.WIDTH / 2, Device.HEIGHT * 3 / 5, 17);
                break;
            }
            case 1: {
                loadTiger.drawImage(graphics, Device.WIDTH * 2 / 5, Device.HEIGHT / 15);
                FontMgr.drawString(2, graphics, Engine.getText(41), Device.WIDTH / 2, Device.HEIGHT * 3 / 5, 17);
                break;
            }
            case 2: {
                loadSid.drawImage(graphics, 3 + Device.WIDTH * 16 / 25, Device.HEIGHT / 6);
                FontMgr.drawString(2, graphics, Engine.getText(42), Device.WIDTH / 2, Device.HEIGHT * 3 / 5, 17);
                break;
            }
            case 3: {
                loadSquirrel.drawImage(graphics, Device.WIDTH / 3, Device.HEIGHT * 2 / 5);
                FontMgr.drawString(2, graphics, Engine.getText(43), Device.WIDTH / 2, Device.HEIGHT * 3 / 5, 17);
                break;
            }
            case 4: {
                loadMouse.drawImage(graphics, Device.WIDTH / 2, Device.HEIGHT / 3);
                FontMgr.drawString(2, graphics, Engine.getText(44), Device.WIDTH / 2, Device.HEIGHT * 3 / 5, 17);
                break;
            }
        }
        if (loadingState == 1) {
            FontMgr.drawString(2, graphics, levelName[GameWorld.level], Device.WIDTH / 2, Device.HEIGHT * 3 / 4, 17);
        } else if (loadingState == 2) {
            FontMgr.drawString(2, graphics, Engine.getText(38), Device.WIDTH / 2, Device.HEIGHT * 3 / 4, 17);
        }
        graphics.setColor(3162987);
        graphics.drawRect(Device.WIDTH / 6, Device.HEIGHT * 9 / 10, Device.WIDTH * 2 / 3, 6);
        graphics.setColor(10206716);
        if (loadingProgressDisplay != 0) {
            graphics.fillRect(Device.WIDTH / 6 + 1, Device.HEIGHT * 9 / 10 + 1, Device.WIDTH * 2 / (3 * loadingProgress) * loadingProgressDisplay - 1, 5);
        }
    }

    public static int cap(int n, int n2) {
        if (n < 0) {
            return Math.max(n, -n2);
        }
        if (n > 0) {
            return Math.min(n, n2);
        }
        return n;
    }

    public static void paintTooltips(Graphics graphics, int n) {
        Engine.paintTooltips(graphics, n, 0, 0);
    }

    public static void paintTooltips(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1 + n2;
        int n5 = Device.WIDTH - Engine.tipsImages[0].width - 1 - n2;
        int n6 = Device.HEIGHT - Engine.tipsImages[0].height - 1 - n3;
        if ((n & 1) != 0) {
            tipsImages[2].drawImage(graphics, reverseTooltips ? n4 : n5, n6);
        } else if ((n & 4) != 0) {
            tipsImages[1].drawImage(graphics, reverseTooltips ? n5 : n4, n6);
        }
        if ((n & 2) != 0) {
            tipsImages[0].drawImage(graphics, reverseTooltips ? n5 : n4, n6);
        }
    }

    public static void paintCommandbar(Graphics graphics, int n, String string, String string2) {
        font = 0;
        boolean bl = true;
        int n2 = Device.WIDTH - Engine.tipsImages[0].width - 1;
        int n3 = Device.HEIGHT - FontMgr.charHeight[font] - 1;
        if ((n & 1) != 0) {
            FontMgr.drawString(font, graphics, string, reverseTooltips ? 1 : Device.WIDTH - FontMgr.stringWidth(font, string) - 1, n3, 20);
        }
        if ((n & 2) != 0) {
            FontMgr.drawString(font, graphics, string2, reverseTooltips ? Device.WIDTH - FontMgr.stringWidth(font, string2) - 1 : 1, n3, 20);
        }
    }

    private void tickEndingScreen() {
        if (endingImage1 == null) {
            endingImage1 = new DeviceImage(65570);
            endingImage2 = new DeviceImage(65571);
            endingImage3 = new DeviceImage(65572);
            brandTick = tick;
        }
        if (tick - brandTick > 100 || tick - brandTick > 10 && (Engine.isPressed(16) || Engine.isPressed(64))) {
            if (endingScreenState < 2) {
                ++endingScreenState;
                brandTick = tick;
                Engine.fadeOut(false, 0);
            } else {
                endingImage1 = null;
                endingImage2 = null;
                endingImage3 = null;
                Engine.setMenuContinue();
                Engine.loadMenuRes();
                Engine.setMenu(menuMain);
                menuCurrent.setCursor(0);
            }
        }
    }

    private void paintEndingScreen(Graphics graphics) {
        font = 1;
        Engine.cls(graphics, 0);
        switch (endingScreenState) {
            case 0: {
                endingImage1.drawImage(graphics, Device.WIDTH - Engine.endingImage1.width >> 1, Device.ENDINGSCREEN_PNG_POSY);
                FontMgr.drawStringAutoChangeLine(font, graphics, text[82], Device.WIDTH / 2, Device.ENDINGSCREEN_TEXT_POSY, 170, 17, 17);
                break;
            }
            case 1: {
                endingImage2.drawImage(graphics, Device.WIDTH - Engine.endingImage2.width >> 1, Device.ENDINGSCREEN_PNG_POSY);
                FontMgr.drawStringAutoChangeLine(font, graphics, text[83], Device.WIDTH / 2, Device.ENDINGSCREEN_TEXT_POSY, 170, 17, 17);
                break;
            }
            case 2: {
                endingImage3.drawImage(graphics, Device.WIDTH - Engine.endingImage3.width >> 1, Device.ENDINGSCREEN_PNG_POSY);
                FontMgr.drawStringAutoChangeLine(font, graphics, text[84], Device.WIDTH / 2, Device.ENDINGSCREEN_TEXT_POSY, 170, 17, 17);
                break;
            }
        }
        Engine.paintTooltips(graphics, 2);
    }

    public static void playLevelSound() {
        switch (GameWorld.level) {
            case 0: 
            case 3: 
            case 6: {
                DeviceSound.play(131076);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                DeviceSound.play(131077);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                DeviceSound.play(131074);
                break;
            }
        }
    }

    public void initMenus() {
        soundOn = false;
        font = 2;
        String[] stringArray = new String[]{Engine.getText(17), Engine.getText(18)};
        upsellMode = 0;
        Object object = Engine.getJadValue("ms-upSell");
        if (object != null) {
            upsellMode = Integer.valueOf((String)object);
        }
        if (upsellMode != 0) {
            bIsUpsellMode = true;
            upsellUrl = Engine.getJadValue("ms-upSellUrl");
        }
        if ((object = Engine.getJadValue("ms-demoMode")) != null) {
            demoMode = Integer.valueOf((String)object);
        }
        if (demoMode != 0) {
            bIsDemoMode = true;
            demoUrl = Engine.getJadValue("ms-demoUrl");
        }
        object = new Vector();
        Engine.setMenuContinue();
        ((Vector)object).addElement(Engine.getText(12));
        ((Vector)object).addElement(Engine.getText(13));
        ((Vector)object).addElement(Engine.getText(6));
        ((Vector)object).addElement(Engine.getText(7));
        ((Vector)object).addElement(Engine.getText(2));
        menuInGame = new Menu(text[11], Engine.vectorToStringArray((Vector)object), 0);
        ((Vector)object).removeAllElements();
        menuNewGame = new Menu(text[4], stringArray, 1);
        menuFigurines = new Menu(Engine.getText(9), stringArray, 1);
        this.initSettingsMenu();
        menuHelp = new Menu(Engine.getText(7), new String[]{Engine.getText(26)}, 1);
        menuAbout = new Menu(Engine.getText(8), new String[]{Engine.getText(25)}, 1);
        menuExit = new Menu(Engine.getText(10), stringArray, 1);
        menuSound = new Menu(text[14], stringArray, 1);
        menuRestart = new Menu(text[15], stringArray, 1);
        menuBackToMenu = new Menu(text[16], stringArray, 1);
        Menu.figurinesName[0] = Engine.getText(40);
        Menu.figurinesName[1] = Engine.getText(41);
        Menu.figurinesName[2] = Engine.getText(42);
        Menu.figurinesName[3] = Engine.getText(43);
        Menu.figurinesName[4] = Engine.getText(44);
        Menu.figurinesText[0] = Engine.getText(29);
        Menu.figurinesText[1] = Engine.getText(30);
        Menu.figurinesText[2] = Engine.getText(31);
        Menu.figurinesText[3] = Engine.getText(32);
        Menu.figurinesText[4] = Engine.getText(33);
        this.initCheatMenu();
    }

    public void initCheatMenu() {
    }

    public void initSettingsMenu() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(Engine.getText(soundOn ? 21 : 22));
        vector.addElement(Engine.getText(vibrateOn ? 23 : 24));
        menuSetting = new Menu(Engine.getText(6), Engine.vectorToStringArray(vector), 1);
    }

    public static void loadMenuRes() {
        menuSnowUp = new DeviceImage(65594);
        menuSnowRight = new DeviceImage(65593);
        menuSnowDown = new DeviceImage(65592);
        menuIce = new DeviceImage(65587);
        ScrollWordArrowUp = new DeviceImage(65569);
        ScrollWordArrowDown = new DeviceImage(65568);
        Engine.figurinesImage[0] = new DeviceImage(65580);
        Engine.figurinesImage[1] = new DeviceImage(65584);
        Engine.figurinesImage[2] = new DeviceImage(65582);
        Engine.figurinesImage[3] = new DeviceImage(65583);
        Engine.figurinesImage[4] = new DeviceImage(65581);
        Engine.figurinesBackgroundImage[0] = new DeviceImage(65575);
        Engine.figurinesBackgroundImage[1] = new DeviceImage(65579);
        Engine.figurinesBackgroundImage[2] = new DeviceImage(65577);
        Engine.figurinesBackgroundImage[3] = new DeviceImage(65578);
        Engine.figurinesBackgroundImage[4] = new DeviceImage(65576);
        figurinesArrowL = new DeviceImage(65573);
        figurinesArrowR = new DeviceImage(65574);
        FontMgr.realise(0);
        FontMgr.realise(1);
        FontMgr.realise(2);
        ResourceMaster.closeResource();
    }

    public static void setMenuContinue() {
        Vector<String> vector = new Vector<String>();
        if (menuMain != null) {
            menuMain = null;
        }
        if (bIsDemoMode) {
            vector.addElement(Engine.getText(92));
            vector.addElement(Engine.getText(86));
            if (bIsUpsellMode) {
                vector.addElement(Engine.getText(93));
            }
        } else {
            if (bIsUpsellMode) {
                vector.addElement(Engine.getText(93));
            }
            if (GameWorld.unlockLevelRecord > 0) {
                vector.addElement(Engine.getText(3));
            }
            vector.addElement(Engine.getText(4));
            vector.addElement(Engine.getText(9));
        }
        vector.addElement(Engine.getText(6));
        vector.addElement(Engine.getText(7));
        vector.addElement(Engine.getText(8));
        vector.addElement(Engine.getText(10));
        menuMain = new Menu(Demo.isEnabled() ? Engine.getText(85) : Engine.getText(2), Engine.vectorToStringArray(vector), 0);
        if (levelName == null) {
            levelName = Engine.getStrings(Engine.getText(28), 250, 2);
        }
        if (bIsUpsellMode) {
            menuUpsell = new Menu(Engine.getText(93), new String[]{Engine.getText(94)}, 1);
        }
        if (bIsDemoMode) {
            menuDemoGetTheGame = new Menu(Engine.getText(92), new String[]{Engine.getText(88)}, 1);
            menuDemoStart = new Menu(Engine.getText(85), new String[]{Engine.getText(88)}, 1);
            menuDemoEnd = new Menu(Engine.getText(87), new String[]{Engine.getText(90)}, 1);
        } else {
            String[] stringArray = new String[GameWorld.unlockLevelRecord + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = levelName[i];
            }
            menuContinue = new Menu(Engine.getText(5), stringArray, 1);
            vector.removeAllElements();
        }
    }

    public static void setMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        Engine.releaseAllKeys();
        if (menu.type != 0) {
            menu.previous = menuCurrent;
        }
        menuCurrent = menu;
        menuItemHeight = FontMgr.charHeight[font];
        state = 10;
    }

    public static void gotoUrl(String string) {
        if (string != null) {
            Device.soundFunction(1, null);
            try {
                Device.deviceFunction(0, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Engine.exit();
        }
    }

    public static Menu createForm(String string, String[] stringArray, Menu menu, Menu menu2) {
        Menu menu3 = new Menu(string, stringArray, 2);
        menu3.previous = menu;
        menu3.next = menu2;
        return menu3;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void initRMS() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                // empty if block
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > n) {
                byte[] byArray = recordStore.getRecord(n + 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (n2 == 0) {
                    vibrateOn = dataInputStream.readBoolean();
                } else if (n2 == 1) {
                    dataInputStream.read(saveSlotInfoBytes);
                } else if (n2 == 2) {
                    dataInputStream.read(saveSlotFigurinesBytes);
                }
                dataInputStream.close();
                byteArrayInputStream.close();
                dataInputStream = null;
                byteArrayInputStream = null;
                System.gc();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean saveRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 == 0) {
                dataOutputStream.writeBoolean(vibrateOn);
            } else if (n2 == 1) {
                ((OutputStream)dataOutputStream).write(saveSlotInfoBytes);
            } else if (n2 == 2) {
                ((OutputStream)dataOutputStream).write(saveSlotFigurinesBytes);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() <= n) {
                for (int i = recordStore.getNumRecords(); i <= n; ++i) {
                    if (i == n) {
                        recordStore.addRecord(byArray, 0, byArray.length);
                        continue;
                    }
                    recordStore.addRecord(new byte[0], 0, 0);
                }
            } else {
                recordStore.setRecord(n + 1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void deleteRMS(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initText(String string) {
        try {
            InputStream inputStream = null;
            DataInputStream dataInputStream = null;
            inputStream = instance.getClass().getResourceAsStream(string);
            dataInputStream = new DataInputStream(inputStream);
            text = new String[dataInputStream.readInt()];
            for (int i = 0; i < text.length; ++i) {
                Engine.text[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getText(int n) {
        if (n < text.length) {
            return text[n];
        }
        return null;
    }

    public static String getText(int n, String[] stringArray) {
        String string = new String(Engine.getText(n));
        if (stringArray.length == 1) {
            string = Engine.replaceText(string, "%U", stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = Engine.replaceText(string, "%U", stringArray[i]);
            }
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3) {
        String string4 = "";
        int n = 0;
        n = string.indexOf(string2);
        string4 = n != -1 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
        return string4;
    }

    public static String[] getStrings(String string, int n, int n2) {
        int n3;
        if (string == null || string.length() == 0) {
            return new String[]{""};
        }
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        int n5 = string.length();
        String string2 = null;
        do {
            n3 = n4;
            int n6 = string.indexOf(10, n3);
            block1: do {
                int n7 = n3;
                String string3 = string2;
                n3 = Engine.getWordIndex(string, n3);
                if (n6 > -1 && n6 < n3) {
                    n3 = n6;
                }
                if (FontMgr.stringWidth(n2, string2 = string.substring(n4, n3).trim()) <= n) continue;
                if (n7 == n4) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (FontMgr.stringWidth(n2, string4) > n) continue;
                        n3 = n7 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n3 = n7;
                string2 = string3;
                break;
            } while (n3 != n6 && n3 < n5);
            vector.addElement(string2);
        } while ((n4 = ++n3) < n5);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (Engine.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!Engine.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    public static String getJadValue(String string) {
        String string2 = parent.getAppProperty(string);
        return string2 != null ? string2.trim() : null;
    }

    public static int rnd(int n) {
        return random.nextInt() % n;
    }

    public static int rndPositive(int n) {
        return Math.abs(random.nextInt() % n);
    }

    public static boolean isPressed(int n) {
        return (keysPressed & n) != 0;
    }

    public static boolean isDoublePressed(int n) {
        if (isDoubleKey && Engine.isPressed(n)) {
            return true;
        }
        if (tickKey < 7 && lastKey == n && Engine.isPressed(n)) {
            isDoubleKey = true;
            return true;
        }
        return false;
    }

    public static boolean isPressedRepeat(int n) {
        if (keyRepeatTimeout == 0) {
            boolean bl = Engine.isPressed(n);
            if (bl) {
                if (blah) {
                    keyRepeatTimeout = 400;
                    blah = false;
                } else {
                    keyRepeatTimeout = 80;
                }
            }
            return bl;
        }
        return false;
    }

    public static boolean key(int n) {
        if ((keyLatch & n) != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static boolean hasAnyKeyPressed() {
        if (keysPressed != 0) {
            keysPressed = 0;
            return true;
        }
        return false;
    }

    public static void resetKeyBuffers() {
        keyUnmapped = 0;
        keyLatch = 0;
    }

    public static void releaseAllKeys() {
        keysPressed = 0;
        keyLatch = 0;
        keyRepeatTimeout = 0;
        blah = false;
    }

    public static void releaseKey(int n) {
        keysPressed &= ~n;
        isDoubleKey = false;
        blah = false;
    }

    public synchronized void keyPressed(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed |= n2;
            lastKeyPressed = n2;
            keyLatch |= n2;
            keyUnmapped = n;
            blah = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void keyReleased(int n) {
        try {
            int n2 = this.getKeyMap(n);
            keysPressed &= ~n2;
            keyRepeatTimeout = 0;
            blah = false;
            lastKey = n2;
            tickKey = 0;
            isDoubleKey = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pointerPressed(int n, int n2) {
        super.pointerPressed(n, n2);
    }

    public void pointerDragged(int n, int n2) {
        super.pointerDragged(n, n2);
    }

    public void pointerReleased(int n, int n2) {
        super.pointerReleased(n, n2);
    }

    public static void doRepaint() {
        instance.repaint();
        instance.serviceRepaints();
    }

    private void handleEvent() {
        handleEvent = false;
        Engine.resetKeyBuffers();
        if (state != 4 && loadingState == 0) {
            Device.soundFunction(1);
            if (text != null) {
                pauseState = state;
                state = 4;
                if (gameWorld != null) {
                    Engine.gameWorld.bIsFreezeTime = true;
                }
            }
        }
        if (gameWorld != null) {
            gameWorld.hideNotify();
        }
    }

    public static byte[] insertPLTE(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray2 == null) {
            return byArray;
        }
        int n2 = 37;
        for (n = 0; n < byArray.length - 4; ++n) {
            if (byArray[n] != 80 || byArray[n + 1] != 76 || byArray[n + 2] != 84 || byArray[n + 3] != 69) continue;
            n2 = n;
            break;
        }
        n = n2 - 4;
        int n3 = ((byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) & 0xFFFFFFFF;
        byte[] byArray3 = new byte[byArray.length - (n3 += 12) + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n + n3, byArray3, n + byArray2.length, byArray.length - (n + n3));
        return byArray3;
    }

    public static int scale(int n, int n2) {
        if (SCALE_VALUES[n] == 'd') {
            return n2;
        }
        return SCALE_VALUES[n] * n2 / 100;
    }

    public static int[] addToArray(int[] nArray, int[] nArray2, boolean bl) {
        bl = bl && nArray.length > 0;
        int[] nArray3 = nArray;
        int[] nArray4 = new int[nArray.length + nArray2.length];
        if (bl) {
            System.arraycopy(nArray3, 0, nArray4, nArray2.length, nArray3.length);
        } else {
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (bl) {
                nArray4[i] = nArray2[i];
                continue;
            }
            nArray4[nArray.length + i] = nArray2[i];
        }
        return nArray4;
    }

    public static int[] removeFromArray(int[] nArray, int n, boolean bl) {
        int[] nArray2 = new int[nArray.length - n];
        System.arraycopy(nArray, bl ? n : 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public static int[] removeFromArray(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        int[] nArray3 = new int[Math.max(0, nArray.length - n2 - 1)];
        System.arraycopy(nArray, n2 + 1, nArray3, 0, nArray3.length);
        int[] nArray4 = new int[nArray.length - (n2 - n) - 1];
        System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
        System.arraycopy(nArray3, 0, nArray4, nArray2.length, nArray3.length);
        return nArray4;
    }

    public static byte[] vectorToByteArray(Vector vector) {
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)vector.elementAt(i);
        }
        return byArray;
    }

    public static int[] vectorToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public static String[] vectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void echo(String string) {
    }

    public static void echo(int n) {
        Engine.echo("" + n);
    }

    public static void startMemCheck(String string) {
        currentMemMsg = string;
        Runtime.getRuntime().gc();
        currentMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[startMemCheck] " + string + ": " + currentMem);
    }

    public static void endMemCheck() {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[endMemCheck] " + currentMemMsg + ": " + l + " (" + (l - currentMem) + " increase)");
    }

    public static void instantMemCheck(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Engine.echo("[instantMemCheck] " + string + ": " + l);
    }

    public static String fillZeros(String string, int n) {
        if (string.length() < n) {
            int n2 = n - string.length();
            for (int i = 0; i < n2; ++i) {
                string = "0" + string;
            }
        }
        return string;
    }

    public static byte[] initByteArray(DataInputStream dataInputStream) throws Exception {
        return Engine.initByteArray(dataInputStream, false);
    }

    public static byte[] initByteArray(DataInputStream dataInputStream, boolean bl) throws Exception {
        int n = bl ? dataInputStream.readShort() : (int)dataInputStream.readByte();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        return byArray;
    }

    public static byte[][] initByte2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readByte();
            if (n2 <= 0) continue;
            byArrayArray[i] = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                byArrayArray[i][j] = dataInputStream.readByte();
            }
        }
        return byArrayArray;
    }

    public static int[] initIntArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static short[] initShortArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static short[][] initShort2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        short[][] sArrayArray = new short[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readShort();
            if (n2 <= 0) continue;
            sArrayArray[i] = new short[n2];
            for (int j = 0; j < n2; ++j) {
                sArrayArray[i][j] = dataInputStream.readShort();
            }
        }
        return sArrayArray;
    }

    public static int[][] initInt2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            if (n2 <= 0) continue;
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArrayArray[i][j] = dataInputStream.readInt();
            }
        }
        return nArrayArray;
    }

    public static int getMapping(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; i += 2) {
            if (n != byArray[i]) continue;
            return byArray[i + 1];
        }
        return -1;
    }

    public static short getMapping(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; i += 2) {
            if (n != sArray[i]) continue;
            return sArray[i + 1];
        }
        return -1;
    }

    public static int getMappingReversed(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; i += 2) {
            if (n != byArray[i + 1]) continue;
            return byArray[i];
        }
        return -1;
    }

    public static int getMapping(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!string.equals(stringArray[i])) continue;
            return Integer.parseInt(stringArray[i + 1]);
        }
        return -1;
    }

    public static byte[] fromVectorToByteArray(Vector vector) {
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)vector.elementAt(i);
        }
        return byArray;
    }

    public static short[] fromVectorToShortArray(Vector vector) {
        short[] sArray = new short[vector.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (Short)vector.elementAt(i);
        }
        return sArray;
    }

    public static int[] fromVectorToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public static String[] fromVectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static byte[][] fromVectorsToByteArrays(Vector vector) {
        byte[][] byArrayArray = new byte[vector.size()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            Object e = vector.elementAt(i);
            if (e == null) continue;
            Vector vector2 = (Vector)e;
            byArrayArray[i] = new byte[vector2.size()];
            for (int j = 0; j < byArrayArray[i].length; ++j) {
                byArrayArray[i][j] = (Byte)vector2.elementAt(j);
            }
        }
        return byArrayArray;
    }

    public static int getIndexInArray(byte[] byArray, int n) {
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (n != byArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexInArray(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int mul(int n, int n2) {
        return (n >> 4) * (n2 >> 4);
    }

    public static int div(int n, int n2) {
        int n3 = n2 >> 8 == 0 ? n : (n << 8) / n2;
        return n3;
    }

    public static void writeIntArray(int[] nArray, DataOutputStream dataOutputStream) throws Exception {
        if (nArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
        }
    }

    public static void writeShortArray(short[] sArray, DataOutputStream dataOutputStream) throws Exception {
        if (sArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                dataOutputStream.writeShort(sArray[i]);
            }
        }
    }

    public static void writeInt2Array(int[][] nArray, DataOutputStream dataOutputStream) throws Exception {
        if (nArray == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null) {
                    dataOutputStream.writeByte(-1);
                    continue;
                }
                Engine.writeIntArray(nArray[i], dataOutputStream);
            }
        }
    }

    public static void writeBooleanArray(boolean[] blArray, DataOutputStream dataOutputStream) throws Exception {
        if (blArray == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                dataOutputStream.writeBoolean(blArray[i]);
            }
        }
    }

    public static int[] readIntArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static short[] readShortArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static int[][] readInt2Array(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        if (n == -1) {
            return null;
        }
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readByte();
            if (n2 == -1) continue;
            nArrayArray[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArrayArray[i][j] = dataInputStream.readInt();
            }
        }
        return nArrayArray;
    }

    public static boolean[] readBooleanArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readShort();
        if (n == -1) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    public static void writeByteArray(byte[] byArray, DataOutputStream dataOutputStream) throws Exception {
        if (byArray == null) {
            dataOutputStream.writeShort(-1);
        } else {
            dataOutputStream.writeShort(byArray.length);
            ((OutputStream)dataOutputStream).write(byArray);
        }
    }

    public static byte[] readByteArray(DataInputStream dataInputStream) throws Exception {
        short s = dataInputStream.readShort();
        if (s == -1) {
            return null;
        }
        byte[] byArray = new byte[s];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static void exit() {
        running = false;
    }

    public static void fadeOut(boolean bl, int n) {
        if (bl) {
            fadeState = 3;
            fadeEvent = n;
        } else {
            fadeStep = 0;
            fadeState = 2;
            fadeEvent = n;
        }
    }

    public static void fadeIn(boolean bl) {
        if (bl) {
            fadeState = 0;
        } else {
            fadeStep = 0;
            fadeState = 1;
        }
        fadeEvent = -1;
    }

    public static void tickFade() {
        if (fadeState == 1 || fadeState == 2) {
            if (fadeStep > 2) {
                if (fadeState == 1) {
                    fadeState = 0;
                } else if (fadeState == 2) {
                    fadeState = 3;
                    Engine.fadeIn(false);
                }
                if (gameWorld != null) {
                    gameWorld.fadeComplete();
                }
                return;
            }
            ++fadeStep;
            if (gameWorld != null) {
                GameWorld.drawHud = true;
            }
        }
    }

    public static boolean fading() {
        return fadeState != 0;
    }

    public static void drawFade(Graphics graphics) {
        Engine.saveAndSetClip(graphics, 0, 0, Device.WIDTH, Device.HEIGHT);
        if (fadeState == 3) {
            Engine.cls(graphics, 0);
        } else if (fadeState == 1 || fadeState == 2) {
            Device.drawFadeEffect(graphics);
        }
        Engine.restoreClip(graphics);
    }

    public static int getColor(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return n;
        }
        if (n3 >= n4) {
            return n2;
        }
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        return (n8 - n5) * n3 / n4 + n5 << 16 | (n9 - n6) * n3 / n4 + n6 << 8 | (n10 - n7) * n3 / n4 + n7;
    }

    public static void drawBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Device.drawARGBRect(graphics, n5, n, n2, n3, n4);
    }

    public static void saveAndSetClip(Graphics graphics, int n, int n2, int n3, int n4) {
        Engine.saveClip(graphics);
        graphics.setClip(n, n2, n3, n4);
    }

    public static void saveAndClipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Engine.saveClip(graphics);
        graphics.clipRect(n, n2, n3, n4);
    }

    public static void saveClip(Graphics graphics) {
        clipX = graphics.getClipX();
        clipY = graphics.getClipY();
        clipW = graphics.getClipWidth();
        clipH = graphics.getClipHeight();
    }

    public static void restoreClip(Graphics graphics) {
        graphics.setClip(clipX, clipY, clipW, clipH);
    }

    public static void drawImageWidth(Graphics graphics, DeviceImage deviceImage, int n, int n2, int n3) {
        int n4;
        for (n4 = n; n4 <= n3 - deviceImage.width; n4 += deviceImage.width) {
            deviceImage.drawImage(graphics, n4, n2);
        }
        if (n4 < n3) {
            Engine.saveAndClipRect(graphics, n4, 0, n3 - n4, Device.HEIGHT);
            deviceImage.drawImage(graphics, n4, n2);
            Engine.restoreClip(graphics);
        }
    }

    public static boolean isRectInRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n5 + n7 > n && n5 < n + n3 && n6 + n8 > n2 && n6 < n2 + n4;
    }

    public static boolean isPointInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    public static int addToValue(int n, int n2, int n3) {
        if ((n += n2) > n3 - 1) {
            return 0;
        }
        if (n < 0) {
            return n3 - 1;
        }
        return n;
    }

    public static void scroll(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3, int n9) {
        n5 = Math.max(n5, n3);
        n5 = Math.min(n5, n7 - n);
        n6 = Math.max(n6, n4);
        n6 = Math.min(n6, n8 - n2);
        if (bl) {
            nArray[0] = n5;
            nArray[1] = n6;
        } else {
            int n10 = (n5 - nArray[0]) / 2;
            int n11 = (n6 - nArray[1]) / 2;
            if (n11 > 10) {
                GameWorld.drawHud = true;
            }
            if (n9 == -2) {
                n10 = n5 - nArray[0];
                n11 = n6 - nArray[1];
            } else if (n9 != -1) {
                n10 = Engine.cap(n10, n9);
                n11 = Engine.cap(n11, n9);
            }
            if (n10 == 0 && nArray[0] != n5) {
                nArray[0] = n5;
                GameWorld.drawHud = true;
            } else {
                nArray[0] = nArray[0] + n10;
            }
            if (n11 == 0 && nArray[1] != n6) {
                nArray[1] = n6;
                GameWorld.drawHud = true;
            } else {
                nArray[1] = nArray[1] + n11;
            }
        }
        if (nArray[0] < n3) {
            nArray[0] = n3;
        } else if (nArray[0] + Device.WIDTH > n7) {
            nArray[0] = n7 - Device.WIDTH;
        }
        if (nArray[1] < n4) {
            nArray[1] = n4;
        } else if (nArray[1] + n2 > n8) {
            nArray[1] = n8 - n2;
        }
        if (bl2) {
            nArray[0] = (n7 - n) / 2;
        }
        if (bl3) {
            nArray[1] = (n8 - n2) / 2;
        }
    }

    static {
        isCheatMode = false;
        debugTimeStamp = null;
        lastSound = -1;
        vibrateOn = true;
        soundOn = true;
        random = new Random();
        figurinesImage = new DeviceImage[5];
        figurinesBackgroundImage = new DeviceImage[5];
        state = -1;
        fullScreenAlphaFadeType = -1;
        fullScreenAlphaFadeTime = 0;
        bEndingScreen = false;
        saveSlotInfoBytes = new byte[3];
        saveSlotFigurinesBytes = new byte[5];
        lastKey = 0;
        tickKey = 0;
        isDoubleKey = false;
    }
}

