/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class DataManager {
    public static final String ARRAYS_BIN = "arrays.bin";
    public static byte[] N_TYPE_BYTES;
    public static byte[] N_TYPE_INTS;
    public static byte[] N_TYPE_INTS2;
    public static byte[] N_TYPE_INTS3;
    public static byte[] N_TYPE_BOOLEANS;
    public static byte[] N_TYPE_OBJECTS;
    public static byte[] N_TYPE_STRINGS2;
    public static short[] INTERACTABLE_TILES;
    public static byte[] SCRIPT_STEP_LENGTHS;
    public static byte[] SPRITES_ON_BOTTOM;
    public static byte[] LEVEL_TIME_LIMIT;
    public static byte[] UNIQUE_ITEM_TYPES;

    public static void initFile(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource(string)));
            if (string == ARRAYS_BIN) {
                N_TYPE_BYTES = DataManager.readByteArray(dataInputStream);
                N_TYPE_INTS = DataManager.readByteArray(dataInputStream);
                N_TYPE_INTS2 = DataManager.readByteArray(dataInputStream);
                N_TYPE_INTS3 = DataManager.readByteArray(dataInputStream);
                N_TYPE_BOOLEANS = DataManager.readByteArray(dataInputStream);
                N_TYPE_OBJECTS = DataManager.readByteArray(dataInputStream);
                N_TYPE_STRINGS2 = DataManager.readByteArray(dataInputStream);
                INTERACTABLE_TILES = DataManager.readShortArray(dataInputStream);
                SCRIPT_STEP_LENGTHS = DataManager.readByteArray(dataInputStream);
                SPRITES_ON_BOTTOM = DataManager.readByteArray(dataInputStream);
                LEVEL_TIME_LIMIT = DataManager.readByteArray(dataInputStream);
                UNIQUE_ITEM_TYPES = DataManager.readByteArray(dataInputStream);
            }
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            DebugManager.debug(exception);
        }
    }

    public static void closeFile(String string) {
        if (string == ARRAYS_BIN) {
            N_TYPE_BYTES = null;
            N_TYPE_INTS = null;
            N_TYPE_INTS2 = null;
            N_TYPE_INTS3 = null;
            N_TYPE_BOOLEANS = null;
            N_TYPE_OBJECTS = null;
            N_TYPE_STRINGS2 = null;
            INTERACTABLE_TILES = null;
            SCRIPT_STEP_LENGTHS = null;
            SPRITES_ON_BOTTOM = null;
            LEVEL_TIME_LIMIT = null;
            UNIQUE_ITEM_TYPES = null;
        }
    }

    public static byte[] readByteArray(DataInputStream dataInputStream) throws Exception {
        byte[] byArray = new byte[dataInputStream.read()];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static short[] readShortArray(DataInputStream dataInputStream) throws Exception {
        short[] sArray = new short[dataInputStream.read()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public static int[] readIntArray(DataInputStream dataInputStream) throws Exception {
        int[] nArray = new int[dataInputStream.read()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static String[] readStringArray(DataInputStream dataInputStream) throws Exception {
        String[] stringArray = new String[dataInputStream.read()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    public static byte[][] readFileArray(DataInputStream dataInputStream) throws Exception {
        byte[][] byArrayArray = new byte[dataInputStream.read()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = new byte[dataInputStream.readShort()];
            dataInputStream.readFully(byArrayArray[i]);
        }
        return byArrayArray;
    }

    public static short[][] readShort2Array(DataInputStream dataInputStream) throws Exception {
        short[][] sArrayArray = new short[dataInputStream.read()][];
        for (int i = 0; i < sArrayArray.length; ++i) {
            int n = dataInputStream.read();
            sArrayArray[i] = new short[n];
            for (int j = 0; j < n; ++j) {
                sArrayArray[i][j] = dataInputStream.readShort();
            }
        }
        return sArrayArray;
    }

    public static byte[][] readByte2Array(DataInputStream dataInputStream) throws Exception {
        byte[][] byArrayArray = new byte[dataInputStream.read()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            int n = dataInputStream.read();
            byArrayArray[i] = new byte[n];
            for (int j = 0; j < n; ++j) {
                byArrayArray[i][j] = dataInputStream.readByte();
            }
        }
        return byArrayArray;
    }

    public static short[] readUnsignedByteArray(DataInputStream dataInputStream) throws Exception {
        short[] sArray = new short[dataInputStream.read()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)dataInputStream.read();
        }
        return sArray;
    }

    public static short[][] readUnsignedByte2Array(DataInputStream dataInputStream) throws Exception {
        short[][] sArrayArray = new short[dataInputStream.read()][];
        for (int i = 0; i < sArrayArray.length; ++i) {
            int n = dataInputStream.read();
            sArrayArray[i] = new short[n];
            for (int j = 0; j < n; ++j) {
                sArrayArray[i][j] = (short)dataInputStream.read();
            }
        }
        return sArrayArray;
    }

    public static byte[] readFile(DataInputStream dataInputStream) throws Exception {
        byte[] byArray = new byte[dataInputStream.readShort()];
        dataInputStream.readFully(byArray);
        return byArray;
    }
}

