/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound {
    private static Player[] sounds;
    private static int[] SOUND_FILES;
    private static int[] SOUND_FORMATS;
    private static Player midi_current;
    private static Player wav_current;

    public static void init() {
        try {
            sounds = new Player[SOUND_FILES.length];
            for (int i = 0; i < sounds.length; ++i) {
                if (SOUND_FILES[i] == -1) continue;
                DeviceSound.sounds[i] = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResource(SOUND_FILES[i])), (String)(SOUND_FORMATS[i] == 0 ? "audio/midi" : "audio/x-wav"));
                sounds[i].realize();
                sounds[i].prefetch();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int n) {
        DeviceSound.play(n &= 0xFFFF, 100);
    }

    public static void play(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = SOUND_FORMATS[n &= 0xFFFF] == 0;
        if (bl) {
            Engine.lastSound = n;
        }
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            if (bl) {
                DeviceSound.stop(true);
                midi_current = sounds[n];
                if (n == 3) {
                    midi_current.setLoopCount(-1);
                }
                midi_current.setMediaTime(0L);
                midi_current.start();
            } else if (!DeviceSound.isSoundPlaying(false) && n2 > 0) {
                wav_current = sounds[n];
                wav_current.setLoopCount(1);
                VolumeControl volumeControl = (VolumeControl)wav_current.getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(n2);
                }
                wav_current.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop(boolean bl) {
        try {
            if (bl && midi_current != null) {
                midi_current.stop();
                midi_current = null;
            } else if (!bl && wav_current != null) {
                wav_current.stop();
                wav_current = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !DeviceSound.isSoundPlaying(true)) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying(true);
        }
        return true;
    }

    public static boolean isSoundPlaying(boolean bl) {
        if (bl) {
            return midi_current != null && midi_current.getState() == 400;
        }
        return wav_current != null && wav_current.getState() == 400;
    }

    static {
        SOUND_FILES = new int[]{131072, 131073, 131074, 131075, 131076, 131077, 131078, 131079, 131080, 131081, 131082, 131083, 131084, 131085};
        SOUND_FORMATS = new int[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1};
    }
}

