/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameObject
implements Constants {
    public static GameWorld gameWorld;
    public int type;
    public GameObject object_link;
    public byte[] bytes;
    public int[] ints;
    public int[][] ints2;
    public int[][][] ints3;
    public boolean[] booleans;
    public String[][] strings2;
    public int x;
    public int y;
    public int velX;
    public int velY;
    public int accX;
    public int accY;
    public int hp = 4;
    public int spriteId;
    public SGSprite sprite;
    public int collisionOffsetX;
    public int collisionOffsetY;
    public int collisionWidth;
    public int collisionHeight;
    public static int gameViewXRecord;
    public static int gameViewYRecord;
    public int wallFireClipXRecord;
    public int wallFireClipWRecord;
    public int wallFireClipHRecord;
    private long stoneTick = 0L;
    private boolean bIsRhinoHasDash = false;
    public boolean bIsHurt = false;
    public int hurtTick = 0;
    public GameObject attackArea = null;
    public boolean bIsStoneCoverSpring = false;
    public boolean bIsStoneCoverWallFire = false;
    public boolean bIsPlayerOnLavaPlatform = false;
    private int lavaPlatformAnimTick = 0;
    private boolean bIsDrown = false;

    public static GameObject createFromPrecisePosition(int n, int n2) {
        return new GameObject(n, n2);
    }

    public static GameObject createFromPosition(int n, int n2) {
        return new GameObject(n << 8, n2 << 8);
    }

    public static GameObject createFromTile(int n, int n2) {
        return GameObject.createFromPosition(n2 * 16 + 8, n * 16 + 8);
    }

    public GameObject() {
    }

    public GameObject(int n) {
        this.type = n;
        this.initArrays();
    }

    public GameObject(int n, int n2) {
        this();
        this.setX(n);
        this.setY(n2);
        this.initArrays();
    }

    public void setSprite(int n) {
        this.spriteId = n;
        this.sprite = new SGSprite(GameWorld.sprites[n]);
    }

    public void changeSprite(int n) {
        this.spriteId = n;
        SGSprite sGSprite = new SGSprite(GameWorld.sprites[n]);
        sGSprite.x = this.sprite.x;
        sGSprite.y = this.sprite.y;
        this.sprite = sGSprite;
    }

    public void setX(int n) {
        this.x = n;
        if (this.sprite != null) {
            this.sprite.x = n >> 8;
        }
    }

    public void setY(int n) {
        this.y = n;
        if (this.sprite != null) {
            this.sprite.y = n >> 8;
        }
    }

    public void setRow(int n) {
        this.setY(16 * n + 8 << 8);
    }

    public void setCol(int n) {
        this.setX(16 * n + 8 << 8);
    }

    public void setTile(int n, int n2) {
        this.setRow(n);
        this.setCol(n2);
    }

    public void refreshPosition() {
        this.setX(this.x);
        this.setY(this.y);
    }

    public void moveX(int n) {
        this.setX(this.x + n);
    }

    public void moveY(int n) {
        this.setY(this.y + n);
    }

    public int getRow() {
        return this.getRow(0);
    }

    public int getRow(int n) {
        return (this.y + n >> 8) / 16;
    }

    public int getCol() {
        return (this.x >> 8) / 16;
    }

    public int getCollisionX() {
        return this.x + this.collisionOffsetX;
    }

    public int getCollisionY() {
        return this.y + this.collisionOffsetY;
    }

    public void initArrays() {
        this.bytes = new byte[10];
        this.ints = new int[8];
        this.ints2 = new int[3][];
        this.ints3 = new int[1][][];
        this.booleans = new boolean[3];
        this.strings2 = new String[1][];
    }

    public void tick() {
        if (GameWorld.isObserveStyle) {
            if (this != GameWorld.observeObject) {
                return;
            }
        }
        this.velX += this.accX;
        this.velY += this.accY;
        this.accX = 0;
        this.accY = 0;
        if (this.type == 1 && this.spriteId != 14) {
            this.ints[2] = this.x;
            this.ints[3] = this.y;
        }
        if (this.type != 5 && (this.velX != 0 || this.spriteId == 1 || this.spriteId == 2 || this.spriteId == 3 || this.spriteId == 5 || this.spriteId == 22 || this.spriteId == 29)) {
            this.moveX(this.velX);
            if (this.spriteId != 15 && (this.x <= 0 || this.x >= GameWorld.mapWidth << 8)) {
                this.moveX(-this.velX);
            }
            if (!(this.spriteId != 1 && this.spriteId != 2 && this.spriteId != 3 && this.spriteId != 5 && this.spriteId != 12 && this.spriteId != 15 && this.spriteId != 5 && this.spriteId != 22 && this.spriteId != 29 && this.spriteId != 36 || GameObject.gameWorld.state != 0 || Engine.isCheatMode)) {
                if (this.spriteId != 22) {
                    this.checkCollisions(0, 0);
                }
                if (this.spriteId != 12) {
                    this.checkCollisions(0, 1);
                }
            }
        }
        if (this.type != 5 && (this.velY != 0 || this.spriteId == 1 || this.spriteId == 2 || this.spriteId == 3 || this.spriteId == 5 || this.spriteId == 22 || this.spriteId == 29)) {
            this.moveY(this.velY);
            if (this.spriteId != 15 && (this.y <= 0 || this.y >= GameWorld.mapHeight << 8)) {
                this.moveY(-this.velY);
            }
            if (!(this.spriteId != 1 && this.spriteId != 2 && this.spriteId != 3 && this.spriteId != 5 && this.spriteId != 12 && this.spriteId != 15 && this.spriteId != 5 && this.spriteId != 22 && this.spriteId != 29 && this.spriteId != 36 || GameObject.gameWorld.state != 0 || Engine.isCheatMode)) {
                if (this.spriteId != 22) {
                    this.checkCollisions(1, 0);
                }
                if (this.spriteId != 12) {
                    this.checkCollisions(1, 1);
                }
            }
        }
        if (this.type == 1) {
            this.tickHurt();
            if (this.spriteId == 22) {
                this.tickRhinoceros();
            } else {
                this.tickCharacter();
            }
        } else if (this.type == 5) {
            this.tickSpeechBubble();
        } else if (this.type == 2 && this.sprite.visible) {
            this.tickHint();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tickCharacter() {
        block172: {
            block169: {
                block171: {
                    block170: {
                        block162: {
                            block165: {
                                block163: {
                                    block168: {
                                        block167: {
                                            block166: {
                                                block164: {
                                                    if (!this.bIsHurt) {
                                                        this.hurtTick = Engine.tick;
                                                    }
                                                    if (this == GameWorld.player) {
                                                        if ((this.spriteId == 3 && this.sprite.currentAnimation == 19 || this.spriteId == 1 && this.sprite.currentAnimation >= 11 && this.sprite.currentAnimation <= 14 || this.spriteId == 2 && this.sprite.currentAnimation >= 23 && this.sprite.currentAnimation <= 26) && !this.sprite.animationDone) {
                                                            Engine.releaseAllKeys();
                                                            return;
                                                        }
                                                        if (this.spriteId == 3 && this.sprite.currentAnimation == 20 || this.spriteId == 2 && this.sprite.currentAnimation == 21 || this.spriteId == 1 && this.sprite.currentAnimation == 9) {
                                                            if (!this.sprite.animationDone) {
                                                                this.velX = 0;
                                                                this.velY = 0;
                                                                return;
                                                            }
                                                            this.bIsHurt = true;
                                                            this.setRow(this.ints[4]);
                                                            this.setCol(this.ints[5]);
                                                            this.checkCollisions(0, 0);
                                                            this.checkCollisions(1, 0);
                                                            this.setMovementAnimation();
                                                        }
                                                        if (this.spriteId == 1 && this.sprite.currentAnimation == 10 || this.spriteId == 2 && this.sprite.currentAnimation == 22 || this.spriteId == 3 && this.sprite.currentAnimation == 21) {
                                                            if (this.sprite.animationDone) {
                                                                GameWorld.playerLocked = false;
                                                                this.bIsHurt = true;
                                                                this.setTile(this.ints[4], this.ints[5]);
                                                                this.checkCollisions(0, 0);
                                                                this.checkCollisions(1, 0);
                                                                this.setMovementAnimation();
                                                            } else {
                                                                this.velX = 0;
                                                                this.velY = 0;
                                                                return;
                                                            }
                                                        }
                                                        GameObject.gameWorld.tickPlayer();
                                                    }
                                                    if (this.spriteId == 19 || this.spriteId == 29) {
                                                        return;
                                                    }
                                                    if (this.spriteId == 39) {
                                                        return;
                                                    }
                                                    if (this.spriteId == 10 && GameWorld.player != null) {
                                                        if (this.sprite.currentAnimation == 6 && Engine.isPointInRect(GameWorld.player.x, GameWorld.player.y, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight) && this.ints[6] != 0) {
                                                            if (this.ints[6] == 1 && this.stoneTick % 50L == 0L) {
                                                                var1_1 = this.collisionWidth / 8192;
                                                                var2_12 = this.collisionHeight / 8192;
                                                                var3_21 = GameWorld.createCharacter(15, 1, GameWorld.level, this.getRow() - var1_1, this.getCol() - var2_12);
                                                                var3_21.bytes[1] = 2;
                                                                var4_27 = GameWorld.createCharacter(15, 1, GameWorld.level, this.getRow() - var1_1, this.getCol() + var2_12);
                                                                var4_27.bytes[1] = 4;
                                                                var5_31 = GameWorld.createCharacter(15, 1, GameWorld.level, this.getRow() + var1_1, this.getCol() - var2_12);
                                                                var5_31.bytes[1] = 0;
                                                                var6_34 = GameWorld.createCharacter(15, 1, GameWorld.level, this.getRow() + var1_1, this.getCol() + var2_12);
                                                                var6_34.bytes[1] = 6;
                                                                GameObject.gameWorld.addObject(var3_21, false);
                                                                GameObject.gameWorld.addObject(var4_27, false);
                                                                GameObject.gameWorld.addObject(var5_31, false);
                                                                GameObject.gameWorld.addObject(var6_34, true);
                                                            } else if (this.ints[6] == 2 && this.stoneTick % 30L == 0L) {
                                                                var1_2 = GameWorld.createCharacter(15, 0, GameWorld.level, 0, 0);
                                                                var1_2.bytes[1] = -1;
                                                                GameObject.gameWorld.addObject(var1_2, true);
                                                                var1_2.sprite.visible = true;
                                                                var1_2.setX(this.x + this.collisionOffsetX + Engine.rndPositive(this.collisionWidth));
                                                                var1_2.setY(this.y + this.collisionOffsetY + Engine.rndPositive(this.collisionHeight));
                                                                var1_2.sprite.startAnimation(4, 1);
                                                            }
                                                            ++this.stoneTick;
                                                        } else if (this.sprite.currentAnimation == 6 && this.ints[6] == 0) {
                                                            if (this.stoneTick % 50L == 0L) {
                                                                var1_3 = GameWorld.createCharacter(15, 1, GameWorld.level, this.getRow(), this.getCol());
                                                                var1_3.bytes[1] = this.bytes[1];
                                                                var1_3.booleans[1] = true;
                                                                GameObject.gameWorld.addObject(var1_3, true);
                                                            }
                                                            ++this.stoneTick;
                                                        }
                                                        if (this.stoneTick == 0x7FFFFFFFFFFFFFFFL) {
                                                            this.stoneTick = 0L;
                                                        }
                                                        return;
                                                    }
                                                    if (GameWorld.player == null || this.spriteId != 5) break block162;
                                                    var1_4 = GameWorld.getTile(this.getRow(), this.getCol());
                                                    if (!this.isMoving()) break block163;
                                                    if (GameWorld.getTileSprite(var1_4).getAnimationSequenceDuration(var1_4 % 200) != 350) break block164;
                                                    if (this.velX > 0) {
                                                        this.velX = 1024;
                                                    } else if (this.velX < 0) {
                                                        this.velX = -1024;
                                                    }
                                                    if (this.velY > 0) {
                                                        this.velY = 1024;
                                                    } else if (this.velY < 0) {
                                                        this.velY = -1024;
                                                    }
                                                    GameWorld.player.stop();
                                                    GameObject.gameWorld.focusedObject = this;
                                                    GameWorld.isPlayerMoveStone = false;
                                                    break block165;
                                                }
                                                if (GameWorld.player.bytes[1] == 0) break block166;
                                                if (GameWorld.player.bytes[1] != 4) ** GOTO lbl-1000
                                            }
                                            if (GameWorld.player.sprite.x <= this.sprite.x + GameWorld.scaleGame(this.collisionOffsetX >> 8)) ** GOTO lbl-1000
                                            if (GameWorld.player.sprite.x >= this.sprite.x + GameWorld.scaleGame(this.collisionOffsetX >> 8) + GameWorld.scaleGame(this.collisionWidth >> 8)) ** GOTO lbl-1000
                                            if (Math.abs(GameWorld.player.sprite.y - this.sprite.y) < 64) {
                                                v0 = true;
                                            } else lbl-1000:
                                            // 4 sources

                                            {
                                                v0 = var2_13 = false;
                                            }
                                            if (var2_13) ** GOTO lbl-1000
                                            if (GameWorld.player.bytes[1] == 6) break block167;
                                            if (GameWorld.player.bytes[1] != 2) ** GOTO lbl-1000
                                        }
                                        if (GameWorld.player.sprite.y <= this.sprite.y + GameWorld.scaleGame(this.collisionOffsetY >> 8)) ** GOTO lbl-1000
                                        if (GameWorld.player.sprite.y < this.sprite.y + GameWorld.scaleGame(this.collisionOffsetY >> 8) + GameWorld.scaleGame(this.collisionHeight >> 8)) {
                                            ** if (Math.abs((int)(GameWorld.player.sprite.x - this.sprite.x)) >= 64) goto lbl-1000
                                        }
                                        ** GOTO lbl-1000
lbl-1000:
                                        // 2 sources

                                        {
                                            v1 = true;
                                            ** GOTO lbl139
                                        }
lbl-1000:
                                        // 4 sources

                                        {
                                            v1 = var2_13 = false;
                                        }
lbl139:
                                        // 2 sources

                                        if (!var2_13) break block168;
                                        if (GameWorld.player.spriteId != 1) break block168;
                                        if (!GameWorld.player.isMoving()) break block168;
                                        if (this.bytes[1] == GameWorld.player.bytes[1]) break block165;
                                    }
                                    this.stop();
                                    GameWorld.isPlayerMoveStone = false;
                                    break block165;
                                }
                                GameWorld.isPlayerMoveStone = false;
                                if (GameObject.gameWorld.focusedObject == this) {
                                    GameObject.gameWorld.focusedObject = GameWorld.player;
                                }
                            }
                            if (this.sprite.currentAnimation != 6 && var1_4 != -1) {
                                if (GameWorld.getTileSprite(var1_4).getAnimationSequenceDuration(var1_4 % 200) == 360) {
                                    this.stop();
                                    this.sprite.startAnimation(6, 1);
                                    GameWorld.isPlayerMoveStone = false;
                                    DeviceSound.stop(false);
                                }
                            }
                            if (this.sprite.currentAnimation == 6 && this.sprite.animationDone) {
                                GameObject.gameWorld.removeObject(this, true);
                            }
                            return;
                        }
                        if (this.spriteId != 36 || this.velX == 0 && this.velY == 0) break block169;
                        if (GameWorld.player == null) break block169;
                        if (GameWorld.player.spriteId != 1) break block170;
                        if (GameWorld.player.sprite.currentAnimation < 11) break block171;
                        if (GameWorld.player.sprite.currentAnimation > 14) break block171;
                    }
                    if (GameWorld.player.spriteId == 1) break block169;
                }
                this.sprite.startAnimation(0, 0);
                this.velX = 0;
                this.velY = 0;
            }
            if (this.spriteId == 12 && GameWorld.isPlayerOnSwamp && this == GameWorld.swampRippleUp) {
                this.setX(GameWorld.player.x);
                this.setY(GameWorld.player.y);
                GameWorld.swampRippleDown.setX(this.x);
                GameWorld.swampRippleDown.setY(this.y);
                GameWorld.swampRipple.setX(this.x);
                GameWorld.swampRipple.setY(this.y);
            }
            if (this.spriteId == 21) {
                if (this.isOnScreen() && this.sprite.animationDone) {
                    this.sprite.startAnimation(1, 1);
                    this.object_link.sprite.startAnimation(0, 1);
                }
                return;
            }
            if (this == GameWorld.observeObject && GameWorld.isObserveStyle) {
                if (Engine.isPressed(4)) {
                    this.velX = -1024;
                }
                if (Engine.isPressed(8)) {
                    this.velX = 1024;
                }
                if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                    this.velX = 0;
                }
                if (Engine.isPressed(1)) {
                    this.velY = -1024;
                }
                if (Engine.isPressed(2)) {
                    this.velY = 1024;
                }
                if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                    this.velY = 0;
                }
                if (this.x >> 8 < Device.WIDTH / 2) {
                    this.setX(Device.WIDTH / 2 << 8);
                }
                if (GameWorld.mapWidth - (this.x >> 8) < Device.WIDTH / 2) {
                    this.setX(GameWorld.mapWidth - Device.WIDTH / 2 << 8);
                }
                if (this.y >> 8 < Device.HEIGHT / 2) {
                    this.setY(Device.HEIGHT / 2 << 8);
                }
                if (GameWorld.mapHeight - (this.y >> 8) < Device.HEIGHT / 2) {
                    this.setY(GameWorld.mapHeight - Device.HEIGHT / 2 << 8);
                }
            }
            if (this.spriteId == 14) {
                if (this.sprite.currentAnimation == 1 && this.sprite.animationDone || this.booleans[1]) {
                    if (this.ints[1] + 7 >= GameWorld.scaleGame(205)) {
                        this.booleans[1] = false;
                        return;
                    }
                    this.booleans[1] = true;
                    this.sprite.visible = false;
                    this.ints[0] = this.ints[0] + (GameWorld.scaleGame(145) - this.ints[2]) / 8;
                    this.ints[1] = this.ints[1] + (GameWorld.scaleGame(205) - this.ints[3]) / 8;
                    GameWorld.drawHud = true;
                    this.setTile(0, 0);
                    if (!GameWorld.bonusObjects.contains(this)) {
                        GameWorld.bonusObjects.addElement(this);
                    }
                }
                return;
            }
            if (this.spriteId == 15) {
                if ((this.sprite.currentAnimation == 1 || this.sprite.currentAnimation == 4) && this.sprite.animationDone) {
                    if (this.bytes[1] == -1) {
                        if (this.sprite.currentAnimation == 1) {
                            this.sprite.startAnimation(3, 1);
                        } else {
                            this.sprite.startAnimation(5, 1);
                        }
                        if (this.isOnScreen()) {
                            DeviceSound.play(131085);
                            Device.vibrate(100);
                        }
                    } else {
                        this.sprite.startAnimation(2, 0);
                        if (this.bytes[1] == 0) {
                            this.velY = -640;
                        } else if (this.bytes[1] == 2) {
                            this.velX = 640;
                        } else if (this.bytes[1] == 4) {
                            this.velY = 640;
                        } else if (this.bytes[1] == 6) {
                            this.velX = -640;
                        }
                    }
                } else if ((this.sprite.currentAnimation == 3 || this.sprite.currentAnimation == 5) && this.sprite.animationDone) {
                    this.sprite.visible = false;
                    GameObject.gameWorld.removeObject(this, true);
                }
                return;
            }
            if (this.spriteId == 17) {
                for (var1_5 = 0; var1_5 < GameObject.gameWorld.objectsOnScreen.size(); ++var1_5) {
                    var2_14 = (GameObject)GameObject.gameWorld.objectsOnScreen.elementAt(var1_5);
                    if (var2_14.spriteId != 5 || !this.isColliding(var2_14)) continue;
                    this.sprite.startAnimation(13, 1);
                    this.bIsStoneCoverSpring = true;
                    return;
                }
                if (var1_5 == GameObject.gameWorld.objectsOnScreen.size()) {
                    this.bIsStoneCoverSpring = false;
                }
                if (!this.bIsStoneCoverSpring && this.sprite.currentAnimation != 0 && this.sprite.animationDone) {
                    GameWorld.player.sprite.visible = true;
                    GameWorld.playerLocked = false;
                    this.sprite.startAnimation(0, 0);
                }
                return;
            }
            if (this.spriteId == 20) {
                var2_15 = false;
                var3_22 = 0;
                for (var1_6 = 0; var1_6 < GameObject.gameWorld.objects.size(); ++var1_6) {
                    var4_28 = (GameObject)GameObject.gameWorld.objects.elementAt(var1_6);
                    if (var4_28.spriteId != 5 || !this.isColliding(var4_28)) continue;
                    this.bIsStoneCoverWallFire = true;
                    if (this.sprite.currentAnimation == 0 || this.sprite.currentAnimation == 1) {
                        this.sprite.clipX = 0;
                        this.sprite.clipY = 0;
                        this.sprite.clipWidth = Device.WIDTH;
                        if (var3_22 == 0 || var3_22 > var4_28.y) {
                            this.sprite.clipHeight = (var4_28.y >> 8) - GameWorld.mapView[1];
                            if (this.sprite.clipHeight > Device.HEIGHT - 22) {
                                this.sprite.clipHeight = Device.HEIGHT - 22;
                            }
                            var3_22 = var4_28.y;
                        }
                        this.wallFireClipHRecord = this.sprite.clipHeight;
                    } else if (this.sprite.currentAnimation == 2 || this.sprite.currentAnimation == 3) {
                        this.sprite.clipX = 0;
                        this.sprite.clipY = 0;
                        if (var3_22 == 0 || var3_22 > var4_28.x) {
                            this.sprite.clipWidth = (var4_28.x >> 8) - GameWorld.mapView[0];
                            var3_22 = var4_28.x;
                        }
                        this.sprite.clipHeight = Device.HEIGHT - 22;
                        this.wallFireClipWRecord = this.sprite.clipWidth;
                    } else if (this.sprite.currentAnimation == 4 || this.sprite.currentAnimation == 5) {
                        if (var3_22 == 0 || var3_22 < var4_28.x) {
                            this.sprite.clipX = (var4_28.x >> 8) - GameWorld.mapView[0];
                            var3_22 = var4_28.x;
                        }
                        this.sprite.clipY = 0;
                        this.sprite.clipWidth = Device.WIDTH;
                        this.sprite.clipHeight = Device.HEIGHT - 22;
                        this.wallFireClipXRecord = this.sprite.clipX;
                    }
                    GameObject.gameViewXRecord = GameWorld.mapView[0];
                    GameObject.gameViewYRecord = GameWorld.mapView[1];
                    var2_15 = true;
                }
                if (!var2_15) {
                    this.bIsStoneCoverWallFire = false;
                    this.sprite.clipX = 0;
                    this.sprite.clipY = 0;
                    this.sprite.clipWidth = 0;
                    this.sprite.clipHeight = 0;
                }
                return;
            }
            if (this.spriteId == 24) {
                for (var1_7 = 0; var1_7 < GameObject.gameWorld.objectsOnScreen.size(); ++var1_7) {
                    var2_16 = (GameObject)GameObject.gameWorld.objectsOnScreen.elementAt(var1_7);
                    if (var2_16 != GameWorld.player || !Engine.isPointInRect(var2_16.x, var2_16.y, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight)) continue;
                    this.bIsPlayerOnLavaPlatform = true;
                    if (this.lavaPlatformAnimTick == 0) {
                        this.lavaPlatformAnimTick = Engine.tick;
                    } else if (Engine.tick - this.lavaPlatformAnimTick > 1 && this.sprite.currentAnimation == 0) {
                        this.sprite.startAnimation(1, 1);
                    }
                    return;
                }
                if (var1_7 == GameObject.gameWorld.objectsOnScreen.size()) {
                    this.bIsPlayerOnLavaPlatform = false;
                    this.lavaPlatformAnimTick = 0;
                }
                if (!this.bIsPlayerOnLavaPlatform) {
                    if (this.sprite.currentAnimation == 1 && this.sprite.animationDone && Engine.tick - this.lavaPlatformAnimTick > 1) {
                        this.sprite.startAnimation(2, 1);
                    } else if (this.sprite.currentAnimation == 2 && this.sprite.animationDone) {
                        this.sprite.startAnimation(0, 0);
                        this.lavaPlatformAnimTick = 0;
                    }
                }
                return;
            }
            if (this.spriteId != 18) break block172;
            if (GameWorld.player == null) break block172;
            if (GameWorld.player.spriteId != 1 || this.sprite.currentAnimation != 0) ** GOTO lbl-1000
            if (Math.abs(this.sprite.x - GameWorld.player.sprite.x) >= 2) ** GOTO lbl-1000
            if (Math.abs(this.sprite.y - GameWorld.player.sprite.y) < 60) {
                GameWorld.playerLocked = true;
                GameWorld.player.stop();
                this.sprite.startAnimation(1, 1);
                this.setY(this.y + 10035);
                GameWorld.player.moveY(-6400);
                GameWorld.player.moveX(this.sprite.x - GameWorld.player.sprite.x << 8);
            } else if (this.sprite.currentAnimation == 1 && this.sprite.animationDone) {
                var1_8 = GameWorld.createCharacter(18, 4, GameWorld.level, 0, 0);
                var1_8.setX(this.x);
                var1_8.setY(this.y);
                var2_17 = GameWorld.createCharacter(18, 2, GameWorld.level, 0, 0);
                var2_17.setX(this.x - 5734);
                var2_17.setY(this.y - 4505);
                var3_23 = GameWorld.createCharacter(18, 3, GameWorld.level, 0, 0);
                var3_23.setX(this.x + 5734);
                var3_23.setY(this.y - 4505);
                GameObject.gameWorld.addObject(var1_8, false);
                GameObject.gameWorld.addObject(var2_17, false);
                GameObject.gameWorld.addObject(var3_23, true);
                GameObject.gameWorld.removeObject(this, true);
                GameWorld.playerLocked = false;
                if (Engine.isRectInRect(GameObject.gameWorld.player_tiger.x + GameObject.gameWorld.player_tiger.collisionOffsetX, GameObject.gameWorld.player_tiger.y + GameObject.gameWorld.player_tiger.collisionOffsetY, GameObject.gameWorld.player_tiger.collisionWidth, GameObject.gameWorld.player_tiger.collisionHeight, var1_8.x + var1_8.collisionOffsetX, var1_8.y + var1_8.collisionOffsetY, var1_8.collisionWidth, var1_8.collisionHeight)) {
                    GameObject.gameWorld.player_tiger.moveY(4096);
                }
                if (Engine.isRectInRect(GameObject.gameWorld.player_sid.x + GameObject.gameWorld.player_sid.collisionOffsetX, GameObject.gameWorld.player_sid.y + GameObject.gameWorld.player_sid.collisionOffsetY, GameObject.gameWorld.player_sid.collisionWidth, GameObject.gameWorld.player_sid.collisionHeight, var1_8.x + var1_8.collisionOffsetX, var1_8.y + var1_8.collisionOffsetY, var1_8.collisionWidth, var1_8.collisionHeight)) {
                    GameObject.gameWorld.player_sid.moveX(4096);
                }
                if (Engine.isRectInRect(GameObject.gameWorld.player_tiger.x + GameObject.gameWorld.player_tiger.collisionOffsetX, GameObject.gameWorld.player_tiger.y + GameObject.gameWorld.player_tiger.collisionOffsetY, GameObject.gameWorld.player_tiger.collisionWidth, GameObject.gameWorld.player_tiger.collisionHeight, var2_17.x + var2_17.collisionOffsetX, var2_17.y + var2_17.collisionOffsetY, var2_17.collisionWidth, var2_17.collisionHeight)) {
                    GameObject.gameWorld.player_tiger.moveX(-4096);
                }
                if (Engine.isRectInRect(GameObject.gameWorld.player_sid.x + GameObject.gameWorld.player_sid.collisionOffsetX, GameObject.gameWorld.player_sid.y + GameObject.gameWorld.player_sid.collisionOffsetY, GameObject.gameWorld.player_sid.collisionWidth, GameObject.gameWorld.player_sid.collisionHeight, var2_17.x + var2_17.collisionOffsetX, var2_17.y + var2_17.collisionOffsetY, var2_17.collisionWidth, var2_17.collisionHeight)) {
                    GameObject.gameWorld.player_sid.moveX(-4096);
                }
                if (Engine.isRectInRect(GameObject.gameWorld.player_tiger.x + GameObject.gameWorld.player_tiger.collisionOffsetX, GameObject.gameWorld.player_tiger.y + GameObject.gameWorld.player_tiger.collisionOffsetY, GameObject.gameWorld.player_tiger.collisionWidth, GameObject.gameWorld.player_tiger.collisionHeight, var3_23.x + var3_23.collisionOffsetX, var3_23.y + var3_23.collisionOffsetY, var3_23.collisionWidth, var3_23.collisionHeight)) {
                    GameObject.gameWorld.player_tiger.moveX(4096);
                }
                if (Engine.isRectInRect(GameObject.gameWorld.player_sid.x + GameObject.gameWorld.player_sid.collisionOffsetX, GameObject.gameWorld.player_sid.y + GameObject.gameWorld.player_sid.collisionOffsetY, GameObject.gameWorld.player_sid.collisionWidth, GameObject.gameWorld.player_sid.collisionHeight, var3_23.x + var3_23.collisionOffsetX, var3_23.y + var3_23.collisionOffsetY, var3_23.collisionWidth, var3_23.collisionHeight)) {
                    GameObject.gameWorld.player_sid.moveX(4096);
                }
            }
            return;
        }
        if (this.spriteId == 16) {
            if (this.sprite.currentAnimation == 1) {
                var1_9 = this.x - 6400;
                var2_18 = this.y - 6400;
                var3_24 = 12800;
                for (var4_29 = 0; var4_29 < GameObject.gameWorld.objects.size(); ++var4_29) {
                    var5_32 = (GameObject)GameObject.gameWorld.objects.elementAt(var4_29);
                    if (var5_32.spriteId != 16 || var5_32.sprite.currentAnimation != 0 || var5_32 == this || !Engine.isRectInRect(var1_9, var2_18, var3_24, var3_24, var5_32.x + var5_32.collisionOffsetX, var5_32.y + var5_32.collisionOffsetY, var5_32.collisionWidth, var5_32.collisionHeight)) continue;
                    var5_32.sprite.startAnimation(1, 1);
                }
            }
            return;
        }
        if (this.spriteId == 30) {
            if (this.sprite.currentAnimation == 1) {
                var1_10 = this.x - 6400;
                var2_19 = this.y - 6400;
                var3_25 = 12800;
                for (var4_30 = 0; var4_30 < GameObject.gameWorld.objects.size(); ++var4_30) {
                    var5_33 = (GameObject)GameObject.gameWorld.objects.elementAt(var4_30);
                    if (var5_33.spriteId != 30 || var5_33.sprite.currentAnimation != 0 || var5_33 == this || !Engine.isRectInRect(var1_10, var2_19, var3_25, var3_25, var5_33.x + var5_33.collisionOffsetX, var5_33.y + var5_33.collisionOffsetY, var5_33.collisionWidth, var5_33.collisionHeight)) continue;
                    var5_33.sprite.startAnimation(1, 1);
                }
            }
            return;
        }
        if (this.spriteId == 40) {
            if (this.sprite.currentAnimation == 3 && this.sprite.animationDone) {
                this.sprite.startAnimation(4, 0);
            }
            return;
        }
        var1_11 = -1;
        if (!GameWorld.isPlayerOnIce || GameWorld.player != null && this.spriteId != GameWorld.player.spriteId) {
            if (this.velX < 0 && this.velY == 0 && this.velX != -256) {
                var1_11 = 6;
                if (this == GameWorld.player && GameWorld.isPlayerOnSwamp) {
                    GameWorld.swampRipple.sprite.visible = false;
                    GameWorld.swampRippleUp.sprite.visible = true;
                    GameWorld.swampRippleDown.sprite.visible = true;
                }
            } else if (this.velX > 0 && this.velY == 0 && this.velX != 256) {
                var1_11 = 2;
                if (this == GameWorld.player && GameWorld.isPlayerOnSwamp) {
                    GameWorld.swampRipple.sprite.visible = false;
                    GameWorld.swampRippleUp.sprite.visible = true;
                    GameWorld.swampRippleDown.sprite.visible = true;
                }
            } else if (this.velY < 0 && this.velX == 0 && this.velY != -256) {
                var1_11 = 0;
                if (this == GameWorld.player && GameWorld.isPlayerOnSwamp) {
                    GameWorld.swampRipple.setY(GameWorld.player.y);
                    GameWorld.swampRippleUp.setY(GameWorld.player.y);
                    GameWorld.swampRippleDown.setY(GameWorld.player.y);
                    if (GameWorld.player.spriteId != 3) {
                        GameWorld.swampRipple.sprite.visible = true;
                        GameWorld.swampRippleUp.sprite.visible = false;
                        GameWorld.swampRippleDown.sprite.visible = false;
                    }
                }
            } else if (this.velY > 0 && this.velX == 0 && this.velY != 256) {
                var1_11 = 4;
                if (this == GameWorld.player && GameWorld.isPlayerOnSwamp) {
                    GameWorld.swampRipple.setY(GameWorld.player.y);
                    GameWorld.swampRippleUp.setY(GameWorld.player.y);
                    GameWorld.swampRippleDown.setY(GameWorld.player.y);
                    if (GameWorld.player.spriteId != 3) {
                        GameWorld.swampRipple.sprite.visible = true;
                        GameWorld.swampRippleUp.sprite.visible = false;
                        GameWorld.swampRippleDown.sprite.visible = false;
                    }
                }
            } else if (!(this.spriteId == 12 || this.spriteId == 10 || this.spriteId == 36 || this.spriteId == 13 || this.spriteId == 3 && this.sprite.currentAnimation == 20 || this.spriteId == 2 && this.sprite.currentAnimation == 21 || this.spriteId == 1 && this.sprite.currentAnimation == 9 || this.spriteId == 1 && this.sprite.currentAnimation == 8 || this.spriteId == 2 && this.sprite.currentAnimation == 16 || this.spriteId == 3 && this.sprite.currentAnimation == 18 || this.spriteId == 2 && this.sprite.currentAnimation == 22 || this.spriteId == 1 && this.sprite.currentAnimation == 10 || this.spriteId == 3 && this.sprite.currentAnimation == 21 || this.spriteId == 3 && this.sprite.currentAnimation == 19 && !this.sprite.animationDone || this.spriteId == 2 && this.sprite.currentAnimation >= 23 && this.sprite.currentAnimation <= 26 && !this.sprite.animationDone || this.spriteId == 1 && this.sprite.currentAnimation >= 11 && this.sprite.currentAnimation <= 14 && !this.sprite.animationDone)) {
                this.setMovementAnimation();
            }
            if (this.bytes[2] != var1_11) {
                if (var1_11 != -1) {
                    this.bytes[1] = (byte)var1_11;
                }
                this.setMovementAnimation();
            }
        }
        if (this == GameObject.gameWorld.player_ele || this == GameObject.gameWorld.player_tiger || this == GameObject.gameWorld.player_sid) {
            if (!GameWorld.playerLocked && GameObject.gameWorld.dialogSpeechBubble == null && (this.sprite.currentAnimation == 16 || this.sprite.currentAnimation == 8 || this.sprite.currentAnimation == 18) && this.sprite.animationDone) {
                this.setMovementAnimation();
            }
            if (!GameWorld.playerLocked && GameObject.gameWorld.dialogSpeechBubble == null && !this.isMoving()) {
                if (this.ints[7] == 0) {
                    this.ints[7] = 170;
                } else {
                    this.ints[7] = this.ints[7] - 1;
                    if (this.ints[7] <= 0) {
                        if (this.spriteId == 2) {
                            this.sprite.startAnimation(16, 1);
                        } else if (this.spriteId == 1) {
                            this.sprite.startAnimation(8, 1);
                        } else if (this.spriteId == 3) {
                            this.sprite.startAnimation(18, 1);
                        }
                        this.ints[7] = 170;
                    }
                }
            } else if (this.isMoving() || this.spriteId == 3 && this.sprite.currentAnimation == 19) {
                this.ints[7] = 170;
            }
        }
        if (!GameWorld.isPlayerOnIce || GameWorld.player != null && this.spriteId != GameWorld.player.spriteId) {
            this.bytes[2] = (byte)var1_11;
        }
        if (this.ints2[0] != null) {
            if (this.bytes[4] > 0) {
                this.bytes[4] = (byte)(this.bytes[4] - 1);
            } else {
                this.setTargetPositionFromPathStep();
                if (this.x == this.ints[0] && this.y == this.ints[1]) {
                    this.bytes[3] = (byte)(this.bytes[3] + 1);
                    if (this.bytes[3] >= this.ints2[0].length / 2) {
                        this.bytes[3] = this.booleans[0] != false ? 0 : -1;
                        if (this.ints2[2] != null) {
                            this.ints2[2][5] = -1;
                            this.ints2[2] = null;
                        }
                    }
                    if (this.bytes[3] == -1) {
                        this.stop();
                        this.ints2[0] = null;
                    } else {
                        if (this.ints2[1] != null) {
                            this.bytes[4] = (byte)this.ints2[1][this.bytes[3]];
                        }
                        if (this.bytes[4] > 0) {
                            this.stop();
                        } else {
                            this.setTargetPositionFromPathStep();
                        }
                    }
                }
                if (this.bytes[3] != -1) {
                    var2_20 = this.ints[0] - this.x;
                    this.velX = Engine.cap(var2_20, 320);
                    var3_26 = this.ints[1] - this.y;
                    this.velY = Engine.cap(var3_26, 320);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tickRhinoceros() {
        block92: {
            block94: {
                block93: {
                    block91: {
                        if (this.hp <= 0) {
                            if (this.sprite.currentAnimation != 9) {
                                this.sprite.startAnimation(9, 0);
                                if (GameWorld.level == 1) {
                                    this.attackArea.setRow(0);
                                    this.attackArea.setCol(-5);
                                } else {
                                    this.attackArea.setRow(0);
                                    this.attackArea.setCol(-5);
                                }
                            }
                            return;
                        }
                        if (this.bytes[6] == 0) {
                            if (this.sprite.currentAnimation != 22) {
                                var1_1 = GameWorld.map[this.getRow() * GameWorld.mapCols + this.getCol()];
                                if (360 == GameWorld.getTileSprite(var1_1).getAnimationSequenceDuration(var1_1 % 200)) {
                                    if (this.velX > 0) {
                                        this.bytes[1] = 4;
                                    } else if (this.velX < 0) {
                                        this.bytes[1] = 0;
                                    } else if (this.velY > 0) {
                                        this.bytes[1] = 2;
                                    } else if (this.velY < 0) {
                                        this.bytes[1] = 6;
                                    }
                                    this.velX = 0;
                                    this.velY = 0;
                                    this.drown();
                                }
                            } else if (this.sprite.animationDone) {
                                GameObject.gameWorld.focusedObject = GameWorld.player;
                            }
                            return;
                        }
                        if (this.bytes[6] != 2 && this.bytes[6] != 3 && this.bytes[6] != 4 && this.bytes[6] != 6 && !this.booleans[2]) {
                            var1_2 = this.x - 16384;
                            var2_9 = this.y - 16384;
                            var3_10 = 32768;
                            if (GameWorld.player != null) {
                                if (Engine.isRectInRect(GameWorld.player.x + GameWorld.player.collisionOffsetX, GameWorld.player.y + GameWorld.player.collisionOffsetY, GameWorld.player.collisionWidth, GameWorld.player.collisionHeight, var1_2, var2_9, var3_10, var3_10)) {
                                    this.bytes[3] = -1;
                                    this.ints2[0] = null;
                                    this.velX = 0;
                                    this.velY = 0;
                                    this.bytes[6] = 2;
                                }
                            }
                        }
                        if (Math.abs(this.getRow() - this.ints[4]) > 6 || Math.abs(this.getCol() - this.ints[5]) > 6) {
                            this.bytes[3] = -1;
                            this.ints2[0] = null;
                            this.velX = 0;
                            this.velY = 0;
                            var1_3 = GameObject.gameWorld.getPathToTile(this, this.getRow(), this.getCol(), this.ints[4], this.ints[5]);
                            this.ints2[0] = var1_3;
                            this.bytes[3] = 0;
                            this.bytes[6] = 5;
                            this.bIsRhinoHasDash = true;
                            this.booleans[2] = true;
                        }
                        if (this.bytes[6] != 1) break block91;
                        this.booleans[2] = false;
                        if (this.sprite.currentAnimation != 0) {
                            this.sprite.startAnimation(0, 0);
                        }
                        break block92;
                    }
                    if (this.bytes[6] != 2) break block93;
                    if (this.sprite.currentAnimation != 13 && this.sprite.currentAnimation != 11 && this.sprite.currentAnimation != 10 && this.sprite.currentAnimation != 12) {
                        this.bIsRhinoHasDash = false;
                        if (Math.abs(GameWorld.player.x - this.x >> 8) < 32) {
                            if (GameWorld.player.y > this.y) {
                                this.sprite.startAnimation(12, 6);
                            } else {
                                this.sprite.startAnimation(10, 6);
                            }
                        } else if (GameWorld.player.x < this.x) {
                            this.sprite.startAnimation(13, 6);
                        } else if (GameWorld.player.x > this.x) {
                            this.sprite.startAnimation(11, 6);
                        }
                    } else if (this.sprite.animationDone) {
                        this.bytes[6] = 3;
                    }
                    break block92;
                }
                if (this.bytes[6] != 3) break block94;
                if (this.sprite.currentAnimation == 4 || this.sprite.currentAnimation == 2 || this.sprite.currentAnimation == 1 || this.sprite.currentAnimation == 3) break block92;
                if (GameWorld.player == null) ** GOTO lbl-1000
                if (Math.abs(GameWorld.player.x - this.x >> 8) < 32) {
                    if (GameWorld.player.y > this.y) {
                        this.sprite.startAnimation(3, 0);
                    } else {
                        this.sprite.startAnimation(1, 0);
                    }
                } else if (GameWorld.player.x < this.x) {
                    this.sprite.startAnimation(4, 0);
                } else if (GameWorld.player.x > this.x) {
                    this.sprite.startAnimation(2, 0);
                }
                var1_4 = GameObject.gameWorld.getPathToTile(this, this.getRow(), this.getCol(), GameWorld.player.getRow(), GameWorld.player.getCol());
                this.ints2[0] = var1_4;
                this.bytes[3] = 0;
                break block92;
            }
            if (this.bytes[6] == 4) {
                if (this.sprite.currentAnimation != 8 && this.sprite.currentAnimation != 6 && this.sprite.currentAnimation != 5 && this.sprite.currentAnimation != 7) {
                    if (this.sprite.currentAnimation == 1) {
                        this.sprite.startAnimation(5, 0);
                    } else if (this.sprite.currentAnimation == 2) {
                        this.sprite.startAnimation(6, 0);
                    } else if (this.sprite.currentAnimation == 3) {
                        this.sprite.startAnimation(7, 0);
                    } else if (this.sprite.currentAnimation == 4) {
                        this.sprite.startAnimation(8, 0);
                    }
                }
            } else if (this.bytes[6] == 6) {
                if (this.sprite.currentAnimation != 21 && this.sprite.currentAnimation != 19 && this.sprite.currentAnimation != 18 && this.sprite.currentAnimation != 20) {
                    if (this.sprite.currentAnimation == 1 || this.sprite.currentAnimation == 5) {
                        this.sprite.startAnimation(18, 1);
                        this.attackArea.setX(this.x);
                        this.attackArea.setY(this.y - this.collisionHeight);
                    } else if (this.sprite.currentAnimation == 2 || this.sprite.currentAnimation == 6) {
                        this.sprite.startAnimation(19, 1);
                        this.attackArea.setX(this.x + this.collisionWidth);
                        this.attackArea.setY(this.y);
                    } else if (this.sprite.currentAnimation == 3 || this.sprite.currentAnimation == 7) {
                        this.sprite.startAnimation(20, 1);
                        this.attackArea.setX(this.x);
                        this.attackArea.setY(this.y + this.collisionHeight);
                    } else if (this.sprite.currentAnimation == 4 || this.sprite.currentAnimation == 8) {
                        this.sprite.startAnimation(21, 1);
                        this.attackArea.setX(this.x - this.collisionWidth);
                        this.attackArea.setY(this.y);
                    }
                }
                if (this.sprite.animationDone) {
                    var1_5 = 0;
                    var2_9 = 0;
                    if (this.sprite.currentAnimation == 18) {
                        var2_9 = -1280;
                    } else if (this.sprite.currentAnimation == 19) {
                        var1_5 = 1280;
                    } else if (this.sprite.currentAnimation == 20) {
                        var2_9 = 1280;
                    } else if (this.sprite.currentAnimation == 21) {
                        var1_5 = -1280;
                    }
                    this.moveX(var1_5);
                    this.moveY(var2_9);
                    if (this.isColliding(GameObject.gameWorld.player_ele) || this.isColliding(GameObject.gameWorld.player_sid) || this.isColliding(GameObject.gameWorld.player_tiger)) {
                        this.sprite.startAnimation(this.sprite.currentAnimation, 1);
                    } else {
                        this.bytes[6] = 5;
                        if (GameWorld.level == 1) {
                            this.attackArea.setRow(0);
                            this.attackArea.setCol(-5);
                        } else {
                            this.attackArea.setRow(0);
                            this.attackArea.setCol(-5);
                        }
                    }
                    this.moveX(-var1_5);
                    this.moveY(-var2_9);
                }
            } else if (this.bytes[6] == 5) {
                if (this.sprite.currentAnimation != 17 && this.sprite.currentAnimation != 15 && this.sprite.currentAnimation != 14 && this.sprite.currentAnimation != 16) {
                    var1_6 = this.ints[5] * 16 - 8 - (this.x >> 8);
                    var2_9 = this.ints[4] * 16 - 8 - (this.y >> 8);
                    if (Math.abs(var1_6) < 32) {
                        if (var2_9 > 0) {
                            this.sprite.startAnimation(16, 0);
                        } else {
                            this.sprite.startAnimation(14, 0);
                        }
                    } else if (var1_6 < 0) {
                        this.sprite.startAnimation(17, 0);
                    } else {
                        this.sprite.startAnimation(15, 0);
                    }
                    this.bIsRhinoHasDash = true;
                }
                var1_7 = GameObject.gameWorld.getPathToTile(this, this.getRow(), this.getCol(), this.ints[4], this.ints[5]);
                this.ints2[0] = var1_7;
                this.bytes[3] = 0;
            }
        }
        if (this.ints2[0] != null) {
            if (this.bytes[4] > 0) {
                this.bytes[4] = (byte)(this.bytes[4] - 1);
            } else {
                this.setTargetPositionFromPathStep();
                if (this.x == this.ints[0] && this.y == this.ints[1]) {
                    this.bytes[3] = (byte)(this.bytes[3] + 1);
                    if (this.bytes[3] + 2 >= this.ints2[0].length / 2) {
                        this.bytes[6] = 4;
                    }
                    if (this.bytes[3] >= this.ints2[0].length / 2) {
                        this.bytes[3] = -1;
                        this.ints2[0] = null;
                        this.velX = 0;
                        this.velY = 0;
                        if (this.bIsRhinoHasDash) {
                            this.bytes[6] = 1;
                            this.bIsRhinoHasDash = false;
                        } else {
                            this.bytes[6] = 5;
                        }
                    } else {
                        if (this.ints2[1] != null) {
                            this.bytes[4] = (byte)this.ints2[1][this.bytes[3]];
                        }
                        if (this.bytes[4] > 0) {
                            this.stop();
                        } else {
                            this.setTargetPositionFromPathStep();
                        }
                    }
                }
                if (this.bytes[3] != -1) {
                    var1_8 = this.ints[0] - this.x;
                    this.velX = Engine.cap(var1_8, 640);
                    var2_9 = this.ints[1] - this.y;
                    this.velY = Engine.cap(var2_9, 640);
                }
            }
        }
    }

    public void tickHurt() {
        if (this.bIsHurt && !Engine.isCheatMode) {
            if (Engine.tick < this.hurtTick + 18 && this.sprite != null) {
                if (Engine.tick == this.hurtTick + 1) {
                    --this.hp;
                    GameWorld.drawHud = true;
                    if (!this.bIsDrown) {
                        if (this.spriteId == 1) {
                            DeviceSound.play(131082);
                        } else if (this.spriteId == 2) {
                            DeviceSound.play(131080);
                        } else if (this.spriteId == 3) {
                            DeviceSound.play(131084);
                        }
                    }
                    if (this.spriteId != 22) {
                        Device.vibrate(1000);
                    }
                }
                this.sprite.visible = Engine.tick % 3 != 0;
                this.ints[7] = 170;
            } else {
                this.bIsHurt = false;
                this.bIsDrown = false;
                this.sprite.visible = true;
            }
        }
    }

    public void drown() {
        this.bIsHurt = false;
        this.bIsDrown = true;
        this.sprite.visible = true;
        if (this.bytes[1] == 6) {
            this.x -= 2048;
        } else if (this.bytes[1] == 2) {
            this.x += 2048;
        } else if (this.bytes[1] == 0) {
            this.y -= 2048;
        } else if (this.bytes[1] == 4) {
            this.y += 2048;
        }
        if (this.spriteId == 1) {
            this.sprite.startAnimation(9, 1);
        } else if (this.spriteId == 2) {
            this.sprite.startAnimation(21, 1);
        } else if (this.spriteId == 3) {
            this.sprite.startAnimation(20, 1);
        } else if (this.spriteId == 22) {
            this.sprite.startAnimation(22, 1);
        }
        if (this.spriteId == 1) {
            DeviceSound.play(131082);
        } else if (this.spriteId == 2) {
            DeviceSound.play(131080);
        } else if (this.spriteId == 3) {
            DeviceSound.play(131084);
        }
    }

    public void setTargetPositionFromPathStep() {
        int n = this.ints2[0][2 * this.bytes[3]];
        int n2 = this.ints2[0][2 * this.bytes[3] + 1];
        this.ints[0] = n2 * 16 + 8 << 8;
        this.ints[1] = n * 16 + 8 << 8;
    }

    public void tickHint() {
        if (GameWorld.player.bytes[1] == 0) {
            this.setX(GameWorld.player.x);
            this.setY(GameWorld.player.y - (GameWorld.scaleGame(30) << 8));
        } else if (GameWorld.player.bytes[1] == 4) {
            this.setX(GameWorld.player.x);
            if (GameWorld.player.spriteId == 1) {
                this.setY(GameWorld.player.y);
            } else if (GameWorld.player.spriteId == 3) {
                this.setY(GameWorld.player.y - (GameWorld.scaleGame(30) << 8));
            }
        } else if (GameWorld.player.bytes[1] == 6) {
            if (GameWorld.player.spriteId == 3) {
                this.setX(GameWorld.player.x);
            } else {
                this.setX(GameWorld.player.x - (GameWorld.scaleGame(24) << 8));
            }
            this.setY(GameWorld.player.y - (GameWorld.scaleGame(30) << 8));
        } else if (GameWorld.player.bytes[1] == 2) {
            if (GameWorld.player.spriteId == 3) {
                this.setX(GameWorld.player.x);
            } else {
                this.setX(GameWorld.player.x + (GameWorld.scaleGame(24) << 8));
            }
            this.setY(GameWorld.player.y - (GameWorld.scaleGame(30) << 8));
        }
    }

    public void tickSpeechBubble() {
        if (this.bytes[9] > 0) {
            this.bytes[9] = (byte)(this.bytes[9] - 1);
            if (this.bytes[9] == 0) {
                this.bytes[9] = -1;
            }
        } else {
            if (this.ints[0] != this.ints[2]) {
                this.ints[0] = Math.abs(this.ints[0] - this.ints[2]) <= 6 ? this.ints[2] : this.ints[0] + (this.ints[2] - this.ints[0]) / 2;
            }
            if (this.ints[1] != this.ints[3]) {
                this.ints[1] = Math.abs(this.ints[1] - this.ints[3]) <= 6 ? this.ints[3] : this.ints[1] + (this.ints[3] - this.ints[1]) / 2;
            }
            if (this.ints[0] == this.ints[2] && this.ints[1] == this.ints[3] && this.bytes[8] > 0) {
                this.bytes[8] = (byte)(this.bytes[8] - 1);
                if (this.bytes[8] == 0) {
                    this.booleans[0] = false;
                    this.bytes[8] = -1;
                }
            }
        }
    }

    public void setSpeechBubbleText(String string, int n) {
        int n2;
        int n3;
        this.ints[2] = this.booleans[2] ? (n == 3 ? 160 : Device.WIDTH - 8) : Device.WIDTH * 2 / 3;
        if (string != null) {
            this.strings2[0] = Engine.getStrings(string, this.ints[2] - 8, 0);
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.strings2[0].length; ++n3) {
            n2 = FontMgr.stringWidth(0, this.strings2[0][n3]);
            if (n2 <= n4) continue;
            n4 = n2;
        }
        this.ints[2] = n4 += 8;
        if (this.booleans[2]) {
            n2 = Device.HEIGHT / FontMgr.charHeight[0] - 2;
            n3 = Math.min(n2, this.strings2[0].length);
        } else {
            n3 = Math.min(2, this.strings2[0].length);
        }
        this.bytes[7] = (byte)n3;
        this.ints[3] = n3 * FontMgr.charHeight[0] + 8;
        if (n == 1) {
            this.ints[0] = 0;
            this.ints[1] = 0;
        } else if (n == 2) {
            this.ints[0] = this.ints[2] + 2;
            this.ints[1] = this.ints[3] + 2;
        } else {
            this.ints[0] = this.ints[2];
            this.ints[1] = this.ints[3];
        }
        this.bytes[4] = (byte)n;
    }

    public void stop() {
        this.accX = 0;
        this.accY = 0;
        this.velX = 0;
        this.velY = 0;
        if (this.type == 1) {
            this.bytes[2] = -1;
            this.setMovementAnimation();
        }
    }

    public int[] getTileInFront(boolean bl) {
        int n = (this.y >> 8) / 16;
        int n2 = (this.x >> 8) / 16;
        switch (this.bytes[1]) {
            case 0: {
                --n;
                break;
            }
            case 2: {
                ++n2;
                break;
            }
            case 4: {
                ++n;
                break;
            }
            case 6: {
                --n2;
            }
        }
        int n3 = GameWorld.getTile(n, n2);
        if (!bl || gameWorld.isTileInteractable(n3)) {
            return new int[]{n, n2, n3};
        }
        return null;
    }

    public int[] getTile(boolean bl) {
        int n = (this.y >> 8) / 16;
        int n2 = (this.x >> 8) / 16;
        int n3 = GameWorld.getTile(n, n2);
        if (!bl || gameWorld.isTileInteractable(n3)) {
            return new int[]{n, n2, n3};
        }
        return null;
    }

    public void setCollisionRectangle(int n, int n2) {
        this.collisionWidth = n << 8;
        this.collisionHeight = n2 << 8;
        this.collisionOffsetX = -this.collisionWidth / 2;
        this.collisionOffsetY = -this.collisionHeight / 2;
    }

    public int[] getCollidingCorners(GameObject gameObject) {
        int[] nArray;
        if (gameObject != null) {
            boolean bl = Engine.isPointInRect(this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight) || Engine.isPointInRect(gameObject.x + gameObject.collisionOffsetX + gameObject.collisionWidth, gameObject.y + gameObject.collisionOffsetY + gameObject.collisionHeight, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight);
            boolean bl2 = Engine.isPointInRect(this.x + this.collisionOffsetX + this.collisionWidth, this.y + this.collisionOffsetY, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight) || Engine.isPointInRect(gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY + gameObject.collisionHeight, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight);
            boolean bl3 = Engine.isPointInRect(this.x + this.collisionOffsetX, this.y + this.collisionOffsetY + this.collisionHeight, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight) || Engine.isPointInRect(gameObject.x + gameObject.collisionOffsetX + gameObject.collisionWidth, gameObject.y + gameObject.collisionOffsetY, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight);
            boolean bl4 = Engine.isPointInRect(this.x + this.collisionOffsetX + this.collisionWidth, this.y + this.collisionOffsetY + this.collisionHeight, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight) || Engine.isPointInRect(gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight);
            nArray = new int[]{bl ? 1 : 0, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight, bl2 ? 1 : 0, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight, bl3 ? 1 : 0, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight, bl4 ? 1 : 0, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight};
        } else {
            int n = this.collisionWidth;
            int n2 = this.collisionHeight;
            int n3 = this.collisionOffsetX;
            int n4 = this.collisionOffsetY;
            if (this.spriteId == 22) {
                n2 = 2048;
                n = 2048;
                n3 = n4 = -this.collisionWidth / 2;
            }
            boolean bl = !gameWorld.isTileWalkable(this, gameWorld.getTileFromPosition(this.y + n4, true), gameWorld.getTileFromPosition(this.x + n3, true));
            boolean bl5 = !gameWorld.isTileWalkable(this, gameWorld.getTileFromPosition(this.y + n4, true), gameWorld.getTileFromPosition(this.x + n3 + n, true));
            boolean bl6 = !gameWorld.isTileWalkable(this, gameWorld.getTileFromPosition(this.y + n4 + n2, true), gameWorld.getTileFromPosition(this.x + n3, true));
            boolean bl7 = !gameWorld.isTileWalkable(this, gameWorld.getTileFromPosition(this.y + n4 + n2, true), gameWorld.getTileFromPosition(this.x + n3 + n, true));
            nArray = new int[]{bl ? 1 : 0, gameWorld.getTileFromPosition(this.x + n3, true) * 16 << 8, gameWorld.getTileFromPosition(this.y + n4, true) * 16 << 8, 4096, 4096, bl5 ? 1 : 0, gameWorld.getTileFromPosition(this.x + n3 + n, true) * 16 << 8, gameWorld.getTileFromPosition(this.y + n4, true) * 16 << 8, 4096, 4096, bl6 ? 1 : 0, gameWorld.getTileFromPosition(this.x + n3, true) * 16 << 8, gameWorld.getTileFromPosition(this.y + n4 + n2, true) * 16 << 8, 4096, 4096, bl7 ? 1 : 0, gameWorld.getTileFromPosition(this.x + n3 + n, true) * 16 << 8, gameWorld.getTileFromPosition(this.y + n4 + n2, true) * 16 << 8, 4096, 4096};
        }
        return nArray;
    }

    public boolean isColliding() {
        boolean bl;
        int[] nArray = this.getCollidingCorners(null);
        boolean bl2 = bl = nArray[0] == 1 || nArray[5] == 1 || nArray[10] == 1 || nArray[15] == 1;
        if (bl) {
            return true;
        }
        for (int i = 0; i < GameObject.gameWorld.objects.size(); ++i) {
            GameObject gameObject = (GameObject)GameObject.gameWorld.objects.elementAt(i);
            if (gameObject == this || !this.isColliding(gameObject)) continue;
            nArray = this.getCollidingCorners(gameObject);
            bl = nArray[0] == 1 || nArray[5] == 1 || nArray[10] == 1 || nArray[15] == 1;
            break;
        }
        return bl;
    }

    public boolean checkLevelChangeCollisions() {
        for (int i = 0; i < DataManager.LEVEL_TIME_LIMIT.length; i += 10) {
            boolean bl;
            byte by = DataManager.LEVEL_TIME_LIMIT[i];
            if (by != GameWorld.level) continue;
            byte by2 = DataManager.LEVEL_TIME_LIMIT[i + 1];
            byte by3 = DataManager.LEVEL_TIME_LIMIT[i + 2];
            byte by4 = DataManager.LEVEL_TIME_LIMIT[i + 3];
            byte by5 = DataManager.LEVEL_TIME_LIMIT[i + 4];
            byte by6 = DataManager.LEVEL_TIME_LIMIT[i + 5];
            byte by7 = DataManager.LEVEL_TIME_LIMIT[i + 6];
            byte by8 = DataManager.LEVEL_TIME_LIMIT[i + 7];
            byte by9 = DataManager.LEVEL_TIME_LIMIT[i + 8];
            boolean bl2 = bl = DataManager.LEVEL_TIME_LIMIT[i + 9] == 1;
            if (!gameWorld.isPlayerInArea(by3, by2, by5, by4)) continue;
            ResourceMaster.initPak(1);
            gameWorld.loadLevel(by6);
            ResourceMaster.closeResource();
            int n = GameWorld.player.x;
            int n2 = GameWorld.player.y;
            GameWorld.player.setX(by7 * 16 << 8);
            GameWorld.player.setY(by8 * 16 << 8);
            if (by9 == 0 || by9 == 4) {
                int n3 = n - (by2 * 16 << 8);
                GameWorld.player.moveX(n3);
                GameWorld.player.moveY(2048);
            } else {
                int n4 = n2 - (by3 * 16 << 8);
                GameWorld.player.moveY(n4);
                GameWorld.player.moveX(2048);
            }
            GameWorld.player.turn(by9);
            gameWorld.scrollView(true);
            if (bl) {
                Engine.releaseAllKeys();
                Engine.fadeIn(false);
            }
            return true;
        }
        return false;
    }

    public void checkCollisions(int n, int n2) {
        Object object;
        int n3;
        int[] nArray = null;
        boolean bl = false;
        if (n2 == 0) {
            nArray = this.getCollidingCorners(null);
        } else {
            if (this.spriteId == 2 && (this.sprite.currentAnimation >= 8 && this.sprite.currentAnimation <= 11 || this.sprite.currentAnimation >= 17 && this.sprite.currentAnimation <= 20)) {
                return;
            }
            for (n3 = 0; n3 < GameObject.gameWorld.objects.size(); ++n3) {
                object = (GameObject)GameObject.gameWorld.objects.elementAt(n3);
                if (((GameObject)object).spriteId == 12 || ((GameObject)object).spriteId == 14 || ((GameObject)object).spriteId == 17 || ((GameObject)object).spriteId == 20 && this.spriteId == 5) continue;
                if (((GameObject)object).spriteId == 13) {
                    if (this.spriteId == 1) continue;
                    if (this.spriteId == 2) {
                        if (!GameWorld.isTigerOnStage) continue;
                    }
                    if (this.spriteId == 3) {
                        if (!GameWorld.isSidOnStage) continue;
                    }
                }
                if (object == this || !this.isColliding((GameObject)object)) continue;
                if (this.spriteId == 2 && ((GameObject)object).spriteId == 10 && ((GameObject)object).sprite.currentAnimation == 5) {
                    GameWorld.isTigerOnStage = true;
                }
                if (((GameObject)object).spriteId == 10) continue;
                if (!(this.spriteId != 1 && this.spriteId != 2 && this.spriteId != 3 || ((GameObject)object).spriteId != 21 && (((GameObject)object).spriteId != 15 || ((GameObject)object).sprite.currentAnimation != 1 && ((GameObject)object).sprite.currentAnimation != 4))) {
                    this.bIsHurt = true;
                    continue;
                }
                if (this.spriteId == 15 && (((GameObject)object).spriteId == 1 || ((GameObject)object).spriteId == 3 || ((GameObject)object).spriteId == 2)) {
                    ((GameObject)object).bIsHurt = true;
                }
                if (((GameObject)object).spriteId == 22 && this.spriteId == 5 && this.isMoving() && (Math.abs(this.velX) == 1024 || Math.abs(this.velY) == 1024)) {
                    ((GameObject)object).bytes[6] = 0;
                    ((GameObject)object).velX = this.velX;
                    ((GameObject)object).velY = this.velY;
                    this.stop();
                    GameObject.gameWorld.focusedObject = object;
                    continue;
                }
                if (!(this.spriteId != 22 || ((GameObject)object).spriteId != 5 && ((GameObject)object).spriteId != 19 || this.bytes[6] != 3 && this.bytes[6] != 2 && this.bytes[6] != 4 && this.bytes[6] != 5)) {
                    if (this.bytes[6] == 5) continue;
                    this.bytes[3] = -1;
                    this.ints2[0] = null;
                    this.velX = 0;
                    this.velY = 0;
                    this.bytes[6] = 5;
                    this.bIsRhinoHasDash = true;
                    continue;
                }
                if (!(this.spriteId != 22 || ((GameObject)object).spriteId != 1 && ((GameObject)object).spriteId != 3 && ((GameObject)object).spriteId != 2 || this.bytes[6] != 3 && this.bytes[6] != 4 && this.bytes[6] != 5)) {
                    ((GameObject)object).hurtTick = Engine.tick;
                    ((GameObject)object).bIsHurt = true;
                    this.bytes[3] = -1;
                    this.ints2[0] = null;
                    this.velX = 0;
                    this.velY = 0;
                    this.bIsRhinoHasDash = false;
                    this.bytes[6] = 6;
                    if (((GameObject)object).spriteId != GameWorld.player.spriteId) {
                        this.bytes[6] = 5;
                        this.bIsRhinoHasDash = true;
                    }
                }
                if (((GameObject)object).spriteId == 25 && (this.spriteId == 22 && ((GameObject)object).bytes[6] == 0 || (this.spriteId == 2 || this.spriteId == 1 || this.spriteId == 3) && ((GameObject)object).bytes[6] == 1)) {
                    if (this.bIsHurt || Engine.isCheatMode) continue;
                    --this.hp;
                    this.bIsHurt = true;
                    this.hurtTick = Engine.tick;
                    continue;
                }
                if ((this.spriteId == 1 || this.spriteId == 2 || this.spriteId == 3) && ((GameObject)object).spriteId == 20) {
                    if (((GameObject)object).bIsStoneCoverWallFire || this.bIsHurt) continue;
                    this.hurtTick = Engine.tick;
                    this.bIsHurt = true;
                    continue;
                }
                if (this.spriteId == 29 && ((GameObject)object).spriteId == 29) continue;
                if (this.spriteId == 29 && ((GameObject)object).spriteId == 25) {
                    if (this.sprite.currentAnimation == 1) break;
                    this.sprite.startAnimation(1, 1);
                    if (DeviceSound.isSoundPlaying(false)) {
                        DeviceSound.stop(false);
                    }
                    DeviceSound.play(131079);
                    break;
                }
                if (((GameObject)object).spriteId == 35) {
                    if (this.spriteId != 1 && this.spriteId != 3 && this.spriteId != 2) continue;
                    this.hurtTick = Engine.tick;
                    this.bIsHurt = true;
                    continue;
                }
                if ((this.spriteId == 1 || this.spriteId == 2 || this.spriteId == 3) && ((GameObject)object).spriteId == 24) {
                    if (((GameObject)object).sprite.currentAnimation != 0 && (((GameObject)object).sprite.currentAnimation != 1 || ((GameObject)object).sprite.getFrame() >= 3) || !Engine.isPointInRect(this.x, this.y, ((GameObject)object).x + ((GameObject)object).collisionOffsetX, ((GameObject)object).y + ((GameObject)object).collisionOffsetY, ((GameObject)object).collisionWidth, ((GameObject)object).collisionHeight)) continue;
                    this.bIsPlayerOnLavaPlatform = true;
                    bl = true;
                    continue;
                }
                if ((this.spriteId == 2 && ((GameObject)object).spriteId == 3 || this.spriteId == 3 && ((GameObject)object).spriteId == 2) && (GameWorld.isSidOnStage && !GameWorld.isTigerOnStage || !GameWorld.isSidOnStage && GameWorld.isTigerOnStage) || this.spriteId == 1 && (((GameObject)object).spriteId != 3 ? ((GameObject)object).spriteId == 2 && GameWorld.isTigerOnStage : GameWorld.isSidOnStage)) continue;
                if ((this.spriteId == 3 ? GameWorld.isSidOnStage : this.spriteId == 2 && GameWorld.isTigerOnStage) && ((GameObject)object).spriteId == 1) continue;
                nArray = this.getCollidingCorners((GameObject)object);
                break;
            }
            if (this == GameWorld.player && !bl) {
                this.bIsPlayerOnLavaPlatform = false;
            }
            if (nArray == null) {
                return;
            }
        }
        int n4 = n3 = nArray[0] == 1 || nArray[5] == 1 || nArray[10] == 1 || nArray[15] == 1 ? 1 : 0;
        if (n3 != 0 && this.velX == 0 && this.velY == 0 && this.bIsHurt) {
            if (nArray[0] == 1 && nArray[5] == 1 && this.bytes[1] != 4) {
                this.y += 512;
            } else if (nArray[5] == 1 && nArray[15] == 1 && this.bytes[1] != 6) {
                this.x -= 512;
            } else if (nArray[15] == 1 && nArray[10] == 1 && this.bytes[1] != 0) {
                this.y -= 512;
            } else if (nArray[10] == 1 && nArray[0] == 1 && this.bytes[1] != 2) {
                this.x += 512;
            }
        }
        if (n3 != 0) {
            int n5;
            if (this.spriteId == 15 && this.sprite.currentAnimation == 2) {
                this.sprite.startAnimation(3, 1);
            }
            object = new boolean[]{nArray[0] == 1, nArray[5] == 1, nArray[10] == 1, nArray[15] == 1};
            int n6 = this.x;
            int n7 = this.y;
            if (n == 2 || n == 0) {
                if (this.velX < 0 && (object[0] != false || object[2] != false)) {
                    this.setX(nArray[1] + nArray[3] - this.collisionOffsetX + 256);
                    if (this.velY == 0) {
                        if (object[0] != false && object[2] == false) {
                            n5 = this.y;
                            this.moveY(320);
                            if (this.isColliding()) {
                                this.setY(n5);
                            }
                        } else if (object[2] != false && object[0] == false) {
                            n5 = this.y;
                            this.moveY(-320);
                            if (this.isColliding()) {
                                this.setY(n5);
                            }
                        }
                    }
                } else if (this.velX > 0 && (object[1] != false || object[3] != false)) {
                    this.setX(nArray[6] + this.collisionOffsetX - 256);
                    if (this.velY == 0) {
                        if (object[1] != false && object[3] == false) {
                            n5 = this.y;
                            this.moveY(320);
                            if (this.isColliding()) {
                                this.setY(n5);
                            }
                        } else if (object[3] != false && object[1] == false) {
                            n5 = this.y;
                            this.moveY(-320);
                            if (this.isColliding()) {
                                this.setY(n5);
                            }
                        }
                    }
                }
                if (this.spriteId != 15 && (this.x <= 0 || this.x >= GameWorld.mapWidth << 8 || this.y <= 0 || this.y >= GameWorld.mapHeight << 8)) {
                    this.setX(n6);
                    this.setY(n7);
                }
            }
            if (n == 2 || n == 1) {
                if (this.velY < 0 && (object[0] != false || object[1] != false)) {
                    this.setY(nArray[2] + nArray[4] - this.collisionOffsetY + 256);
                    if (this.velX == 0) {
                        if (object[0] != false && object[1] == false) {
                            n5 = this.x;
                            this.moveX(320);
                            if (this.isColliding()) {
                                this.setX(n5);
                            }
                        } else if (object[1] != false && object[0] == false) {
                            n5 = this.x;
                            this.moveX(-320);
                            if (this.isColliding()) {
                                this.setX(n5);
                            }
                        }
                    }
                } else if (this.velY > 0 && (object[2] != false || object[3] != false)) {
                    this.setY(nArray[12] + this.collisionOffsetY - 256);
                    if (this.velX == 0) {
                        if (object[2] != false && object[3] == false) {
                            n5 = this.x;
                            this.moveX(320);
                            if (this.isColliding()) {
                                this.setX(n5);
                            }
                        } else if (object[3] != false && object[2] == false) {
                            n5 = this.x;
                            this.moveX(-320);
                            if (this.isColliding()) {
                                this.setX(n5);
                            }
                        }
                    }
                }
                if (this.spriteId != 15 && (this.x <= 0 || this.x >= GameWorld.mapWidth << 8 || this.y <= 0 || this.y >= GameWorld.mapHeight << 8)) {
                    this.setX(n6);
                    this.setY(n7);
                }
            }
            if (this.spriteId == 5) {
                this.stop();
            }
        }
    }

    public boolean isColliding(GameObject gameObject) {
        if (gameObject == null) {
            return false;
        }
        if (this.collisionWidth == 0 || this.collisionHeight == 0 || gameObject.collisionWidth == 0 || gameObject.collisionHeight == 0) {
            return false;
        }
        return Engine.isRectInRect(this.x + this.collisionOffsetX, this.y + this.collisionOffsetY, this.collisionWidth, this.collisionHeight, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight);
    }

    public boolean isMoving() {
        return this.velX != 0 || this.velY != 0;
    }

    public void turn(int n) {
        this.bytes[1] = (byte)n;
        this.setMovementAnimation();
    }

    public void setMovementAnimation() {
        boolean bl;
        int n;
        int n2;
        block25: {
            block39: {
                block41: {
                    int[] nArray;
                    block42: {
                        block40: {
                            block27: {
                                block37: {
                                    block38: {
                                        block36: {
                                            block35: {
                                                block33: {
                                                    block34: {
                                                        block32: {
                                                            block31: {
                                                                block29: {
                                                                    block30: {
                                                                        block28: {
                                                                            block26: {
                                                                                block24: {
                                                                                    if (this.sprite == null || this.spriteId == 31) {
                                                                                        return;
                                                                                    }
                                                                                    nArray = this.getTile(true);
                                                                                    n = n2 = this.sprite.currentAnimation;
                                                                                    bl = false;
                                                                                    if (!this.isMoving()) break block24;
                                                                                    if (this.spriteId == 3 && nArray != null && ((nArray[2] == 401 || nArray[2] == 406 || nArray[2] == 403 || nArray[2] == 404 || nArray[2] == 402 || nArray[2] == 405 || nArray[2] == 400) && GameWorld.tileSheetGround == 1 || (nArray[2] == 408 || nArray[2] == 412 || nArray[2] == 410 || nArray[2] == 409 || nArray[2] == 411 || nArray[2] == 407) && GameWorld.tileSheetGround == 0 || (nArray[2] == 414 || nArray[2] == 415 || nArray[2] == 420 || nArray[2] == 421 || nArray[2] == 417 || nArray[2] == 418 || nArray[2] == 416 || nArray[2] == 419 || nArray[2] == 413) && GameWorld.tileSheetGround == 2)) {
                                                                                        return;
                                                                                    }
                                                                                    switch (this.bytes[1]) {
                                                                                        case 0: {
                                                                                            if (this.spriteId == 5) {
                                                                                                n = 3;
                                                                                                break;
                                                                                            }
                                                                                            n = 4;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            if (this.spriteId == 5) {
                                                                                                n = 1;
                                                                                                break;
                                                                                            }
                                                                                            n = 5;
                                                                                            break;
                                                                                        }
                                                                                        case 4: {
                                                                                            if (this.spriteId == 5) {
                                                                                                n = 4;
                                                                                                break;
                                                                                            }
                                                                                            n = 6;
                                                                                            break;
                                                                                        }
                                                                                        case 6: {
                                                                                            n = this.spriteId == 5 ? 2 : 7;
                                                                                        }
                                                                                    }
                                                                                    bl = true;
                                                                                    break block25;
                                                                                }
                                                                                if (this.spriteId != 5) break block26;
                                                                                n = 0;
                                                                                break block25;
                                                                            }
                                                                            if (this.spriteId != 3 || n2 < 8 || n2 > 11) break block27;
                                                                            if (nArray == null) break block25;
                                                                            if (nArray[2] != 403 && nArray[2] != 404 && nArray[2] != 402) break block28;
                                                                            if (GameWorld.tileSheetGround == 1) break block29;
                                                                        }
                                                                        if (nArray[2] != 410 && nArray[2] != 409) break block30;
                                                                        if (GameWorld.tileSheetGround == 0) break block29;
                                                                    }
                                                                    if (nArray[2] != 417 && nArray[2] != 418 && nArray[2] != 416) break block31;
                                                                    if (GameWorld.tileSheetGround != 2) break block31;
                                                                }
                                                                n = 17;
                                                                break block25;
                                                            }
                                                            if (nArray[2] != 406 && nArray[2] != 405) break block32;
                                                            if (GameWorld.tileSheetGround == 1) break block33;
                                                        }
                                                        if (nArray[2] != 412 && nArray[2] != 411) break block34;
                                                        if (GameWorld.tileSheetGround == 0) break block33;
                                                    }
                                                    if (nArray[2] != 420 && nArray[2] != 421 && nArray[2] != 419) break block35;
                                                    if (GameWorld.tileSheetGround != 2) break block35;
                                                }
                                                n = 15;
                                                break block25;
                                            }
                                            if (nArray[2] != 401 && nArray[2] != 400) break block36;
                                            if (GameWorld.tileSheetGround == 1) break block37;
                                        }
                                        if (nArray[2] != 408 && nArray[2] != 407) break block38;
                                        if (GameWorld.tileSheetGround == 0) break block37;
                                    }
                                    if (nArray[2] != 414 && nArray[2] != 415 && nArray[2] != 413) break block25;
                                    if (GameWorld.tileSheetGround != 2) break block25;
                                }
                                n = 16;
                                break block25;
                            }
                            if (this.spriteId != 3 || nArray == null) break block39;
                            if (nArray[2] != 401 && nArray[2] != 406 && nArray[2] != 403 && nArray[2] != 404 && nArray[2] != 402 && nArray[2] != 405 && nArray[2] != 400) break block40;
                            if (GameWorld.tileSheetGround == 1) break block41;
                        }
                        if (nArray[2] != 408 && nArray[2] != 412 && nArray[2] != 410 && nArray[2] != 409 && nArray[2] != 411 && nArray[2] != 407) break block42;
                        if (GameWorld.tileSheetGround == 0) break block41;
                    }
                    if (nArray[2] != 414 && nArray[2] != 415 && nArray[2] != 420 && nArray[2] != 421 && nArray[2] != 417 && nArray[2] != 418 && nArray[2] != 416 && nArray[2] != 419 && nArray[2] != 413) break block39;
                    if (GameWorld.tileSheetGround != 2) break block39;
                }
                return;
            }
            switch (this.bytes[1]) {
                case 0: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 6: {
                    n = 3;
                }
            }
            bl = true;
        }
        if (n != n2) {
            this.sprite.startAnimation(n, bl ? 0 : 1);
        }
    }

    public void setInteractAnimation() {
        int n;
        int n2 = n = this.sprite.currentAnimation;
        this.sprite.startAnimation(n2, 1);
    }

    public boolean isOnScreen() {
        if (this.x >> 8 > GameWorld.mapView[0] - 32) {
            if (this.x >> 8 < GameWorld.mapView[0] + Device.WIDTH + 32) {
                if (this.y >> 8 > GameWorld.mapView[1] - 32) {
                    if (this.y >> 8 < GameWorld.mapView[1] + Device.HEIGHT + 32) {
                        return true;
                    }
                }
            }
        }
        if (this.getCol() == 0 && this.getRow() == 0) {
            return true;
        }
        return this.spriteId == 30;
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.sprite != null && this.sprite.spriteKey.equals("hill")) {
            return;
        }
        if (this.spriteId == 31) {
            return;
        }
        if (this.sprite != null) {
            if (!GameWorld.isObserveStyle) {
                this.sprite.tickAnimation(50);
            }
            if (this.sprite.collisionRect != null) {
                if (this.spriteId == 10 && this.sprite.currentAnimation == 6) {
                    this.setCollisionRectangle(this.ints[4], this.ints[5]);
                } else if (this.sprite.curAnimationSequence[this.sprite.frameIndex] != -1) {
                    this.setCollisionRectangle(this.sprite.collisionRect[this.sprite.curAnimationSequence[this.sprite.frameIndex]][2], this.sprite.collisionRect[this.sprite.curAnimationSequence[this.sprite.frameIndex]][3]);
                }
            }
        }
        if (this.spriteId == 20 && this.sprite.clipWidth + this.sprite.clipHeight != 0) {
            if (this.sprite.currentAnimation == 0 || this.sprite.currentAnimation == 1) {
                if (this.sprite.clipHeight - this.wallFireClipHRecord != gameViewYRecord - GameWorld.mapView[1]) {
                    this.sprite.clipHeight = gameViewYRecord - GameWorld.mapView[1] + this.wallFireClipHRecord;
                }
                if (this.sprite.clipHeight > Device.HEIGHT - 22) {
                    this.sprite.clipHeight = Device.HEIGHT - 22;
                }
            } else if (this.sprite.currentAnimation == 2 || this.sprite.currentAnimation == 3) {
                if (this.sprite.clipWidth - this.wallFireClipWRecord != gameViewXRecord - GameWorld.mapView[0]) {
                    this.sprite.clipWidth = gameViewXRecord - GameWorld.mapView[0] + this.wallFireClipWRecord;
                }
            } else if ((this.sprite.currentAnimation == 4 || this.sprite.currentAnimation == 5) && this.sprite.clipX - this.wallFireClipXRecord != gameViewXRecord - GameWorld.mapView[0]) {
                this.sprite.clipX = gameViewXRecord - GameWorld.mapView[0] + this.wallFireClipXRecord;
            }
        }
        if (this.sprite != null && this.spriteId != 10) {
            this.sprite.paint(graphics, n, n2);
        }
        if (this.type == 5 && this.booleans[0]) {
            Engine.saveAndSetClip(graphics, 0, 0, Device.WIDTH, Device.HEIGHT);
            this.drawSpeechBubble(graphics, n, n2);
            Engine.restoreClip(graphics);
        }
    }

    public void drawSpeechBubble(Graphics graphics, int n, int n2) {
        int n3 = this.x >> 8;
        int n4 = this.y >> 8;
        if (this.booleans[1]) {
            n = 0;
            n2 = 0;
        }
        int n5 = -1;
        if ((this.bytes[5] == 0 || this.bytes[5] == 4) && this.ints[4] != -1) {
            n5 = this.ints[4] + n;
        } else if ((this.bytes[5] == 6 || this.bytes[5] == 2) && this.ints[5] != -1) {
            n5 = this.ints[5] + n2;
        }
        GameWorld.drawSpeechBubble(graphics, n3 + n, n4 + n2, this.ints[0], this.ints[1], this.strings2[0], this.bytes[7], this.bytes[6], 3, n5, this.bytes[5], this.bytes[4] == 2 || this.ints[0] == this.ints[2] && this.ints[1] == this.ints[3], this.bytes[4]);
    }
}

