/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class SGSprite
implements Constants {
    public static Hashtable cachedSprites = new Hashtable();
    public static Hashtable cachedSpriteImages = new Hashtable();
    public static Hashtable cachedSpriteImageRef = new Hashtable();
    public static Hashtable cachedSpriteImagesPlte = new Hashtable();
    public String spriteKey;
    public int[] spriteImageKeys;
    public DeviceImage[] spriteImages;
    public short[][] layerImageIndices;
    public short[][] layerImageX;
    public short[][] layerImageY;
    public byte[][] animationSequences;
    public short[][] animationDelay;
    public int currentAnimation = 0;
    public byte[] curAnimationSequence;
    public int nextAnimationSequenceIndex;
    public boolean nextAnimationSequenceLoops;
    public byte[] nextAnimationSequences;
    public int frameIndex;
    public int x;
    public int y;
    public int loops = 1;
    public boolean animationDone;
    public int curFrameTime;
    public boolean firstTimeDone;
    public int clipX;
    public int clipY;
    public int clipWidth;
    public int clipHeight;
    public static final byte COLLISION_X = 0;
    public static final byte COLLISION_Y = 1;
    public static final byte COLLISION_WIDTH = 2;
    public static final byte COLLISION_HEIGHT = 3;
    public short[] spriteBound;
    public short[][] collisionRect;
    public short[] actualSpriteBound;
    public short[] anchorPointX;
    public short[] anchorPointY;
    public boolean visible = true;

    public static DeviceImage[] loadSprite(String string) throws Exception {
        return SGSprite.loadSprite(string, null, false);
    }

    public static DeviceImage[] loadSprite(String string, SGSprite sGSprite, boolean bl) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            DeviceImage[] deviceImageArray;
            ByteArrayInputStream byteArrayInputStream = null;
            FilterInputStream filterInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(ResourceMaster.getResource(string + ".sg"));
                filterInputStream = new DataInputStream(byteArrayInputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byteArrayInputStream == null) {
                DeviceImage[] deviceImageArray2 = new DeviceImage[]{new DeviceImage(string + ".png")};
                if (sGSprite != null) {
                    sGSprite.spriteImages = deviceImageArray2;
                    sGSprite.layerImageIndices = new short[][]{{0}};
                    sGSprite.layerImageX = new short[][]{{0}};
                    sGSprite.layerImageY = new short[][]{{0}};
                    sGSprite.animationSequences = new byte[][]{{0}};
                    sGSprite.curAnimationSequence = sGSprite.animationSequences[0];
                    sGSprite.spriteImages = deviceImageArray2;
                }
                return deviceImageArray2;
            }
            int n8 = filterInputStream.read();
            boolean bl2 = ((DataInputStream)filterInputStream).readBoolean();
            int n9 = ((DataInputStream)filterInputStream).readShort();
            DeviceImage[] deviceImageArray3 = new DeviceImage[n9];
            if (n8 == 1) {
                if (n9 > 0) {
                    DeviceImage deviceImage = new DeviceImage(string + ".png");
                    deviceImageArray = null;
                    n7 = filterInputStream.read();
                    if (n7 > 0) {
                        deviceImageArray = new DeviceImage[n7];
                        if (sGSprite != null) {
                            sGSprite.spriteImageKeys = new int[n7];
                        }
                        for (n6 = 0; n6 < n7; ++n6) {
                            n5 = ((DataInputStream)filterInputStream).readInt();
                            if (sGSprite != null) {
                                sGSprite.spriteImageKeys[n6] = n5;
                            }
                            deviceImageArray[n6] = SGSprite.loadSpriteImage(n5, sGSprite);
                        }
                    }
                    for (n6 = 0; n6 < n9; ++n6) {
                        n5 = -1;
                        if (n7 > 0) {
                            n5 = ((DataInputStream)filterInputStream).readByte();
                        }
                        if (n5 == -1) {
                            if (deviceImage.width < 256 && deviceImage.height < 256) {
                                n4 = filterInputStream.read();
                                n3 = filterInputStream.read();
                                n2 = filterInputStream.read();
                                n = filterInputStream.read();
                            } else {
                                n4 = ((DataInputStream)filterInputStream).readShort();
                                n3 = ((DataInputStream)filterInputStream).readShort();
                                n2 = ((DataInputStream)filterInputStream).readShort();
                                n = ((DataInputStream)filterInputStream).readShort();
                            }
                            deviceImageArray3[n6] = new DeviceImage(deviceImage, n4, n3, n2, n);
                            continue;
                        }
                        deviceImageArray3[n6] = deviceImageArray[n5];
                    }
                }
            } else {
                if (sGSprite != null) {
                    sGSprite.spriteImageKeys = new int[n9];
                }
                for (int i = 0; i < n9; ++i) {
                    int n10 = ((DataInputStream)filterInputStream).readInt();
                    if (sGSprite != null) {
                        sGSprite.spriteImageKeys[i] = n10;
                    }
                    deviceImageArray3[i] = SGSprite.loadSpriteImage(n10, sGSprite);
                }
            }
            int n11 = ((DataInputStream)filterInputStream).readShort();
            deviceImageArray = new DeviceImage[n11];
            for (n7 = 0; n7 < n11; ++n7) {
                n6 = filterInputStream.read();
                n5 = filterInputStream.read();
                deviceImageArray[n7] = new DeviceImage(deviceImageArray3[n6], n5);
            }
            deviceImageArray3 = null;
            if (sGSprite != null) {
                int n12;
                short s;
                int n13;
                int n14;
                int n15;
                sGSprite.spriteImages = deviceImageArray;
                n7 = ((InputStream)byteArrayInputStream).read();
                sGSprite.layerImageIndices = new short[n7][];
                sGSprite.layerImageX = new short[n7][];
                sGSprite.layerImageY = new short[n7][];
                sGSprite.collisionRect = new short[n7][4];
                sGSprite.spriteBound = new short[4];
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MIN_VALUE;
                n4 = Integer.MAX_VALUE;
                n3 = Integer.MIN_VALUE;
                for (n2 = 0; n2 < n7; ++n2) {
                    n = ((InputStream)byteArrayInputStream).read();
                    sGSprite.layerImageIndices[n2] = new short[n];
                    sGSprite.layerImageX[n2] = new short[n];
                    sGSprite.layerImageY[n2] = new short[n];
                    for (n15 = 0; n15 < n; ++n15) {
                        int n16;
                        n14 = ((InputStream)byteArrayInputStream).read();
                        if (bl2) {
                            n13 = ((DataInputStream)filterInputStream).readShort();
                            s = ((DataInputStream)filterInputStream).readShort();
                        } else {
                            n13 = ((DataInputStream)filterInputStream).readByte();
                            s = ((DataInputStream)filterInputStream).readByte();
                        }
                        sGSprite.layerImageIndices[n2][n15] = (short)n14;
                        sGSprite.layerImageX[n2][n15] = (short)n13;
                        sGSprite.layerImageY[n2][n15] = s;
                        if (n13 < n6) {
                            n6 = n13;
                        }
                        if ((n12 = n13 + sGSprite.spriteImages[n14].width) > n5) {
                            n5 = n12;
                        }
                        if (s < n4) {
                            n4 = s;
                        }
                        if ((n16 = s + sGSprite.spriteImages[n14].height) <= n3) continue;
                        n3 = n16;
                    }
                    n15 = ((DataInputStream)filterInputStream).readBoolean() ? 1 : 0;
                    if (n15 == 0) continue;
                    sGSprite.collisionRect[n2] = new short[4];
                    if (bl2) {
                        sGSprite.collisionRect[n2][0] = ((DataInputStream)filterInputStream).readShort();
                        sGSprite.collisionRect[n2][1] = ((DataInputStream)filterInputStream).readShort();
                        sGSprite.collisionRect[n2][2] = ((DataInputStream)filterInputStream).readShort();
                        sGSprite.collisionRect[n2][3] = ((DataInputStream)filterInputStream).readShort();
                    } else {
                        sGSprite.collisionRect[n2][0] = ((DataInputStream)filterInputStream).readByte();
                        sGSprite.collisionRect[n2][1] = ((DataInputStream)filterInputStream).readByte();
                        sGSprite.collisionRect[n2][2] = (short)filterInputStream.read();
                        sGSprite.collisionRect[n2][3] = (short)filterInputStream.read();
                    }
                    if (sGSprite.collisionRect[n2][2] == 1 && sGSprite.collisionRect[n2][3] == 1) {
                        sGSprite.collisionRect[n2][2] = 0;
                        sGSprite.collisionRect[n2][3] = 0;
                    } else {
                        if (sGSprite.collisionRect[n2][0] < n6) {
                            n6 = sGSprite.collisionRect[n2][0];
                        }
                        if ((n14 = sGSprite.collisionRect[n2][0] + sGSprite.collisionRect[n2][2]) > n5) {
                            n5 = n14;
                        }
                        if (sGSprite.collisionRect[n2][1] < n4) {
                            n4 = sGSprite.collisionRect[n2][1];
                        }
                        if ((n13 = sGSprite.collisionRect[n2][1] + sGSprite.collisionRect[n2][3]) > n3) {
                            n3 = n13;
                        }
                    }
                    if (!bl) continue;
                    sGSprite.collisionRect[n2][0] = (short)GameWorld.scaleToBase(sGSprite.collisionRect[n2][0]);
                    sGSprite.collisionRect[n2][1] = (short)GameWorld.scaleToBase(sGSprite.collisionRect[n2][1]);
                    sGSprite.collisionRect[n2][2] = (short)GameWorld.scaleToBase(sGSprite.collisionRect[n2][2]);
                    sGSprite.collisionRect[n2][3] = (short)GameWorld.scaleToBase(sGSprite.collisionRect[n2][3]);
                }
                sGSprite.spriteBound[0] = (short)n6;
                sGSprite.spriteBound[1] = (short)n4;
                sGSprite.spriteBound[2] = (short)(n5 - n6);
                sGSprite.spriteBound[3] = (short)(n3 - n4);
                if (bl) {
                    sGSprite.actualSpriteBound = new short[4];
                    for (n2 = 0; n2 < 4; ++n2) {
                        sGSprite.actualSpriteBound[n2] = sGSprite.spriteBound[n2];
                    }
                    sGSprite.spriteBound[0] = (short)GameWorld.scaleToBase(sGSprite.spriteBound[0]);
                    sGSprite.spriteBound[1] = (short)GameWorld.scaleToBase(sGSprite.spriteBound[1]);
                    sGSprite.spriteBound[2] = (short)GameWorld.scaleToBase(sGSprite.spriteBound[2]);
                    sGSprite.spriteBound[3] = (short)GameWorld.scaleToBase(sGSprite.spriteBound[3]);
                } else {
                    sGSprite.actualSpriteBound = sGSprite.spriteBound;
                }
                n2 = filterInputStream.read();
                sGSprite.anchorPointX = new short[n2];
                sGSprite.anchorPointY = new short[n2];
                for (n = 0; n < n2; ++n) {
                    if (bl2) {
                        sGSprite.anchorPointX[n] = ((DataInputStream)filterInputStream).readShort();
                        sGSprite.anchorPointY[n] = ((DataInputStream)filterInputStream).readShort();
                    } else {
                        sGSprite.anchorPointX[n] = ((DataInputStream)filterInputStream).readByte();
                        sGSprite.anchorPointY[n] = ((DataInputStream)filterInputStream).readByte();
                    }
                    if (!bl) continue;
                    sGSprite.anchorPointX[n] = (short)GameWorld.scaleToBase(sGSprite.anchorPointX[n]);
                    sGSprite.anchorPointY[n] = (short)GameWorld.scaleToBase(sGSprite.anchorPointY[n]);
                }
                n = filterInputStream.read();
                if (n == 0) {
                    sGSprite.animationSequences = new byte[1][n7];
                    sGSprite.animationDelay = new short[1][n7];
                    for (n15 = 0; n15 < n7; ++n15) {
                        sGSprite.animationSequences[0][n15] = (byte)n15;
                        sGSprite.animationDelay[0][n15] = 100;
                    }
                } else {
                    sGSprite.animationSequences = new byte[n][];
                    sGSprite.animationDelay = new short[n][];
                    for (n15 = 0; n15 < n; ++n15) {
                        n14 = filterInputStream.read();
                        sGSprite.animationSequences[n15] = new byte[n14];
                        sGSprite.animationDelay[n15] = new short[n14];
                        for (n13 = 0; n13 < n14; ++n13) {
                            s = ((DataInputStream)filterInputStream).readByte();
                            n12 = ((DataInputStream)filterInputStream).readShort();
                            sGSprite.animationSequences[n15][n13] = s;
                            sGSprite.animationDelay[n15][n13] = n12;
                        }
                    }
                }
                sGSprite.curAnimationSequence = sGSprite.animationSequences[0];
            }
            ((InputStream)byteArrayInputStream).close();
            return deviceImageArray;
        }
        catch (Exception exception) {
            DebugManager.debug(exception);
            return null;
        }
    }

    private static DeviceImage loadSpriteImage(int n, SGSprite sGSprite) throws Exception {
        String string = String.valueOf(n);
        DeviceImage deviceImage = (DeviceImage)cachedSpriteImages.get(string);
        if (deviceImage != null) {
            if (sGSprite != null) {
                SGSprite[] sGSpriteArray = (SGSprite[])cachedSpriteImageRef.get(string);
                SGSprite[] sGSpriteArray2 = new SGSprite[sGSpriteArray.length + 1];
                System.arraycopy(sGSpriteArray, 0, sGSpriteArray2, 0, sGSpriteArray.length);
                sGSpriteArray2[sGSpriteArray.length] = sGSprite;
                cachedSpriteImageRef.put(string, sGSpriteArray2);
            }
        } else {
            deviceImage = new DeviceImage(ResourceMaster.getResource(ResourceMaster.getIDFromHash(n)));
            if (sGSprite != null) {
                cachedSpriteImages.put(string, deviceImage);
                cachedSpriteImageRef.put(string, new SGSprite[]{sGSprite});
            }
        }
        return deviceImage;
    }

    public SGSprite(String string, boolean bl) {
        SGSprite sGSprite = (SGSprite)cachedSprites.get(string);
        if (sGSprite != null) {
            this.cloneSprite(sGSprite);
        } else {
            SGSprite.loadSprite(string, this, bl);
            this.spriteKey = string;
            cachedSprites.put(string, this);
        }
    }

    public SGSprite(String string) {
        this(string, false);
    }

    public SGSprite(SGSprite sGSprite) {
        this.cloneSprite(sGSprite);
    }

    public void cloneSprite(SGSprite sGSprite) {
        this.spriteImages = sGSprite.spriteImages;
        this.layerImageIndices = sGSprite.layerImageIndices;
        this.layerImageX = sGSprite.layerImageX;
        this.layerImageY = sGSprite.layerImageY;
        this.animationSequences = sGSprite.animationSequences;
        this.animationDelay = sGSprite.animationDelay;
        this.curAnimationSequence = sGSprite.curAnimationSequence;
        this.currentAnimation = sGSprite.currentAnimation;
        this.collisionRect = sGSprite.collisionRect;
        this.spriteBound = sGSprite.spriteBound;
        this.actualSpriteBound = sGSprite.actualSpriteBound;
        this.frameIndex = sGSprite.frameIndex;
        this.x = sGSprite.x;
        this.y = sGSprite.y;
        this.loops = sGSprite.loops;
        this.anchorPointX = sGSprite.anchorPointX;
        this.anchorPointY = sGSprite.anchorPointY;
        this.spriteKey = sGSprite.spriteKey;
    }

    public short[] getAnchorPoint(int n) {
        return new short[]{this.anchorPointX[n], this.anchorPointY[n]};
    }

    public int getFrame() {
        return this.frameIndex;
    }

    public int getFrameSequenceLength() {
        return this.curAnimationSequence.length;
    }

    public int getRawFrameCount() {
        return this.spriteImages.length;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCenterX() {
        return this.x + this.spriteBound[0] + (this.spriteBound[2] >> 1);
    }

    public int getCenterY() {
        return this.y + this.spriteBound[1] + (this.spriteBound[3] >> 1);
    }

    public int getLeftX() {
        return this.x + this.spriteBound[0];
    }

    public int getTopY() {
        return this.y + this.spriteBound[1];
    }

    public int getRightX() {
        return this.x + this.spriteBound[0] + this.spriteBound[2];
    }

    public int getBottomY() {
        return this.y + this.spriteBound[1] + this.spriteBound[3];
    }

    public int getWidth() {
        return this.spriteBound[2];
    }

    public int getHeight() {
        return this.spriteBound[3];
    }

    public int getAnimationSequenceDuration(int n) {
        int n2 = 0;
        for (int i = 0; i < this.animationSequences[n].length; ++i) {
            n2 += this.animationDelay[n][i];
        }
        return n2;
    }

    public int getSequenceIndex() {
        return this.currentAnimation;
    }

    public void setFrame(int n) {
        if (n < this.curAnimationSequence.length) {
            this.frameIndex = (byte)n;
        }
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void nextFrame() {
        ++this.frameIndex;
        if (this.frameIndex >= this.curAnimationSequence.length) {
            this.frameIndex = 0;
        }
    }

    public void setFrameSequence(byte[] byArray) {
        this.curAnimationSequence = byArray;
        this.frameIndex = 0;
    }

    public void setFrameSequence(int n) {
        if (this.animationSequences != null && n < this.animationSequences.length) {
            byte[] byArray = this.animationSequences[n];
            this.setFrameSequence(byArray);
            this.currentAnimation = n;
        }
    }

    public void startAnimationSequence(byte[] byArray, boolean bl) {
        this.nextAnimationSequences = byArray;
        this.nextAnimationSequenceIndex = 0;
        this.nextAnimationSequenceLoops = bl;
        this.startAnimation(this.nextAnimationSequences[0], 1);
    }

    public void randomizeAnimation() {
        if (this.nextAnimationSequences != null) {
            this.startAnimation(Engine.rndPositive(this.nextAnimationSequences.length), 1);
        }
        this.tickAnimation(Engine.rndPositive(this.getAnimationSequenceDuration(this.currentAnimation)));
    }

    public void startAnimation(int n, int n2) {
        this.frameIndex = 0;
        this.curFrameTime = 0;
        this.currentAnimation = n;
        this.curAnimationSequence = this.animationSequences[this.currentAnimation];
        this.loops = n2;
        this.animationDone = false;
        this.firstTimeDone = false;
    }

    public void restartAnimation() {
        this.frameIndex = 0;
        this.curFrameTime = 0;
        this.curAnimationSequence = this.animationSequences[this.currentAnimation];
        this.animationDone = false;
        this.firstTimeDone = false;
    }

    public void tickAnimation(int n) {
        if (this.animationDone) {
            return;
        }
        this.curFrameTime += n;
        short s = this.animationDelay[this.currentAnimation][this.frameIndex];
        while (this.curFrameTime >= s) {
            ++this.frameIndex;
            if (this.frameIndex >= this.curAnimationSequence.length) {
                if (this.nextAnimationSequences != null) {
                    ++this.nextAnimationSequenceIndex;
                    if (this.nextAnimationSequenceIndex >= this.nextAnimationSequences.length) {
                        if (this.nextAnimationSequenceLoops) {
                            this.nextAnimationSequenceIndex = 0;
                            this.startAnimation(this.nextAnimationSequences[this.nextAnimationSequenceIndex], 1);
                        } else {
                            this.nextAnimationSequences = null;
                            this.frameIndex = this.curAnimationSequence.length - 1;
                            this.animationDone = true;
                        }
                    } else {
                        this.startAnimation(this.nextAnimationSequences[this.nextAnimationSequenceIndex], 1);
                    }
                } else {
                    if (this.loops > 1) {
                        this.frameIndex = 0;
                        --this.loops;
                    } else if (this.loops <= 0) {
                        this.frameIndex = 0;
                    } else {
                        this.frameIndex = this.curAnimationSequence.length - 1;
                        this.animationDone = true;
                    }
                    this.firstTimeDone = true;
                }
            }
            this.curFrameTime -= s;
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (!this.visible) {
            return;
        }
        if (GameWorld.isPlayerOnSwamp && this.spriteKey.equals(GameWorld.player.sprite.spriteKey)) {
            if (GameWorld.swampTick <= 50 && !GameWorld.isPlayerDie) {
                n5 = GameWorld.player.spriteId - 1;
                n4 = n2 + this.x + (GameWorld.player.collisionOffsetX >> 8);
                int n6 = n3 + this.y + (GameWorld.player.collisionOffsetY >> 8);
                int n7 = GameWorld.player.collisionWidth >> 8;
                int n8 = GameWorld.player.collisionHeight >> 8;
                if (GameWorld.player.spriteId == 1) {
                    if (GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) {
                        Engine.saveAndSetClip(graphics, n4, n6, n7, n8);
                    } else {
                        Engine.saveAndSetClip(graphics, n4, n6 - 5, n7, n8);
                    }
                } else if (GameWorld.player.spriteId == 2) {
                    if (GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) {
                        Engine.saveAndSetClip(graphics, n4, n6, n7, n8);
                    } else {
                        Engine.saveAndSetClip(graphics, n4, n6 - 5, n7 + 15, n8);
                    }
                } else if (GameWorld.player.spriteId == 3) {
                    if (GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) {
                        Engine.saveAndSetClip(graphics, n4 - 5, n6 - 15, n7 + 10, n8 + 8);
                    } else {
                        Engine.saveAndSetClip(graphics, n4 - 5, n6 - 15, n7 + 10, n8 + 8);
                    }
                }
                if (GameWorld.swampTick == 50) {
                    GameWorld.playerDie(GameWorld.player.spriteId);
                    return;
                }
            } else if (GameWorld.swampTick > 50 || GameWorld.isPlayerDie) {
                return;
            }
        }
        if (this.clipWidth + this.clipHeight != 0 && this.spriteKey.equals("wall_fire")) {
            Engine.saveAndSetClip(graphics, this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        n5 = n2;
        n4 = n3;
        if (bl) {
            n5 += GameWorld.scaleGame(this.x);
            n4 += GameWorld.scaleGame(this.y);
        } else {
            n5 += this.x;
            n4 += this.y;
        }
        short[] sArray = this.layerImageIndices[n];
        short[] sArray2 = this.layerImageX[n];
        short[] sArray3 = this.layerImageY[n];
        if (!GameWorld.isPlayerDie && GameWorld.isPlayerOnSwamp && this.spriteKey.equals(GameWorld.player.sprite.spriteKey)) {
            for (int i = sArray.length - 1; i >= 0; --i) {
                if ((GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) && GameWorld.player.spriteId != 3) {
                    this.spriteImages[sArray[i]].drawImage(graphics, n5 + sArray2[i], n4 + sArray3[i]);
                    continue;
                }
                this.spriteImages[sArray[i]].drawImage(graphics, n5 + sArray2[i], n4 + sArray3[i] + (GameWorld.swampHeight >> 8));
            }
            if (GameWorld.player.spriteId == 1) {
                GameWorld.swampHeight += 112;
            } else if (GameWorld.player.spriteId == 2) {
                GameWorld.swampHeight += 63;
            } else if (GameWorld.player.spriteId == 3) {
                GameWorld.swampHeight += 84;
            }
            Engine.restoreClip(graphics);
        } else if (this.clipWidth + this.clipHeight != 0 && this.spriteKey.equals("wall_fire")) {
            for (int i = sArray.length - 1; i >= 0; --i) {
                this.spriteImages[sArray[i]].drawImage(graphics, n5 + sArray2[i], n4 + sArray3[i]);
            }
            Engine.restoreClip(graphics);
        } else {
            for (int i = sArray.length - 1; i >= 0; --i) {
                this.spriteImages[sArray[i]].drawImage(graphics, n5 + sArray2[i], n4 + sArray3[i]);
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        this.paint(graphics, this.curAnimationSequence[this.frameIndex], n, n2, bl);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.curAnimationSequence.length != 0) {
            this.paint(graphics, this.curAnimationSequence[this.frameIndex], n, n2, false);
        }
    }

    public void paintAnchored(Graphics graphics, int n, int n2, int n3) {
        this.paintAnchored(graphics, this.curAnimationSequence[this.frameIndex], n, n2, n3);
    }

    public void paintAnchored(Graphics graphics, int n, int n2, int n3, int n4) {
        if ((n4 & 4) != 0) {
            n2 -= this.spriteBound[0];
        } else if ((n4 & 8) != 0) {
            n2 = n2 - this.spriteBound[0] - this.spriteBound[2];
        } else if ((n4 & 1) != 0) {
            n2 = n2 - this.spriteBound[0] - (this.spriteBound[2] >> 1);
        }
        if ((n4 & 0x10) != 0) {
            n3 -= this.spriteBound[1];
        } else if ((n4 & 0x20) != 0) {
            n3 = n3 - this.spriteBound[1] - this.spriteBound[3];
        } else if ((n4 & 2) != 0) {
            n3 = n3 - this.spriteBound[1] - (this.spriteBound[3] >> 1);
        }
        this.paint(graphics, n, n2, n3, false);
    }

    public void releaseBaseSprite() {
        if (this.spriteKey != null) {
            if (this.spriteImageKeys != null) {
                for (int i = 0; i < this.spriteImageKeys.length; ++i) {
                    String string = String.valueOf(this.spriteImageKeys[i]);
                    SGSprite[] sGSpriteArray = (SGSprite[])cachedSpriteImageRef.get(string);
                    if (sGSpriteArray == null) continue;
                    for (int j = 0; j < sGSpriteArray.length; ++j) {
                        if (sGSpriteArray[j] != this) continue;
                        SGSprite[] sGSpriteArray2 = new SGSprite[sGSpriteArray.length - 1];
                        System.arraycopy(sGSpriteArray, 0, sGSpriteArray2, 0, j);
                        System.arraycopy(sGSpriteArray, j + 1, sGSpriteArray2, j, sGSpriteArray2.length - j);
                        sGSpriteArray = sGSpriteArray2;
                        break;
                    }
                    if (sGSpriteArray.length == 0) {
                        cachedSpriteImages.remove(string);
                        cachedSpriteImageRef.remove(string);
                        continue;
                    }
                    cachedSpriteImageRef.put(string, sGSpriteArray);
                }
            }
            cachedSprites.remove(this.spriteKey);
        }
    }

    public static void releaseAllCaches() {
        cachedSprites.clear();
        cachedSpriteImageRef.clear();
        cachedSpriteImages.clear();
    }
}

