/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class AJPackInputStream
extends InputStream {
    private DataInputStream in;
    private AJFileEntry[] toc;
    private int currentEntry = -1;
    private int byteCount = 0;
    private int byteTotal = 0;
    private int entries;
    public static final String ID = "AJPK";
    public static final byte VERSION = 16;

    public AJPackInputStream(InputStream inputStream) throws IOException {
        this.in = new DataInputStream(inputStream);
        this.processHeader();
    }

    public int seekEntry(String string) throws IOException {
        AJFileEntry aJFileEntry = this.getEntry(string);
        if (aJFileEntry != null) {
            this.byteCount = 0;
            this.byteTotal = aJFileEntry.getSize();
            this.in.skip(aJFileEntry.getOffset());
            return this.byteTotal;
        }
        return -1;
    }

    public int nextEntry() {
        if (++this.currentEntry < this.toc.length) {
            AJFileEntry aJFileEntry = this.toc[this.currentEntry];
            this.byteCount = 0;
            this.byteTotal = aJFileEntry.getSize();
            return this.byteTotal;
        }
        return -1;
    }

    public int read() throws IOException {
        return this.byteCount++ < this.byteTotal ? this.in.read() : -1;
    }

    public Image[] getAllImages() throws IOException {
        Image[] imageArray = new Image[this.entries];
        for (int i = 0; i < this.entries; ++i) {
            imageArray[i] = this.getNextImage();
        }
        return imageArray;
    }

    public Image getNextImage() throws IOException {
        return this.getImage(this.nextEntry());
    }

    public Image getImage(String string) throws IOException {
        return this.getImage(this.seekEntry(string));
    }

    private Image getImage(int n) throws IOException {
        Image image;
        if (n <= 0) {
            throw new IOException("No more files");
        }
        byte[] byArray = new byte[n];
        this.read(byArray);
        try {
            image = Image.createImage((byte[])byArray, (int)0, (int)n);
        }
        catch (Exception exception) {
            throw new IOException("Image failed to load");
        }
        byArray = null;
        return image;
    }

    public void close() throws IOException {
        this.in.close();
        for (int i = 0; i < this.toc.length; ++i) {
            this.toc[i] = null;
        }
        this.toc = null;
        System.gc();
    }

    private AJFileEntry getEntry(String string) {
        int n = this.toc.length;
        for (int i = 0; i < n; ++i) {
            if (!this.toc[i].getId().equals(string)) continue;
            this.currentEntry = i;
            return this.toc[i];
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processHeader() throws IOException {
        byte[] byArray = new byte[ID.length()];
        this.in.read(byArray);
        if (!new String(byArray).equals(ID)) throw new IOException("Invalid file");
        if (this.in.read() != 16) throw new IOException("incompatible version");
        this.entries = this.in.readShort();
        int n = 0;
        this.toc = new AJFileEntry[this.entries];
        for (int i = 0; i < this.entries; ++i) {
            this.toc[i] = new AJFileEntry(this.in);
            this.toc[i].setOffset(n);
            n += this.toc[i].getSize();
        }
    }
}

