/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;

public class QuizManager
extends Sortable {
    public static final int TIPQUIZ_CATEGORIES = 22;
    public static final int POSSIBILITY_CATEGORIES = 21;
    public static final int ITEMS_PER_CATEGORY = 5;
    public static final byte TIP_QUIZ = 0;
    public static final byte POSSIBILITY_QUIZ = 1;
    private Vector tipQuizes = new Vector();
    private Vector possibilityQuizes = new Vector();
    private TipQuiz quizforSort;

    public void loadTipQuizes(Resources resources) throws IOException {
        this.tipQuizes.removeAllElements();
        System.gc();
        resources.openQuizData("/tipq.dat", 0, this.tipQuizes);
    }

    public void loadPossibilityQuizes(Resources resources) throws IOException {
        this.possibilityQuizes.removeAllElements();
        System.gc();
        resources.openQuizData("/possq.dat", 1, this.possibilityQuizes);
    }

    private Quiz getQuiz(Vector vector, int n) {
        Quiz quiz = null;
        for (int i = 0; i < vector.size(); ++i) {
            quiz = (Quiz)vector.elementAt(i);
            if (quiz.category == n) break;
        }
        if (quiz != null) {
            vector.removeElement(quiz);
        }
        return quiz;
    }

    public Quiz getNextQuiz(byte by, int n) {
        return by == 0 ? this.getQuiz(this.tipQuizes, n) : this.getQuiz(this.possibilityQuizes, n);
    }

    public boolean compare(Object object, Object object2) {
        Player player = (Player)object;
        Player player2 = (Player)object2;
        if (Math.abs(player.quizAnswer - this.quizforSort.correctAnswer) > Math.abs(player2.quizAnswer - this.quizforSort.correctAnswer)) {
            return true;
        }
        if (Math.abs(player.quizAnswer - this.quizforSort.correctAnswer) == Math.abs(player2.quizAnswer - this.quizforSort.correctAnswer)) {
            return player2.quizTime < player.quizTime;
        }
        return false;
    }

    public void compareTipQuizResults(TipQuiz tipQuiz, PlayerList playerList) {
        this.quizforSort = tipQuiz;
        Sortable.sortArray(playerList.order, 0, playerList.size, this);
    }

    public static int comparePossibilityQuizResults(PossibilityQuiz possibilityQuiz, PlayerList playerList) {
        if (playerList.size == 2) {
            int n = (playerList.order[0].quizAnswer == possibilityQuiz.correctAnswer ? 1 : 0) | (playerList.order[1].quizAnswer == possibilityQuiz.correctAnswer ? 2 : 0);
            return n == 3 ? (playerList.order[0].quizTime < playerList.order[1].quizTime ? 1 : 2) : n;
        }
        throw new RuntimeException("only 2 players can be compared!");
    }

    public static TipQuiz createTipQuiz(String string, int n, int n2, int n3, int n4) {
        return new TipQuiz(string, n, n3, n4);
    }

    public static PossibilityQuiz createPossibilityQuiz(String string, int n, int n2) {
        return new PossibilityQuiz(string, n, n2);
    }
}

