/*
 * Decompiled with CFR 0.152.
 */
public class SportList
extends Sortable {
    private static final int DEFAULT_CAPACITY = 5;
    public Sport[] data;
    protected int size = 0;

    public SportList() {
        this.data = new Sport[5];
    }

    public SportList(int n) {
        this.data = new Sport[n];
    }

    public SportList(Sport[] sportArray) {
        this.size = sportArray.length;
        this.data = new Sport[this.size];
        System.arraycopy(sportArray, 0, this.data, 0, this.size);
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            Sport[] sportArray = new Sport[Math.max(n2 * 2, n)];
            System.arraycopy(this.data, 0, sportArray, 0, this.size);
            this.data = sportArray;
            System.gc();
        }
    }

    public void trimToSize() {
        if (this.size != this.data.length) {
            Sport[] sportArray = new Sport[this.size];
            System.arraycopy(this.data, 0, sportArray, 0, this.size);
            this.data = sportArray;
            System.gc();
        }
    }

    public int size() {
        return this.size;
    }

    public boolean contains(Sport sport) {
        return this.indexOf(sport) != -1;
    }

    public int indexOf(Sport sport) {
        for (int i = 0; i < this.size; ++i) {
            if (!sport.name.equals(this.data[i].name)) continue;
            return i;
        }
        return -1;
    }

    public boolean add(Sport sport) {
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = sport;
        return true;
    }

    public Sport remove(Sport sport) {
        int n = this.indexOf(sport);
        if (n != -1) {
            return this.remove(n);
        }
        return null;
    }

    public Sport remove(int n) {
        Sport sport = this.data[n];
        if (n != --this.size) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
        System.gc();
        return sport;
    }

    public Sport get(int n) {
        return this.data[n];
    }

    public void clear() {
        if (this.size > 0) {
            this.data = null;
            System.gc();
            this.data = new Sport[5];
            this.size = 0;
        }
    }

    public void free() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.data = null;
        System.gc();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        String string = " [ ";
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(string).append(i).append(' ').append(this.data[i].name).append(' ').append(this.data[i].selectedBy).append(']');
        }
        return stringBuffer.toString();
    }

    public final SportList complementFromMap(Sport[] sportArray) {
        SportList sportList = new SportList();
        for (int i = 0; i < sportArray.length; ++i) {
            if (this.contains(sportArray[i])) continue;
            sportList.add(sportArray[i]);
        }
        return sportList;
    }

    public void sortByPosY() {
        Sortable.sortArray(this.data, 0, this.size, this);
    }

    public boolean compare(Object object, Object object2) {
        return ((Sport)object).posY > ((Sport)object2).posY;
    }
}

