/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public abstract class AJPanel {
    protected AJScreen screen = AJScreen.getScreen();
    protected int width;
    protected int height;
    public String title = null;
    protected boolean forceRepaint = true;
    protected AJCommandListener cmdListener;
    protected Command leftCommand;
    protected Command rightCommand;
    protected Command selectCommand;

    public AJPanel() {
        if (this.screen == null) {
            throw new RuntimeException("Error, screen is not initialized!");
        }
        this.setSize(this.screen.width, this.screen.height);
    }

    protected abstract void activate();

    protected abstract void tick();

    protected abstract void keyEvent(int var1, boolean var2);

    protected abstract void render(Graphics var1);

    protected void appActive(boolean bl) {
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void renderAt(Graphics graphics, int n, int n2) {
        graphics.translate(n, n2);
        this.render(graphics);
        graphics.translate(-n, -n2);
    }

    public void refresh() {
        this.forceRepaint = true;
    }

    public void addCommand(Command command) {
        if (command.getCommandType() == 2) {
            this.rightCommand = command;
        } else {
            this.leftCommand = command;
        }
        this.screen.repaintBorder = true;
    }

    public void removeCommand(Command command) {
        if (command == this.leftCommand) {
            this.leftCommand = null;
        } else if (command == this.rightCommand) {
            this.rightCommand = null;
        }
        if (command == this.selectCommand) {
            this.selectCommand = null;
        }
        this.screen.repaintBorder = true;
    }

    public void setSelectCommand(Command command) {
        this.selectCommand = command;
    }

    public void removeAllCommands() {
        this.selectCommand = null;
        this.rightCommand = null;
        this.leftCommand = null;
    }

    public void setCommandListener(AJCommandListener aJCommandListener) {
        this.cmdListener = aJCommandListener;
    }
}

