/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class AJScreen
extends Canvas
implements Runnable {
    public static final int SOFTKEY_LEFT = -6;
    public static final int SOFTKEY_RIGHT = -7;
    private MIDlet midlet = null;
    private static AJScreen instance;
    private boolean active = true;
    private Thread thread = null;
    private static final int MILLIS_PER_TICK = 50;
    private AJPanel current;
    private boolean panelChanged = false;
    private static int fullWidth;
    private static int fullHeight;
    private static boolean fullScreen;
    public AJGraphicFont titleFont;
    public static int borderColor;
    public static int borderLineColor;
    public static int softkeyHOffsetCenter;
    public static int softkeyVOffset;
    public static int softkeyVAlign;
    public static int titleHPosition;
    public static int titleVPosition;
    public static int titleHAlign;
    public static int titleVAlign;
    public static Image background;
    public static int backgroundFill;
    public boolean showBackgroundImage = true;
    private static int backgroundPosX;
    private static int backgroundPosY;
    private boolean forceBackFill = false;
    public boolean repaintBorder = true;
    public static Image verticalArrows;
    public static final byte ARROWS_OFF = 0;
    public static final byte UP_ARROW = 1;
    public static final byte DOWN_ARROW = 2;
    public static int showArrows;
    public int left;
    public int top;
    public int bottomHeight;
    public int width;
    public int height;

    public static AJScreen getScreen() {
        return instance;
    }

    public static AJScreen getScreen(int n, int n2, AJGraphicFont aJGraphicFont, MIDlet mIDlet) {
        if (instance == null) {
            instance = new AJScreen(n, n2, aJGraphicFont, mIDlet);
        }
        return instance;
    }

    public void setFullScreen(boolean bl) {
        fullScreen = bl;
        this.updateHeights();
    }

    public AJPanel getCurrent() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(AJPanel aJPanel) {
        showArrows = 0;
        this.repaintBorder = true;
        aJPanel.forceRepaint = true;
        aJPanel.activate();
        AJScreen aJScreen = this;
        synchronized (aJScreen) {
            this.current = aJPanel;
            this.panelChanged = true;
        }
    }

    public void clearBackImage() {
        background = null;
        System.gc();
    }

    public void setLogoBackground(boolean bl, int n) {
        if (bl) {
            backgroundPosX = (fullWidth >> 1) - (background.getWidth() >> 1);
            backgroundPosY = (fullHeight - this.top >> 1) - (background.getHeight() >> 1);
        } else {
            backgroundPosX = 0;
            backgroundPosY = 0;
        }
        backgroundFill = n;
        this.forceBackFill = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            long l;
            AJScreen aJScreen;
            long l2 = System.currentTimeMillis();
            if (this.current != null && !this.panelChanged) {
                aJScreen = this;
                synchronized (aJScreen) {
                    this.current.tick();
                }
            } else {
                this.panelChanged = false;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isShown()) {
                this.repaint();
                this.serviceRepaints();
            }
            if ((l = System.currentTimeMillis() - l2) >= 50L) continue;
            aJScreen = this;
            synchronized (aJScreen) {
                try {
                    this.wait(50L - l);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        } while (this.active);
        this.thread = null;
        instance = null;
        background = null;
        if (this.midlet != null) {
            this.midlet.notifyDestroyed();
        }
    }

    public void close() {
        long l = System.currentTimeMillis();
        this.active = false;
        while (System.currentTimeMillis() - l < 1500L && this.thread != null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void setBackgroundPos(int n, int n2) {
        backgroundPosX = n;
        backgroundPosY = n2;
    }

    public int getFullHeight() {
        return fullHeight;
    }

    public int getFullWidth() {
        return fullWidth;
    }

    public void showNotify() {
        if (this.current != null) {
            this.current.forceRepaint = true;
            this.current.appActive(true);
        }
        this.repaintBorder = true;
    }

    public void hideNotify() {
        if (this.current != null) {
            this.current.appActive(false);
        }
    }

    public synchronized void paint(Graphics graphics) {
        boolean bl = true;
        if (!this.active) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        if (this.current != null) {
            bl = this.current.forceRepaint;
        }
        if (bl) {
            if (this.getHeight() > fullHeight) {
                graphics.setColor(backgroundFill);
                graphics.fillRect(0, fullHeight, this.getWidth(), this.getHeight() - fullHeight);
            }
            graphics.setClip(0, this.top, this.width, this.height);
            if (background != null && this.showBackgroundImage) {
                if (this.forceBackFill) {
                    graphics.setColor(backgroundFill);
                    graphics.fillRect(0, this.top, this.width, this.height);
                }
                graphics.drawImage(background, backgroundPosX, this.top + backgroundPosY, 4 | 0x10);
            } else {
                graphics.setColor(backgroundFill);
                graphics.fillRect(0, this.top, this.width, this.height);
            }
            graphics.setClip(0, 0, fullWidth, fullHeight);
        }
        if (this.current != null) {
            graphics.translate(0, this.top);
            this.current.render(graphics);
            graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        }
        graphics.setClip(0, 0, fullWidth, fullHeight);
        if (!fullScreen && this.repaintBorder) {
            this.renderBorder(graphics);
        }
    }

    public int getGameActionKey(int n) {
        try {
            return super.getGameAction(n);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean leftSoftkeyPressed(int n) {
        return n == -6;
    }

    public void keyPressed(int n) {
        if (this.current != null) {
            AJPanel aJPanel = this.current;
            this.current.keyEvent(n, true);
            if (aJPanel != this.current) {
                return;
            }
            if (!fullScreen) {
                switch (n) {
                    case -6: {
                        if (this.current.leftCommand == null || this.current.cmdListener == null) break;
                        this.current.cmdListener.commandAction(this.current, this.current.leftCommand);
                        break;
                    }
                    case -7: {
                        if (this.current.rightCommand == null || this.current.cmdListener == null) break;
                        this.current.cmdListener.commandAction(this.current, this.current.rightCommand);
                        break;
                    }
                    default: {
                        if (this.getGameAction(n) != 8 || this.current.selectCommand == null || this.current.cmdListener == null) break;
                        this.current.cmdListener.commandAction(this.current, this.current.selectCommand);
                        return;
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        if (this.current != null) {
            this.current.keyEvent(n, false);
        }
    }

    public void updateHeights() {
        this.left = 0;
        this.width = fullWidth;
        backgroundPosX = 0;
        backgroundPosY = 0;
        if (fullScreen) {
            this.top = 0;
            this.height = fullHeight;
        } else {
            int n = this.titleFont.getHeight();
            this.top = verticalArrows != null ? verticalArrows.getHeight() + 1 : 0;
            this.bottomHeight = this.top;
            if (this.top < n) {
                this.top = this.bottomHeight = n + 2;
            }
            this.height = fullHeight - this.bottomHeight - this.top;
        }
        if (this.current != null) {
            this.current.setSize(this.width, this.height);
        }
    }

    private void renderBorder(Graphics graphics) {
        graphics.setColor(borderColor);
        graphics.fillRect(0, 0, fullWidth, this.top);
        graphics.fillRect(0, fullHeight - this.bottomHeight, fullWidth, this.bottomHeight + 1);
        graphics.setColor(borderLineColor);
        graphics.drawLine(0, this.top, fullWidth, this.top);
        graphics.drawLine(0, fullHeight - this.bottomHeight, fullWidth, fullHeight - this.bottomHeight);
        if (showArrows > 0 && verticalArrows != null) {
            int n = (fullWidth >> 1) - (verticalArrows.getWidth() >> 1) - 1;
            int n2 = fullHeight - verticalArrows.getHeight();
            if ((showArrows & 1) == 1) {
                graphics.setClip(n, n2, verticalArrows.getWidth(), (verticalArrows.getHeight() >> 1) + 1);
                graphics.drawImage(verticalArrows, n, n2, 0);
            }
            if ((showArrows & 2) == 2) {
                graphics.setClip(n, n2 + (verticalArrows.getHeight() >> 1) + 1, verticalArrows.getWidth(), verticalArrows.getHeight() >> 1);
                graphics.drawImage(verticalArrows, n, n2, 0);
            }
            graphics.setClip(0, 0, fullWidth, fullHeight);
        }
        if (this.current != null) {
            if (this.current.title != null) {
                this.titleFont.render(graphics, this.current.title, titleHPosition, titleVPosition, titleHAlign | titleVAlign);
            }
            if (this.current.leftCommand != null) {
                this.titleFont.render(graphics, this.current.leftCommand.getLabel(), softkeyHOffsetCenter, fullHeight - softkeyVOffset, softkeyVAlign | 1);
            }
            if (this.current.rightCommand != null) {
                this.titleFont.render(graphics, this.current.rightCommand.getLabel(), fullWidth - softkeyHOffsetCenter, fullHeight - softkeyVOffset, softkeyVAlign | 1);
            }
        }
        this.repaintBorder = false;
    }

    private void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.start();
    }

    private AJScreen(int n, int n2, AJGraphicFont aJGraphicFont, MIDlet mIDlet) {
        this.midlet = mIDlet;
        this.titleFont = aJGraphicFont;
        this.setFullScreenMode(true);
        fullWidth = n;
        fullHeight = n2;
        this.updateHeights();
        this.start();
    }

    public static Image loadImage(String string) throws IOException {
        try {
            return Image.createImage((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Failed to load/create file: " + string);
        }
    }

    static {
        fullScreen = false;
        borderColor = 5779744;
        borderLineColor = 10387573;
        softkeyHOffsetCenter = 10;
        softkeyVOffset = 10;
        softkeyVAlign = 2;
        titleHPosition = 40;
        titleVPosition = 20;
        titleHAlign = 1;
        titleVAlign = 16;
        background = null;
        backgroundFill = 0;
        backgroundPosX = 0;
        backgroundPosY = 0;
        verticalArrows = null;
        showArrows = 0;
    }
}

