/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class GameSession {
    public static final Random rand = new Random();
    public static final int GAME_PLAYERS = 3;
    protected GameScreen stateHandler;
    public static final int STATE_WAIT = 0;
    public static final int STATE_INITGAME = 1;
    public static final int STATE_GAMEFINISHED = 100;
    public static final byte FINALQUIZ_CATEGORY = 21;
    private int sessionState = 1;
    protected int waitingNextState = -1;
    protected int nextStateAfterClientInvoke = -1;
    public static long USER_RESPONSE_TIME = 15000L;
    public static Sport[] map;
    public static Player[] players;
    public static Player clientPlayer;
    private boolean clientPlayerPlaysQuiz = false;
    public RobotPlayer[] robots = new RobotPlayer[2];
    public static int MAX_ROUNDS;
    public static int currentRound;
    protected Player currentPlayer;
    private int currentPlayerIndex;
    private boolean playerAttackConfirmed = false;
    public static final int ATTACKRESULT_NONE = 0;
    public static final int ATTACKRESULT_DRAWN = 3;
    public int lastAttackResult;
    private Player attackWinner = null;
    public static final byte PCOLOR_RED = 0;
    public static final byte PCOLOR_YELLOW = 1;
    public static final byte PCOLOR_GREEN = 2;
    protected QuizManager quizMan;
    protected Quiz currentQuiz = null;
    public PlayerList quizPlayers = new PlayerList();
    public PlayerList displayPList;
    public static final byte LEVEL_HARD = 2;
    public static final byte LEVEL_NORMAL = 1;
    public static final byte LEVEL_ROOKIE = 0;
    public static final short[] GAMELEVEL_RATES;
    public static int gameLevel;
    public static final short[] QUIZ_QUESTION_LEVEL;
    protected static final int COUNTY_MODEATTACK = 1;
    protected static final int COUNTY_BASEATTACKABLE = 2;

    public GameSession(GameScreen gameScreen) {
        this.stateHandler = gameScreen;
        this.quizMan = new QuizManager();
    }

    public void loadSports() throws IOException {
        map = Resources.loadSports("/sports.dat");
    }

    public void loadQuiz(byte by, Resources resources) throws IOException {
        switch (by) {
            case 0: {
                this.quizMan.loadTipQuizes(resources);
                break;
            }
            case 1: {
                this.quizMan.loadPossibilityQuizes(resources);
            }
        }
    }

    protected void setState(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 34: {
                this.nextStateAfterClientInvoke = n + 1;
                this.stateHandler.sessionStateUpdated(n);
            }
        }
        this.sessionState = n;
    }

    public void confirmSelected(boolean bl) {
        this.playerAttackConfirmed = bl;
        this.setState(this.nextStateAfterClientInvoke);
    }

    public void sportSelected() {
        this.setState(this.nextStateAfterClientInvoke);
    }

    public void quizAnswered(Player player) {
        int n;
        if (this.currentQuiz instanceof PossibilityQuiz) {
            this.stateHandler.possibilityQuizAnswered(player);
        }
        for (n = 0; n < this.quizPlayers.size && this.quizPlayers.order[n].quizAnswer != -1; ++n) {
        }
        if (n == this.quizPlayers.size) {
            this.setState(this.nextStateAfterClientInvoke);
        }
    }

    protected void sportSelectedBy(Player player) {
        player.selectedSport.selectedBy = player;
        player.selectedSport.setValue(currentRound * 100);
    }

    public boolean isClientPlayerTurn() {
        return this.currentPlayer == clientPlayer;
    }

    public boolean isClientPlayerPlaysInQuiz() {
        return this.clientPlayerPlaysQuiz;
    }

    public Player getAttackWinner() {
        return this.attackWinner;
    }

    private void sportSelectRequest(boolean bl) {
        this.currentPlayer.selectedSport = null;
        this.setSelectableSports(this.currentPlayer, bl);
        this.currentPlayer.selectable.sortByPosY();
        if (this.currentPlayer instanceof RobotPlayer) {
            ((RobotPlayer)this.currentPlayer).startConquere(1000);
        }
    }

    private void waitForRobotsQA(int n) {
        for (int i = 0; i < this.quizPlayers.size; ++i) {
            if (!(this.quizPlayers.order[i] instanceof RobotPlayer)) continue;
            ((RobotPlayer)this.quizPlayers.order[i]).tick(n);
        }
    }

    private void initQuiz(byte by, int n) {
        int n2;
        for (n2 = 0; n2 < players.length; ++n2) {
            GameSession.players[n2].quizAnswer = -1;
        }
        this.currentQuiz = this.quizMan.getNextQuiz(by, n);
        for (n2 = 0; n2 < this.quizPlayers.size; ++n2) {
            if (!(this.quizPlayers.order[n2] instanceof RobotPlayer)) continue;
            ((RobotPlayer)this.quizPlayers.order[n2]).startQuiz((n2 + 1) * 2000 - 1000);
        }
    }

    public void tick() {
        switch (this.sessionState) {
            case 1: {
                this.initPlayers();
                this.quizPlayers.setArray(players, players.length);
                currentRound = 0;
                this.currentPlayerIndex = 0;
                this.currentPlayer = players[0];
                this.stateHandler.sessionStateUpdated(this.sessionState);
                this.waitForClients(10);
                break;
            }
            case 100: {
                this.displayPList = new PlayerList(players);
                this.displayPList.sortByScore(0);
                this.waitForClients(-1);
                break;
            }
            case 10: 
            case 14: {
                this.currentPlayer = players[this.currentPlayerIndex];
                this.sportSelectRequest(false);
                this.waitForClients(this.sessionState + 1);
                break;
            }
            case 12: {
                this.currentPlayer.setFavSport(this.currentPlayer.selectedSport);
                if (++this.currentPlayerIndex == 3) {
                    this.currentPlayerIndex = 0;
                    currentRound = 1;
                    this.waitForClients(14);
                    break;
                }
                this.waitForClients(10);
                break;
            }
            case 16: {
                this.sportSelectedBy(this.currentPlayer);
                this.waitForClients(17);
                break;
            }
            case 21: {
                if (++this.currentPlayerIndex == 3) {
                    this.currentPlayerIndex = 0;
                    if (currentRound++ == MAX_ROUNDS) {
                        this.setState(33);
                        break;
                    }
                    this.setState(23);
                    break;
                }
                this.setState(14);
                break;
            }
            case 17: 
            case 33: {
                this.quizPlayers.setArray(players, players.length);
                this.clientPlayerPlaysQuiz = true;
                if (this.sessionState == 33) {
                    this.initQuiz((byte)0, 21);
                } else {
                    this.initQuiz((byte)0, this.currentPlayer.selectedSport.id);
                }
                this.waitForClients(this.sessionState + 1);
                break;
            }
            case 19: 
            case 35: {
                this.quizMan.compareTipQuizResults((TipQuiz)this.currentQuiz, this.quizPlayers);
                this.displayPList = new PlayerList(this.quizPlayers);
                if (this.sessionState == 19) {
                    this.waitForClients(20);
                    break;
                }
                this.waitForClients(36);
                break;
            }
            case 20: {
                Player[] playerArray = this.quizPlayers.getArray();
                ++playerArray[0].matchesWon;
                playerArray[0].addScore(currentRound * 100);
                playerArray[1].addScore(currentRound * 50);
                this.waitForClients(21);
                break;
            }
            case 36: {
                Player[] playerArray = this.quizPlayers.getArray();
                ++playerArray[0].matchesWon;
                playerArray[0].addScore(playerArray[0].score);
                playerArray[2].addScore(-(playerArray[2].score >> 1));
                this.waitForClients(100);
                break;
            }
            case 23: {
                this.currentPlayer = players[0];
                for (int i = 0; i < 3; ++i) {
                    if (GameSession.players[i].score >= this.currentPlayer.score) continue;
                    this.currentPlayer = players[i];
                }
                this.setState(24);
                break;
            }
            case 24: {
                if (!(this.currentPlayer instanceof RobotPlayer)) break;
                ((RobotPlayer)this.currentPlayer).doConfirmSelect();
                break;
            }
            case 25: {
                this.waitForClients(this.playerAttackConfirmed ? 26 : 14);
                break;
            }
            case 26: {
                this.sportSelectRequest(true);
                this.quizPlayers.reset();
                this.quizPlayers.add(this.currentPlayer);
                this.waitForClients(27);
                break;
            }
            case 28: {
                this.quizPlayers.add(this.currentPlayer.selectedSport.selectedBy);
                this.currentPlayer.selectedSport.selectedBy.inAttackWith = this.currentPlayer;
                this.currentPlayer.inAttackWith = this.currentPlayer.selectedSport.selectedBy;
                this.waitForClients(29);
                break;
            }
            case 29: {
                this.initQuiz((byte)1, this.currentPlayer.inAttackWith.favSport.id);
                this.clientPlayerPlaysQuiz = this.quizPlayers.hasPlayer(clientPlayer);
                this.waitForClients(30);
                break;
            }
            case 31: {
                this.lastAttackResult = QuizManager.comparePossibilityQuizResults((PossibilityQuiz)this.currentQuiz, this.quizPlayers);
                this.attackWinner = null;
                if (this.lastAttackResult > 0) {
                    this.attackWinner = this.quizPlayers.order[this.lastAttackResult - 1];
                }
                this.waitForClients(32);
                break;
            }
            case 32: {
                if (this.lastAttackResult > 0) {
                    if (this.attackWinner == this.currentPlayer) {
                        this.currentPlayer.addScore(this.currentPlayer.inAttackWith.score / 4);
                        this.currentPlayer.inAttackWith.addScore(-(this.currentPlayer.inAttackWith.score / 4));
                    } else {
                        this.currentPlayer.addScore(-(this.attackWinner.score / 4));
                    }
                } else {
                    this.currentPlayer.addScore(-(this.currentPlayer.inAttackWith.score / 4));
                }
                this.waitForClients(14);
                break;
            }
            case 11: 
            case 15: 
            case 27: {
                if (!(this.currentPlayer instanceof RobotPlayer)) break;
                ((RobotPlayer)this.currentPlayer).tick(this.sessionState);
                break;
            }
            case 18: 
            case 30: 
            case 34: {
                this.waitForRobotsQA(this.sessionState);
            }
        }
    }

    public boolean isWaiting() {
        return this.sessionState == 0;
    }

    protected void waitForClients(int n) {
        this.stateHandler.sessionStateUpdated(this.sessionState);
        this.waitingNextState = n;
        this.setState(0);
    }

    public void resume() {
        if (this.waitingNextState != -1) {
            this.setState(this.waitingNextState);
            this.waitingNextState = -1;
        }
    }

    public void reset() {
        this.clientPlayerPlaysQuiz = false;
        this.nextStateAfterClientInvoke = -1;
        map = null;
        this.displayPList = null;
        clientPlayer = null;
        this.currentPlayer = null;
        this.attackWinner = null;
        System.gc();
        this.sessionState = 1;
    }

    private boolean isConquereLastRound() {
        return currentRound == MAX_ROUNDS - 1;
    }

    private void initPlayers() {
        int n;
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = Math.abs(rand.nextInt()) % players.length;
        for (n = 0; n < ModelControl.countries.length; ++n) {
            if (n == ModelControl.selectedCountry) continue;
            vector.addElement(new Integer(n));
        }
        for (n = 0; n < players.length; ++n) {
            if (n3 == n) {
                clientPlayer = GameSession.players[n] = new Player(ModelControl.playerName);
                GameSession.clientPlayer.countryId = ModelControl.selectedCountry;
                continue;
            }
            Integer n4 = (Integer)vector.elementAt(Math.abs(rand.nextInt() % vector.size()));
            int n5 = n2++;
            RobotPlayer robotPlayer = new RobotPlayer(ModelControl.countries[n4], this);
            this.robots[n5] = robotPlayer;
            GameSession.players[n] = robotPlayer;
            GameSession.players[n].countryId = n4;
            vector.removeElement(n4);
        }
    }

    protected void setSelectableSports(Player player, boolean bl) {
        int n = map.length;
        player.selectable.clear();
        for (int i = 0; i < n; ++i) {
            Sport sport = map[i];
            if (!bl) {
                if (sport.selectedBy != null) continue;
                player.selectable.add(sport);
                continue;
            }
            if (!sport.favSport || sport.selectedBy == player) continue;
            player.selectable.add(sport.clone());
        }
    }

    public int getCurrentPlayerIndex() {
        return this.currentPlayerIndex + 1;
    }

    public boolean isPlayerAttackConfirmed() {
        return this.playerAttackConfirmed;
    }

    static {
        players = new Player[3];
        MAX_ROUNDS = 6;
        currentRound = 1;
        GAMELEVEL_RATES = new short[]{100, 75, 45};
        gameLevel = 0;
        QUIZ_QUESTION_LEVEL = new short[]{70, 80, 95};
    }
}

