/*
 * Decompiled with CFR 0.152.
 */
public class RobotPlayer
extends Player {
    public static final int SPORT_SELECTION_TIMEOUT = 1000;
    public static final int QUIZ_MIN_REPLY_TIME = 2500;
    public static final int CONFIRM_SELECTION_PERCENT = 60;
    private GameSession session;
    private SysTimer timer = new SysTimer();
    private long timeToReply = 0L;
    public int activateTime = -1;
    private Player lastAttacked = null;

    public RobotPlayer(String string, GameSession gameSession) {
        super(string);
        this.session = gameSession;
    }

    public void setReplyDuration(int n) {
        this.timeToReply = n == 0 ? 2500L + (long)Math.abs(GameSession.rand.nextInt()) % (GameSession.USER_RESPONSE_TIME - 2500L) : (long)n;
    }

    public void doConfirmSelect() {
        boolean bl = Math.abs(GameSession.rand.nextInt()) % 100 > 40;
        this.session.confirmSelected(bl);
    }

    public void doSportSelect(int n) {
        int n2 = -1;
        int n3 = 0;
        if (n == 27) {
            if (GameSession.clientPlayer != null) {
                int n4 = this.selectable.get((int)0).selectedBy.score;
                for (n3 = 0; n3 < this.selectable.size; ++n3) {
                    Player player = this.selectable.get((int)n3).selectedBy;
                    if (this.lastAttacked != this.session.currentPlayer) {
                        if (player != GameSession.clientPlayer) continue;
                        n2 = n3;
                        break;
                    }
                    if (player.score <= n4) continue;
                    n4 = player.score;
                    n2 = n3;
                }
            }
        }
        if (n2 == -1) {
            n2 = Math.abs(GameSession.rand.nextInt()) % this.selectable.size();
        }
        if (n2 < 0 || n2 >= this.selectable.size()) {
            n2 = 0;
        }
        this.selectedSport = this.selectable.data[n2];
        if (n == 27 && this.selectedSport.selectedBy != null) {
            this.lastAttacked = this.selectedSport.selectedBy;
            if (this.lastAttacked != GameSession.clientPlayer) {
                ((RobotPlayer)this.lastAttacked).lastAttacked = null;
            }
        }
        this.session.sportSelected();
    }

    private int prepareQuiz() {
        Quiz quiz = this.session.currentQuiz;
        if (quiz instanceof TipQuiz) {
            TipQuiz tipQuiz = (TipQuiz)quiz;
            short s = GameSession.GAMELEVEL_RATES[GameSession.gameLevel];
            int n = tipQuiz.lowerBound * s / 100 + tipQuiz.upperBound * s / 100;
            if (n == 0) {
                n = 2;
            }
            int n2 = Math.abs(GameSession.rand.nextInt()) % n;
            this.quizAnswer = quiz.correctAnswer - tipQuiz.lowerBound * s / 100 + n2;
        } else {
            PossibilityQuiz possibilityQuiz = (PossibilityQuiz)quiz;
            int n = Math.abs(GameSession.rand.nextInt()) % 100;
            int n3 = GameSession.QUIZ_QUESTION_LEVEL[possibilityQuiz.difficulity - 1] * GameSession.GAMELEVEL_RATES[GameSession.gameLevel] / 100;
            this.quizAnswer = n >= n3 ? possibilityQuiz.correctAnswer : (possibilityQuiz.correctAnswer + (n % 3 + 1)) % 4;
        }
        return this.quizAnswer;
    }

    public void startQuiz(int n) {
        this.activateTime = n;
        this.timeToReply = -1L;
        this.timer.reset();
    }

    public void startConquere(int n) {
        this.setReplyDuration(n);
        this.timer.reset();
    }

    public void tick(int n) {
        long l = this.timer.tick();
        switch (n) {
            case 18: 
            case 30: 
            case 34: {
                if (this.timeToReply > -1L) {
                    if (this.isAnswered() || l < this.timeToReply) break;
                    this.setSelectedQuizAnswer(this.prepareQuiz(), this.timeToReply);
                    this.session.quizAnswered(this);
                    break;
                }
                if (l < (long)this.activateTime) break;
                this.setReplyDuration(0);
                break;
            }
            case 11: 
            case 15: 
            case 27: {
                if (l <= this.timeToReply) break;
                this.doSportSelect(n);
            }
        }
    }
}

