/*
 * Decompiled with CFR 0.152.
 */
package tom;

import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import tom.Button;
import tom.PipeCase;
import tom.PipeReplace;
import tom.PipeWater;

class PipeDream
extends Canvas
implements CommandListener,
Runnable {
    int timeFactor;
    static int SZ = 16;
    int nbX;
    int nbY;
    int nbPieces;
    int score;
    int nbSquare;
    int offX;
    int offY;
    Button buttonFast = null;
    PipeCase[] board;
    PipeCase[] tabPipe;
    PipeCase[] waiting;
    PipeCase rien;
    PipeCase PipeEnd;
    PipeWater water = null;
    boolean smallScreen = false;
    static final int stateInit = 0;
    static final int stateGame = 1;
    static final int stateLevelEnd = 2;
    static final int stateGameOver = 3;
    static final int stateLevelEnded = 4;
    int state = 0;
    boolean flgConnected;
    boolean mustClear = true;
    int level;
    int pxStart;
    int pyStart;
    int pxEnd;
    int pyEnd;
    Image SW;
    Image ES;
    Image EW;
    Image EWNS;
    Image NS;
    Image NW;
    Image IPipeStart;
    Image IPipeEnd;
    Image RIEN;
    Image EN;
    Image buff;
    Image intro;
    Graphics g;
    Random r = new Random();
    int width;
    int height;
    int px;
    int py;
    int lastX = -1;
    int lastY;
    int timer = 0;
    boolean doThread = true;
    Command ng;
    Command fast;
    Command goNextLevel;
    MIDlet parent;

    public PipeDream(MIDlet parent) {
        this.parent = parent;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.width > 100 && this.height > 100) {
            SZ = this.width > 200 && this.height > 200 ? 32 : 16;
        } else {
            SZ = 8;
            this.smallScreen = true;
        }
        this.nbX = (this.width - SZ - 5) / SZ;
        this.nbY = (this.height - 20) / SZ;
        System.out.println("nbX:" + this.nbX + " nbY:" + this.nbY + " SZ:" + SZ);
        this.nbPieces = 4;
        this.board = new PipeCase[this.nbX * this.nbY];
        this.buff = Image.createImage((int)(this.nbX * SZ), (int)(this.nbY * SZ));
        this.g = this.buff.getGraphics();
        this.tabPipe = new PipeCase[8];
        this.waiting = new PipeCase[4];
        this.flgConnected = false;
        try {
            String size = Integer.toString(SZ);
            if (size.length() < 2) {
                size = '0' + size;
            }
            String path = "/images/" + size + "/";
            System.out.println(path);
            this.RIEN = Image.createImage((String)(path + "rien.png"));
            this.IPipeStart = Image.createImage((String)(path + "pipestart.png"));
            this.IPipeEnd = Image.createImage((String)(path + "pipeend.png"));
            this.EW = Image.createImage((String)(path + "ew.png"));
            this.NS = Image.createImage((String)(path + "ns.png"));
            this.EN = Image.createImage((String)(path + "en.png"));
            this.ES = Image.createImage((String)(path + "es.png"));
            this.SW = Image.createImage((String)(path + "sw.png"));
            this.NW = Image.createImage((String)(path + "nw.png"));
            this.EWNS = Image.createImage((String)(path + "ewns.png"));
            this.intro = Image.createImage((String)"/images/cmn/FullFlow.png");
            this.rien = new PipeCase(this, 10, this.RIEN);
            this.PipeEnd = new PipeCase(this, 11, this.IPipeEnd);
            this.tabPipe[0] = new PipeCase(this, 0, this.IPipeStart);
            this.tabPipe[1] = new PipeCase(this, 1, this.EW);
            this.tabPipe[2] = new PipeCase(this, 2, this.NS);
            this.tabPipe[3] = new PipeCase(this, 3, this.EN);
            this.tabPipe[4] = new PipeCase(this, 4, this.ES);
            this.tabPipe[5] = new PipeCase(this, 5, this.SW);
            this.tabPipe[6] = new PipeCase(this, 6, this.NW);
            this.tabPipe[7] = new PipeCase(this, 7, this.EWNS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u0423\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0439:" + this.hasPointerEvents());
        this.ng = new Command("\u0412\u044b\u0445\u043e\u0434", 4, 1);
        this.addCommand(this.ng);
        this.fast = new Command("\u041f\u0443\u0441\u043a", 4, 1);
        this.setCommandListener(this);
        this.mustClear = true;
    }

    public void commandAction(Command c, Displayable d) {
        System.out.println("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0439" + c + " " + d);
        if (c == this.ng) {
            this.state = 0;
            this.displayIntro();
        } else if (c == this.fast) {
            this.water.fast = true;
        }
    }

    void displayIntro() {
        Alert go = new Alert("\u041c\u0435\u0447\u0442\u0430 \u0412\u043e\u0434\u043e\u043f\u0440\u043e\u0432\u043e\u0434\u0447\u0438\u043a\u0430", "\u041f\u0435\u0440\u0435\u0432\u0451\u043b MrRap\n\u0410\u0432\u0442\u043e\u0440\u044b\ntomsoft@visualbeans.com\nhttp://www.visualbeans.com\n", this.intro, AlertType.INFO);
        go.setTimeout(-2);
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)go);
        this.newGame();
    }

    public void displayPieces(Graphics g) {
        int j = 0;
        while (j < this.waiting.length) {
            if (this.waiting[j] != null) {
                g.setColor(0, 0, 0);
                g.drawRect(this.width - SZ - 2, (this.waiting.length - j) * (SZ + 2) - 1, SZ + 1, SZ + 1);
                if (this.waiting[j].bmp != null) {
                    g.drawImage(this.waiting[j].bmp, this.width - SZ - 1, (this.waiting.length - j) * (SZ + 2), 20);
                }
            }
            ++j;
        }
    }

    public void doUpdatePieces() {
        this.repaint(0, this.height - 15, 20, 15);
    }

    public void drawBordRect(Graphics g, int x, int y, int w, int h) {
        g.setColor(255, 255, 255);
        g.fillRect(x, y, w, h);
        g.setColor(0, 0, 0);
        g.drawRect(x, y, w, h);
    }

    public void drawCase(int i, int j) {
        PipeCase pipecase = this.getCase(i, j);
        this.repaintCase(i * SZ, j * SZ, pipecase, this.g);
    }

    public void dropPiece(int inpx, int inpy) {
        if (inpx >= 0 && inpy >= 0 && inpx < this.nbX && inpy < this.nbY) {
            PipeCase pipecase = this.getCase(inpx, inpy);
            PipeCase pipecase1 = this.waiting[0].getClone();
            if (pipecase.isModifiable()) {
                this.setCase(inpx, inpy, pipecase1);
                this.drawCase(inpx, inpy);
                this.newPiece();
            } else if (pipecase.dontHaveWater) {
                PipeReplace pipereplace = new PipeReplace(inpx, inpy, pipecase1, this);
                pipereplace.start();
                this.newPiece();
            }
            this.repaint(inpx, inpy);
        }
    }

    public void doEnd() {
        this.flgConnected = true;
        this.gameOver();
    }

    public void gameOver() {
        this.doThread = false;
        this.water.flgEnd = true;
        this.removeCommand(this.fast);
        if (this.flgConnected || this.nbPieces == 0) {
            Alert go = new Alert("\u041a\u043e\u043d\u0435\u0446 \u0443\u0440\u043e\u0432\u043d\u044f", "\u041c\u043e\u043b\u043e\u0434\u0435\u0446! \n \u041a \u043d\u043e\u0432\u043e\u043c\u0443 \u0443\u0440\u043e\u0432\u043d\u044e" + (this.level + 1), null, AlertType.INFO);
            go.setTimeout(-2);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)go);
            this.nextLevel();
            this.mustClear = true;
        } else {
            this.state = 3;
            Alert go = new Alert("\u041a\u043e\u043d\u0435\u0446 \u0418\u0433\u0440\u044b", "\u041f\u0440\u043e\u0441\u0442\u0438\u0442\u0435,\u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0439\u0434\u0438\u0442\u0435 \u0438\u0437 \u0438\u0433\u0440\u044b.", null, AlertType.INFO);
            go.setTimeout(-2);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)go);
            this.state = 0;
            this.mustClear = true;
            this.displayIntro();
        }
    }

    public PipeCase getCase(int i, int j) {
        PipeCase pipecase = null;
        if (i >= 0 && j >= 0 && i < this.nbX && j < this.nbY) {
            pipecase = this.board[i + j * this.nbX];
        }
        return pipecase;
    }

    public void keyPressed(int Key) {
        int gameKey = this.getGameAction(Key);
        switch (this.state) {
            case 0: {
                this.newGame();
                break;
            }
            case 1: {
                this.repaint(this.px, this.py);
                if (gameKey != 0) {
                    switch (gameKey) {
                        case 2: {
                            if (this.px <= 0) break;
                            --this.px;
                            break;
                        }
                        case 5: {
                            if (this.px >= this.nbX - 1) break;
                            ++this.px;
                            break;
                        }
                        case 6: {
                            if (this.py >= this.nbY - 1) break;
                            ++this.py;
                            break;
                        }
                        case 1: {
                            if (this.py <= 0) break;
                            --this.py;
                            break;
                        }
                        case 8: {
                            this.dropPiece(this.px, this.py);
                        }
                    }
                } else {
                    switch (Key) {
                        case 53: {
                            this.dropPiece(this.px, this.py);
                        }
                    }
                }
                this.repaint(this.px, this.py);
                break;
            }
            case 2: {
                this.nextLevel();
                break;
            }
            case 3: {
                this.newGame();
            }
        }
    }

    public void newGame() {
        this.state = 1;
        if (this.water != null) {
            this.water.flgEnd = true;
            this.water = null;
        }
        this.level = 0;
        this.score = 0;
        this.nextLevel();
        this.mustClear = true;
    }

    public void newPiece() {
        int i = 0;
        while (i < this.waiting.length - 1) {
            this.waiting[i] = this.waiting[i + 1];
            ++i;
        }
        int l = 1 + Math.abs(this.r.nextInt()) % 7;
        this.waiting[this.waiting.length - 1] = this.tabPipe[l];
        int j = 0;
        while (j < this.waiting.length) {
            if (this.waiting[j] != null && this.waiting[j].bmp != null) {
                int py = (this.waiting.length - j) * (SZ + 2);
                this.g.drawImage(this.waiting[j].bmp, this.width - SZ - 1, py, 20);
                this.repaint(this.width - SZ - 1, py, SZ, SZ);
            }
            ++j;
        }
    }

    public void nextLevel() {
        this.timer = 0;
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 0, this.buff.getWidth(), this.buff.getHeight());
        this.flgConnected = false;
        this.state = 1;
        ++this.level;
        this.nbPieces = this.level + 9;
        int i = 0;
        while (i < this.nbY) {
            int j = 0;
            while (j < this.nbX) {
                this.setCase(j, i, this.rien);
                this.drawCase(j, i);
                ++j;
            }
            ++i;
        }
        PipeCase pipecase = this.tabPipe[0].getClone();
        int k = Math.abs(this.r.nextInt()) % (this.nbX - 1);
        int l = Math.abs(this.r.nextInt()) % (this.nbY - 1);
        this.px = k;
        this.py = l;
        this.newPiece();
        this.newPiece();
        this.newPiece();
        this.newPiece();
        this.setCase(k, l, pipecase);
        this.repaint(k, l);
        boolean isOk = false;
        do {
            this.pxEnd = 1 + Math.abs(this.r.nextInt()) % (this.nbX - 2);
            this.pyEnd = Math.abs(this.r.nextInt()) % (this.nbY - 1);
            System.out.println("\u041a\u043e\u043d\u0435\u0446:" + this.pxEnd + " " + this.pyEnd);
            if (this.pxEnd == k || this.pyEnd == l) {
                isOk = false;
                continue;
            }
            isOk = true;
            this.setCase(this.pxEnd, this.pyEnd, this.PipeEnd);
            this.drawCase(this.pxEnd, this.pyEnd);
            this.repaint(this.pxEnd, this.pyEnd);
        } while (!isOk);
        this.water = new PipeWater(k, l, this, pipecase);
        this.water.dirX = 1;
        this.water.dirY = 0;
        this.water.start();
        this.addCommand(this.fast);
    }

    public void paint(Graphics g) {
        if (this.mustClear) {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(0, 0, 0);
            this.mustClear = false;
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.timer < 100) {
                    g.drawString("\u0423\u0440\u043e\u0432\u0435\u043d\u044c:" + this.level, 50 - this.timer, 20, 20);
                }
                g.drawImage(this.buff, this.offX, this.offY, 20);
                if (this.timer % 2 == 0) {
                    g.setColor(0, 0, 0);
                    g.drawRect(this.px * SZ, this.py * SZ, SZ, SZ);
                    g.drawRect(this.px * SZ + 1, this.py * SZ + 1, SZ - 2, SZ - 2);
                }
                this.displayPieces(g);
                this.updatePieces(g);
                break;
            }
            case 2: {
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, this.width, this.height);
                g.setColor(0, 0, 0);
                g.drawString("\u041f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u043e" + (this.level + 1), 0, 35, 20);
                break;
            }
            case 3: {
                if (this.smallScreen) {
                    g.setColor(255, 255, 255);
                    g.fillRect(0, 0, this.width, this.height);
                    g.setColor(0, 0, 0);
                    g.drawString("\u041a\u043e\u043d\u0435\u0446 \u0418\u0433\u0440\u044b", 0, 5, 20);
                    break;
                }
                g.setColor(255, 255, 255);
                g.fillRect(10, 30, 100, 50);
                g.setColor(0, 0, 0);
                g.drawString("\u041a\u043e\u043d\u0435\u0446 \u0418\u0433\u0440\u044b", 25, 35, 20);
                break;
            }
        }
    }

    public void pointerPressed(int i, int j) {
        System.out.println("pointer Pressed" + i + " " + j);
        int k = (i - this.offY) / SZ;
        int l = (j - this.offX) / SZ;
        switch (this.state) {
            case 0: {
                this.nextLevel();
                this.repaint();
                break;
            }
            case 2: {
                this.nextLevel();
                this.repaint();
                break;
            }
            case 3: {
                this.newGame();
                break;
            }
            case 1: {
                if (this.buttonFast != null && this.buttonFast.isPressed(i, j)) {
                    this.water.fast = true;
                }
                this.repaint(this.px, this.py);
                this.px = k;
                this.py = l;
                this.dropPiece(this.px, this.py);
                this.repaint(this.px, this.py);
            }
        }
    }

    public void repaint(int i, int j) {
        this.repaint(i * SZ, j * SZ, SZ, SZ);
    }

    public void repaintCase(int i, int j, PipeCase pipecase, Graphics g) {
        g.setClip(i, j, SZ, SZ);
        g.drawImage(pipecase.bmp, i, j, 20);
        g.setClip(0, 0, this.width, this.height);
        this.repaint(i, j, SZ, SZ);
    }

    public void run() {
        System.out.println("\u0412\u043e\u0434\u0430 \u043f\u043e\u0442\u0435\u043a\u043b\u0430...");
        while (this.doThread) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                this.repaint(this.px, this.py);
                ++this.timer;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCase(int i, int j, PipeCase pipecase) {
        this.board[i + j * this.nbX] = pipecase;
    }

    public void updatePieces(Graphics g) {
        Font f = g.getFont();
        int i = 1 + f.stringWidth("\u041b\u0435\u0432\u043e:");
        int heightf = f.getHeight();
        g.setColor(255, 255, 255);
        g.fillRect(i, this.height - heightf - 1, this.width, heightf);
        g.setColor(0, 0, 0);
        String levelS = "\u0423\u0440\u043e\u0432\u0435\u043d\u044c:" + String.valueOf(this.level);
        g.drawString(levelS, 1, this.height - heightf - 1, 20);
        String scoreS = "\u0421\u0447\u0451\u0442:" + String.valueOf(this.score);
        g.drawString(scoreS, 20 + f.stringWidth(levelS), this.height - heightf - 1, 20);
        this.repaint(i, this.height - heightf - 1, this.width, heightf);
    }
}

