/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordManager {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(byte[] object, String object2) {
        if (object == null) {
            return;
        }
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)object2, (boolean)true);
            recordStore.setRecord(1, object, 0, ((byte[])object).length);
            recordStore.closeRecordStore();
            return;
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            try {
                recordStore = RecordStore.openRecordStore((String)object2, (boolean)true);
                recordStore.addRecord(object, 0, ((byte[])object).length);
                recordStore.closeRecordStore();
            }
            catch (RecordStoreFullException recordStoreFullException) {
                try {
                    throw new RecordStoreException("RecordStore full trying to save " + (String)object2 + "\n\n" + recordStoreFullException.toString());
                    catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                        throw new RecordStoreException("RecordStore not found trying to save " + (String)object2 + "\n\n" + recordStoreNotFoundException.toString());
                    }
                    catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                        throw new RecordStoreException("RecordStore not open trying to save " + (String)object2 + "\n\n" + recordStoreNotOpenException.toString());
                    }
                }
                catch (Throwable throwable) {
                    try {
                        recordStore.closeRecordStore();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        object2 = exception;
                        exception.printStackTrace();
                    }
                    throw throwable;
                }
            }
            try {
                recordStore.closeRecordStore();
                return;
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
                return;
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            throw new RecordStoreException("RecordStore full trying to update " + (String)object2 + "\n\n" + recordStoreFullException.toString());
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            throw new RecordStoreException("RecordStore not found trying to update " + (String)object2 + "\n\n" + recordStoreNotFoundException.toString());
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            throw new RecordStoreException("RecordStore not open trying to update " + (String)object2 + "\n\n" + recordStoreNotOpenException.toString());
        }
    }

    public static void save(int n, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(n);
            RecordManager.save(byteArrayOutputStream.toByteArray(), string);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            RecordStoreException recordStoreException2 = recordStoreException;
            throw recordStoreException;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }

    public static void save(long l, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            RecordManager.save(byteArrayOutputStream.toByteArray(), string);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            RecordStoreException recordStoreException2 = recordStoreException;
            throw recordStoreException;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }

    public static void save(String object, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF((String)object);
            RecordManager.save(byteArrayOutputStream.toByteArray(), string);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            object = recordStoreException;
            throw recordStoreException;
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
    }

    public static void save(boolean bl, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBoolean(bl);
            RecordManager.save(byteArrayOutputStream.toByteArray(), string);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            RecordStoreException recordStoreException2 = recordStoreException;
            throw recordStoreException;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
    }

    public static byte[] load(String string) {
        byte[] byArray = null;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byArray = recordStore.getRecord(1);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException2) {
                RecordStoreException recordStoreException3 = recordStoreException2;
                throw recordStoreException2;
            }
            throw recordStoreException;
        }
        return byArray;
    }

    public static void delete(String object) {
        try {
            RecordStore.deleteRecordStore((String)object);
            return;
        }
        catch (RecordStoreException recordStoreException) {
            object = recordStoreException;
            throw recordStoreException;
        }
    }

    public static boolean exists(String string) {
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int byteArrayToInt(byte[] object) {
        int n;
        if (object == null) {
            return 0;
        }
        if (((byte[])object).length < 4) {
            return 0;
        }
        object = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            n = ((DataInputStream)object).readInt();
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        return n;
    }

    public static long byteArrayToLong(byte[] object) {
        long l;
        if (object == null) {
            return 0L;
        }
        object = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            l = ((DataInputStream)object).readLong();
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        return l;
    }

    public static String byteArrayToString(byte[] object) {
        if (object == null) {
            return "";
        }
        object = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            object = ((DataInputStream)object).readUTF();
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        return object;
    }

    public static boolean byteArrayToBoolean(byte[] object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        object = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            bl = ((DataInputStream)object).readBoolean();
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        return bl;
    }
}

