/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
implements Runnable {
    private final byte LOGO;
    private final byte SPLASH;
    public final byte MENU = (byte)2;
    private final byte SETTINGS = (byte)3;
    private final byte HELP = (byte)4;
    private final byte ABOUT = (byte)5;
    private String status = "Loading...";
    public MPMidlet midlet;
    Font gameFont = Font.getFont((int)64, (int)1, (int)8);
    Font smallFont = Font.getFont((int)64, (int)0, (int)8);
    int fontHeight = this.gameFont.getHeight();
    public boolean isContinue = false;
    public int MODE = 0;
    public Thread menuThread;
    public Image button;
    public Image menuStr;
    public Image logo;
    public Image splash;
    public int gameWidth = 640;
    public int gameHeight = 360;
    public int tx;
    public int ty;
    public byte selectIndex = 0;
    public byte selectIndex1 = 0;
    public byte noOfItem = 0;
    public int originY;
    public String[] menuString;
    Image[] imgMenuText;
    Image[] imgMenuTitle;
    Image imgMenuChar;
    Image imgBg;
    Image imgHelpTxt;
    Image[] imgArrow;
    boolean isPressed = false;
    MainCanvas canvas;
    boolean isPaused = false;
    int y_gap = 55;
    int startY;
    int dragY;

    public MainMenu(MPMidlet midlet, MainCanvas mainCanvas, boolean hasContinue) {
        this.LOGO = 0;
        this.SPLASH = 1;
        this.midlet = midlet;
        this.isContinue = hasContinue;
        this.canvas = mainCanvas;
        this.reset((byte)0);
        try {
            this.logo = Image.createImage((String)"/logo.png");
            this.splash = Image.createImage((String)"/splash.png");
            this.imgMenuText = new Image[20];
            this.imgMenuText[0] = Image.createImage((String)"/continue_n.png");
            this.imgMenuText[1] = Image.createImage((String)"/continue_h.png");
            this.imgMenuText[2] = Image.createImage((String)"/newgame_n.png");
            this.imgMenuText[3] = Image.createImage((String)"/newgame_h.png");
            this.imgMenuText[4] = Image.createImage((String)"/options_n.png");
            this.imgMenuText[5] = Image.createImage((String)"/options_h.png");
            this.imgMenuText[6] = Image.createImage((String)"/help_n.png");
            this.imgMenuText[7] = Image.createImage((String)"/help_h.png");
            this.imgMenuText[8] = Image.createImage((String)"/about_n.png");
            this.imgMenuText[9] = Image.createImage((String)"/about_h.png");
            this.imgMenuText[10] = Image.createImage((String)"/exit_n.png");
            this.imgMenuText[11] = Image.createImage((String)"/exit_h.png");
            this.imgMenuText[12] = Image.createImage((String)"/soundoff_n.png");
            this.imgMenuText[13] = Image.createImage((String)"/soundoff_h.png");
            this.imgMenuText[14] = Image.createImage((String)"/soundon_n.png");
            this.imgMenuText[15] = Image.createImage((String)"/soundon_h.png");
            this.imgMenuText[16] = Image.createImage((String)"/viboff_n.png");
            this.imgMenuText[17] = Image.createImage((String)"/viboff_h.png");
            this.imgMenuText[18] = Image.createImage((String)"/vibon_n.png");
            this.imgMenuText[19] = Image.createImage((String)"/vibon_h.png");
            this.imgHelpTxt = Image.createImage((String)"/helptext.png");
            this.imgMenuTitle = new Image[4];
            this.imgMenuTitle[0] = Image.createImage((String)"/option_title.png");
            this.imgMenuTitle[1] = Image.createImage((String)"/help_title.png");
            this.imgMenuTitle[2] = Image.createImage((String)"/about_title.png");
            this.imgMenuTitle[3] = Image.createImage((String)"/menu_title.png");
            this.imgMenuChar = Image.createImage((String)"/menu_char.png");
            this.imgArrow = new Image[1];
            this.imgArrow[0] = Image.createImage((String)"/arrow.png");
        }
        catch (Exception e) {
            System.out.println("Error in image loading");
        }
        this.tx = this.canvas.getWidth() - this.gameWidth >> 1;
        this.ty = this.canvas.getHeight() - this.gameHeight >> 1;
        this.menuThread = new Thread(this);
        this.menuThread.start();
    }

    public void sizeChanged(int w, int h) {
        this.tx = w - this.gameWidth >> 1;
        this.ty = h - this.gameHeight >> 1;
    }

    synchronized void loadImage() {
        this.canvas.game = this.midlet.canvas = new MPCanvas(this.midlet, this.canvas);
        this.status = "Press any key";
    }

    public void showNotify() {
        this.isPaused = false;
    }

    public void hideNotify() {
        this.isPaused = true;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.menuThread) {
            try {
                if (this.isPaused) continue;
                long startTime = System.currentTimeMillis();
                if (this.MODE == 0) {
                    this.selectIndex = (byte)(this.selectIndex + 1);
                    if (this.selectIndex > 25) {
                        this.reset((byte)1);
                        this.selectIndex = 0;
                    }
                } else if (this.MODE == 1) {
                    this.selectIndex = (byte)(this.selectIndex + 1);
                    if (this.selectIndex == 4) {
                        this.loadImage();
                    } else if (this.selectIndex > 20) {
                        this.reset((byte)2);
                        this.selectIndex = 0;
                    }
                }
                this.canvas.repaint();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken >= 100L) continue;
                Thread.sleep(100L - timeTaken);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void reset(byte mode) {
        this.MODE = mode;
        switch (mode) {
            case 1: {
                this.selectIndex = 0;
                this.logo = null;
                return;
            }
            case 0: {
                this.selectIndex = 0;
                return;
            }
            case 2: {
                if (this.splash != null) {
                    this.splash = null;
                }
                try {
                    this.imgBg = Image.createImage((String)"/menubg.jpg");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.isContinue) {
                    this.noOfItem = (byte)6;
                    this.originY = this.gameHeight - 150 >> 1;
                } else {
                    this.noOfItem = (byte)5;
                    this.originY = this.gameHeight - 125 >> 1;
                }
                this.menuString = new String[2];
                this.menuString[0] = "Ok";
                this.menuString[1] = "Exit";
                break;
            }
            case 3: {
                this.noOfItem = (byte)2;
                this.selectIndex1 = 0;
                this.menuString = new String[7];
                this.menuString[0] = "Sound";
                this.menuString[1] = "Vibration";
                this.menuString[2] = "SETTINGS";
                this.menuString[4] = "On";
                this.menuString[5] = "Off";
                this.menuString[6] = "Back";
                break;
            }
            case 4: {
                this.menuString = new String[6];
                this.originY = this.gameHeight - 160 >> 1;
                this.menuString[5] = "Back";
                break;
            }
            case 5: {
                this.menuString = new String[7];
                this.menuString[1] = "Developed by";
                this.menuString[2] = "Nextwave Multimedia";
                this.menuString[3] = "Help and Support";
                this.menuString[4] = "www.nextwavemultimedia.com";
                this.menuString[6] = "Back";
                try {
                    this.logo = null;
                    this.logo = Image.createImage((String)"/abouttxt.png");
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (this.MODE == 0) {
            this.reset((byte)1);
            return;
        }
        if (this.MODE == 1 && this.selectIndex > 5) {
            this.reset((byte)2);
            this.selectIndex = 0;
            return;
        }
        switch (keyCode) {
            case -1: 
            case 1: 
            case 50: {
                if (this.MODE == 2) {
                    this.selectIndex = (byte)((this.selectIndex - 1 + this.noOfItem) % this.noOfItem);
                    break;
                }
                if (this.MODE != 3) break;
                this.selectIndex1 = (byte)((this.selectIndex1 - 1 + this.noOfItem) % this.noOfItem);
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                break;
            }
            case -5: 
            case 8: 
            case 53: {
                if (this.MODE == 2) {
                    this.selection();
                    break;
                }
                if (this.MODE != 3) break;
                this.midlet.setting[this.selectIndex1] = (byte)(1 - this.midlet.setting[this.selectIndex1]);
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                if (this.MODE == 2) {
                    this.selectIndex = (byte)((this.selectIndex + 1) % this.noOfItem);
                    break;
                }
                if (this.MODE != 3) break;
                this.selectIndex1 = (byte)((this.selectIndex1 + 1) % this.noOfItem);
                break;
            }
            case -6: {
                if (this.MODE == 2) {
                    this.selection();
                    break;
                }
                if (this.MODE != 3) break;
                this.midlet.setting[this.selectIndex1] = (byte)(1 - this.midlet.setting[this.selectIndex1]);
                break;
            }
            case -7: {
                if (this.MODE == 2) {
                    this.menuThread = null;
                    this.midlet.exit();
                    break;
                }
                if (this.MODE == 3) {
                    this.midlet.setSettings();
                }
                this.reset((byte)2);
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void selection() {
        int selIndex = this.isContinue ? this.selectIndex : this.selectIndex + 1;
        switch (selIndex) {
            case 0: {
                this.midlet.continueGame();
                break;
            }
            case 1: {
                System.gc();
                this.midlet.newGame();
                break;
            }
            case 2: {
                this.midlet.getHighScores();
                this.reset((byte)3);
                break;
            }
            case 3: {
                this.reset((byte)4);
                break;
            }
            case 4: {
                this.reset((byte)5);
                break;
            }
            case 5: {
                this.midlet.exit();
            }
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.gameWidth, this.gameHeight);
        g.translate(this.tx, this.ty);
        g.setClip(0, 0, this.gameWidth, this.gameHeight);
        switch (this.MODE) {
            case 0: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.gameWidth, this.gameHeight);
                g.setClip(0, 0, this.gameWidth, this.gameHeight);
                g.drawImage(this.logo, this.gameWidth >> 1, this.gameHeight >> 1, 1 | 2);
                break;
            }
            case 1: {
                g.drawImage(this.splash, this.gameWidth >> 1, this.gameHeight >> 1, 1 | 2);
                g.setColor(0xFFFFFF);
                g.setFont(this.smallFont);
                break;
            }
            case 2: {
                g.setColor(0x460000);
                g.fillRect(0, 0, this.gameWidth, this.gameHeight);
                g.setFont(this.gameFont);
                g.drawImage(this.imgBg, 0, 0, 20);
                boolean btnY = false;
                for (int i = 0; i < this.noOfItem; ++i) {
                    int index = i + (this.noOfItem == 5 ? (byte)1 : 0);
                    int y = (360 - this.noOfItem * this.y_gap) / 2 + i * this.y_gap + 12;
                    if (i == this.selectIndex && this.isPressed) {
                        g.drawImage(this.imgMenuText[index * 2 + 1], 460, y, 1 | 0x10);
                        continue;
                    }
                    g.drawImage(this.imgMenuText[index * 2], 460, y, 1 | 0x10);
                }
                g.setClip(0, 0, this.gameWidth, this.gameHeight);
                g.setColor(14166570);
                g.setFont(this.smallFont);
                break;
            }
            case 3: {
                g.drawImage(this.imgBg, 0, 0, 20);
                g.drawImage(this.imgMenuTitle[0], 362, 56, 1 | 0x10);
                int y = 140;
                int index = 12 + (this.midlet.setting[0] == 1 ? 2 : 0);
                if (0 == this.selectIndex1 && this.isPressed) {
                    g.drawImage(this.imgMenuText[index + 1], 362, y, 1 | 0x10);
                } else {
                    g.drawImage(this.imgMenuText[index + 0], 362, y, 1 | 0x10);
                }
                y = 200;
                index = 16 + (this.midlet.setting[1] == 1 ? 2 : 0);
                if (1 == this.selectIndex1 && this.isPressed) {
                    g.drawImage(this.imgMenuText[index + 1], 362, y, 1 | 0x10);
                } else {
                    g.drawImage(this.imgMenuText[index + 0], 362, y, 1 | 0x10);
                }
                g.drawImage(this.midlet.imgHome[0 + (this.isPressed && this.selectIndex1 == 2 ? 1 : 0)], 570, 10, 0x10 | 4);
                break;
            }
            case 4: {
                g.drawImage(this.imgBg, 0, 0, 20);
                g.drawImage(this.imgMenuTitle[1], 402, 56, 1 | 0x10);
                g.drawImage(this.midlet.imgHome[0 + (this.isPressed && this.selectIndex == 2 ? 1 : 0)], 570, 10, 0x10 | 4);
                g.setClip(0, 100, this.gameWidth, 205);
                g.drawImage(this.imgHelpTxt, 255, 100 - this.dragY, 0x10 | 4);
                g.setClip(0, 0, this.gameWidth, this.gameHeight);
                if (this.dragY > 0) {
                    g.setClip(425, 310, 12, 15);
                    g.drawImage(this.imgArrow[0], 430, 310, 0x10 | 1);
                }
                if (this.dragY >= 157) break;
                g.setClip(425, 325, 12, 15);
                g.drawImage(this.imgArrow[0], 430, 310, 0x10 | 1);
                break;
            }
            case 5: {
                g.drawImage(this.imgBg, 0, 0, 20);
                g.drawImage(this.imgMenuTitle[2], 402, 56, 1 | 0x10);
                g.drawImage(this.logo, 399, 100, 0x10 | 1);
                g.drawImage(this.midlet.imgHome[0 + (this.isPressed && this.selectIndex == 2 ? 1 : 0)], 570, 10, 0x10 | 4);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        block0 : switch (this.MODE) {
            case 2: {
                for (int i = 0; i < this.noOfItem; ++i) {
                    int y1 = (360 - this.noOfItem * this.y_gap) / 2 + i * this.y_gap;
                    if (!this.hasPoint(x, y, 355, y1, 215, this.y_gap)) continue;
                    this.selectIndex = (byte)i;
                    this.isPressed = true;
                    break block0;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 2; ++i) {
                    int y1 = 120 + 60 * i;
                    if (!this.hasPoint(x, y, 225, y1, 275, 60)) continue;
                    this.selectIndex1 = (byte)i;
                    this.isPressed = true;
                }
            }
            case 4: {
                this.startY = y;
            }
            case 5: {
                if (!this.hasPoint(x, y, 570, 10, 60, 60)) break;
                this.selectIndex = (byte)2;
                this.selectIndex1 = (byte)2;
                this.isPressed = true;
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        block0 : switch (this.MODE) {
            case 2: {
                for (int i = 0; i < this.noOfItem; ++i) {
                    int y1 = (360 - this.noOfItem * this.y_gap) / 2 + i * this.y_gap;
                    if (!this.hasPoint(x, y, 355, y1, 215, this.y_gap)) continue;
                    this.selectIndex = (byte)i;
                    break block0;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 2; ++i) {
                    int y1 = 120 + 60 * i;
                    if (!this.hasPoint(x, y, 225, y1, 275, 60)) continue;
                    this.selectIndex1 = (byte)i;
                    this.isPressed = true;
                }
                break;
            }
            case 4: {
                this.dragY += this.startY - y;
                this.startY = y;
                if (this.dragY > 157) {
                    this.dragY = 157;
                } else if (this.dragY < 0) {
                    this.dragY = 0;
                }
                System.out.println("dragY " + this.dragY);
                break;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        this.isPressed = false;
        block0 : switch (this.MODE) {
            case 2: {
                for (int i = 0; i < this.noOfItem; ++i) {
                    int y1 = (360 - this.noOfItem * this.y_gap) / 2 + i * this.y_gap;
                    if (!this.hasPoint(x, y, 355, y1, 215, this.y_gap)) continue;
                    this.selectIndex = (byte)i;
                    this.selection();
                    break block0;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 2; ++i) {
                    int y1 = 120 + 60 * i;
                    if (!this.hasPoint(x, y, 225, y1, 275, 60)) continue;
                    this.keyPressed(-6);
                }
            }
            case 4: 
            case 5: {
                if (!this.hasPoint(x, y, 570, 10, 60, 60)) break;
                this.keyPressed(-7);
            }
        }
    }

    public boolean hasPoint(int x1, int y1, int x, int y, int w, int h) {
        return x < x1 && x + w > x1 && y < y1 && y + h > y1;
    }
}

