/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte GAME_TYPE = (byte)5;
    final byte CHECK_SAMEPHONE = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgMenuLogo;
    Image imgAboutLogo;
    Image imgOptionHeading;
    Image imgHelpHeading;
    Image imgAboutHeading;
    Image[] imgFont;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    int selectIndex = 1;
    int optionIndex;
    Button buttonSingleP;
    Button buttonMultiP;
    Button buttonNFC;
    Button buttonSamePhone;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.png");
            this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.imgSplash == null) {
            try {
                this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(this.WIDTH - 113 >> 1, 110, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(this.WIDTH - 120 >> 1, 110, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.WIDTH - 157 >> 1, this.butSoundon.y + 40, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.WIDTH - 164 >> 1, this.butSoundon.y + 40, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
        }
        if (this.isContinue) {
            this.butContinue.setXY(this.WIDTH - 165 + (165 - this.butContinue.width >> 1), 22);
            this.butNewGame.setXY(this.WIDTH - 165 + (165 - this.butNewGame.width >> 1), this.butContinue.y + 37);
            this.butOption.setXY(this.WIDTH - 165 + (165 - this.butOption.width >> 1), this.butNewGame.y + 37);
            this.butHelp.setXY(this.WIDTH - 165 + (160 - this.butHelp.width >> 1), this.butOption.y + 37);
            this.butAbout.setXY(this.WIDTH - 165 + (165 - this.butAbout.width >> 1), this.butHelp.y + 37);
            this.butExit.setXY(this.WIDTH - 165 + (165 - this.butExit.width >> 1), this.butAbout.y + 37);
        } else {
            this.butNewGame.setXY(this.WIDTH - 165 + (165 - this.butNewGame.width >> 1), 23);
            this.butOption.setXY(this.WIDTH - 165 + (165 - this.butOption.width >> 1), this.butNewGame.y + 45);
            this.butHelp.setXY(this.WIDTH - 165 + (165 - this.butHelp.width >> 1), this.butOption.y + 45);
            this.butAbout.setXY(this.WIDTH - 165 + (165 - this.butAbout.width >> 1), this.butHelp.y + 45);
            this.butExit.setXY(this.WIDTH - 165 + (165 - this.butExit.width >> 1), this.butAbout.y + 45);
        }
        this.buttonHome = new Button(this.WIDTH - 56, this.HEIGHT - 25, "/res/menu/homeIcon0.png", "/res/menu/homeIcon1.png");
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
    }

    public void resetHelp() {
        block5: {
            if (this.buttonHelpData == null) {
                try {
                    if (this.buttonHelpData != null) break block5;
                    try {
                        this.imgHelpText = Image.createImage((String)"/res/menu/helpText.png");
                        this.imgUpArrow = Image.createImage((String)"/res/menu/upArrow.png");
                        this.imgDownArrow = Image.createImage((String)"/res/menu/downArrow.png");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.buttonHelpData = new Button(this.WIDTH - this.imgHelpText.getWidth() >> 1, 60, this.imgHelpText.getWidth(), 150, -1, -1);
                    this.buttonHelpData.setMovable(true);
                    this.buttonHelpData.nameX = this.buttonHelpData.x;
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                    this.buttonHelpData.name = null;
                    this.buttonHelpData.imgButton = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.buttonHelpData.nameY = this.buttonHelpData.y;
    }

    public void resetAbout() {
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgSplash == null) {
                    try {
                        this.imgSplash = Image.createImage((String)"/res/menu/menuBg.png");
                        this.imgMenuLogo = Image.createImage((String)"/res/menu/menuLogo.png");
                        this.imgOptionHeading = Image.createImage((String)"/res/menu/optionHeading.png");
                        this.imgHelpHeading = Image.createImage((String)"/res/menu/helpHeading.png");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 5: {
                if (this.buttonSingleP != null) break;
                this.buttonSingleP = new Button(this.WIDTH - 330 + 53, 130, "/res/menu/singleplayer0.png", "/res/menu/singleplayer1.png");
                this.buttonMultiP = new Button(this.WIDTH - 330 + 68, 205, "/res/menu/multiplayer0.png", "/res/menu/multiplayer1.png");
                break;
            }
            case 6: {
                if (this.buttonNFC != null) break;
                this.buttonNFC = new Button(this.WIDTH - 330 + 77, this.buttonSingleP.y, "/res/menu/nfc0.png", "/res/menu/nfc1.png");
                this.buttonSamePhone = new Button(this.WIDTH - 330 + 68, this.buttonMultiP.y, "/res/menu/samephone0.png", "/res/menu/samephone1.png");
            }
        }
        this.MENU_MODE = gameMode;
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 3: {
                result = this.buttonHome.isPressed(x, y);
                if (!result) {
                    result = this.buttonHelpData.isPressed(x, y);
                }
                if (result || x <= this.WIDTH - 30 || y <= this.buttonHelpData.y || y >= this.buttonHelpData.y + this.buttonHelpData.height) break;
                this.buttonHelpData.touchY = y;
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 5: {
                result = this.buttonSingleP.isPressed(x, y);
                if (result || (result = this.buttonMultiP.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 6: {
                result = this.buttonNFC.isPressed(x, y);
                if (result || (result = this.buttonSamePhone.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                    this.selection();
                }
                if (result) break;
                result = this.butNewGame.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butOption.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butHelp.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butAbout.isReleased(x, y);
                if (!result) break;
                this.selection();
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (result || !(result = this.buttonHome.isReleased(x, y))) break;
                this.resetMainMenu();
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.MENU_MODE = 1;
                    break;
                }
                this.buttonHelpData.isReleased(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                result = this.buttonSingleP.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = true;
                    this.dc.isSingleHandSet = false;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonMultiP.isReleased(x, y);
                if (result) {
                    this.resetMode(6);
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 6: {
                result = this.buttonNFC.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = false;
                    this.isContinue = false;
                    this.dc.getClass();
                    this.dc.resetBlueToothMode((byte)10);
                    break;
                }
                result = this.buttonSamePhone.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = true;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
            }
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.dc.continueGame();
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                if (!this.dc.checkTurn()) {
                    this.dc.KEY = 0;
                    return;
                }
                this.dc.sendData(0);
                break;
            }
            case 1: {
                this.dc.timeUpCounter = 0;
                this.dc.level = 0;
                this.dc.isSinglePlayer = true;
                this.dc.isSingleHandSet = false;
                this.dc.initGame();
                this.isContinue = true;
                this.dc.KEY = 0;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void input(int KEY) {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                block26: {
                                    if (KEY == this.dc.KEY_LEFT_SOFT) break block26;
                                    if (KEY != 42) break block27;
                                }
                                this.dc.KEY = 0;
                                break block28;
                            }
                            if (KEY == this.dc.KEY_RIGHT_SOFT) break block29;
                            if (KEY != 35) break block30;
                        }
                        switch (this.MENU_MODE) {
                            case 2: 
                            case 3: 
                            case 4: {
                                this.resetMainMenu();
                                break;
                            }
                        }
                        break block28;
                    }
                    if (KEY == 49) break block28;
                    if (KEY != 50) break block31;
                    switch (this.MENU_MODE) {
                        case 1: {
                            if (this.isContinue) {
                                this.selectIndex = (this.selectIndex + 5) % 6;
                                break;
                            }
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = 5;
                                break;
                            }
                            if (this.selectIndex != 6) break;
                            this.selectIndex = 5;
                            break;
                        }
                        case 2: {
                            this.optionIndex = Math.abs((this.optionIndex - 1) % 2);
                            break;
                        }
                        case 3: {
                            this.buttonHelpData.nameY += 15;
                            if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                                this.buttonHelpData.nameY = this.buttonHelpData.y;
                                break;
                            }
                            if (this.buttonHelpData.nameY >= this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) break;
                            this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
                            break;
                        }
                    }
                    this.dc.KEY = 0;
                    break block28;
                }
                if (KEY != 56) break block32;
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % 6;
                            break;
                        }
                        ++this.selectIndex;
                        if (this.selectIndex == 6) {
                            this.selectIndex = 1;
                            break;
                        }
                        break block28;
                    }
                    case 2: {
                        this.optionIndex = (this.optionIndex + 1) % 2;
                        break;
                    }
                    case 3: {
                        this.buttonHelpData.nameY -= 15;
                        if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                            this.buttonHelpData.nameY = this.buttonHelpData.y;
                            break;
                        }
                        if (this.buttonHelpData.nameY < this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) {
                            this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
                            break;
                        }
                        break block28;
                    }
                }
                break block28;
            }
            if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        if (this.optionIndex != 1) break;
                        this.onoffv = !this.onoffv;
                        break;
                    }
                }
            }
        }
        this.dc.KEY = 0;
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplash = null;
                this.resetMode(1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 8, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 0x10 | 4);
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                switch (this.selectIndex) {
                    case 0: {
                        if (!this.isContinue || this.butContinue.buttonState != 0) break;
                        this.butContinue.buttonState = 1;
                        this.butContinue.paint(g);
                        this.butContinue.buttonState = 0;
                        break;
                    }
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(g);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(g);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(g);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(g);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(g);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgOptionHeading, this.WIDTH - this.imgOptionHeading.getWidth() >> 1, 50, 0x10 | 4);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(g);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(g);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(g);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(g);
                        this.butVibrateoff.buttonState = 0;
                    }
                }
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgHelpHeading, this.WIDTH - this.imgHelpHeading.getWidth() >> 1, 10, 4 | 0x10);
                g.setClip(this.buttonHelpData.x, this.buttonHelpData.y, this.buttonHelpData.width, this.buttonHelpData.height);
                g.drawImage(this.imgHelpText, this.buttonHelpData.nameX, this.buttonHelpData.nameY, 0x10 | 4);
                g.setClip(0, 0, this.WIDTH, this.HEIGHT);
                if (this.buttonHelpData.nameY < this.buttonHelpData.y) {
                    g.drawImage(this.imgUpArrow, this.WIDTH >> 1, this.HEIGHT - 24, 1 | 2);
                }
                if (this.buttonHelpData.nameY + (this.imgHelpText.getHeight() - this.buttonHelpData.height) > this.buttonHelpData.y) {
                    g.drawImage(this.imgDownArrow, this.WIDTH >> 1, this.HEIGHT - 11, 1 | 2);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, this.WIDTH - this.imgAboutLogo.getWidth() >> 1, this.HEIGHT - this.imgAboutLogo.getHeight() >> 1, 4 | 0x10);
                }
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 8, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 0x10 | 4);
                this.buttonSingleP.paint(g);
                this.buttonMultiP.paint(g);
                this.buttonHome.paint(g);
                break;
            }
            case 6: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, 8, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 0x10 | 4);
                this.buttonNFC.paint(g);
                this.buttonSamePhone.paint(g);
                this.buttonHome.paint(g);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.MENU_MODE == 3 && this.buttonHelpData.isMovable && this.buttonHelpData.buttonState == 1) {
            this.buttonHelpData.nameY += y - this.buttonHelpData.touchY;
            this.buttonHelpData.touchY = y;
            if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                this.buttonHelpData.nameY = this.buttonHelpData.y;
            } else if (this.buttonHelpData.nameY < this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) {
                this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
            }
        }
    }
}

