/*
 * Decompiled with CFR 0.152.
 */
package bluetooth1;

import bluetooth1.ClientConnectionHandlerListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.L2CAPConnection;

public class ClientConnectionHandler
implements Runnable {
    private static final int WAIT_MILLIS = 250;
    private final ClientConnectionHandlerListener listener;
    private final Hashtable sendMessages = new Hashtable();
    private L2CAPConnection connection;
    int transmitMTU = 0;
    private volatile boolean aborting;

    public ClientConnectionHandler(L2CAPConnection connection, ClientConnectionHandlerListener listener) {
        this.connection = connection;
        this.listener = listener;
        this.aborting = false;
    }

    ClientConnectionHandlerListener getListener() {
        return this.listener;
    }

    public synchronized void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.aborting) {
            Object object = this;
            synchronized (object) {
                this.aborting = true;
            }
            object = this.sendMessages;
            synchronized (object) {
                this.sendMessages.notify();
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    object = this;
                    synchronized (object) {
                        this.connection = null;
                        this.transmitMTU = 0;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageForSending(Integer id, byte[] data) {
        if (data.length > this.transmitMTU) {
            throw new IllegalArgumentException("Message too long: limit is " + this.transmitMTU + " bytes");
        }
        Hashtable hashtable = this.sendMessages;
        synchronized (hashtable) {
            this.sendMessages.put(id, data);
            this.sendMessages.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.transmitMTU = this.connection.getTransmitMTU();
            Writer writer = new Writer(this);
            Thread writeThread = new Thread(writer);
            writeThread.start();
            this.listener.handleStreamsOpen();
        }
        catch (IOException e) {
            this.close();
            this.listener.handleStreamsOpenError(e.getMessage());
            return;
        }
        while (!this.aborting) {
            boolean ready = false;
            try {
                ready = this.connection.ready();
            }
            catch (IOException e) {
                this.close();
                this.listener.handleClose();
            }
            int length = 0;
            try {
                if (ready) {
                    int mtuLength = this.connection.getReceiveMTU();
                    if (mtuLength <= 0) continue;
                    byte[] buffer = new byte[mtuLength];
                    length = this.connection.receive(buffer);
                    byte[] readData = new byte[length];
                    System.arraycopy(buffer, 0, readData, 0, length);
                    this.listener.handleReceivedMessage(readData);
                    continue;
                }
                try {
                    ClientConnectionHandler mtuLength = this;
                    synchronized (mtuLength) {
                        this.wait(250L);
                    }
                }
                catch (InterruptedException e) {
                }
            }
            catch (IOException e) {
                this.close();
                if (length == 0) {
                    this.listener.handleClose();
                    continue;
                }
                this.listener.handleErrorClose(e.getMessage());
            }
        }
    }

    private class Writer
    implements Runnable {
        private final ClientConnectionHandler handler;

        Writer(ClientConnectionHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ClientConnectionHandler.this.aborting) {
                Enumeration e = ClientConnectionHandler.this.sendMessages.keys();
                if (e.hasMoreElements()) {
                    Integer id = (Integer)e.nextElement();
                    byte[] sendData = (byte[])ClientConnectionHandler.this.sendMessages.get(id);
                    try {
                        ClientConnectionHandler.this.connection.send(sendData);
                        ClientConnectionHandler.this.sendMessages.remove(id);
                        ClientConnectionHandler.this.listener.handleQueuedMessageWasSent(id);
                    }
                    catch (IOException ex) {
                        ClientConnectionHandler.this.close();
                        ClientConnectionHandler.this.listener.handleErrorClose(ex.getMessage());
                    }
                }
                Hashtable hashtable = ClientConnectionHandler.this.sendMessages;
                synchronized (hashtable) {
                    if (ClientConnectionHandler.this.sendMessages.isEmpty()) {
                        try {
                            ClientConnectionHandler.this.sendMessages.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

