/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.DisplayableCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class RaindomWordsMidlet
extends MIDlet {
    public static DisplayableCanvas canvas;
    Display dis;
    int highScore;
    private boolean restoreDiscoverableModeOnExit;
    private int initialDiscoverableMode;

    public RaindomWordsMidlet() {
        try {
            this.restoreDiscoverableModeOnExit = true;
            this.initialDiscoverableMode = LocalDevice.getLocalDevice().getDiscoverable();
        }
        catch (BluetoothStateException e) {
            this.restoreDiscoverableModeOnExit = false;
        }
        canvas = new DisplayableCanvas(this);
        this.dis = Display.getDisplay((MIDlet)this);
        this.getHighScores();
    }

    public void startApp() {
        this.dis.setCurrent((Displayable)canvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void exit() {
        if (RaindomWordsMidlet.canvas.isConnected) {
            canvas.sendData(-1);
            while (RaindomWordsMidlet.canvas.isDataSending) {
            }
            if (this.restoreDiscoverableModeOnExit) {
                try {
                    LocalDevice ld = LocalDevice.getLocalDevice();
                    ld.setDiscoverable(this.initialDiscoverableMode);
                }
                catch (BluetoothStateException e) {
                    System.out.println("Error BluetoothStateException");
                }
            }
        }
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void vibrate() {
        if (RaindomWordsMidlet.canvas.menu.onoffv) {
            try {
                this.dis.vibrate(300);
            }
            catch (Exception e) {
                this.dis.vibrate(300);
            }
        }
    }

    public void getHighScores() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SCORE", (boolean)true);
            if (rs.getNumRecords() == 0) {
                byte[] rec = null;
                ByteArrayOutputStream BA = new ByteArrayOutputStream(60);
                DataOutputStream DOS = new DataOutputStream(BA);
                DOS.writeInt(0);
                DOS.flush();
                DOS.close();
                rec = BA.toByteArray();
                BA.close();
                rs.addRecord(rec, 0, rec.length);
            } else {
                for (int i = rs.getNextRecordID() - 1; i > 0; --i) {
                    byte[] rec = null;
                    rec = rs.getRecord(i);
                    DataInputStream DOS = new DataInputStream(new ByteArrayInputStream(rec, 0, rec.length));
                    this.highScore = DOS.readInt();
                    DOS.close();
                }
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SCORE", (boolean)true);
            byte[] rec = null;
            ByteArrayOutputStream BA = new ByteArrayOutputStream(60);
            DataOutputStream DOS = new DataOutputStream(BA);
            this.highScore = 0;
            DOS.writeInt(0);
            DOS.flush();
            DOS.close();
            rec = BA.toByteArray();
            BA.close();
            rs.setRecord(1, rec, 0, rec.length);
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SCORE", (boolean)true);
            for (int i = 1; i < 6; ++i) {
                byte[] rec = null;
                ByteArrayOutputStream BA = new ByteArrayOutputStream(60);
                DataOutputStream DOS = new DataOutputStream(BA);
                DOS.writeInt(this.highScore);
                DOS.flush();
                DOS.close();
                rec = BA.toByteArray();
                BA.close();
                rs.setRecord(i, rec, 0, rec.length);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

