/*
 * Decompiled with CFR 0.152.
 */
package gamecontrol_view;

import game.GameCanvas;
import gamecontrol_view.GameControl;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.Const;

public class GameView {
    GameCanvas GC;
    GameControl gc;
    int Rect_w = 28;
    int Rect_h = 28;
    int rect_W = 10;
    int rect_H = 10;
    public String[] text;
    int i;
    int j;
    int px;
    int py;
    int k;
    int ct;
    public int length = 0;
    public Image I_1;
    public Image I_2;
    Image grid;
    Image grid1;
    Image grid2;
    Image[] redc;
    Image[] greenc;
    Image[] bluec;
    Image[] redr;
    Image[] bluer;
    Image[] blackc;
    Image[] star;
    Image levelup;
    Image pop;
    Image c0;
    Image c1;
    Image c2;
    Image c3;
    Image plus;
    Image pdg;
    Image time;
    Image arrow;
    Image l1;
    Image l2;
    Image l3;
    Image domain;
    Image L;
    public Image[] score;
    public Image[] s_score;
    public Image[] yellowm;

    public GameView(GameControl gc) {
        this.gc = gc;
    }

    public GameView() {
    }

    public void paint(Graphics g) {
        System.out.println("gamemode =" + this.gc.gameMode);
        g.setClip(0, 0, Const.w, Const.h);
        switch (this.gc.gameMode) {
            case -100: 
            case 0: {
                this.paintGameContent(g);
                this.paintbar(g);
                if (this.gc.gameOver == -1 && this.gc.count >= 5) {
                    g.drawImage(this.I_1, Const.w / 2, Const.h / 2, 3);
                }
                switch (this.gc.gameState) {
                    case -3: {
                        this.paintpause(g);
                        break;
                    }
                    case -2: {
                        this.paintBubMenu(g);
                    }
                }
                break;
            }
            case -22: {
                ++this.gc.gobackTime;
                if (this.gc.gobackTime < 20) break;
                this.gc.goBackBuyMode();
                break;
            }
            case -1: {
                this.paintGameContent(g);
                this.paintbar(g);
            }
        }
    }

    public void paintpause(Graphics g) {
        g.setColor(0);
        g.fillRect(0, Const.h / 2 - 20 + 2, Const.w, 20);
        GameCanvas.w18.drawString(g, "PAUSE", Const.w / 2, Const.h / 2 - 20, 17);
        if (!this.gc.pause) {
            this.gc.pause = true;
        }
    }

    void paintBubMenu(Graphics g) {
        int mx = 5;
        int my = Const.h - 5 - this.gc.ct.mainmenu.length * 16;
        int height = 18;
        int i = 0;
        while (i < this.gc.ct.mainmenu.length) {
            if (i == this.gc.gameCount) {
                g.setColor(6958088);
                g.fillRect(0, my + i * 18 - 4, 100, 18);
                GameCanvas.w18.drawString(g, this.gc.ct.mainmenu[i], mx, my + i * height - 3, 20);
            } else {
                g.setColor(12885351);
                g.fillRect(0, my + i * 18 - 4, 100, 18);
                GameCanvas.y18.drawString(g, this.gc.ct.mainmenu[i], mx, my + i * height - 3, 20);
            }
            ++i;
        }
    }

    void setCanIndex3(Graphics g) {
    }

    void paintbar(Graphics g) {
        if (!(this.gc.gameMode == 0 && this.gc.gameTime >= this.gc.NextLeveScore || this.gc.completeScore >= 500 && this.gc.gameMode == 1)) {
            g.drawImage(this.pdg, 0, Const.h - 2, 36);
            this.paintScore(g, this.s_score, 215, Const.h - 23, this.gc.levelScore, 3, 0, false);
            g.setClip(59, Const.h - 17 - 6, this.gc.gameTime / 4, 8);
            g.drawImage(this.time, 61, Const.h - 17 - 6, 20);
            g.setClip(0, 0, Const.w, Const.h);
            if (this.gc.gameTime <= this.gc.NextLeveScore) {
                g.drawImage(this.domain, 62 + this.gc.gameTime / 4, Const.h - 30, 17);
            } else {
                g.drawImage(this.domain, 158, Const.h - 30, 17);
            }
        }
    }

    void paintGameContent(Graphics g) {
        this.paintMap(g);
        this.px = 5;
        this.py = 55;
        switch (this.gc.startEnd) {
            case 1: {
                switch (this.gc.rdn) {
                    case 1: 
                    case 3: {
                        this.paintColOneByOne(g);
                        break;
                    }
                    case 2: {
                        this.paintRowOneByOne(g);
                    }
                }
                break;
            }
            case 2: {
                this.paintRect(g);
            }
        }
        this.paintStar(g);
        this.paintSelect(g);
        if (this.gc.paintStar && this.gc.s_count > -40) {
            g.drawImage(this.plus, this.gc.sx - 30, this.gc.sy + this.gc.s_count, 20);
            this.paintScore(g, this.score, this.gc.sx, this.gc.sy + this.gc.s_count, this.gc.TempScore, 9, 0, false);
            --this.gc.s_count;
            if (this.gc.s_count == -28) {
                // empty if block
            }
        }
        switch (this.gc.gameMode) {
            case 0: {
                if (this.gc.gameTime < this.gc.NextLeveScore) break;
                this.paintLevelUp(g);
                break;
            }
            case 1: {
                if (this.gc.completeScore < 500) break;
                this.paintLevelUp(g);
            }
        }
        if (this.gc.gameOver == -2) {
            g.drawImage(this.I_1, Const.w / 2, Const.h / 2, 3);
        }
    }

    void paintLevelUp(Graphics g) {
        if (this.gc.s_count > -60) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, Const.w, Const.h);
            g.drawImage(this.levelup, Const.w / 2, Const.h / 2, 3);
            --this.gc.s_count;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void paintColOneByOne(Graphics g) {
        block5: {
            int i;
            block4: {
                i = 0;
                if (!true) break block4;
                this.gc.getClass();
                if (i >= 8) break block5;
            }
            do {
                block7: {
                    int j;
                    block6: {
                        j = 0;
                        if (!true) break block6;
                        this.gc.getClass();
                        if (j >= 8) break block7;
                    }
                    do {
                        if (this.gc.rect[i][j].Vx == 1) {
                            this.RectPaint(g, i, j, 0, 0, 0);
                        }
                        ++j;
                        this.gc.getClass();
                    } while (j < 8);
                }
                ++i;
                this.gc.getClass();
            } while (i < 8);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void paintRowOneByOne(Graphics g) {
        block5: {
            int i;
            block4: {
                i = 0;
                if (!true) break block4;
                this.gc.getClass();
                if (i >= 8) break block5;
            }
            do {
                block7: {
                    int j;
                    block6: {
                        j = 0;
                        if (!true) break block6;
                        this.gc.getClass();
                        if (j >= 8) break block7;
                    }
                    do {
                        if (this.gc.rect[j][i].Vx == 1) {
                            this.RectPaint(g, j, i, 0, 0, 0);
                        }
                        ++j;
                        this.gc.getClass();
                    } while (j < 8);
                }
                ++i;
                this.gc.getClass();
            } while (i < 8);
        }
    }

    public void paintStar(Graphics g) {
        int k = 0;
        while (k < 6) {
            if (this.gc.star[k][2] == 1) {
                g.drawImage(this.star[k], this.gc.star[k][0], this.gc.star[k][1], 20);
            }
            ++k;
        }
    }

    public void paintSelect(Graphics g) {
        block0 : switch (this.gc.sRect.state) {
            case 0: {
                g.drawImage(this.c0, this.px + this.gc.sRect.objx * this.Rect_w - 2, this.py + this.gc.sRect.objy * this.Rect_h, 20);
                break;
            }
            case 1: {
                g.drawImage(this.c1, this.px + this.gc.sRect.objx * this.Rect_w - 2, this.py + this.gc.sRect.objy * this.Rect_h, 20);
                break;
            }
            case 2: 
            case 3: {
                switch (this.gc.direction) {
                    case 1: {
                        g.drawImage(this.c2, this.px + this.gc.sRect.objx * this.Rect_w - 2, this.py + this.gc.sRect.objy * this.Rect_h, 20);
                        break block0;
                    }
                    case 2: {
                        g.drawImage(this.c2, this.px + this.gc.lastx * this.Rect_w - 2, this.py + this.gc.lasty * this.Rect_h, 20);
                        break block0;
                    }
                    case 3: {
                        g.drawImage(this.c3, this.px + this.gc.sRect.objx * this.Rect_w - 2, this.py + this.gc.sRect.objy * this.Rect_h, 20);
                        break block0;
                    }
                    case 4: {
                        g.drawImage(this.c3, this.px + this.gc.lastx * this.Rect_w - 2, this.py + this.gc.lasty * this.Rect_h, 20);
                    }
                }
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void paintRect(Graphics g) {
        block22: {
            boolean selected;
            int oldy;
            int oldx;
            block21: {
                oldx = -1;
                oldy = -1;
                selected = false;
                if (this.gc.direction > 0) {
                    selected = true;
                }
                switch (this.gc.direction) {
                    case 1: {
                        this.RectPaint(g, this.gc.sRect.objx, this.gc.sRect.objy, 0, 0, this.gc.dxy);
                        this.RectPaint(g, this.gc.lastx, this.gc.lasty, 0, 0, -this.gc.dxy);
                        oldx = this.gc.sRect.objx;
                        oldy = this.gc.sRect.objy + 1;
                        break;
                    }
                    case 2: {
                        this.RectPaint(g, this.gc.sRect.objx, this.gc.sRect.objy, 0, 0, -this.gc.dxy);
                        this.RectPaint(g, this.gc.lastx, this.gc.lasty, 0, 0, this.gc.dxy);
                        oldx = this.gc.sRect.objx;
                        oldy = this.gc.sRect.objy - 1;
                        break;
                    }
                    case 3: {
                        this.RectPaint(g, this.gc.sRect.objx, this.gc.sRect.objy, 0, this.gc.dxy, 0);
                        this.RectPaint(g, this.gc.lastx, this.gc.lasty, 0, -this.gc.dxy, 0);
                        oldx = this.gc.sRect.objx + 1;
                        oldy = this.gc.sRect.objy;
                        break;
                    }
                    case 4: {
                        this.RectPaint(g, this.gc.sRect.objx, this.gc.sRect.objy, 0, -this.gc.dxy, 0);
                        this.RectPaint(g, this.gc.lastx, this.gc.lasty, 0, this.gc.dxy, 0);
                        oldx = this.gc.sRect.objx - 1;
                        oldy = this.gc.sRect.objy;
                        break;
                    }
                }
                this.i = 0;
                if (!true) break block21;
                this.gc.getClass();
                if (this.i >= 8) break block22;
            }
            do {
                block24: {
                    block23: {
                        this.j = 0;
                        if (!true) break block23;
                        this.gc.getClass();
                        if (this.j >= 8) break block24;
                    }
                    do {
                        if (!(selected && (this.i == this.gc.sRect.objx && this.j == this.gc.sRect.objy || this.i == oldx && this.j == oldy))) {
                            if (this.gc.rect[this.i][this.j].state == 1) {
                                if (this.gc.rect[this.i][this.j].totalFrame < 3) {
                                    ++this.gc.rect[this.i][this.j].totalFrame;
                                } else {
                                    ++this.gc.rect[this.i][this.j].currentFrame;
                                    this.gc.rect[this.i][this.j].totalFrame &= 0;
                                }
                                if (this.gc.gameMode == 0 && this.i == this.gc.nextRect_l && this.j == this.gc.nextRect_h && this.gc.sRect.state != 1) {
                                    g.drawImage(this.arrow, this.px + this.i * 28 + 14, this.py + this.j * 28 - 20 - this.gc.rect[this.i][this.j].totalFrame, 17);
                                }
                            }
                            switch (this.gc.rect[this.i][this.j].currentFrame) {
                                case 0: {
                                    this.RectPaint(g, this.i, this.j, 0, 0, 0);
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    this.RectPaint(g, this.i, this.j, 1, 0, 0);
                                    break;
                                }
                                case 2: {
                                    this.RectPaint(g, this.i, this.j, 2, 0, 0);
                                    break;
                                }
                                case 4: {
                                    this.gc.rect[this.i][this.j].currentFrame &= 0;
                                    this.RectPaint(g, this.i, this.j, 0, 0, 0);
                                    break;
                                }
                            }
                        }
                        ++this.j;
                        this.gc.getClass();
                    } while (this.j < 8);
                }
                ++this.i;
                this.gc.getClass();
            } while (this.i < 8);
        }
    }

    void RectPaint(Graphics g, int i, int j, int k, int dx, int dy) {
        dx += this.px + i * 28 + 16;
        dy += this.py + j * 28 + 5;
        switch (this.gc.rect[i][j].type) {
            case 1: {
                g.drawImage(this.redc[k], dx, dy, 17);
                break;
            }
            case 2: {
                g.drawImage(this.greenc[k], dx, dy, 17);
                break;
            }
            case 3: {
                if (this.gc.level == 1) {
                    dy += 2;
                }
                g.drawImage(this.bluec[k], dx, dy, 17);
                break;
            }
            case 4: {
                if (this.gc.level == 1) {
                    dy += 2;
                }
                g.drawImage(this.redr[k], dx, dy, 17);
                break;
            }
            case 5: {
                if (this.gc.level == 1) {
                    dy += 2;
                }
                g.drawImage(this.bluer[k], dx, dy, 17);
                break;
            }
            case 6: {
                if (this.gc.level == 3) {
                    dy += 2;
                }
                g.drawImage(this.blackc[k], dx, dy, 17);
                break;
            }
            case 7: {
                g.drawImage(this.yellowm[k], dx, dy, 17);
            }
        }
    }

    public void paintMap(Graphics g) {
        g.drawImage(this.grid, 0, 0, 20);
    }

    public void paintScore(Graphics g, Image[] img, int x, int y, int levelScore, int halfWidth, int dd, boolean needTwo) {
        this.length = 0;
        int sc = levelScore;
        if (sc != 0) {
            while (sc > 0) {
                ++this.length;
                sc /= 10;
            }
            sc = levelScore;
            if (needTwo) {
                g.drawImage(img[0], x -= 3 * dd * halfWidth, y, 17);
                g.drawImage(img[sc], x + 2 * halfWidth, y, 17);
            } else {
                int ten = 10;
                int lg = this.length;
                if (dd == 0) {
                    x += (this.length - 1) * 2 * halfWidth - this.length * halfWidth;
                } else if (dd == -1) {
                    x += (this.length - 1) * 2 * halfWidth - this.length * 2 * halfWidth;
                } else if (dd == 1) {
                    x += (this.length - 1) * 2 * halfWidth;
                }
                while (lg >= 1) {
                    int pNum = sc < 10 ? sc : sc % ten;
                    g.drawImage(img[pNum], x - (this.length - lg) * 2 * halfWidth, y, 20);
                    sc /= ten;
                    --lg;
                }
            }
        } else {
            this.length = 1;
            if (needTwo) {
                int x1 = x;
                if (dd == 0) {
                    x -= 2 * halfWidth;
                } else if (dd == -1) {
                    x1 -= 2 * halfWidth;
                    x -= 4 * halfWidth;
                } else if (dd == 1) {
                    x += 2 * halfWidth;
                }
                g.drawImage(img[0], x1, y, 20);
                g.drawImage(img[0], x, y, 20);
            } else {
                if (dd == 0) {
                    x -= halfWidth;
                } else if (dd == -1) {
                    x += halfWidth;
                } else if (dd == 1) {
                    // empty if block
                }
                g.drawImage(img[0], x, y, 20);
            }
        }
    }

    public void ImageInit() {
        this.levelup = Const.cImage("/cr");
        this.time = Const.cImage("/p/tm");
        this.plus = Const.cImage("/c/+");
        this.pdg = Const.cImage("/p/pbg");
        this.grid = Const.cImage("/gbg");
        this.domain = Const.cImage("/diamond");
        this.L = Const.cImage("/p/L");
        this.star = new Image[6];
        this.i = 0;
        while (this.i < this.star.length) {
            this.star[this.i] = Const.cImage("/s" + this.i);
            ++this.i;
        }
        this.score = new Image[10];
        this.i = 0;
        while (this.i < this.score.length) {
            this.score[this.i] = Const.cImage("/c/" + this.i);
            ++this.i;
        }
        this.s_score = new Image[10];
        this.i = 0;
        while (this.i < this.s_score.length) {
            this.s_score[this.i] = Const.cImage("/p/" + this.i);
            ++this.i;
        }
        this.l1 = Const.cImage("/p/L1");
        this.l2 = Const.cImage("/p/L2");
        this.l3 = Const.cImage("/p/L3");
        this.c0 = Const.cImage("/c0");
        this.c1 = Const.cImage("/c1");
        this.c2 = Const.cImage("/c2");
        this.c3 = Const.cImage("/c3");
        this.arrow = Const.cImage("/a");
    }

    public void releaseImageInit() {
        this.L = null;
        this.domain = null;
        this.grid2 = null;
        this.grid1 = null;
        this.grid = null;
        this.pdg = null;
        this.plus = null;
        this.time = null;
        this.levelup = null;
        this.s_score = null;
        this.score = null;
        this.star = null;
        this.arrow = null;
        this.c3 = null;
        this.c2 = null;
        this.c1 = null;
        this.c0 = null;
    }

    public void levelDomian() {
        System.out.println("levelDomain.." + this.gc.level);
        this.yellowm = null;
        this.blackc = null;
        this.bluer = null;
        this.redr = null;
        this.bluec = null;
        this.greenc = null;
        this.redc = null;
        System.gc();
        this.redc = new Image[3];
        this.i = 0;
        while (this.i < this.redc.length) {
            this.redc[this.i] = Const.cImage("/l" + this.gc.level + "/0" + this.i);
            ++this.i;
        }
        this.greenc = new Image[3];
        this.i = 0;
        while (this.i < this.greenc.length) {
            this.greenc[this.i] = Const.cImage("/l" + this.gc.level + "/1" + this.i);
            ++this.i;
        }
        this.bluec = new Image[3];
        this.i = 0;
        while (this.i < this.bluec.length) {
            this.bluec[this.i] = Const.cImage("/l" + this.gc.level + "/2" + this.i);
            ++this.i;
        }
        this.redr = new Image[3];
        this.i = 0;
        while (this.i < this.redr.length) {
            this.redr[this.i] = Const.cImage("/l" + this.gc.level + "/3" + this.i);
            ++this.i;
        }
        this.bluer = new Image[3];
        this.i = 0;
        while (this.i < this.bluer.length) {
            this.bluer[this.i] = Const.cImage("/l" + this.gc.level + "/4" + this.i);
            ++this.i;
        }
        this.blackc = new Image[3];
        this.i = 0;
        while (this.i < this.blackc.length) {
            this.blackc[this.i] = Const.cImage("/l" + this.gc.level + "/5" + this.i);
            ++this.i;
        }
        this.yellowm = new Image[3];
        this.i = 0;
        while (this.i < this.yellowm.length) {
            this.yellowm[this.i] = Const.cImage("/l" + this.gc.level + "/6" + this.i);
            ++this.i;
        }
    }

    public void createScoreImage() {
        if (this.score == null) {
            this.score = new Image[10];
            this.i = 0;
            while (this.i < this.score.length) {
                this.score[this.i] = Const.cImage("/c/" + this.i);
                ++this.i;
            }
        }
    }

    void SubMenu(int action) {
        if (action == 0) {
            this.gc.ct.setMenu(3);
        } else if (action == 1) {
            this.gc.ct.mainmenu = null;
        }
        System.gc();
    }

    public void GameImageRelease() {
        this.I_1 = null;
        this.I_2 = null;
    }
}

