/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ImageFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.Const;

public class StringPainter {
    int W;
    int H;
    public String[] str;
    static ImageFont myFont;
    String textTitle;
    int currentln = 1;
    int count = 0;
    int startLine = 0;

    public StringPainter(int W, int H) {
        this.W = W;
        this.H = H;
        myFont = new ImageFont();
        ImageFont.initFontPool();
    }

    public static void drawBigString(Graphics g, String str, int x, int y, Image fontImage) {
        ImageFont.drawMenuString(g, str, x, y, Const.FONT_ALIGN_CENTER, 0, fontImage);
    }

    public static void drawSmallString(Graphics g, String str, int x, int y, Image fontImage) {
        ImageFont.drawHelpString(g, str, x, y, Const.FONT_ALIGN_CENTER, fontImage);
    }

    public static void drawLeftString(Graphics g, String str, int x, int y, Image fontImage) {
        ImageFont.drawHelpString(g, str, x += ImageFont.getLength(str, true) / 2, y, Const.FONT_ALIGN_CENTER, fontImage);
    }

    public static void drawRightString(Graphics g, String str, int x, int y, Image fontImage) {
        ImageFont.drawHelpString(g, str, x -= ImageFont.getLength(str, true) / 2, y, Const.FONT_ALIGN_CENTER, fontImage);
    }

    void drawTextPage(Graphics g, int y, int linesOfPage, int rowspacing, Image titleImage, Image textImage) {
        int lth = this.str.length;
        int i = this.startLine;
        while (i < this.startLine + linesOfPage) {
            if (i >= lth) {
                i = 999;
            } else if (this.str[i] != null) {
                StringPainter.drawSmallString(g, this.str[i], this.W / 2, y + (i - this.startLine) * rowspacing, textImage);
            }
            ++i;
        }
    }

    void lineup() {
        if (this.startLine > 0) {
            --this.startLine;
        }
    }

    void linedown() {
        if (this.startLine < this.str.length - 6) {
            ++this.startLine;
        }
    }

    public void drawArrText(Graphics g, int y, int rowspacing, Image textImage) {
        int i = 0;
        while (i < this.str.length) {
            if (this.str[i] != null) {
                StringPainter.drawSmallString(g, this.str[i], this.W / 2, y + i * rowspacing, textImage);
            }
            ++i;
        }
    }

    public void setArrText(String s, int lineWidth) {
        String[] wordArr = StringPainter.split(s, " ");
        this.str = this.setupline(wordArr, lineWidth);
    }

    void drawMoveText(Graphics g, String[] str, int y, int lh, int rowspacing, Image fontImage) {
        g.fillRect(0, y - rowspacing, this.W, lh * rowspacing + rowspacing);
        int lth = str.length;
        int i = 0;
        while (i < lh) {
            if (this.currentln + i >= 0 && this.currentln + i < lth) {
                StringPainter.drawSmallString(g, str[this.currentln + i], this.W / 2, y + i * rowspacing - this.count % rowspacing, fontImage);
            }
            ++i;
        }
        g.fillRect(0, y - rowspacing, this.W, 8);
        g.fillRect(0, y + lh * rowspacing - rowspacing, this.W, rowspacing);
        ++this.count;
        if (this.count % rowspacing == 0) {
            ++this.currentln;
            this.count = 0;
            if (this.currentln == str.length) {
                this.currentln = -lh;
            }
        }
    }

    void setString(String title, String s, int lineWidth) {
    }

    private static String[] split(String original, String regex) {
        int startIndex = 0;
        Vector<String> v = new Vector<String>();
        String[] strArr = null;
        int index = 0;
        startIndex = original.indexOf(regex);
        boolean tempIndex = false;
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            v.addElement(temp);
            index = startIndex + regex.length();
            startIndex = original.indexOf(regex, startIndex + regex.length());
        }
        v.addElement(original.substring(index + 1 - regex.length()));
        strArr = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            strArr[i] = (String)v.elementAt(i);
            ++i;
        }
        return strArr;
    }

    public String[] setupline(String[] StrArr, int length) {
        String[] str = null;
        String tempStr = "";
        String tempLineStr = "";
        Vector<String> lineV = new Vector<String>();
        int i = 0;
        while (i < StrArr.length) {
            tempStr = String.valueOf(tempLineStr) + " " + StrArr[i];
            if (tempStr.length() > length) {
                lineV.addElement(tempLineStr);
                tempStr = StrArr[i];
            }
            tempLineStr = tempStr;
            ++i;
        }
        lineV.addElement(tempStr);
        str = new String[lineV.size() + 1];
        i = 0;
        while (i < lineV.size()) {
            str[i] = (String)lineV.elementAt(i);
            ++i;
        }
        return str;
    }
}

