/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class Cursor
extends Canvas {
    int x = 1;
    int y = 1;
    int w = this.getWidth();
    int h = this.getHeight();
    public boolean[][] curs = new boolean[3][3];

    public Cursor(boolean[][] curs) {
        this.curs = curs;
    }

    public void paint(Graphics g) {
        int i;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(0);
        for (i = 0; i < 4; ++i) {
            g.drawLine(i * this.w / 3, 0, i * this.w / 3, this.h);
        }
        for (int j = 0; j < 4; ++j) {
            g.drawLine(0, j * this.h / 3, this.w, j * this.h / 3);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.curs[i][j]) continue;
                g.setColor(255, 0, 0);
                g.fillRect(i * this.w / 3 + 2, j * this.h / 3 + 2, this.w / 3 - 3, this.h / 3 - 2);
            }
        }
        g.setColor(12, 165, 12);
        g.translate(this.x * this.w / 3 + 1, this.y * this.h / 3 + 1);
        for (i = 0; i <= 5; ++i) {
            g.drawRect(1, 1, this.w / 3 - 4 - i * 2, this.h / 3 - 3 - i * 2);
            g.translate(1, 1);
        }
    }

    public void keyPressed(int kc) {
        boolean b = true;
        int k9 = 57;
        switch (kc) {
            case 49: {
                --this.x;
                --this.y;
                b = false;
                break;
            }
            case 50: {
                --this.y;
                b = false;
                break;
            }
            case 51: {
                ++this.x;
                --this.y;
                b = false;
                break;
            }
            case 52: {
                --this.x;
                b = false;
                break;
            }
            case 53: {
                this.fire();
                b = false;
                break;
            }
            case 54: {
                ++this.x;
                b = false;
                break;
            }
            case 55: {
                --this.x;
                ++this.y;
                b = false;
                break;
            }
            case 56: {
                ++this.y;
                b = false;
                break;
            }
            case 57: {
                ++this.x;
                ++this.y;
                b = false;
            }
        }
        if (b) {
            switch (this.getGameAction(kc)) {
                case 1: {
                    --this.y;
                    break;
                }
                case 6: {
                    ++this.y;
                    break;
                }
                case 2: {
                    --this.x;
                    break;
                }
                case 5: {
                    ++this.x;
                    break;
                }
                case 8: {
                    this.fire();
                }
            }
        }
        if (this.x <= -1) {
            this.x = 2;
        } else if (this.x >= 3) {
            this.x = 0;
        }
        if (this.y <= -1) {
            this.y = 2;
        } else if (this.y >= 3) {
            this.y = 0;
        }
        this.repaint();
    }

    public void pointerReleased(int xp, int yp) {
        this.x = xp / (this.w / 3);
        this.y = yp / (this.h / 3);
        this.fire();
        this.repaint();
    }

    public void fire() {
        this.curs[this.x][this.y] = !this.curs[this.x][this.y];
        this.repaint();
    }
}

