/*
 * Decompiled with CFR 0.152.
 */
public abstract class GameLogic {
    protected int score = 0;
    protected int CurrentScore = 0;
    public boolean active = false;
    protected boolean gameover = false;
    protected boolean gameup = false;
    public static final int INFO_H = 4;
    public static final int INFO_LEN = 16;
    protected final boolean[] info = new boolean[16];
    protected int[] figure_pos;
    protected byte[] figure_elem;
    private int life_max;
    private int life = 0;

    public GameLogic(int figureSize) {
        this.figure_pos = new int[figureSize];
        this.figure_elem = new byte[figureSize];
        this.life_max = 0;
        this.clear();
    }

    public GameLogic(int figureSize, int lifeMax) {
        this.figure_pos = new int[figureSize];
        this.figure_elem = new byte[figureSize];
        this.life_max = lifeMax;
        this.clear();
    }

    protected final void clear() {
        if (!this.gameup) {
            GUtillArray.fill(this.info, false);
            GUtillArray.fill(this.figure_pos, -1);
            GUtillArray.fill(this.figure_elem, (byte)0);
            this.updateLifeInfo();
            this.gameover = false;
            this.gameup = false;
            this.active = false;
            this.score = 0;
            this.CurrentScore = 0;
            this.life = this.life_max;
            this.updateLifeInfo();
        }
    }

    protected void save() throws Exception {
        GUtillIo.writeInt(this.life);
        GUtillIo.writeInt(this.score);
        GUtillIo.writeInt(this.CurrentScore);
        GUtillIo.writeBooleanArray(this.info);
        GUtillIo.writeInt(this.figure_pos.length);
        GUtillIo.writeArray(this.figure_pos);
        GUtillIo.writeArray(this.figure_elem);
    }

    protected void load() throws Exception {
        this.gameover = false;
        this.gameup = false;
        this.active = false;
        this.life = GUtillIo.readInt();
        this.score = GUtillIo.readInt();
        this.CurrentScore = GUtillIo.readInt();
        GUtillIo.readBooleanArray(this.info);
        int len = GUtillIo.readInt();
        this.figure_pos = GUtillIo.readIntArray(len);
        this.figure_elem = GUtillIo.readByteArray(len);
    }

    protected final boolean canUpdate() {
        return !this.gameover && !this.gameup;
    }

    protected final void lifeDecr() {
        if (this.life >= 1) {
            --this.life;
            this.updateLifeInfo();
        }
        if (this.life == 0) {
            this.gameover = true;
        } else {
            this.placePlayer();
        }
    }

    protected abstract void placePlayer();

    public abstract void updateLevel(int var1);

    public abstract void updateState();

    public abstract boolean updateEvent();

    private final void updateLifeInfo() {
        if (this.life_max > 0) {
            for (int i = 1; i <= 4; ++i) {
                this.info[16 - i * 4] = i <= this.life;
            }
        }
    }
}

