/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Board {
    public int TILE_WIDTH = 24;
    public int TILE_HEIGHT = 24;
    public int PLAYER_TILE_WIDTH = 16;
    public static final byte WHITE = 0;
    public static final byte BLACK = 1;
    public static final byte OBSTACLE = 2;
    public static final byte NULL = 3;
    public static final byte QUAKE = 4;
    public static final byte ZAP = 5;
    public static final byte GRAVITY = 6;
    public int nObstacles = 0;
    int zapstonex = -1;
    int zapstoney = -1;
    byte zappedstonecolor = (byte)-1;
    public byte specialEffectDurationCounter = 0;
    public byte[] specialEffectDuration = new byte[]{0, 0, 0, 0, 16, 18, 6};
    public byte specialObstacle = (byte)3;
    public boolean specialDone = false;
    private int[] scores = new int[]{0, 0, 0, 3, 10, 25, 56, 119};
    public byte[][] board;
    protected int possibleMoves = 0;
    private byte computer;
    private byte player;
    private int lastMoveX;
    private int lastMoveY;
    public int[][] last2Moves;
    public int xET;
    public int yET;
    public int ET_BEAM_OFFSET_X = 20;
    public int ET_BEAM_OFFSET_Y = 49;
    public boolean ET_OBDUCTION = false;
    public int quakeToDestroy = 0;
    private Random random;
    private GameCanvas canvas;

    public Board(GameCanvas _canvas, byte _player, byte _computer) {
        this.canvas = _canvas;
        this.board = new byte[7][7];
        this.possibleMoves = 49;
        this.setPlayer(_player);
        this.setComputer(_computer);
        this.random = new Random(System.currentTimeMillis());
    }

    public void undoLast2Moves() {
        this.board[this.last2Moves[0][0]][this.last2Moves[0][1]] = 3;
        this.board[this.last2Moves[1][0]][this.last2Moves[1][1]] = 3;
    }

    public void redoLast2Moves() {
        this.board[this.last2Moves[0][0]][this.last2Moves[0][1]] = 0;
        this.board[this.last2Moves[1][0]][this.last2Moves[1][1]] = 1;
    }

    public void newGame() {
        this.initializeBoard(this.board);
    }

    public byte evalMove(int _x, int _y) {
        byte value = -1;
        byte _player = this.getPlayer();
        byte _computer = this.getComputer();
        if (this.getValue(_x, _y) >= 3) {
            int playerScore = this.getScoreDiff(_x, _y, _player);
            int computerScore = this.getScoreDiff(_x, _y, _computer);
            value = (byte)(playerScore + computerScore);
        }
        return value;
    }

    public byte evalLines(int x, int y, byte player) {
        int tyu;
        int txl;
        byte score = 0;
        byte previousValue = this.getValue(x, y);
        this.setValue(x, y, player);
        int txr = x + 1;
        for (txl = x - 1; txl > 0 && this.getValue(txl, y) == player; --txl) {
        }
        if (txl >= 0 && this.getValue(txl, y) >= 3) {
            while (txr < 6 && this.getValue(txr, y) == player) {
                ++txr;
            }
            if (txr <= 6 && this.getValue(txr, y) >= 3 && txr - txl > 2) {
                score = (byte)(score + this.getScoreDiff(txr, y, player));
            }
        }
        int tyd = y + 1;
        for (tyu = y - 1; tyu > 0 && this.getValue(x, tyu) == player; --tyu) {
        }
        if (tyu >= 0 && this.getValue(x, tyu) >= 3) {
            while (tyd < 6 && this.getValue(x, tyd) == player) {
                ++tyd;
            }
            if (tyd <= 6 && this.getValue(x, tyd) >= 3 && tyd - tyu > 2) {
                score = (byte)(score + this.getScoreDiff(x, tyd, player));
            }
        }
        this.setValue(x, y, previousValue);
        return score;
    }

    public char evalLiberties(int x, int y) {
        char libs = '\u0000';
        if (y > 0 && this.getValue(x, y - 1) >= 3) {
            libs = (char)(libs + 3);
            if (y > 1 && this.getValue(x, y - 2) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (x > 0 && this.getValue(x - 1, y - 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (x < 6 && this.getValue(x + 1, y - 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
        }
        if (y < 6 && this.getValue(x, y + 1) >= 3) {
            libs = (char)(libs + 3);
            if (y < 5 && this.getValue(x, y + 2) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (x > 0 && this.getValue(x - 1, y + 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (x < 6 && this.getValue(x + 1, y + 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
        }
        if (x > 0 && this.getValue(x - 1, y) >= 3) {
            libs = (char)(libs + 3);
            if (x > 1 && this.getValue(x - 2, y) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (y > 0 && this.getValue(x - 1, y - 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (y < 6 && this.getValue(x - 1, y + 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
        }
        if (x < 6 && this.getValue(x + 1, y) >= 3) {
            libs = (char)(libs + 3);
            if (x < 5 && this.getValue(x + 2, y) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (y > 0 && this.getValue(x + 1, y - 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
            if (y < 6 && this.getValue(x + 1, y + 1) >= 3) {
                libs = (char)(libs + '\u0001');
            }
        }
        return libs;
    }

    public byte intersect(int _x, int _y, byte _player) {
        byte inters = 0;
        if (_y > 1 && this.getValue(_x, _y - 1) >= 3 && this.getValue(_x, _y - 2) == _player) {
            inters = (byte)(inters + 1);
        }
        if (_y < 5 && this.getValue(_x, _y + 1) >= 3 && this.getValue(_x, _y + 2) == _player) {
            inters = (byte)(inters + 1);
        }
        if (_x > 1 && this.getValue(_x - 1, _y) >= 3 && this.getValue(_x - 2, _y) == _player) {
            inters = (byte)(inters + 1);
        }
        if (_x < 5 && this.getValue(_x + 1, _y) >= 3 && this.getValue(_x + 2, _y) == _player) {
            inters = (byte)(inters + 1);
        }
        if (_x > 0 && _x < 6 && (this.getValue(_x - 1, _y) == _player && this.getValue(_x + 1, _y) >= 3 || this.getValue(_x - 1, _y) >= 3 && this.getValue(_x + 1, _y) == _player)) {
            inters = (byte)(inters + 2);
        }
        if (_y > 0 && _y < 6 && (this.getValue(_x, _y - 1) == _player && this.getValue(_x, _y + 1) >= 3 || this.getValue(_x, _y - 1) >= 3 && this.getValue(_x, _y + 1) == _player)) {
            inters = (byte)(inters + 2);
        }
        return inters;
    }

    public void createObstacles() {
        this.nObstacles = Math.abs(this.random.nextInt() % 6);
        if (this.nObstacles % 2 == 0) {
            ++this.nObstacles;
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.nObstacles; ++i) {
            while (this.getValue(j = Math.abs(this.random.nextInt() % 7), k = Math.abs(this.random.nextInt() % 7)) != 3) {
            }
            this.board[j][k] = 2;
        }
    }

    private void initializeBoard(byte[][] _board) {
        this.canvas.oldplayerFieldLocationX = 3;
        this.canvas.oldplayerFieldLocationY = 3;
        this.canvas.playerFieldLocationX = 3;
        this.canvas.playerFieldLocationY = 3;
        this.canvas.calculatePlayerLocation();
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                _board[i][j] = 3;
            }
        }
        this.lastMoveX = -1;
        this.lastMoveY = -1;
        this.last2Moves = new int[2][2];
        this.last2Moves[0][0] = -1;
        this.last2Moves[0][1] = -1;
        this.last2Moves[1][0] = -1;
        this.last2Moves[1][1] = -1;
        this.specialDone = false;
    }

    public int getScore(byte player) {
        int score = 0;
        for (int i = 0; i < 7; ++i) {
            score += this.getHorizontalScore(i, player);
        }
        for (int j = 0; j < 7; ++j) {
            score += this.getVerticalScore(j, player);
        }
        return score;
    }

    public int getScoreDiff(int x, int y, byte player) {
        int scorediff = 0;
        byte previousValue = this.getValue(x, y);
        this.board[x][y] = player;
        scorediff += this.getVerticalScore(y, player);
        scorediff += this.getHorizontalScore(x, player);
        this.board[x][y] = previousValue;
        scorediff -= this.getVerticalScore(y, player);
        return scorediff -= this.getHorizontalScore(x, player);
    }

    public int getVerticalScore(int _nColumn, byte player) {
        int noOfStonesInColumn = 0;
        int score = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.board[i][_nColumn] == player) {
                ++noOfStonesInColumn;
                continue;
            }
            score += this.scores[noOfStonesInColumn];
            noOfStonesInColumn = 0;
        }
        score += this.scores[noOfStonesInColumn];
        noOfStonesInColumn = 0;
        return score;
    }

    public int getHorizontalScore(int _nRow, byte player) {
        int noOfStonesInRow = 0;
        int score = 0;
        for (int j = 0; j < 7; ++j) {
            if (this.board[_nRow][j] == player) {
                ++noOfStonesInRow;
                continue;
            }
            score += this.scores[noOfStonesInRow];
            noOfStonesInRow = 0;
        }
        score += this.scores[noOfStonesInRow];
        noOfStonesInRow = 0;
        return score;
    }

    public boolean isMovePossible() {
        this.refreshInternalState();
        return this.possibleMoves > 0;
    }

    public byte[][] getBoard() {
        return this.board;
    }

    public byte getValue(int x, int y) {
        return x > 7 || y > 7 ? (byte)3 : this.board[x][y];
    }

    public byte getPlayer() {
        return this.player;
    }

    public void setPlayer(byte _player) {
        this.player = _player;
    }

    public byte getComputer() {
        return this.computer;
    }

    public void setComputer(byte _computer) {
        this.computer = _computer;
    }

    public void setSpecialObstacle() {
        if (this.specialObstacle == 3) {
            if (this.canvas.getMode() == 7 && !this.specialDone && this.possibleMoves < 49 - this.nObstacles - 10 && (this.possibleMoves > 10 && this.random.nextInt() % (this.possibleMoves - 10) == 0 || this.possibleMoves <= 10)) {
                this.specialDone = true;
                Tournament cfr_ignored_0 = this.canvas.tournament;
                this.specialObstacle = (byte)this.canvas.tournament.TOURNAMENT[this.canvas.tournament.selectedLandIndex][5];
                this.specialEffectDurationCounter = this.specialEffectDuration[this.specialObstacle];
            }
        }
    }

    public void setValue(int x, int y, byte value) {
        this.board[x][y] = value;
        this.lastMoveX = x;
        this.lastMoveY = y;
    }

    public boolean isLastMove(int _x, int _y) {
        return _x == this.lastMoveX && _y == this.lastMoveY;
    }

    public byte getSpecialObstacle() {
        return this.specialObstacle;
    }

    private void refreshInternalState() {
        int tempPossibleMoves = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.board[i][j] < 3) continue;
                ++tempPossibleMoves;
            }
        }
        this.possibleMoves = tempPossibleMoves;
    }

    public void drawPlayer(Graphics _g, byte _playerType, int _x, int _y, int canvasWidth, int canvasHeight, boolean isLastMove) {
        if (_playerType != 3) {
            int clipXPos = _x + 3;
            int clipYPos = _y + 3;
            _g.setClip(clipXPos, clipYPos, this.PLAYER_TILE_WIDTH, this.PLAYER_TILE_WIDTH);
            int tokenImgXPos = clipXPos;
            int tokenImgYPos = clipYPos;
            switch (_playerType) {
                case 1: {
                    break;
                }
                case 0: {
                    tokenImgXPos -= this.PLAYER_TILE_WIDTH;
                    break;
                }
                case 2: {
                    tokenImgXPos -= this.PLAYER_TILE_WIDTH << 1;
                    break;
                }
                default: {
                    tokenImgXPos -= this.PLAYER_TILE_WIDTH << 4;
                }
            }
            _g.drawImage(Resources.images[0], tokenImgXPos, tokenImgYPos, 20);
            if (isLastMove) {
                int starsImgXPos = clipXPos - this.PLAYER_TILE_WIDTH * 1;
                int starsImgYPos = clipYPos - this.PLAYER_TILE_WIDTH;
                _g.drawImage(Resources.images[0], starsImgXPos, starsImgYPos, 20);
            }
            _g.setClip(0, 0, canvasWidth, canvasHeight);
        }
    }

    public void drawET(Graphics _g, int _x, int _y, int canvasWidth, int canvasHeight) {
        if (this.canvas.paintRequested[this.canvas.PREQ_BOARD_ET]) {
            this.canvas.donePaint(this.canvas.PREQ_BOARD_ET);
            _g.setClip(_x, _y, 60, 60);
            _g.drawImage(Resources.images[13], _x, _y, 20);
            _g.setClip(0, 0, canvasWidth, canvasHeight);
        }
    }

    public void drawETBeam(Graphics _g, int _x, int _y, int canvasWidth, int canvasHeight) {
        if (this.canvas.paintRequested[this.canvas.PREQ_BOARD_ETBEAM]) {
            this.canvas.donePaint(this.canvas.PREQ_BOARD_ETBEAM);
            _g.setClip(_x, _y, 17, 18);
            _g.setColor(0xFFFFFF);
            _g.fillRect(_x + 5, _y, 1, 16);
            _g.fillRect(_x + 7, _y, 1, 17);
            _g.fillRect(_x + 9, _y, 1, 17);
            _g.fillRect(_x + 11, _y, 1, 17);
            _g.fillRect(_x + 13, _y, 1, 16);
            _g.fillRect(_x + 3, _y, 1, 15);
            _g.fillRect(_x + 15, _y, 1, 15);
            _g.setClip(0, 0, canvasWidth, canvasHeight);
        }
    }

    public void drawBackground(Graphics _g, int _x, int _y, int _canvasWidth, int _canvasHeight) {
        if (this.canvas.paintRequested[this.canvas.PREQ_BOARD_BACKGROUND]) {
            this.canvas.donePaint(this.canvas.PREQ_BOARD_BACKGROUND);
            _g.setClip(0, 0, _canvasWidth, _canvasHeight);
            _g.drawImage(Resources.images[1], this.canvas.screenXOrigin, this.canvas.screenYOrigin, 20);
        }
    }

    public void drawGameBoard(Graphics _g, int _mode, int _x, int _y, int _canvasWidth, int _canvasHeight) {
        if (this.canvas.paintRequested[this.canvas.PREQ_BOARD_GAMEBOARD]) {
            this.canvas.donePaint(this.canvas.PREQ_BOARD_GAMEBOARD);
            if (_mode == 1 || _mode == 8 || _mode == 7 || _mode == 2 && this.canvas.menu.currentMenu == this.canvas.menu.inGameMenu) {
                for (int j = 0; j < 7; ++j) {
                    for (int i = 0; i < 7; ++i) {
                        if (this.getValue(i, j) > 2 || this.getValue(i, j) == 3) continue;
                        this.drawPlayer(_g, this.getValue(i, j), _x + this.TILE_WIDTH * i, _y + this.TILE_HEIGHT * j, _canvasWidth, _canvasHeight, this.isLastMove(i, j));
                    }
                }
            }
        }
    }

    public int getRandomInt() {
        if (this.random == null) {
            this.random = new Random(System.currentTimeMillis());
        }
        return this.random.nextInt();
    }

    public void updateSpecialEffect() {
        switch (this.specialObstacle) {
            case 4: {
                int j;
                if (this.specialEffectDurationCounter == this.specialEffectDuration[this.specialObstacle]) {
                    Resources.playFile(4);
                    int playerValues = 0;
                    for (int i = 0; i < 7; ++i) {
                        for (j = 0; j < 7; ++j) {
                            if (this.getValue(i, j) < 0 || this.getValue(i, j) > 1) continue;
                            ++playerValues;
                        }
                    }
                    this.quakeToDestroy = playerValues * 30 / 100;
                    if (this.quakeToDestroy % 2 == 1) {
                        ++this.quakeToDestroy;
                    }
                }
                this.specialEffectDurationCounter = (byte)(this.specialEffectDurationCounter - 1);
                int newBoardX = this.getRandomInt() % 4;
                int newBoardY = this.getRandomInt() % 4;
                this.canvas.setXYOrigin(-newBoardX, -newBoardY);
                if (this.quakeToDestroy > 0 && this.specialEffectDurationCounter > this.quakeToDestroy && (this.specialEffectDurationCounter >= this.quakeToDestroy * 2 && this.specialEffectDurationCounter % 2 == 0 || this.specialEffectDurationCounter < this.quakeToDestroy * 2)) {
                    j = 0;
                    int k = 0;
                    while (this.getValue(j = Math.abs(this.random.nextInt() % 7), k = Math.abs(this.random.nextInt() % 7)) != 0) {
                    }
                    this.setValue(j, k, (byte)3);
                    --this.quakeToDestroy;
                    while (this.getValue(j = Math.abs(this.random.nextInt() % 7), k = Math.abs(this.random.nextInt() % 7)) != 1) {
                    }
                    this.setValue(j, k, (byte)3);
                    --this.quakeToDestroy;
                }
                if (this.specialEffectDurationCounter != 0) break;
                this.canvas.setGameScore();
                this.canvas.setXYOrigin(0, 0);
                this.canvas.calculatePlayerLocation();
                this.specialObstacle = (byte)3;
                break;
            }
            case 5: {
                int accel;
                int pathDone;
                if (this.specialEffectDurationCounter == this.specialEffectDuration[5]) {
                    Resources.playFile(5);
                    int stones = 0;
                    int selectstone = Math.abs(this.random.nextInt()) % (49 - (this.possibleMoves + this.nObstacles));
                    this.zapstonex = 0;
                    while (this.zapstonex < 7) {
                        this.zapstoney = 0;
                        while (this.zapstoney < 7) {
                            if (this.getValue(this.zapstonex, this.zapstoney) == 1 || this.getValue(this.zapstonex, this.zapstoney) == 0) {
                                if (stones == selectstone) break;
                                ++stones;
                            }
                            if (stones == selectstone && (this.getValue(this.zapstonex, this.zapstoney) == 1 || this.getValue(this.zapstonex, this.zapstoney) == 0)) break;
                            ++this.zapstoney;
                        }
                        if (stones == selectstone && (this.getValue(this.zapstonex, this.zapstoney) == 1 || this.getValue(this.zapstonex, this.zapstoney) == 0)) break;
                        ++this.zapstonex;
                    }
                }
                this.specialEffectDurationCounter = (byte)(this.specialEffectDurationCounter - 1);
                int animPartLength = this.specialEffectDuration[5] / 3;
                if (this.specialEffectDurationCounter >= animPartLength * 2) {
                    this.zappedstonecolor = this.board[this.zapstonex][this.zapstoney];
                    pathDone = (this.specialEffectDurationCounter - animPartLength * 2) * 100 / animPartLength;
                    accel = 100 - pathDone * pathDone / 100;
                    this.xET = accel * this.TILE_WIDTH * this.zapstonex / 100;
                    this.yET = accel * this.TILE_WIDTH * this.zapstoney / 100;
                    if (this.specialEffectDurationCounter == animPartLength * 2) {
                        Resources.playFile(6);
                    }
                } else if (this.specialEffectDurationCounter >= animPartLength) {
                    this.board[this.zapstonex][this.zapstoney] = 3;
                    this.ET_OBDUCTION = true;
                    if (this.specialEffectDurationCounter == animPartLength) {
                        Resources.playFile(5);
                    }
                } else {
                    this.ET_OBDUCTION = false;
                    this.board[this.zapstonex][this.zapstoney] = 2;
                    pathDone = 100 - this.specialEffectDurationCounter * 100 / animPartLength;
                    accel = 100 - pathDone * pathDone / 100;
                    this.xET = accel * this.TILE_WIDTH * this.zapstonex / 100;
                    this.yET = accel * this.TILE_WIDTH * this.zapstoney / 100;
                }
                if (this.specialEffectDurationCounter != 0) break;
                this.canvas.setGameScore();
                this.specialObstacle = (byte)3;
                break;
            }
            case 6: {
                if (this.specialEffectDurationCounter == this.specialEffectDuration[this.specialObstacle]) {
                    Resources.playFile(0);
                }
                for (int i = 0; i < 7; ++i) {
                    int j;
                    if (this.specialEffectDurationCounter <= 0 || this.getValue(i, this.specialEffectDurationCounter) < 3) continue;
                    for (j = this.specialEffectDurationCounter - 1; j > 0 && this.getValue(i, j) >= 3; --j) {
                    }
                    if (this.getValue(i, j) >= 3) continue;
                    this.setValue(i, this.specialEffectDurationCounter, this.getValue(i, j));
                    this.setValue(i, j, (byte)3);
                }
                this.specialEffectDurationCounter = (byte)(this.specialEffectDurationCounter - 1);
                if (this.specialEffectDurationCounter > 0) break;
                this.canvas.setGameScore();
                this.specialObstacle = (byte)3;
            }
        }
        for (int i = 0; i < this.canvas.PREQ_MAX; ++i) {
            this.canvas.paintRequested[i] = true;
        }
    }
}

