/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.cells.ArrowCell;
import com.ximad.braincube2.cells.BarrierCell;
import com.ximad.braincube2.cells.BossFinishCell;
import com.ximad.braincube2.cells.Cell;
import com.ximad.braincube2.cells.ChangerCell;
import com.ximad.braincube2.cells.ConstantBridgeCell;
import com.ximad.braincube2.cells.ContactCell;
import com.ximad.braincube2.cells.DecorCell;
import com.ximad.braincube2.cells.FinishCell;
import com.ximad.braincube2.cells.IceCell;
import com.ximad.braincube2.cells.NormalCell;
import com.ximad.braincube2.cells.RotatorCell;
import com.ximad.braincube2.cells.StartCell;
import com.ximad.braincube2.cells.SwitchCell;
import com.ximad.braincube2.cells.TempBridgeCell;
import com.ximad.braincube2.cells.WindCell;
import com.ximad.braincube2.cells.WoodCell;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.Battery;
import com.ximad.braincube2.components.Boss;
import com.ximad.braincube2.components.BossMagneto;
import com.ximad.braincube2.components.BossTurbo;
import com.ximad.braincube2.components.Camera;
import com.ximad.braincube2.components.Cube;
import com.ximad.braincube2.components.Cubes;
import com.ximad.braincube2.components.ElectroCell;
import com.ximad.braincube2.components.Hint;
import com.ximad.braincube2.components.NormalCube;
import com.ximad.braincube2.components.ScoresManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.parser.IXMLEvent;
import com.ximad.braincube2.parser.SAXLevelParser;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.utils.Utils;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class Board
implements IXMLEvent {
    private static final int INITIAL_COUNT = 32;
    private static final int DEFAULT_STEP = 16;
    public Cell[][] cells;
    public int dimX;
    public int dimY;
    public int world;
    public int level;
    public int columnCount;
    public int rowCount;
    public int startX;
    public int startY;
    public int minMoves;
    public int hintTime;
    public int[] elements;
    public int[] soundElements;
    private boolean isChanger = false;
    private boolean isBattery;
    private boolean isBoss;
    private Cell currentCell;
    private SwitchCell[] tempBridgeStack = new SwitchCell[32];
    private int tempBridgeStackCount = 0;
    public Battery[] batteryStack = new Battery[32];
    public int batteryStackCount = 0;
    public Hint hints = new Hint();
    public Boss[] bosses = new Boss[32];
    public int bossesCount = 0;
    private Boss currentBoss;
    private Cubes cubes = Cubes.getInstance();
    public int numOfMove;
    public int numOfBatteries;
    private boolean isCellBlocked = false;
    private Cell[] tempCells;
    private int tempCellsCount;
    private static Board _instance;
    private int[] achievementCounter;
    private Cell lastArrowUsed;

    public static Board getInstance() {
        if (_instance == null) {
            _instance = new Board();
        }
        return _instance;
    }

    public Board() {
        int i;
        this.elements = new int[17];
        for (i = 0; i < 17; ++i) {
            this.elements[i] = 0;
        }
        this.soundElements = new int[SoundSystem.NUM_OF_SOUNDS];
        for (i = 0; i < SoundSystem.NUM_OF_SOUNDS; ++i) {
            this.soundElements[i] = 0;
        }
        this.tempCells = new Cell[32];
        this.tempCellsCount = 0;
        this.achievementCounter = new int[]{0, 0, 0};
        this.lastArrowUsed = null;
    }

    private void reinitialize() {
        int i;
        this.tempBridgeStackCount = 0;
        this.batteryStackCount = 0;
        this.isChanger = false;
        this.hints = new Hint();
        this.bossesCount = 0;
        this.isCellBlocked = false;
        this.cubes = Cubes.getInstance();
        for (i = 0; i < 17; ++i) {
            this.elements[i] = 0;
        }
        for (i = 0; i < SoundSystem.NUM_OF_SOUNDS; ++i) {
            this.soundElements[i] = 0;
        }
        this.tempCellsCount = 0;
        this.achievementCounter = new int[]{0, 0, 0};
        this.lastArrowUsed = null;
    }

    public void initLevel(int iWorld, int iLevel) {
        this.world = iWorld;
        this.level = iLevel;
        String levelFileName = "/levels/map_world_" + this.world + "_level_" + this.level + ".xml";
        SAXLevelParser levelParser = new SAXLevelParser(this, levelFileName);
        levelParser.startParser();
        this.secondParserRun();
        this.hints.sortHints();
    }

    private void secondParserRun() {
        for (int i = 0; i < this.tempCellsCount; ++i) {
            try {
                Cell cell = this.tempCells[i];
                switch (cell.type) {
                    case 10: {
                        ConstantBridgeCell cb = (ConstantBridgeCell)cell;
                        ((SwitchCell)this.cells[cb.xP][cb.yP]).addChildCell(cb);
                        break;
                    }
                    case 11: {
                        TempBridgeCell tb = (TempBridgeCell)cell;
                        ((SwitchCell)this.cells[tb.xP][tb.yP]).addChildCell(tb);
                        break;
                    }
                    case 12: {
                        ContactCell cc = (ContactCell)cell;
                        ((SwitchCell)this.cells[cc.xP][cc.yP]).addChildCell(cc);
                    }
                }
                continue;
            }
            catch (Exception e) {
                boolean bl = false;
            }
        }
    }

    public void init(int sizeX, int sizeY) {
        this.cells = new Cell[sizeX][sizeY];
        this.dimX = sizeX;
        this.dimY = sizeY;
    }

    public void addCell(Cell cell) {
        this.cells[cell.x][cell.y] = cell;
    }

    public void paint(Graphics g) {
        Battery battery;
        int i;
        int x;
        int y;
        int xAdd = Camera.getInstance().x;
        int yAdd = Camera.getInstance().y;
        NormalCube cube = (NormalCube)this.cubes.getActiveCube();
        int boundX = 0;
        int boundY = 0;
        switch (cube.state) {
            case 0: 
            case 13: {
                if (!cube.isArrowAnimationInProgress && !cube.isTurboAnimationInProgress) {
                    boundX = cube.x;
                    boundY = cube.y;
                    break;
                }
                switch (cube.shiftingDirection) {
                    case 0: {
                        boundX = cube.x;
                        boundY = cube.y;
                        break;
                    }
                    case 1: {
                        boundX = cube.x;
                        boundY = cube.y;
                        break;
                    }
                    case 2: {
                        boundX = cube.x;
                        boundY = cube.y + 1;
                        break;
                    }
                    case 3: {
                        boundX = cube.x - 1;
                        if (boundX < 0) {
                            boundX = 0;
                        }
                        boundY = cube.y;
                    }
                }
                break;
            }
            case 1: {
                boundX = cube.x;
                boundY = cube.y;
                break;
            }
            case 2: {
                boundX = cube.x;
                boundY = cube.y + 2;
                break;
            }
            case 3: {
                boundX = cube.x - 2;
                boundY = cube.y;
                break;
            }
            case 4: 
            case 14: {
                if (!cube.isTurboAnimationInProgress && !cube.inAction) {
                    boundX = cube.x;
                    boundY = cube.y;
                    break;
                }
                boundX = cube.x - 1;
                if (boundX < 0) {
                    boundX = 0;
                }
                boundY = cube.y;
                break;
            }
            case 5: {
                boundX = cube.x;
                boundY = cube.y;
                break;
            }
            case 6: {
                boundX = cube.x;
                boundY = cube.y + 1;
                break;
            }
            case 7: {
                boundX = cube.x - 1;
                boundY = cube.y;
                break;
            }
            case 8: 
            case 15: {
                if (!cube.isTurboAnimationInProgress) {
                    boundX = cube.x;
                    boundY = cube.y + 1;
                    break;
                }
                boundX = cube.x - 1;
                if (boundX < 0) {
                    boundX = 0;
                }
                boundY = cube.y + 1;
                break;
            }
            case 9: {
                boundX = cube.x;
                boundY = cube.y + 1;
                break;
            }
            case 10: {
                boundX = cube.x;
                boundY = cube.y + 2;
                break;
            }
            case 11: {
                boundX = cube.x - 1;
                boundY = cube.y + 1;
                break;
            }
            case 12: {
                boundX = cube.x;
                boundY = cube.y;
            }
        }
        for (y = 0; y <= boundY; ++y) {
            for (x = this.dimX - 1; x >= boundX; --x) {
                if (x >= 0 && y >= 0 && this.cells[x][y] != null) {
                    this.cells[x][y].paint(g, xAdd, yAdd);
                }
                if (!this.isBattery) continue;
                for (i = 0; i < this.batteryStackCount; ++i) {
                    battery = this.batteryStack[i];
                    if (!battery.isActive || battery.x != x || battery.y != y) continue;
                    battery.paint(g, xAdd, yAdd);
                }
            }
        }
        if (cube != null) {
            cube.paint(g, xAdd, yAdd);
            cube.animate();
        }
        for (y = 0; y <= boundY; ++y) {
            for (x = boundX - 1; x >= 0; --x) {
                if (this.cells[x][y] != null) {
                    this.cells[x][y].paint(g, xAdd, yAdd);
                }
                if (!this.isBattery) continue;
                for (i = 0; i < this.batteryStackCount; ++i) {
                    battery = this.batteryStack[i];
                    if (!battery.isActive || battery.x != x || battery.y != y) continue;
                    battery.paint(g, xAdd, yAdd);
                }
            }
        }
        for (y = boundY + 1; y < this.dimY; ++y) {
            for (x = this.dimX - 1; x >= 0; --x) {
                if (this.cells[x][y] != null) {
                    this.cells[x][y].paint(g, xAdd, yAdd);
                }
                if (!this.isBattery) continue;
                for (i = 0; i < this.batteryStackCount; ++i) {
                    battery = this.batteryStack[i];
                    if (!battery.isActive || battery.x != x || battery.y != y) continue;
                    battery.paint(g, xAdd, yAdd);
                }
            }
        }
        if (this.hints.isActive) {
            this.hints.paint(g, xAdd, yAdd);
        }
        if (this.isBoss) {
            for (int i2 = 0; i2 < this.bossesCount; ++i2) {
                Boss boss = this.bosses[i2];
                if (!boss.isDisplayed) continue;
                boss.paint(g, xAdd, yAdd);
            }
        }
    }

    public void objectReceived(Cell cell) {
    }

    public void objectReceived(Hashtable attributes, String tagName) {
        int y;
        Object[] tmp;
        if (tagName.equals("Map")) {
            this.columnCount = Integer.parseInt(attributes.get("columnCount").toString());
            this.rowCount = Integer.parseInt(attributes.get("rowCount").toString());
            this.init(this.columnCount, this.rowCount);
            this.minMoves = Integer.parseInt(attributes.get("minMoves").toString());
            this.hintTime = Integer.parseInt(attributes.get("hintTime").toString()) * 1000;
        }
        if (tagName.equals("c")) {
            int yP;
            int xP;
            int kind;
            String type = attributes.get("t").toString();
            int x = Integer.parseInt(attributes.get("x").toString());
            int y2 = Integer.parseInt(attributes.get("y").toString());
            if (type.equalsIgnoreCase("0")) {
                kind = Integer.parseInt(attributes.get("k").toString());
                this.cells[x][y2] = new DecorCell(x, y2, kind);
                this.elements[0] = 1;
            } else if (type.equalsIgnoreCase("1")) {
                this.cells[x][y2] = new NormalCell(x, y2);
                this.elements[1] = 1;
                this.soundElements[0] = 1;
            } else if (type.equalsIgnoreCase("2")) {
                this.cells[x][y2] = new WoodCell(x, y2);
                this.elements[2] = 1;
                this.soundElements[1] = 1;
            } else if (type.equalsIgnoreCase("3")) {
                kind = Integer.parseInt(attributes.get("k").toString());
                this.cells[x][y2] = new IceCell(x, y2, kind);
                this.elements[3] = 1;
                this.soundElements[2] = 1;
                this.soundElements[10] = 1;
            } else if (type.equalsIgnoreCase("4")) {
                kind = Integer.parseInt(attributes.get("k").toString());
                this.cells[x][y2] = new SwitchCell(x, y2, kind);
                this.currentCell = this.cells[x][y2];
                this.elements[4] = 1;
                this.soundElements[9] = 1;
            } else if (type.equalsIgnoreCase("5")) {
                this.cells[x][y2] = new RotatorCell(x, y2);
                this.elements[5] = 1;
                this.soundElements[8] = 1;
            } else if (type.equalsIgnoreCase("6")) {
                kind = Integer.parseInt(attributes.get("k").toString());
                this.cells[x][y2] = new ArrowCell(x, y2, kind /= 3);
                this.elements[6] = 1;
                this.soundElements[5] = 1;
            } else if (type.equalsIgnoreCase("7")) {
                this.isChanger = true;
                kind = Integer.parseInt(attributes.get("k").toString()) / 3;
                this.cells[x][y2] = new ChangerCell(x, y2, kind);
                this.elements[7] = 1;
            } else if (type.equalsIgnoreCase("9")) {
                this.cells[x][y2] = new FinishCell(x, y2);
                this.elements[9] = 1;
                this.soundElements[11] = 1;
            } else if (type.equalsIgnoreCase("10")) {
                xP = Integer.parseInt(attributes.get("xp").toString());
                yP = Integer.parseInt(attributes.get("yp").toString());
                this.cells[x][y2] = new ConstantBridgeCell(x, y2, xP, yP);
                if (this.tempCellsCount == this.tempCells.length) {
                    Cell[] tmp2 = new Cell[this.tempCellsCount + 16];
                    System.arraycopy(this.tempCells, 0, tmp2, 0, this.tempCellsCount);
                    this.tempCells = tmp2;
                }
                this.tempCells[this.tempCellsCount++] = this.cells[x][y2];
                this.elements[10] = 1;
            } else if (type.equalsIgnoreCase("11")) {
                xP = Integer.parseInt(attributes.get("xp").toString());
                yP = Integer.parseInt(attributes.get("yp").toString());
                this.cells[x][y2] = new TempBridgeCell(x, y2, xP, yP);
                if (this.tempCellsCount == this.tempCells.length) {
                    Cell[] tmp3 = new Cell[this.tempCellsCount + 16];
                    System.arraycopy(this.tempCells, 0, tmp3, 0, this.tempCellsCount);
                    this.tempCells = tmp3;
                }
                this.tempCells[this.tempCellsCount++] = this.cells[x][y2];
                this.elements[11] = 1;
                this.soundElements[6] = 1;
                this.soundElements[7] = 1;
            } else if (type.equalsIgnoreCase("12")) {
                kind = Integer.parseInt(attributes.get("k").toString());
                int xP2 = Integer.parseInt(attributes.get("xp").toString());
                int yP2 = Integer.parseInt(attributes.get("yp").toString());
                int n = Integer.parseInt(attributes.get("n").toString());
                this.cells[x][y2] = new ContactCell(x, y2, kind, xP2, yP2, n);
                if (this.tempCellsCount == this.tempCells.length) {
                    tmp = new Cell[this.tempCellsCount + 16];
                    System.arraycopy(this.tempCells, 0, tmp, 0, this.tempCellsCount);
                    this.tempCells = tmp;
                }
                this.tempCells[this.tempCellsCount++] = this.cells[x][y2];
                this.elements[12] = 1;
            } else if (type.equalsIgnoreCase("8")) {
                this.cells[x][y2] = new StartCell(x, y2);
                this.startX = x;
                this.startY = y2;
                this.elements[8] = 1;
            } else if (type.equalsIgnoreCase("13")) {
                this.cells[x][y2] = new ElectroCell(x, y2);
                this.elements[13] = 1;
            } else if (type.equalsIgnoreCase("14")) {
                this.cells[x][y2] = new BarrierCell(x, y2);
                this.elements[14] = 1;
            } else if (type.equalsIgnoreCase("15")) {
                this.cells[x][y2] = new BossFinishCell(x, y2);
                this.elements[15] = 1;
            } else if (type.equalsIgnoreCase("16")) {
                this.cells[x][y2] = new WindCell(x, y2);
                this.elements[16] = 1;
            }
        }
        if (tagName.equals("h")) {
            int x = Integer.parseInt(attributes.get("x").toString());
            y = Integer.parseInt(attributes.get("y").toString());
            int n = Integer.parseInt(attributes.get("n").toString());
            this.hints.addHint(x, y, n);
        }
        if (tagName.equalsIgnoreCase("bat")) {
            int x = Integer.parseInt(attributes.get("x").toString());
            y = Integer.parseInt(attributes.get("y").toString());
            int batX = Integer.parseInt(attributes.get("xd").toString());
            int batY = Integer.parseInt(attributes.get("yd").toString());
            int count = Integer.parseInt(attributes.get("nm").toString()) - 1;
            if (this.batteryStackCount == this.batteryStack.length) {
                Battery[] tmp4 = new Battery[this.batteryStackCount + 16];
                System.arraycopy(this.batteryStack, 0, tmp4, 0, this.batteryStackCount);
                this.batteryStack = tmp4;
            }
            this.batteryStack[this.batteryStackCount++] = new Battery(x, y, batX, batY, count);
            this.isBattery = true;
            this.soundElements[3] = 1;
            this.soundElements[4] = 1;
        }
        if (tagName.equals("mb")) {
            int x = Integer.parseInt(attributes.get("x").toString());
            y = Integer.parseInt(attributes.get("y").toString());
            this.isBoss = true;
            BossMagneto boss = null;
            int xd = Integer.parseInt(attributes.get("xd").toString());
            int yd = Integer.parseInt(attributes.get("yd").toString());
            int numMove = Integer.parseInt(attributes.get("nm").toString());
            boolean isf = Utils.string2boolean(attributes.get("if").toString());
            boss = new BossMagneto(x, y, xd, yd, numMove, isf);
            this.currentBoss = boss;
            if (this.bossesCount == this.bosses.length) {
                tmp = new Boss[this.bossesCount + 16];
                System.arraycopy(this.bosses, 0, tmp, 0, this.bossesCount);
                this.bosses = tmp;
            }
            this.bosses[this.bossesCount++] = this.currentBoss;
        }
        if (tagName.equals("mc")) {
            int x = Integer.parseInt(attributes.get("x").toString());
            y = Integer.parseInt(attributes.get("y").toString());
            for (int i = 0; i < this.bossesCount; ++i) {
                if (this.bosses[i] != this.currentBoss) continue;
                ((BossMagneto)this.bosses[i]).addCell(x, y);
                break;
            }
        }
        if (tagName.equals("tb")) {
            int x = Integer.parseInt(attributes.get("x").toString());
            y = Integer.parseInt(attributes.get("y").toString());
            this.isBoss = true;
            BossTurbo boss = new BossTurbo(x, y);
            if (this.bossesCount == this.bosses.length) {
                Boss[] tmp5 = new Boss[this.bossesCount + 16];
                System.arraycopy(this.bosses, 0, tmp5, 0, this.bossesCount);
                this.bosses = tmp5;
            }
            this.bosses[this.bossesCount++] = boss;
            this.soundElements[20] = 1;
            this.soundElements[21] = 1;
        }
    }

    public void roleCube(int direction) {
        int type;
        int state;
        int y;
        int x;
        Cube cube = this.cubes.getActiveCube();
        if (cube != null && cube.isCubeActive && !cube.inAction && this.checkIfMoveAllowed(x = cube.x, y = cube.y, state = cube.state, type = cube.type, direction)) {
            ScoresManager.getInstance().increaseCurrentMoves();
            cube.roleCube(direction);
            Camera.getInstance().smoothCenterCube(cube);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkIfMoveAllowed(int x, int y, int state, int type, int direction) {
        boolean isAllowed = false;
        switch (type) {
            case 0: {
                switch (direction) {
                    case 0: {
                        switch (state) {
                            case 0: {
                                if (y - 2 < 0) return false;
                                if (y - 1 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y - 1])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x][y - 2])) return isAllowed;
                                return true;
                            }
                            case 4: {
                                if (y - 1 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y - 1])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x + 1][y - 1])) return isAllowed;
                                return true;
                            }
                            case 8: {
                                if (y - 1 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y - 1])) return isAllowed;
                                return true;
                            }
                        }
                        return isAllowed;
                    }
                    case 1: {
                        switch (state) {
                            case 0: {
                                if (x + 2 >= this.dimX) return false;
                                if (x + 1 >= this.dimX) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x + 1][y])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x + 2][y])) return isAllowed;
                                return true;
                            }
                            case 4: {
                                if (x + 2 >= this.dimX) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x + 2][y])) return isAllowed;
                                return true;
                            }
                            case 8: {
                                if (x + 1 >= this.dimX) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x + 1][y])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x + 1][y + 1])) return isAllowed;
                                return true;
                            }
                        }
                        return isAllowed;
                    }
                    case 2: {
                        switch (state) {
                            case 0: {
                                if (y + 2 >= this.dimY) return false;
                                if (y + 1 >= this.dimY) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y + 1])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x][y + 2])) return isAllowed;
                                return true;
                            }
                            case 4: {
                                if (y + 1 >= this.dimY) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y + 1])) return isAllowed;
                                if (!this.checkIfCellisAllowed(this.cells[x + 1][y + 1])) return isAllowed;
                                return true;
                            }
                            case 8: {
                                if (y + 2 >= this.dimY) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x][y + 2])) return isAllowed;
                                return true;
                            }
                        }
                        return isAllowed;
                    }
                    case 3: {
                        switch (state) {
                            case 0: {
                                if (x - 1 < 0) return false;
                                if (x - 2 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x - 1][y]) || !this.checkIfCellisAllowed(this.cells[x - 2][y])) return isAllowed;
                                return true;
                            }
                            case 4: {
                                if (x - 1 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x - 1][y])) return isAllowed;
                                return true;
                            }
                            case 8: {
                                if (x - 1 < 0) {
                                    return false;
                                }
                                if (!this.checkIfCellisAllowed(this.cells[x - 1][y]) || !this.checkIfCellisAllowed(this.cells[x - 1][y + 1])) return isAllowed;
                                return true;
                            }
                        }
                        return isAllowed;
                    }
                }
                return isAllowed;
            }
        }
        return isAllowed;
    }

    private boolean checkIfCellisAllowed(Cell cell) {
        boolean isAllowed = false;
        if (cell != null) {
            switch (cell.type) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 12: 
                case 15: {
                    if (cell.isBlocked) break;
                    isAllowed = true;
                    break;
                }
                case 3: 
                case 10: 
                case 11: {
                    if (cell.state != 1 || cell.isBlocked) break;
                    isAllowed = true;
                    break;
                }
                case 7: {
                    if (cell.state != 0 || cell.isBlocked) break;
                    isAllowed = true;
                }
            }
        }
        return isAllowed;
    }

    public void processCubeMove(Cube cube, boolean isRolling) {
        boolean isNeedToCancelAction = true;
        switch (cube.type) {
            case 0: {
                Boss boss;
                int i;
                int x = cube.x;
                int y = cube.y;
                int state = cube.state;
                if (x < 0 || y < 0 || this.cells[x][y] == null) break;
                if (this.isChanger && isRolling) {
                    this.triggerChanger(cube);
                }
                if (this.isBattery) {
                    for (i = 0; i < this.batteryStackCount; ++i) {
                        Battery battery = this.batteryStack[i];
                        if (battery.isActive && !battery.isOverAnimationInProgress) {
                            --battery.counter;
                            boolean isNeedToCollect = false;
                            switch (cube.state) {
                                case 0: {
                                    if (battery.x != cube.x || battery.y != cube.y) break;
                                    isNeedToCollect = true;
                                    break;
                                }
                                case 4: {
                                    if ((battery.x != cube.x || battery.y != cube.y) && (battery.x != cube.x + 1 || battery.y != cube.y)) break;
                                    isNeedToCollect = true;
                                    break;
                                }
                                case 8: {
                                    if ((battery.x != cube.x || battery.y != cube.y) && (battery.x != cube.x || battery.y != cube.y + 1)) break;
                                    isNeedToCollect = true;
                                }
                            }
                            if (isNeedToCollect) {
                                this.collectBattery(battery);
                                SoundSystem.play(15);
                                continue;
                            }
                            if (battery.counter != -1) continue;
                            battery.flyAway();
                            SoundSystem.play(14);
                            continue;
                        }
                        if (battery.pX != cube.x || battery.pY != cube.y || cube.state != 0 || battery.isActive || battery.isAlreadyShow) continue;
                        battery.activate();
                        SoundSystem.play(13);
                    }
                }
                if (this.isBoss) {
                    for (i = 0; i < this.bossesCount; ++i) {
                        boss = this.bosses[i];
                        if (!boss.isDisplayed && boss.x == cube.x && boss.y == cube.y && cube.state == 0) {
                            boss.show();
                            this.activateBoss(boss);
                            continue;
                        }
                        if (!boss.isDisplayed) continue;
                        if (boss.type == 1) {
                            isNeedToCancelAction = false;
                        }
                        this.processBoss(boss);
                    }
                }
                if (this.tempBridgeStackCount > 0) {
                    block27: for (i = 0; i < this.tempBridgeStackCount; ++i) {
                        SwitchCell sc = this.tempBridgeStack[i];
                        for (int k = 0; k < sc.childStack.length; ++k) {
                            if (sc.contactCellToOff == sc.childStack.length - 1) {
                                if (sc.childStack[k].type != 11) continue;
                                ((TempBridgeCell)this.cells[sc.childStack[k].x][sc.childStack[k].y]).deactivateBridge();
                                sc.restoreSwitch();
                                System.arraycopy(this.tempBridgeStack, i + 1, this.tempBridgeStack, i, this.tempBridgeStackCount - i - 1);
                                SoundSystem.play(8);
                                continue;
                            }
                            if (sc.childStack[k].type != 12) continue;
                            ContactCell cs = (ContactCell)sc.childStack[k];
                            if (cs.state % 2 != 1 || cs.n != sc.contactCellToOff) continue;
                            cs.deactivateCell();
                            ++sc.contactCellToOff;
                            continue block27;
                        }
                    }
                }
                if (state == 4 && this.cells[x + 1][y].type == 3) {
                    ((IceCell)this.cells[x + 1][y]).breakCell();
                    this.restoreIceSwitcher();
                }
                if (state == 8 && this.cells[x][y + 1].type == 3) {
                    ((IceCell)this.cells[x][y + 1]).breakCell();
                    this.restoreIceSwitcher();
                }
                if (this.cells[x][y].type == 2 && state == 0) {
                    SoundSystem.play(10);
                    switch (cube.prevState) {
                        case 8: {
                            cube.roleCube(2);
                            break;
                        }
                        case 10: {
                            cube.roleCube(0);
                            break;
                        }
                        case 7: {
                            cube.roleCube(1);
                            break;
                        }
                        case 5: {
                            cube.roleCube(3);
                        }
                    }
                    this.achievementCounter[0] = this.achievementCounter[0] + 1;
                    if (this.achievementCounter[0] == 10) {
                        Achievements.makeAchivment(Achievements.SPRING, 1);
                    }
                } else if (this.cells[x][y].type == 3) {
                    ((IceCell)this.cells[x][y]).breakCell();
                    this.restoreIceSwitcher();
                } else if (this.cells[x][y].type == 4 && cube.state == 0) {
                    switch (this.cells[x][y].state) {
                        case 0: {
                            SoundSystem.play(9);
                            this.restoreIceCells();
                            ++this.cells[x][y].state;
                            break;
                        }
                        case 2: {
                            SoundSystem.play(9);
                            this.activateConstantBridge(x, y);
                            ++this.cells[x][y].state;
                            break;
                        }
                        case 4: {
                            SoundSystem.play(7);
                            this.activateTempBridge(x, y);
                            ++this.cells[x][y].state;
                        }
                    }
                } else if (this.cells[x][y].type == 5 && cube.state == 0) {
                    SoundSystem.play(12);
                    this.rotateCells();
                    ((NormalCube)cube).rotateCube();
                    this.achievementCounter[1] = this.achievementCounter[1] + 1;
                    if (this.achievementCounter[1] == 4) {
                        Achievements.makeAchivment(Achievements.ROTATOR, 1);
                    }
                } else if (this.cells[x][y].type == 6 && cube.state == 0) {
                    boolean isAllowed = false;
                    SoundSystem.play(11);
                    switch (this.cells[x][y].kind) {
                        case 0: {
                            isAllowed = this.checkIfCellisAllowed(this.cells[x][y - 1]);
                            break;
                        }
                        case 1: {
                            isAllowed = this.checkIfCellisAllowed(this.cells[x + 1][y]);
                            break;
                        }
                        case 2: {
                            isAllowed = this.checkIfCellisAllowed(this.cells[x][y + 1]);
                            break;
                        }
                        case 3: {
                            isAllowed = this.checkIfCellisAllowed(this.cells[x - 1][y]);
                        }
                    }
                    if (isAllowed) {
                        ((NormalCube)cube).shiftCube(this.cells[x][y].kind);
                        if (this.lastArrowUsed != null) {
                            if (this.lastArrowUsed == this.cells[x][y]) {
                                this.achievementCounter[2] = this.achievementCounter[2] + 1;
                                if (this.achievementCounter[2] == 3) {
                                    Achievements.makeAchivment(Achievements.ARROW, 1);
                                }
                            } else {
                                this.achievementCounter[2] = 0;
                            }
                        }
                        this.lastArrowUsed = this.cells[x][y];
                    }
                } else if (this.cells[x][y].type == 9 && cube.state == 0) {
                    SoundSystem.play(5);
                    ((NormalCube)cube).finishCube();
                    ((FinishCell)this.cells[x][y]).finishCell();
                } else if (this.cells[x][y].type == 15 && cube.state == 0) {
                    for (i = 0; i < this.bossesCount; ++i) {
                        boss = this.bosses[i];
                        if (!boss.isDisplayed) continue;
                        boss.finishBoss();
                    }
                }
                int mode = 0;
                SoundSystem.playRollingSound(mode);
                if (!isNeedToCancelAction) break;
                cube.inAction = false;
            }
        }
    }

    private void restoreIceCells() {
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                if (this.cells[x][y] == null || this.cells[x][y].type != 3) continue;
                ((IceCell)this.cells[x][y]).restoreCell();
            }
        }
    }

    private void activateConstantBridge(int x, int y) {
        SwitchCell sc = (SwitchCell)this.cells[x][y];
        for (int i = 0; i < sc.childStack.length; ++i) {
            ((ConstantBridgeCell)this.cells[sc.childStack[i].x][sc.childStack[i].y]).activateBridge();
        }
    }

    private void activateTempBridge(int x, int y) {
        SwitchCell sc = (SwitchCell)this.cells[x][y];
        sc.contactCellToOff = 0;
        if (this.tempBridgeStackCount == this.tempBridgeStack.length) {
            SwitchCell[] tmp = new SwitchCell[this.tempBridgeStackCount + 16];
            System.arraycopy(this.tempBridgeStack, 0, tmp, 0, this.tempBridgeStackCount);
            this.tempBridgeStack = tmp;
        }
        this.tempBridgeStack[this.tempBridgeStackCount++] = sc;
        for (int i = 0; i < sc.childStack.length; ++i) {
            if (this.cells[sc.childStack[i].x][sc.childStack[i].y].type == 12) {
                ((ContactCell)this.cells[sc.childStack[i].x][sc.childStack[i].y]).activateCell();
                continue;
            }
            if (this.cells[sc.childStack[i].x][sc.childStack[i].y].type != 11) continue;
            ((TempBridgeCell)this.cells[sc.childStack[i].x][sc.childStack[i].y]).activateBridge();
        }
    }

    private void rotateCells() {
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                if (this.cells[x][y] == null || this.cells[x][y].type != 6) continue;
                ((ArrowCell)this.cells[x][y]).rotateCell();
            }
        }
    }

    private void triggerChanger(Cube cube) {
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                if (this.cells[x][y] == null || this.cells[x][y].type != 7) continue;
                block0 : switch (cube.type) {
                    case 0: {
                        switch (cube.state) {
                            case 0: {
                                ((ChangerCell)this.cells[x][y]).changeCell(cube.x == x && cube.y == y);
                                break block0;
                            }
                            case 4: {
                                ((ChangerCell)this.cells[x][y]).changeCell(cube.x == x && cube.y == y || cube.x + 1 == x && cube.y == y);
                                break block0;
                            }
                            case 8: {
                                ((ChangerCell)this.cells[x][y]).changeCell(cube.x == x && cube.y == y || cube.x == x && cube.y + 1 == y);
                            }
                        }
                    }
                }
            }
        }
    }

    private void restoreIceSwitcher() {
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                if (this.cells[x][y] == null || this.cells[x][y].type != 4 || this.cells[x][y].state != 1) continue;
                ((SwitchCell)this.cells[x][y]).restoreSwitch();
            }
        }
    }

    private void collectBattery(Battery battery) {
        ScoresManager.getInstance().increaseCurrentBatteries();
        battery.deactivate();
        battery.disable();
        Cubes.getInstance().getActiveCube().getBattery();
    }

    public void showHint() {
        this.hints.showHint();
    }

    public void hideHint() {
        this.hints.hideHint();
    }

    private void activateBoss(Boss boss) {
        switch (boss.type) {
            case 0: {
                ((BossMagneto)boss).startBoss();
                if (((BossMagneto)boss).isFinalBoss) {
                    for (int i = 0; i < this.dimX; ++i) {
                        for (int j = 0; j < this.dimY; ++j) {
                            if (this.cells[i][j] == null || this.cells[i][j].type != 13) continue;
                            this.currentCell = this.cells[i][j];
                        }
                    }
                }
                SoundSystem.play(16);
                break;
            }
            case 1: {
                ((BossTurbo)boss).startBoss();
                if (!DataManager.isSoundEffectsEnabled) break;
                SoundSystem.startTurbo();
            }
        }
    }

    public void activateBossEffect(Boss boss) {
        switch (boss.type) {
            case 0: {
                int[][] magCells = ((BossMagneto)boss).cells;
                int magCellsCount = ((BossMagneto)boss).cellsCount;
                for (int i = 0; i < magCellsCount; ++i) {
                    int[] xy = magCells[i];
                    if (this.cells[xy[0]][xy[1]] == null) continue;
                    this.cells[xy[0]][xy[1]].setMagneto();
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dimX; ++i) {
                    for (int j = 0; j < this.dimY; ++j) {
                        if (this.cells[i][j] == null || this.cells[i][j].type != 16) continue;
                        ((WindCell)this.cells[i][j]).activate();
                    }
                }
                break;
            }
        }
    }

    public void processBoss(Boss boss) {
        switch (boss.type) {
            case 0: {
                ((BossMagneto)boss).nextMove();
                break;
            }
            case 1: {
                ((BossTurbo)boss).nextMove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flyCells(Boss boss) {
        switch (boss.type) {
            case 0: {
                Cube cube = this.cubes.getActiveCube();
                if (((BossMagneto)boss).isFinalBoss) {
                    this.cells[this.currentCell.x][this.currentCell.y].yR -= Constants.MAGNETO_SHIFTS[2];
                    cube.inAction = true;
                    return;
                }
                int[][] magnetoCells = ((BossMagneto)boss).cells;
                int magnetoCellsCount = ((BossMagneto)boss).cellsCount;
                block11: for (int i = 0; i < magnetoCellsCount; ++i) {
                    int[] xy = magnetoCells[i];
                    if (this.cells[xy[0]][xy[1]] != null) {
                        if (((BossMagneto)boss).isBossExited) {
                            this.cells[xy[0]][xy[1]] = null;
                            if (cube.type == 0 && ((NormalCube)cube).isCubeMagnetted) {
                                GameScreen.gameStatus = 2;
                            }
                        } else {
                            this.cells[xy[0]][xy[1]].yR -= Constants.MAGNETO_SHIFTS[2];
                            this.cells[xy[0]][xy[1]].isBlocked = true;
                        }
                    }
                    switch (cube.type) {
                        case 0: {
                            switch (cube.state) {
                                case 0: {
                                    if (cube.x != xy[0] || cube.y != xy[1]) break;
                                    cube.inAction = true;
                                    ((NormalCube)cube).isCubeMagnetted = true;
                                    break;
                                }
                                case 4: {
                                    if ((cube.x != xy[0] || cube.y != xy[1]) && (cube.x + 1 != xy[0] || cube.y != xy[1])) break;
                                    cube.inAction = true;
                                    ((NormalCube)cube).isCubeMagnetted = true;
                                    break;
                                }
                                case 8: {
                                    if ((cube.x != xy[0] || cube.y != xy[1]) && (cube.x != xy[0] || cube.y + 1 != xy[1])) break;
                                    cube.inAction = true;
                                    ((NormalCube)cube).isCubeMagnetted = true;
                                }
                            }
                            continue block11;
                        }
                    }
                }
                if (!((NormalCube)cube).isCubeMagnetted) return;
                cube.yR -= Constants.MAGNETO_SHIFTS[2];
                return;
            }
        }
    }

    public void clear() {
        this.tempBridgeStack = null;
        this.batteryStack = null;
        this.hints = null;
        _instance = null;
        this.elements = null;
        this.achievementCounter = null;
        this.lastArrowUsed = null;
    }
}

