/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.components.ScoresManager;
import com.ximad.braincube2.engine.Bitmap;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class NormalGameScreen
extends GameScreen {
    private static NormalGameScreen instance_normal;

    private NormalGameScreen(int iWorld, int iLevel) {
        super(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                NormalGameScreen.this.hintButton.update(NormalGameScreen.this.timeFromBeg);
                NormalGameScreen.this.bg.draw(g, 0, 0);
                if (NormalGameScreen.this.camera.isAnimationInProgress) {
                    NormalGameScreen.this.camera.makeSmoothAnimation();
                }
                NormalGameScreen.this.drawBackgroundEffect(g);
                NormalGameScreen.this.drawBoard(g);
                if (NormalGameScreen.this.isScrollingMode) {
                    ImagesResources.scrollingImage.draw(g, 0, 0);
                } else {
                    g.setColor(0xFFFFFF);
                    g.setFont(NormalGameScreen.this.boldOblicueFont);
                    int width = NormalGameScreen.this.boldOblicueFont.stringWidth(NormalGameScreen.this.moveCount);
                    g.drawString(NormalGameScreen.this.moveCount, 640 - width - 7, Constants.GAME_SCREEN_COORDS[3][1], 0);
                    GameScreen.batteryCount = ScoresManager.getInstance().getCurrentBatteries();
                    for (int i = 0; i < NormalGameScreen.this.batteryMaxCount; ++i) {
                        if (i < GameScreen.batteryCount) {
                            ImagesResources.batterySymbolImages[1].draw(g, Constants.GAME_SCREEN_COORDS[i][0], Constants.GAME_SCREEN_COORDS[i][1]);
                            continue;
                        }
                        ImagesResources.batterySymbolImages[0].draw(g, Constants.GAME_SCREEN_COORDS[i][0], Constants.GAME_SCREEN_COORDS[i][1]);
                    }
                }
                super.onPaint(g);
            }

            public void execute(int code) {
            }

            public void arrangeChild() {
                NormalGameScreen.this.pauseButton.setPosition(Constants.GAME_SCREEN_COORDS[4][0], Constants.GAME_SCREEN_COORDS[4][1]);
                NormalGameScreen.this.scrollButton.setPosition(Constants.GAME_SCREEN_COORDS[5][0], Constants.GAME_SCREEN_COORDS[5][1]);
                NormalGameScreen.this.hintButton.setPosition(Constants.GAME_SCREEN_COORDS[6][0], Constants.GAME_SCREEN_COORDS[6][1]);
            }
        };
        this.layoutManager.add(this.pauseButton, Constants.GAME_SCREEN_COORDS[4][0], Constants.GAME_SCREEN_COORDS[4][1]);
        this.layoutManager.add(this.scrollButton, Constants.GAME_SCREEN_COORDS[5][0], Constants.GAME_SCREEN_COORDS[5][1]);
        this.layoutManager.add(this.hintButton, Constants.GAME_SCREEN_COORDS[6][0], Constants.GAME_SCREEN_COORDS[6][1]);
        this.layoutManager.arrangeChild();
        this.startGame();
        this.layoutManager.execute(0);
    }

    public void onPaint(Graphics g) {
        this.layoutManager.onPaint(g);
    }

    public static NormalGameScreen getInstance(int iWorld, int iLevel) {
        if (instance_normal == null) {
            instance_normal = new NormalGameScreen(iWorld, iLevel);
        } else {
            instance_normal.reinitialize(iWorld, iLevel);
        }
        return instance_normal;
    }

    protected void reinitialize(int iWorld, int iLevel) {
        super.reinitialize(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        this.layoutManager.arrangeChild();
        this.startGame();
        this.layoutManager.execute(0);
    }
}

