/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.cells;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.ImagesResources;
import javax.microedition.lcdui.Graphics;

public abstract class Cell {
    public int x;
    public int y;
    public int type;
    public int state;
    public int animationFrame;
    public int xR;
    public int yR;
    public int kind;
    protected int xRR;
    protected int yRR;
    public boolean isBlocked;
    protected boolean isMagneto;

    public Cell(int iX, int iY) {
        this.x = iX;
        this.y = iY;
        this.xR = Constants.cBc[0][0] * this.x + Constants.cBc[0][1] * this.y;
        this.yR = Constants.cBc[1][0] * this.x + Constants.cBc[1][1] * this.y;
        this.isMagneto = false;
        this.isBlocked = false;
    }

    public void paint(Graphics g, int shiftX, int shiftY) {
        this.xRR = this.xR + shiftX;
        this.yRR = this.yR + shiftY;
        if (this.xRR > -150 && this.xRR < 790 && this.yRR > -150 && this.yRR < 510) {
            ImagesResources.cellImages[this.type][this.state].draw(g, this.xRR, this.yRR);
            if (this.isMagneto) {
                ImagesResources.magnetCellImage.draw(g, this.xRR, this.yRR);
            }
        }
    }

    public void setMagneto() {
        this.isMagneto = true;
    }
}

