/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.component.Field;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CustomButtonField
extends Field {
    private String label;
    private int textColorUnfocused;
    private int textColorFocused;
    private int horizontalPadding = 5;
    private int verticalPadding = 5;
    private Font font;
    private boolean isEnabled = true;
    private boolean isVisible = true;

    public CustomButtonField(String label, int textColorUnfocused, int textColorFocused) {
        this.label = label;
        this.textColorUnfocused = textColorUnfocused;
        this.textColorFocused = textColorFocused;
        this.font = Font.getDefaultFont();
        this.width = this.font.stringWidth(label);
        this.height = this.font.getHeight();
    }

    public void onPaint(Graphics graphics) {
        if (this.isVisible) {
            graphics.setColor(this.status == 1 ? this.textColorFocused : this.textColorUnfocused);
            int fontWidth = this.font.stringWidth(this.label);
            graphics.drawString(this.label, this.left + (this.getWidth() - fontWidth) / 2, this.top + this.verticalPadding, 20);
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        if (!(this.isVisible && this.isEnabled || touchEventType == 1)) {
            return false;
        }
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.status = 1;
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.repaint();
    }
}

