/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.cells.Cell;
import com.ximad.braincube2.cells.StartCell;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Boss;
import com.ximad.braincube2.components.BossTurbo;
import com.ximad.braincube2.components.Camera;
import com.ximad.braincube2.components.Cube;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class NormalCube
extends Cube {
    public static final int VerticalVerticalUp = 0;
    public static final int VerticalVerticalRight = 1;
    public static final int VerticalVerticalDown = 2;
    public static final int VerticalVerticalLeft = 3;
    public static final int HorizontalHorizontalUp = 4;
    public static final int HorizontalHorizontalRight = 5;
    public static final int HorizontalHorizontalDown = 6;
    public static final int HorizontalHorizontalLeft = 7;
    public static final int HorizontalVerticalUp = 8;
    public static final int HorizontalVerticalRight = 9;
    public static final int HorizontalVerticalDown = 10;
    public static final int HorizontalVerticalLeft = 11;
    public static int status = 0;
    public static final int Rotation = 12;
    public static final int Start = 1;
    public static final int Finish = 2;
    public static final int Return = 3;
    public static final int BatteryVerticalVerticalUp = 13;
    public static final int BatteryHorizontalHorizontalUp = 14;
    public static final int BatteryHorizontalVerticalUp = 15;
    public static final int RollingComplete = 0;
    public static final int StartComplete = 1;
    public static final int FinishComplete = 2;
    public static final int RotationComplete = 3;
    public static final int ArrowComplete = 4;
    public static final int BatteryGetComplete = 5;
    public static final int TurboActionComplete = 6;
    public int animationFrame = 0;
    private int shiftingFrame;
    public boolean isRollingAnimationInProgress = false;
    public boolean isRotationAnimationInProgress = false;
    public boolean isFlyingAnimationInProgress;
    public boolean isArrowAnimationInProgress = false;
    public int shiftingDirection;
    public boolean isTurboAnimationInProgress;
    public boolean isBatteryGetting;
    public boolean isFallingDown;
    int xAdd;
    int yAdd;
    int gravitationCounter;
    int tempX;
    int tempY;
    public boolean isCubeMagnetted;
    int isLoosed;
    public int prevPrevState;

    public NormalCube(int x, int y, int state) {
        super(x, y, state);
        this.inAction = false;
        this.camX = Constants.ncBc[0][2];
        this.camY = Constants.ncBc[1][2];
        this.type = 0;
        this.nextX = x;
        this.nextY = y;
        this.updateRealCoords();
        this.updateNextRealCoords();
        this.isCubeMagnetted = false;
        this.isBatteryGetting = false;
        this.isFallingDown = false;
        this.isLoosed = 0;
    }

    public void setCubeActivity(boolean activity) {
        this.isCubeActive = activity;
    }

    public void paint(Graphics g, int shiftX, int shiftY) {
        ImagesResources.cubeImages[this.state].draw(g, this.xR + shiftX + this.xAdd, this.yR + shiftY + this.yAdd, 223, this.animationFrame * 223);
    }

    public void animate() {
        if (this.isRollingAnimationInProgress) {
            ++this.animationFrame;
            if (this.animationFrame > 4) {
                this.isRollingAnimationInProgress = false;
                this.animationFrame = 0;
                this.onActionComplete(0);
            }
        } else if (this.isRotationAnimationInProgress) {
            ++this.animationFrame;
            if (this.animationFrame > 2) {
                this.isRotationAnimationInProgress = false;
                this.animationFrame = 0;
                this.state = 0;
                this.onActionComplete(3);
            }
        } else if (this.isFlyingAnimationInProgress) {
            switch (status) {
                case 1: {
                    this.yAdd += 2 * (this.gravitationCounter * this.gravitationCounter) / 6;
                    ++this.gravitationCounter;
                    if (this.yAdd < 0) break;
                    this.yAdd = 0;
                    this.isFlyingAnimationInProgress = false;
                    this.state = 0;
                    this.onActionComplete(1);
                    break;
                }
                case 2: {
                    this.yAdd -= 1 * (this.gravitationCounter * this.gravitationCounter) / 12;
                    ++this.gravitationCounter;
                    if (this.yR + this.yAdd >= -400) break;
                    this.isFlyingAnimationInProgress = false;
                    this.state = 0;
                    this.onActionComplete(2);
                }
            }
        } else if (this.isArrowAnimationInProgress || this.isTurboAnimationInProgress) {
            ++this.shiftingFrame;
            if (this.shiftingFrame > 4) {
                if (!this.isTurboAnimationInProgress) {
                    this.isArrowAnimationInProgress = false;
                    this.onActionComplete(4);
                } else {
                    this.isTurboAnimationInProgress = false;
                    this.onActionComplete(6);
                }
            } else {
                this.xAdd += this.tempX;
                this.yAdd += this.tempY;
            }
        } else if (this.isBatteryGetting) {
            ++this.animationFrame;
            if (this.animationFrame > 4) {
                this.animationFrame = 0;
                this.isBatteryGetting = false;
                this.onActionComplete(5);
            }
        } else if (this.isFallingDown) {
            this.yAdd += 2 * (this.gravitationCounter * this.gravitationCounter) / 6;
            ++this.gravitationCounter;
            if (this.yAdd > 400) {
                this.isFallingDown = false;
                this.state = 0;
                GameScreen.gameStatus = 2;
            }
        }
    }

    public void roleCube(int direction) {
        if (this.isRollingAnimationInProgress || this.isRotationAnimationInProgress || this.isFlyingAnimationInProgress || this.isArrowAnimationInProgress || this.isBatteryGetting) {
            return;
        }
        this.isRollingAnimationInProgress = true;
        this.inAction = true;
        block0 : switch (direction) {
            case 0: {
                switch (this.state) {
                    case 0: {
                        this.nextY = this.y - 2;
                        break;
                    }
                    case 4: {
                        this.nextY = this.y - 1;
                        break;
                    }
                    case 8: {
                        this.nextY = this.y - 1;
                    }
                }
                break;
            }
            case 1: {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.nextX = this.x + 1;
                        break;
                    }
                    case 4: {
                        this.state = 5;
                        this.nextX = this.x + 2;
                        break;
                    }
                    case 8: {
                        this.state = 9;
                        this.nextX = this.x + 1;
                    }
                }
                break;
            }
            case 2: {
                switch (this.state) {
                    case 0: {
                        this.state = 2;
                        this.nextY = this.y + 1;
                        break;
                    }
                    case 4: {
                        this.state = 6;
                        this.nextY = this.y + 1;
                        break;
                    }
                    case 8: {
                        this.state = 10;
                        this.nextY = this.y + 2;
                    }
                }
                break;
            }
            case 3: {
                switch (this.state) {
                    case 0: {
                        this.state = 3;
                        this.nextX = this.x - 2;
                        break block0;
                    }
                    case 4: {
                        this.state = 7;
                        this.nextX = this.x - 1;
                        break block0;
                    }
                    case 8: {
                        this.state = 11;
                        this.nextX = this.x - 1;
                    }
                }
            }
        }
        this.updateNextRealCoords();
    }

    public void rotateCube() {
        if (this.isRotationAnimationInProgress) {
            return;
        }
        this.state = 12;
        this.isRotationAnimationInProgress = true;
        this.inAction = true;
    }

    public void startCube() {
        this.gravitationCounter = 0;
        status = 1;
        this.yAdd = -230;
        this.isFlyingAnimationInProgress = true;
        this.inAction = true;
    }

    public void finishCube() {
        this.gravitationCounter = 0;
        this.yAdd = 0;
        status = 2;
        this.isFlyingAnimationInProgress = true;
        this.inAction = true;
    }

    public void shiftCube(int direction) {
        switch (direction) {
            case 0: {
                this.nextY = this.y - 1;
                this.nextX = this.x;
                break;
            }
            case 1: {
                this.nextX = this.x + 1;
                this.nextY = this.y;
                break;
            }
            case 2: {
                this.nextY = this.y + 1;
                this.nextX = this.x;
                break;
            }
            case 3: {
                this.nextX = this.x - 1;
                this.nextY = this.y;
            }
        }
        this.tempX = (Constants.ncBc[0][0] * this.nextX + Constants.ncBc[0][1] * this.nextY + Constants.ncBc[0][2] - this.xR) / 4;
        this.tempY = (Constants.ncBc[1][0] * this.nextX + Constants.ncBc[1][1] * this.nextY + Constants.ncBc[1][2] - this.yR) / 4;
        this.shiftingFrame = 0;
        this.isArrowAnimationInProgress = true;
        this.inAction = true;
        this.updateNextRealCoords();
        this.shiftingDirection = direction;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void shiftCubeTurbo() {
        boolean isNeedToShift = true;
        switch (this.state) {
            case 0: 
            case 4: {
                if (this.x - 1 < 0 || Board.getInstance().cells[this.x - 1][this.y] == null) break;
                switch (Board.getInstance().cells[this.x - 1][this.y].type) {
                    case 14: {
                        isNeedToShift = false;
                        break;
                    }
                    case 10: {
                        if (Board.getInstance().cells[this.x - 1][this.y].state != 0) break;
                        isNeedToShift = false;
                        break;
                    }
                }
                break;
            }
            case 8: {
                if (this.x - 1 < 0) break;
                if (Board.getInstance().cells[this.x - 1][this.y] != null) {
                    switch (Board.getInstance().cells[this.x - 1][this.y].type) {
                        case 14: {
                            isNeedToShift = false;
                            break;
                        }
                        case 10: {
                            if (Board.getInstance().cells[this.x - 1][this.y].state != 0) break;
                            isNeedToShift = false;
                            break;
                        }
                    }
                }
                if (Board.getInstance().cells[this.x - 1][this.y + 1] == null) break;
                switch (Board.getInstance().cells[this.x - 1][this.y + 1].type) {
                    case 14: {
                        isNeedToShift = false;
                        break;
                    }
                    case 10: {
                        if (Board.getInstance().cells[this.x - 1][this.y + 1].state != 0) break;
                        isNeedToShift = false;
                    }
                }
                break;
            }
        }
        if (isNeedToShift) {
            this.nextX = this.x - 1;
            this.nextY = this.y;
            this.tempX = (Constants.ncBc[0][0] * this.nextX + Constants.ncBc[0][1] * this.nextY + Constants.ncBc[0][2] - this.xR) / 4;
            this.tempY = (Constants.ncBc[1][0] * this.nextX + Constants.ncBc[1][1] * this.nextY + Constants.ncBc[1][2] - this.yR) / 4;
            this.shiftingFrame = 0;
            this.isTurboAnimationInProgress = true;
            this.inAction = true;
            this.updateNextRealCoords();
            this.shiftingDirection = 3;
            return;
        }
        this.inAction = false;
    }

    public void onActionComplete(int action) {
        switch (action) {
            case 1: {
                Board board = Board.getInstance();
                ((StartCell)board.cells[board.startX][board.startY]).breakCell();
                this.inAction = false;
                break;
            }
            case 2: {
                this.inAction = false;
                GameScreen.gameStatus = 6;
                break;
            }
            case 0: {
                this.x = this.nextX;
                this.y = this.nextY;
                this.updateRealCoords();
                this.prevPrevState = this.state;
                this.prevState = this.state;
                switch (this.state) {
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: {
                        this.state = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: {
                        this.state = 4;
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 9: 
                    case 11: {
                        this.state = 8;
                    }
                }
                Board.getInstance().processCubeMove(this, true);
                break;
            }
            case 4: {
                this.x = this.nextX;
                this.y = this.nextY;
                this.prevState = this.state;
                this.xAdd = 0;
                this.yAdd = 0;
                this.updateRealCoords();
                SoundSystem.isNeedToPlaySound = false;
                Board.getInstance().processCubeMove(this, false);
                SoundSystem.isNeedToPlaySound = true;
                this.inAction = false;
                Camera.getInstance().smoothCenterCube(this);
                break;
            }
            case 5: {
                Cell cell = Board.getInstance().cells[this.x][this.y];
                if (cell != null) {
                    if (cell.type == 2 && this.state == 13) {
                        this.inAction = false;
                        this.state = 0;
                        switch (this.prevPrevState) {
                            case 8: {
                                this.roleCube(2);
                                break;
                            }
                            case 10: {
                                this.roleCube(0);
                                break;
                            }
                            case 7: {
                                this.roleCube(1);
                                break;
                            }
                            case 5: {
                                this.roleCube(3);
                            }
                        }
                        break;
                    }
                    this.inAction = false;
                    this.state = this.prevState;
                    Board.getInstance().processCubeMove(this, false);
                    break;
                }
                this.inAction = false;
                this.state = this.prevState;
                break;
            }
            case 6: {
                int i;
                this.x = this.nextX;
                this.y = this.nextY;
                this.prevState = this.state;
                this.xAdd = 0;
                this.yAdd = 0;
                this.updateRealCoords();
                switch (this.state) {
                    case 0: {
                        if (this.x >= 0 && this.x <= Board.getInstance().dimX && this.y >= 0 && this.y <= Board.getInstance().dimY) {
                            if (Board.getInstance().cells[this.x][this.y] == null) {
                                ++this.isLoosed;
                                break;
                            }
                            if (Board.getInstance().cells[this.x][this.y].type != 16) break;
                            ++this.isLoosed;
                            break;
                        }
                        ++this.isLoosed;
                        break;
                    }
                    case 4: {
                        if (this.x >= 0 && this.x + 1 >= 0 && this.x + 1 <= Board.getInstance().dimX && this.x <= Board.getInstance().dimX && this.y >= 0 && this.y <= Board.getInstance().dimY) {
                            if (Board.getInstance().cells[this.x][this.y] == null || Board.getInstance().cells[this.x + 1][this.y] == null) {
                                ++this.isLoosed;
                                break;
                            }
                            if (Board.getInstance().cells[this.x][this.y].type != 16 && Board.getInstance().cells[this.x + 1][this.y].type != 16) break;
                            ++this.isLoosed;
                            break;
                        }
                        ++this.isLoosed;
                        break;
                    }
                    case 8: {
                        if (this.x >= 0 && this.y + 1 >= 0 && this.y + 1 <= Board.getInstance().dimY && this.x <= Board.getInstance().dimX && this.y >= 0 && this.y <= Board.getInstance().dimY) {
                            if (Board.getInstance().cells[this.x][this.y] == null || Board.getInstance().cells[this.x][this.y + 1] == null) {
                                ++this.isLoosed;
                                break;
                            }
                            if (Board.getInstance().cells[this.x][this.y].type != 16 && Board.getInstance().cells[this.x][this.y + 1].type != 16) break;
                            ++this.isLoosed;
                            break;
                        }
                        ++this.isLoosed;
                    }
                }
                Camera.getInstance().smoothCenterCube(this);
                Boss[] bosses = Board.getInstance().bosses;
                int bossesCount = Board.getInstance().bossesCount;
                for (i = 0; i < bossesCount; ++i) {
                    if (bosses[i].type != 1) continue;
                    ((BossTurbo)bosses[i]).isNeedToShift = false;
                }
                SoundSystem.isNeedToPlaySound = false;
                Board.getInstance().processCubeMove(this, false);
                for (i = 0; i < bossesCount; ++i) {
                    if (bosses[i].type != 1) continue;
                    ((BossTurbo)bosses[i]).isNeedToShift = true;
                }
                SoundSystem.isNeedToPlaySound = true;
                if (this.isLoosed == 1) {
                    this.shiftCubeTurbo();
                }
                if (this.isLoosed >= 2) {
                    this.isFallingDown = true;
                    this.gravitationCounter = 0;
                    this.inAction = true;
                    if (DataManager.isSoundEffectsEnabled) {
                        SoundSystem.stopTurbo();
                        SoundSystem.play(21);
                    }
                }
                this.inAction = false;
            }
        }
    }

    private void updateRealCoords() {
        this.xR = Constants.ncBc[0][0] * this.x + Constants.ncBc[0][1] * this.y + Constants.ncBc[0][2];
        this.yR = Constants.ncBc[1][0] * this.x + Constants.ncBc[1][1] * this.y + Constants.ncBc[1][2];
    }

    private void updateNextRealCoords() {
        this.nextXR = Constants.ncBc[0][0] * this.nextX + Constants.ncBc[0][1] * this.nextY + Constants.ncBc[0][2];
        this.nextYR = Constants.ncBc[1][0] * this.nextX + Constants.ncBc[1][1] * this.nextY + Constants.ncBc[1][2];
    }

    public void getBattery() {
        this.prevState = this.state;
        switch (this.state) {
            case 0: {
                this.state = 13;
                break;
            }
            case 4: {
                this.state = 14;
                break;
            }
            case 8: {
                this.state = 15;
            }
        }
        this.isBatteryGetting = true;
        this.animationFrame = 0;
        this.inAction = true;
    }
}

