/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.engine.DataManager;

public class ScoresManager {
    private static ScoresManager _instance;
    private int currentMovements = 0;
    private int currentBatarries = 0;
    private int availableBattaries;
    private int currentScore;
    private int bestScore;
    private int bestBattaries;
    private int totalScore;
    private int totalBatteries;
    public int world;
    public int level;
    public boolean isBestTotalAnimationNeeded;
    public int bestScorePrev;
    public int totalScorePrev;

    public static ScoresManager getInstance() {
        if (_instance == null) {
            _instance = new ScoresManager();
        }
        return _instance;
    }

    public void init(int iWorld, int iLevel) {
        this.world = iWorld;
        this.level = iLevel;
        int[] temp = DataManager.getLevelScore(this.world, this.level);
    }

    public int getBestScore() {
        this.bestScore = DataManager.getLevelScore(this.world, this.level)[0];
        return this.bestScore;
    }

    public int getCurrentMoves() {
        return this.currentMovements;
    }

    public void increaseCurrentMoves() {
        ++this.currentMovements;
    }

    public int getCurrentBatteries() {
        return this.currentBatarries;
    }

    public void increaseCurrentBatteries() {
        ++this.currentBatarries;
    }

    public int getCurrentScore() {
        this.availableBattaries = Board.getInstance().batteryStackCount;
        int scoreOfBattery = this.availableBattaries == 0 ? 0 : (200 + (this.availableBattaries - 1) * 50) / this.availableBattaries;
        double koef = 0.5;
        int scoreOfMoves = (int)(100.0 + (double)((900 - scoreOfBattery * this.availableBattaries) * Board.getInstance().minMoves) * (1.0 + koef) / ((double)this.currentMovements + koef * (double)Board.getInstance().minMoves));
        this.currentScore = scoreOfMoves + (scoreOfBattery *= this.currentBatarries);
        if (this.currentScore > 1000) {
            this.currentScore = 1000;
        }
        return this.currentScore;
    }

    public int getBestBattaries() {
        this.bestBattaries = DataManager.getLevelScore(this.world, this.level)[1];
        return this.bestBattaries;
    }

    public void updateBestCurrentScore() {
        if (this.currentBatarries > this.getBestBattaries()) {
            DataManager.storeTotalBatteries(DataManager.getTotalBatteries() + (this.currentBatarries - this.getBestBattaries()));
            if (this.getCurrentScore() > this.getBestScore()) {
                if (this.getBestScore() > 0) {
                    Achievements.makeAchivment(Achievements.IMPROVED_RESULT, 1);
                }
                this.bestScorePrev = this.bestScore;
                this.totalScorePrev = this.getTotalScore();
                int ns = this.totalScorePrev - this.bestScore + this.currentScore;
                this.setTotalScore(ns);
                this.bestScore = this.currentScore;
                DataManager.storeLevelScore(this.world, this.level, this.currentScore, this.currentBatarries, Board.getInstance().batteryStackCount);
                this.isBestTotalAnimationNeeded = true;
            } else {
                if (this.getBestScore() > 0) {
                    Achievements.makeAchivment(Achievements.IMPROVED_RESULT, 1);
                }
                DataManager.storeLevelScore(this.world, this.level, this.getBestScore(), this.currentBatarries, Board.getInstance().batteryStackCount);
                this.isBestTotalAnimationNeeded = true;
            }
        } else if (this.getCurrentScore() > this.getBestScore()) {
            if (this.getBestScore() > 0) {
                Achievements.makeAchivment(Achievements.IMPROVED_RESULT, 1);
            }
            this.bestScorePrev = this.bestScore;
            this.totalScorePrev = this.getTotalScore();
            int ns = this.totalScorePrev - this.bestScore + this.currentScore;
            this.setTotalScore(ns);
            this.bestScore = this.currentScore;
            DataManager.storeLevelScore(this.world, this.level, this.currentScore, this.getBestBattaries(), Board.getInstance().batteryStackCount);
            this.isBestTotalAnimationNeeded = true;
        } else {
            this.isBestTotalAnimationNeeded = false;
        }
    }

    public int getTotalScore() {
        this.totalScore = DataManager.getTotalScore();
        return this.totalScore;
    }

    public void setTotalScore(int score) {
        DataManager.storeTotalScore(score);
    }

    public void clear() {
        this.currentMovements = 0;
        this.currentScore = 0;
        this.currentBatarries = 0;
    }
}

