/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Boss;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class BossMagneto
extends Boss {
    private static final int INITIAL_COUNT = 32;
    private static final int DEFAULT_STEP = 16;
    public boolean isFinalBoss;
    public int xD;
    public int yD;
    public int numMoves;
    public int xAdd;
    public int yAdd;
    public boolean isDisplayed;
    public boolean isActive;
    private boolean isBossComing;
    public boolean isBossExiting;
    public boolean isBossExited;
    public boolean isElectroCellUpping;
    public boolean isElectroCellUpped;
    public int[][] cells;
    public int cellsCount;
    private int animationFrame;
    public int state;
    private int counter;
    private int musicCounter;
    private boolean exitSoundPlayed;

    public BossMagneto(int iX, int iY, int ixD, int iyD, int inumMoves, boolean iIsFinish) {
        this.type = 0;
        this.x = iX;
        this.y = iY;
        this.xD = ixD;
        this.yD = iyD;
        this.numMoves = inumMoves;
        this.isFinalBoss = iIsFinish;
        this.xR = Constants.magBc[0][0] * this.xD + Constants.magBc[0][1] * this.yD + Constants.magBc[0][2];
        this.yR = Constants.magBc[1][0] * this.xD + Constants.magBc[1][1] * this.yD + Constants.magBc[1][2];
        this.isDisplayed = false;
        this.isActive = false;
        this.isBossComing = false;
        this.isBossExiting = false;
        this.isBossExited = false;
        this.cells = new int[32][];
        this.cellsCount = 0;
        this.musicCounter = 0;
        this.exitSoundPlayed = false;
    }

    public void paint(Graphics g, int shiftX, int shiftY) {
        if (this.isBossComing) {
            ++this.counter;
            if (this.counter > 20) {
                this.yAdd = 0;
                this.animationFrame = 0;
                this.counter = 0;
                this.activate();
                this.isBossComing = false;
            } else {
                this.yAdd += 10;
            }
        } else if (this.isBossExiting) {
            ++this.counter;
            if (this.counter > 12) {
                this.yAdd -= Constants.MAGNETO_SHIFTS[2];
            }
            if (this.counter > 40) {
                this.yAdd = -1000;
                this.animationFrame = 0;
                this.deactivate();
                this.isBossExited = true;
                this.isBossExiting = false;
            }
            Board.getInstance().flyCells(this);
        } else if (this.isElectroCellUpping) {
            ++this.counter;
            if (this.counter > 20) {
                this.isElectroCellUpped = true;
                this.isElectroCellUpping = false;
                this.counter = 0;
                this.isActive = false;
            } else {
                Board.getInstance().flyCells(this);
            }
        } else if (this.isElectroCellUpped) {
            if (this.counter == 8) {
                this.state = 4;
                Achievements.makeAchivment(Achievements.FIRST_BOSS_PASSED, 1);
                GameScreen.gameStatus = 6;
            } else {
                if (this.state == 3) {
                    this.state = 1;
                    ++this.counter;
                } else {
                    ++this.state;
                }
                if (this.musicCounter < 12) {
                    SoundSystem.play(18);
                    ++this.musicCounter;
                }
            }
        }
        if (this.isActive) {
            ImagesResources.magnetAnimationImages[this.animationFrame].draw(g, this.xR + shiftX + this.xAdd + Constants.MAGNETO_WAVES[0], this.yR + shiftY + this.yAdd + ImagesResources.magnetBossImages[this.state].getHeight() + Constants.MAGNETO_WAVES[1]);
            ++this.animationFrame;
            if (this.animationFrame > 2) {
                this.animationFrame = 0;
            }
        }
        ImagesResources.magnetBossImages[this.state].draw(g, this.xR + shiftX + this.xAdd, this.yR + shiftY + this.yAdd);
    }

    public void startBoss() {
        this.isBossComing = true;
        this.yAdd = -200;
    }

    public void finishMagneton() {
        this.isBossExiting = true;
        this.yAdd = 0;
    }

    public void activate() {
        this.isActive = true;
        if (!this.isFinalBoss) {
            Board.getInstance().activateBossEffect(this);
        } else {
            this.isElectroCellUpping = true;
        }
    }

    public void deactivate() {
        this.isActive = false;
        this.isDisplayed = false;
        this.isBossExited = true;
        this.isBossExiting = false;
    }

    public void nextMove() {
        --this.numMoves;
        if (this.numMoves <= 0) {
            this.isBossExiting = true;
            if (!this.exitSoundPlayed) {
                SoundSystem.play(17);
                this.exitSoundPlayed = true;
            }
        }
    }

    public void addCell(int x, int y) {
        if (this.cellsCount == this.cells.length) {
            int[][] tmp = new int[this.cellsCount + 16][];
            System.arraycopy(this.cells, 0, tmp, 0, this.cellsCount);
            this.cells = tmp;
        }
        this.cells[this.cellsCount++] = new int[]{x, y};
    }

    public void finishBoss() {
    }
}

