/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.component.Field;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CustomTextBox
extends Field {
    private static final int INITIAL_COUNT = 32;
    private static final int DEFAULT_STEP = 16;
    private String[] strings = new String[32];
    private int stringsCount = 0;
    private int fontHeight;
    private int fontColor;
    private boolean SCROLL;
    private int lastEventY;
    private int scrollPosition;
    private int delta;
    private int speed;
    private int begin;
    private boolean inertion;
    private int style = 20;
    private Font font;

    public CustomTextBox(int width, int height, Font font, int style) {
        this(width, height);
        this.font = font;
        this.style = 0x10 | style & 0xD;
    }

    public CustomTextBox(int width, int height, int textColor, int style) {
        this(width, height, textColor);
        this.style = 0x10 | style & 0xD;
    }

    private CustomTextBox(int width, int height, int textColor) {
        this.width = width;
        this.height = height;
        this.fontHeight = Font.getDefaultFont().getHeight();
        this.fontColor = textColor;
        this.font = Font.getFont((int)0, (int)0, (int)16);
    }

    private CustomTextBox(int width, int height) {
        this.width = width;
        this.height = height;
        this.fontHeight = Font.getDefaultFont().getHeight();
        this.fontColor = 0xFFFFFF;
    }

    public void onPaint(Graphics g) {
        g.setColor(this.fontColor);
        g.setFont(this.font);
        g.clipRect(this.left, this.top, this.width, this.height);
        int textLeft = this.left;
        if ((this.style & 1) != 0) {
            textLeft = this.left + this.width / 2;
        } else if ((this.style & 8) != 0) {
            textLeft = this.left + this.width;
        }
        for (int i = 0; i < this.stringsCount; ++i) {
            int y = this.top + i * this.fontHeight - this.scrollPosition;
            if (y > this.top + this.height || y + this.fontHeight < this.top) continue;
            String s = this.strings[i];
            g.drawString(s, textLeft, y, this.style);
        }
        g.setClip(0, 0, 640, 360);
    }

    public void onIdle() {
        if (this.inertion && this.begin > 10) {
            if (this.delta > 0) {
                this.scrollPosition -= this.speed * 2;
            } else if (this.delta < 0) {
                this.scrollPosition += this.speed * 2;
            }
            if (this.scrollPosition < 0) {
                this.scrollPosition = 0;
            } else if (this.scrollPosition > this.getMaxPosition()) {
                this.scrollPosition = this.getMaxPosition();
            }
            --this.speed;
            if (this.speed == 0) {
                this.inertion = false;
            }
            this.repaint(this.left, this.top, this.width, this.height);
        }
    }

    public void append(String text) {
        if (this.stringsCount == this.strings.length) {
            String[] tmp = new String[this.stringsCount + 16];
            System.arraycopy(this.strings, 0, tmp, 0, this.stringsCount);
            this.strings = tmp;
        }
        this.strings[this.stringsCount++] = text;
    }

    public void setText(String text) {
        int nextEndl;
        this.stringsCount = 0;
        int currEndl = 0;
        do {
            String[] tmp;
            if ((nextEndl = text.indexOf(10, currEndl + 1)) != -1) {
                if (currEndl == 0) {
                    if (this.stringsCount == this.strings.length) {
                        tmp = new String[this.stringsCount + 16];
                        System.arraycopy(this.strings, 0, tmp, 0, this.stringsCount);
                        this.strings = tmp;
                    }
                    this.strings[this.stringsCount++] = text.substring(currEndl, nextEndl);
                    continue;
                }
                if (this.stringsCount == this.strings.length) {
                    tmp = new String[this.stringsCount + 16];
                    System.arraycopy(this.strings, 0, tmp, 0, this.stringsCount);
                    this.strings = tmp;
                }
                this.strings[this.stringsCount++] = text.substring(currEndl + 1, nextEndl);
                continue;
            }
            if (currEndl == 0) {
                if (this.stringsCount == this.strings.length) {
                    tmp = new String[this.stringsCount + 16];
                    System.arraycopy(this.strings, 0, tmp, 0, this.stringsCount);
                    this.strings = tmp;
                }
                this.strings[this.stringsCount++] = text.substring(currEndl);
                continue;
            }
            if (this.stringsCount == this.strings.length) {
                tmp = new String[this.stringsCount + 16];
                System.arraycopy(this.strings, 0, tmp, 0, this.stringsCount);
                this.strings = tmp;
            }
            this.strings[this.stringsCount++] = text.substring(currEndl + 1);
        } while ((currEndl = nextEndl) != -1);
    }

    private int getMaxPosition() {
        return this.fontHeight * this.stringsCount - this.height / 2;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.SCROLL = true;
                this.lastEventY = eventY;
                this.begin = eventY;
                this.inertion = false;
                break;
            }
            case 1: {
                this.SCROLL = false;
                if (this.delta > 1 || this.delta < -1) {
                    this.inertion = true;
                    this.speed = 10;
                }
                this.begin = eventY - this.begin;
                if (this.begin >= 0) break;
                this.begin *= -1;
                break;
            }
            case 3: {
                if (!this.SCROLL) {
                    return false;
                }
                this.delta = eventY - this.lastEventY;
                this.scrollPosition -= this.delta;
                this.lastEventY = eventY;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                } else if (this.scrollPosition > this.getMaxPosition()) {
                    this.scrollPosition = this.getMaxPosition();
                }
                this.repaint(this.left, this.top, this.width, this.height);
            }
        }
        return !out;
    }

    public void setInertion(boolean inertion) {
        this.inertion = inertion;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setVerticalScroll(int pos) {
        this.scrollPosition = pos;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

