/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.CustomButtonField;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.components.LevelSelectorButton;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.LoadingScreen;
import com.ximad.braincube2.screens.WorldSelectorScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LevelSelectorScreen
extends UiScreen {
    private Application.XRunnable animator;
    private int animatorID = -1;
    private static LevelSelectorScreen instance;
    CustomManager layoutManager;
    private int selectedIndex;
    private int lastOpenedLevel;
    private LevelSelectorButton[] buttonsStack;
    private CustomButton unlockLevelButton;
    private CustomButtonField backButton;
    public static Font levelNumberFont;
    public Font totalScoreLabelFont;
    public Font totalScoreFont;
    volatile boolean isRunning = false;
    private long period = 80L;
    public long currentTime;
    private int totalScoreLabelX;
    private int totalScoreX;
    private String totalScore;
    private int world;
    private int[][] scores;
    private long initTime = System.currentTimeMillis();

    private LevelSelectorScreen(int iWorld, int iSelectedIndex) {
        this.world = iWorld;
        ImagesResources.initLevelSelector();
        this.state = 1;
        this.scores = DataManager.loadLevelsScore(this.world);
        this.lastOpenedLevel = this.getLastOpenedLevel();
        levelNumberFont = Utils.getFont(64, 0, 28);
        this.totalScoreLabelFont = Utils.getFont(64, 0, 20);
        this.totalScoreFont = Utils.getFont(64, 0, 22);
        this.totalScoreLabelX = Constants.LEVEL_SELECTOR_COORDS[29][0] - this.totalScoreLabelFont.stringWidth("Total score:") - 5;
        this.totalScore = String.valueOf(DataManager.getTotalScore());
        this.totalScoreX = Constants.LEVEL_SELECTOR_COORDS[29][0] - this.totalScoreFont.stringWidth(this.totalScore) - 5;
        this.initButtons();
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                ImagesResources.worldLevelSelectorBackground.draw(g, 0, 0);
                ImagesResources.levelSelectorSelectLevel.draw(g, Constants.LEVEL_SELECTOR_COORDS[26][0], Constants.LEVEL_SELECTOR_COORDS[26][1]);
                g.setColor(52214);
                g.setFont(LevelSelectorScreen.this.totalScoreLabelFont);
                g.drawString("Total score:", LevelSelectorScreen.this.totalScoreLabelX, Constants.LEVEL_SELECTOR_COORDS[27][0], 20);
                g.setFont(LevelSelectorScreen.this.totalScoreFont);
                g.drawString(LevelSelectorScreen.this.totalScore, LevelSelectorScreen.this.totalScoreX, Constants.LEVEL_SELECTOR_COORDS[28][0], 20);
                super.onPaint(g);
            }

            public void execute(int code) {
                for (int i = 0; i < 25; ++i) {
                    LevelSelectorScreen.this.buttonsStack[i].setPosition(Constants.LEVEL_SELECTOR_COORDS[i][0], Constants.LEVEL_SELECTOR_COORDS[i][1]);
                }
            }
        };
        for (int i = 0; i < 25; ++i) {
            this.layoutManager.add(this.buttonsStack[i], Constants.LEVEL_SELECTOR_COORDS[i][0], Constants.LEVEL_SELECTOR_COORDS[i][1]);
        }
        this.animator = new Application.XRunnable(){

            public void run() {
                Screen.repaint();
            }
        };
        this.animatorID = Application.invokeLater(this.animator, 80L, true);
        CustomButton backButton = new CustomButton(ImagesResources.backButtonInactive, ImagesResources.backButtonActive, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(WorldSelectorScreen.getInstance());
            }
        };
        this.layoutManager.add(backButton, 20, 283);
        this.selectedIndex = iSelectedIndex != -1 ? iSelectedIndex : this.lastOpenedLevel;
    }

    private int getLastOpenedLevel() {
        this.lastOpenedLevel = 0;
        for (int i = 0; i < 25; ++i) {
            if (this.scores[i][0] == 0) continue;
            this.lastOpenedLevel = i + 1;
        }
        if (this.lastOpenedLevel == 25) {
            this.lastOpenedLevel = 24;
            DataManager.unlockLevel(this.world);
        }
        return this.lastOpenedLevel;
    }

    private void closeScreen() {
    }

    private void initButtons() {
        if (this.buttonsStack == null) {
            this.buttonsStack = new LevelSelectorButton[25];
            for (int i = 0; i < 25; ++i) {
                final int index = i;
                this.buttonsStack[i] = i <= this.lastOpenedLevel || DataManager.levelsOpenIndicator[this.world] == 1 ? new LevelSelectorButton(true, i, this.scores[i][1], this.scores[i][2]){

                    public void touchAction() {
                        SoundSystem.playButtonSound();
                        if (((LevelSelectorScreen)LevelSelectorScreen.this).buttonsStack[index].isLevelEnabled || DataManager.levelsOpenIndicator[LevelSelectorScreen.this.world] == 1) {
                            LevelSelectorScreen.this.closeScreen();
                            if (DataManager.isSoundMusicEnabled) {
                                SoundSystem.stopBackgroundMusic();
                            }
                            Application.setScreen(LoadingScreen.getInstance(LevelSelectorScreen.this.world, index));
                        }
                    }
                } : new LevelSelectorButton(false, i, this.scores[i][1], this.scores[i][2]){

                    public void touchAction() {
                        SoundSystem.playButtonSound();
                        if (((LevelSelectorScreen)LevelSelectorScreen.this).buttonsStack[index].isLevelEnabled || DataManager.levelsOpenIndicator[LevelSelectorScreen.this.world] == 1) {
                            LevelSelectorScreen.this.closeScreen();
                            if (DataManager.isSoundMusicEnabled) {
                                SoundSystem.stopBackgroundMusic();
                            }
                            Application.setScreen(LoadingScreen.getInstance(LevelSelectorScreen.this.world, index));
                        }
                    }
                };
            }
        } else {
            for (int i = 0; i < 25; ++i) {
                this.buttonsStack[i].reinitialize(i <= this.lastOpenedLevel || DataManager.levelsOpenIndicator[this.world] == 1, i, this.scores[i][1], this.scores[i][2]);
            }
        }
    }

    public boolean onClose() {
        this.closeScreen();
        Application.setScreen(WorldSelectorScreen.getInstance());
        return true;
    }

    private boolean isMoveAllowed() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.initTime > 100L) {
            this.initTime = currTime;
            return true;
        }
        return false;
    }

    public void unlockLevels() {
        for (int i = 0; i < 25; ++i) {
            this.buttonsStack[i].enableLevel();
        }
        if (this.unlockLevelButton != null) {
            this.unlockLevelButton = null;
        }
        LevelSelectorScreen.repaint();
    }

    public void pause() {
        this.state = 0;
    }

    public void resume() {
        this.state = 1;
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public static LevelSelectorScreen getInstance(int iWorld, int iSelectedIndex) {
        if (instance == null) {
            instance = new LevelSelectorScreen(iWorld, iSelectedIndex);
        } else {
            instance.reinitialize(iWorld, iSelectedIndex);
        }
        return instance;
    }

    private void reinitialize(int iWorld, int iSelectedIndex) {
        this.world = iWorld;
        ImagesResources.initLevelSelector();
        this.state = 1;
        this.scores = DataManager.loadLevelsScore(this.world);
        this.lastOpenedLevel = this.getLastOpenedLevel();
        levelNumberFont = Utils.getFont(64, 0, 28);
        this.totalScoreLabelFont = Utils.getFont(64, 0, 20);
        this.totalScoreFont = Utils.getFont(64, 0, 22);
        this.totalScoreLabelX = Constants.LEVEL_SELECTOR_COORDS[29][0] - this.totalScoreLabelFont.stringWidth("Total score:") - 5;
        this.totalScore = String.valueOf(DataManager.getTotalScore());
        this.totalScoreX = Constants.LEVEL_SELECTOR_COORDS[29][0] - this.totalScoreFont.stringWidth(this.totalScore) - 5;
        this.initButtons();
        this.selectedIndex = iSelectedIndex != -1 ? iSelectedIndex : this.lastOpenedLevel;
        if (this.animatorID == -1) {
            this.animatorID = Application.invokeLater(this.animator, 80L, true);
        }
    }

    public void onHide() {
        Application.cancelInvokeLater(this.animatorID);
        this.animatorID = -1;
    }
}

