/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.Camera;
import com.ximad.braincube2.components.Cubes;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Bitmap;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class MagnetoGameScreen
extends GameScreen {
    private static MagnetoGameScreen instance_magneto;

    private MagnetoGameScreen(int iWorld, int iLevel) {
        super(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        ImagesResources.loadMagneto();
        Camera.getInstance().setShifts(Constants.MAGNETO_SHIFTS[0], Constants.MAGNETO_SHIFTS[1]);
        Camera.getInstance().smoothCenterCube(Cubes.getInstance().getActiveCube());
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                MagnetoGameScreen.this.bg.draw(g, 0, 0);
                if (MagnetoGameScreen.this.camera.isAnimationInProgress) {
                    MagnetoGameScreen.this.camera.makeSmoothAnimation();
                }
                MagnetoGameScreen.this.drawBoard(g);
                if (MagnetoGameScreen.this.isScrollingMode) {
                    ImagesResources.scrollingImage.draw(g, 0, 0);
                } else {
                    g.setColor(0xFFFFFF);
                    g.setFont(MagnetoGameScreen.this.boldOblicueFont);
                    int width = MagnetoGameScreen.this.boldOblicueFont.stringWidth(MagnetoGameScreen.this.moveCount);
                    g.drawString(MagnetoGameScreen.this.moveCount, 640 - width - 7, Constants.GAME_SCREEN_COORDS[3][1], 0);
                }
                super.onPaint(g);
            }
        };
        this.layoutManager.add(this.pauseButton, Constants.GAME_SCREEN_COORDS[4][0], Constants.GAME_SCREEN_COORDS[4][1]);
        this.layoutManager.add(this.scrollButton, Constants.GAME_SCREEN_COORDS[5][0], Constants.GAME_SCREEN_COORDS[5][1]);
        this.layoutManager.arrangeChild();
        this.startGame();
        this.layoutManager.execute(0);
    }

    public void openWorldSelector() {
        super.openWorldSelector();
    }

    public void onPaint(Graphics g) {
        this.layoutManager.onPaint(g);
    }

    public static MagnetoGameScreen getInstance(int iWorld, int iLevel) {
        if (instance_magneto == null) {
            instance_magneto = new MagnetoGameScreen(iWorld, iLevel);
        } else {
            instance_magneto.reinitialize(iWorld, iLevel);
        }
        return instance_magneto;
    }

    protected void reinitialize(int iWorld, int iLevel) {
        super.reinitialize(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        ImagesResources.loadMagneto();
        Camera.getInstance().setShifts(Constants.MAGNETO_SHIFTS[0], Constants.MAGNETO_SHIFTS[1]);
        Camera.getInstance().smoothCenterCube(Cubes.getInstance().getActiveCube());
        this.layoutManager.arrangeChild();
        this.startGame();
        this.layoutManager.execute(0);
    }
}

