/*
 * Decompiled with CFR 0.152.
 */
package CubeCode;

import CubeCode.Cubelet;
import Puzzle3D.Coord2D;
import Puzzle3D.Coord3D;
import Puzzle3D.Matrix;
import Puzzle3D.Polyhedron;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Cube
extends Polyhedron {
    public final int TWISTSTEPS;
    private int cubeletSizeK;
    private Cubelet[][][] cubelet;
    private Coord3D[][][] vertex;
    private Coord2D[][][] uPoints;
    private Coord2D[][][] rPoints;
    private Matrix C = new Matrix();
    private final int SIN_STEP_K;
    private final int COS_STEP_K;
    private boolean twisted = false;
    private boolean drawingUnrotatedPart = false;
    private boolean drawingObscuredPart = false;
    private int spinAxis = 0;
    private boolean spinClockwise = true;
    private int numStepsDone;
    private int screenWidth;
    private int screenHeight;
    private Random randFace = new Random();
    private Random randDir = new Random();
    private final int COS30K;
    private final int SIN30K;

    public void saveMe(DataOutputStream outputStream) throws IOException {
        int segColour = -1;
        int f = 0;
        while (f < 3) {
            int s = 0;
            while (s < 2) {
                int m = 0;
                while (m < 2) {
                    int n = 0;
                    while (n < 2) {
                        if (f == 0) {
                            segColour = this.cubelet[s][m][n].getColour(0);
                        }
                        if (f == 1) {
                            segColour = this.cubelet[m][s][n].getColour(1);
                        }
                        if (f == 2) {
                            segColour = this.cubelet[m][n][s].getColour(2);
                        }
                        outputStream.writeInt(segColour);
                        ++n;
                    }
                    ++m;
                }
                ++s;
            }
            ++f;
        }
    }

    public void loadMe(DataInputStream inputStream) throws EOFException, IOException {
        int f = 0;
        while (f < 3) {
            int s = 0;
            while (s < 2) {
                int m = 0;
                while (m < 2) {
                    int n = 0;
                    while (n < 2) {
                        int segColour = inputStream.readInt();
                        if (f == 0) {
                            this.cubelet[s][m][n].setColour(0, segColour);
                        }
                        if (f == 1) {
                            this.cubelet[m][s][n].setColour(1, segColour);
                        }
                        if (f == 2) {
                            this.cubelet[m][n][s].setColour(2, segColour);
                        }
                        ++n;
                    }
                    ++m;
                }
                ++s;
            }
            ++f;
        }
    }

    public void initMe() {
        this.unjumble();
    }

    public boolean jumbled() {
        boolean jumbledState = false;
        int currentFace = -1;
        int faceColour = -1;
        int segColour = -1;
        int f = 0;
        while (f < 3) {
            int s = 0;
            while (s < 2) {
                int thisFace = 2 * f + s;
                int m = 0;
                while (m < 2) {
                    int n = 0;
                    while (n < 2) {
                        if (f == 0) {
                            segColour = this.cubelet[s][m][n].getColour(0);
                        }
                        if (f == 1) {
                            segColour = this.cubelet[m][s][n].getColour(1);
                        }
                        if (f == 2) {
                            segColour = this.cubelet[m][n][s].getColour(2);
                        }
                        if (thisFace != currentFace) {
                            currentFace = thisFace;
                            faceColour = segColour;
                        } else if (segColour != faceColour) {
                            jumbledState = true;
                        }
                        ++n;
                    }
                    ++m;
                }
                ++s;
            }
            ++f;
        }
        return jumbledState;
    }

    private int abs(int x) {
        if (x > 0) {
            return x;
        }
        return -x;
    }

    private void invisibleRandomRotate() {
    }

    public void nPuzzle(int n) {
        this.unjumble();
        int NUMFACES = 3;
        int MAXTWISTS = 3;
        int face = this.abs(this.randFace.nextInt()) % 3;
        int i = 0;
        while (i < n) {
            int faceInc = this.abs(this.randFace.nextInt()) % 2;
            face += ++faceInc;
            int numTwists = 1 + this.abs(this.randDir.nextInt()) % 3;
            this.twistSegments(face %= 3, numTwists);
            ++i;
        }
        this.invisibleRandomRotate();
        this.straighten();
    }

    private void setColour(Graphics g, int colour) {
        switch (colour) {
            case 0: {
                g.setColor(255, 0, 0);
                break;
            }
            case 1: {
                g.setColor(255, 255, 255);
                break;
            }
            case 2: {
                g.setColor(0, 0, 255);
                break;
            }
            case 3: {
                g.setColor(0, 255, 255);
                break;
            }
            case 4: {
                g.setColor(255, 192, 0);
                break;
            }
            case 5: {
                g.setColor(192, 128, 255);
                break;
            }
            default: {
                g.setColor(0, 0, 0);
            }
        }
    }

    public void unjumble() {
        int D = 2;
        int x = 0;
        while (x < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    if (x == 0) {
                        this.cubelet[x][y][z].setColour(0, 0);
                    } else {
                        this.cubelet[x][y][z].setColour(0, 1);
                    }
                    if (y == 0) {
                        this.cubelet[x][y][z].setColour(1, 2);
                    } else {
                        this.cubelet[x][y][z].setColour(1, 3);
                    }
                    if (z == 0) {
                        this.cubelet[x][y][z].setColour(2, 4);
                    } else {
                        this.cubelet[x][y][z].setColour(2, 5);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void twistSegments(int face, int numTwists) {
        this.spinAxis = face;
        int i = 0;
        while (i < numTwists) {
            this.twistSegments();
            ++i;
        }
    }

    public void twistSegments() {
        Cubelet save = new Cubelet();
        switch (this.spinAxis) {
            case 0: {
                save.setColour(0, this.cubelet[0][0][0].getColour(0));
                save.setColour(1, this.cubelet[0][0][0].getColour(1));
                save.setColour(2, this.cubelet[0][0][0].getColour(2));
                this.cubelet[0][0][0].setColour(0, this.cubelet[0][1][0].getColour(0));
                this.cubelet[0][0][0].setColour(1, this.cubelet[0][1][0].getColour(2));
                this.cubelet[0][0][0].setColour(2, this.cubelet[0][1][0].getColour(1));
                this.cubelet[0][1][0].setColour(0, this.cubelet[0][1][1].getColour(0));
                this.cubelet[0][1][0].setColour(1, this.cubelet[0][1][1].getColour(2));
                this.cubelet[0][1][0].setColour(2, this.cubelet[0][1][1].getColour(1));
                this.cubelet[0][1][1].setColour(0, this.cubelet[0][0][1].getColour(0));
                this.cubelet[0][1][1].setColour(1, this.cubelet[0][0][1].getColour(2));
                this.cubelet[0][1][1].setColour(2, this.cubelet[0][0][1].getColour(1));
                this.cubelet[0][0][1].setColour(0, save.getColour(0));
                this.cubelet[0][0][1].setColour(1, save.getColour(2));
                this.cubelet[0][0][1].setColour(2, save.getColour(1));
                break;
            }
            case 1: {
                save.setColour(1, this.cubelet[0][0][0].getColour(1));
                save.setColour(2, this.cubelet[0][0][0].getColour(2));
                save.setColour(0, this.cubelet[0][0][0].getColour(0));
                this.cubelet[0][0][0].setColour(1, this.cubelet[0][0][1].getColour(1));
                this.cubelet[0][0][0].setColour(2, this.cubelet[0][0][1].getColour(0));
                this.cubelet[0][0][0].setColour(0, this.cubelet[0][0][1].getColour(2));
                this.cubelet[0][0][1].setColour(1, this.cubelet[1][0][1].getColour(1));
                this.cubelet[0][0][1].setColour(2, this.cubelet[1][0][1].getColour(0));
                this.cubelet[0][0][1].setColour(0, this.cubelet[1][0][1].getColour(2));
                this.cubelet[1][0][1].setColour(1, this.cubelet[1][0][0].getColour(1));
                this.cubelet[1][0][1].setColour(2, this.cubelet[1][0][0].getColour(0));
                this.cubelet[1][0][1].setColour(0, this.cubelet[1][0][0].getColour(2));
                this.cubelet[1][0][0].setColour(1, save.getColour(1));
                this.cubelet[1][0][0].setColour(2, save.getColour(0));
                this.cubelet[1][0][0].setColour(0, save.getColour(2));
                break;
            }
            case 2: {
                save.setColour(2, this.cubelet[0][0][0].getColour(2));
                save.setColour(0, this.cubelet[0][0][0].getColour(0));
                save.setColour(1, this.cubelet[0][0][0].getColour(1));
                this.cubelet[0][0][0].setColour(2, this.cubelet[1][0][0].getColour(2));
                this.cubelet[0][0][0].setColour(0, this.cubelet[1][0][0].getColour(1));
                this.cubelet[0][0][0].setColour(1, this.cubelet[1][0][0].getColour(0));
                this.cubelet[1][0][0].setColour(2, this.cubelet[1][1][0].getColour(2));
                this.cubelet[1][0][0].setColour(0, this.cubelet[1][1][0].getColour(1));
                this.cubelet[1][0][0].setColour(1, this.cubelet[1][1][0].getColour(0));
                this.cubelet[1][1][0].setColour(2, this.cubelet[0][1][0].getColour(2));
                this.cubelet[1][1][0].setColour(0, this.cubelet[0][1][0].getColour(1));
                this.cubelet[1][1][0].setColour(1, this.cubelet[0][1][0].getColour(0));
                this.cubelet[0][1][0].setColour(2, save.getColour(2));
                this.cubelet[0][1][0].setColour(0, save.getColour(1));
                this.cubelet[0][1][0].setColour(1, save.getColour(0));
            }
        }
    }

    public void rotateSegments() {
    }

    private void fillPolygon(Graphics g, Coord2D a, Coord2D b, Coord2D c, Coord2D d) {
        int[] x = new int[5];
        int[] y = new int[5];
        x[0] = a.x;
        x[1] = b.x;
        x[2] = c.x;
        x[3] = d.x;
        y[0] = a.y;
        y[1] = b.y;
        y[2] = c.y;
        y[3] = d.y;
        x[4] = x[0];
        y[4] = y[0];
        Coord2D.fillPolygon(g, x, y, 5);
    }

    private void drawPolygon(Graphics g, Coord2D a, Coord2D b, Coord2D c, Coord2D d) {
        g.drawLine(a.x, a.y, b.x, b.y);
        g.drawLine(b.x, b.y, c.x, c.y);
        g.drawLine(c.x, c.y, d.x, d.y);
        g.drawLine(d.x, d.y, a.x, a.y);
    }

    private void drawMask(Graphics g) {
    }

    private Coord2D interpolate(int percent, Coord2D a, Coord2D b) {
        Coord2D res = new Coord2D();
        res.x = (percent * a.x + (100 - percent) * b.x) / 100;
        res.y = (percent * a.y + (100 - percent) * b.y) / 100;
        return res;
    }

    private Coord2D average(Coord2D a, Coord2D b) {
        Coord2D res = new Coord2D();
        res.x = (a.x + b.x) / 2;
        res.y = (a.y + b.y) / 2;
        return res;
    }

    private void paintAFace(Graphics g, Coord2D a, Coord2D b, Coord2D c, Coord2D d) {
        Coord2D s;
        Coord2D r;
        Coord2D q;
        Coord2D p;
        Coord2D centre = this.average(a, c);
        if (this.drawingObscuredPart) {
            p = this.interpolate(45, a, centre);
            q = this.interpolate(45, b, centre);
            r = this.interpolate(45, c, centre);
            s = this.interpolate(45, d, centre);
        } else {
            p = this.interpolate(62, a, centre);
            q = this.interpolate(62, b, centre);
            r = this.interpolate(62, c, centre);
            s = this.interpolate(62, d, centre);
        }
        this.fillPolygon(g, p, q, r, s);
        if (!this.drawingObscuredPart) {
            g.setColor(0, 0, 0);
            this.drawPolygon(g, p, q, r, s);
        }
    }

    private void unrotateVertices() {
        int K = this.cubeletSizeK;
        int D = 2;
        int x = 0;
        while (x < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    this.vertex[x][y][z].set(K - 2 * x * K, K - 2 * y * K, K - 2 * z * K);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private Coord2D project(Coord3D p) {
        Coord2D q = new Coord2D();
        q.x = this.XORIGIN + 866 * (p.yK - p.xK) / 1000000;
        q.y = this.YORIGIN + 500 * (p.xK + p.yK) / 1000000 - p.zK / 1000;
        return q;
    }

    private void set2DPoints(Coord2D[][][] p) {
        int D = 2;
        int x = 0;
        while (x < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    p[2 * x][2 * y][2 * z] = this.project(this.vertex[x][y][z]);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        p[0][0][1] = this.average(p[0][0][0], p[0][0][2]);
        p[0][1][0] = this.average(p[0][0][0], p[0][2][0]);
        p[0][2][1] = this.average(p[0][2][0], p[0][2][2]);
        p[0][1][2] = this.average(p[0][0][2], p[0][2][2]);
        p[1][0][0] = this.average(p[0][0][0], p[2][0][0]);
        p[1][0][2] = this.average(p[0][0][2], p[2][0][2]);
        p[1][2][0] = this.average(p[0][2][0], p[2][2][0]);
        p[1][2][2] = this.average(p[0][2][2], p[2][2][2]);
        p[2][0][1] = this.average(p[2][0][0], p[2][0][2]);
        p[2][1][0] = this.average(p[2][0][0], p[2][2][0]);
        p[2][2][1] = this.average(p[2][2][0], p[2][2][2]);
        p[2][1][2] = this.average(p[2][0][2], p[2][2][2]);
        p[0][1][1] = this.average(p[0][0][0], p[0][2][2]);
        p[2][1][1] = this.average(p[2][0][0], p[2][2][2]);
        p[1][0][1] = this.average(p[0][0][0], p[2][0][2]);
        p[1][2][1] = this.average(p[0][2][0], p[2][2][2]);
        p[1][1][0] = this.average(p[0][0][0], p[2][2][0]);
        p[1][1][2] = this.average(p[0][0][2], p[2][2][2]);
        p[1][1][1] = this.average(p[0][0][0], p[2][2][2]);
    }

    private boolean setStrokeType(Graphics g, int axis, int y, int z) {
        boolean obscured = false;
        int relativeAxis = (3 + this.spinAxis - axis) % 3;
        if (this.numStepsDone < 2 | this.drawingUnrotatedPart) {
            if (y == 2 & z == 2) {
                obscured = true;
            }
            if (y == 1 & z == 2) {
                obscured = true;
            }
            if (y == 2 & z == 1) {
                obscured = true;
            }
        } else if (this.spinClockwise) {
            switch (relativeAxis) {
                case 0: {
                    if (y == 0 & z == 2) {
                        obscured = true;
                    }
                    if (y == 0 & z == 1) {
                        obscured = true;
                    }
                    if (!(y == 1 & z == 2)) break;
                    obscured = true;
                    break;
                }
                case 1: {
                    if (y == 2 & z == 0) {
                        obscured = true;
                    }
                    if (y == 1 & z == 0) {
                        obscured = true;
                    }
                    if (!(y == 2 & z == 1)) break;
                    obscured = true;
                    break;
                }
                case 2: {
                    if (y == 2 & z == 2) {
                        obscured = true;
                    }
                    if (y == 1 & z == 2) {
                        obscured = true;
                    }
                    if (!(y == 2 & z == 1)) break;
                    obscured = true;
                }
            }
        }
        if (obscured) {
            g.setColor(128, 128, 128);
        } else {
            g.setColor(192, 192, 192);
        }
        return obscured;
    }

    private void drawLine(Graphics g, Coord2D a, Coord2D b) {
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    private void paintLinesLayer(Graphics g, boolean frontLayer) {
        boolean obscured;
        int D = 3;
        boolean backLayer = !frontLayer;
        int y = 0;
        while (y < D) {
            int z = 0;
            while (z < D) {
                if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                    this.drawLine(g, this.rPoints[0][y][z], this.rPoints[2][y][z]);
                }
                ++z;
            }
            ++y;
        }
        int x = 0;
        while (x < D) {
            int z = 0;
            while (z < D) {
                if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                    this.drawLine(g, this.rPoints[x][0][z], this.rPoints[x][2][z]);
                }
                ++z;
            }
            ++x;
        }
        int x2 = 0;
        while (x2 < D) {
            int y2 = 0;
            while (y2 < D) {
                if (!(x2 == 1 & y2 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x2, y2))) {
                    this.drawLine(g, this.rPoints[x2][y2][0], this.rPoints[x2][y2][2]);
                }
                ++y2;
            }
            ++x2;
        }
    }

    private void XhalfPaintLinesLayer(Graphics g, boolean frontLayer) {
        boolean obscured;
        Coord2D[][][] p = this.drawingUnrotatedPart ? this.uPoints : this.rPoints;
        int D = 3;
        boolean backLayer = !frontLayer;
        int x1 = this.drawingUnrotatedPart ? 1 : 0;
        int x2 = x1 + 1;
        int y = 0;
        while (y < D) {
            int z = 0;
            while (z < D) {
                if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                    this.drawLine(g, p[x1][y][z], p[x2][y][z]);
                }
                ++z;
            }
            ++y;
        }
        if (this.drawingUnrotatedPart) {
            x1 = 2;
            x2 = 3;
        } else {
            x1 = 0;
            x2 = 2;
        }
        int x = x1;
        while (x < x2) {
            int z = 0;
            while (z < D) {
                if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                    this.drawLine(g, p[x][0][z], p[x][2][z]);
                }
                ++z;
            }
            ++x;
        }
        int x3 = x1;
        while (x3 < x2) {
            int y2 = 0;
            while (y2 < D) {
                if (!(x3 == 1 & y2 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x3, y2))) {
                    this.drawLine(g, p[x3][y2][0], p[x3][y2][2]);
                }
                ++y2;
            }
            ++x3;
        }
    }

    private void YhalfPaintLinesLayer(Graphics g, boolean frontLayer) {
        boolean backLayer;
        int D = 3;
        boolean bl = backLayer = !frontLayer;
        if (this.drawingUnrotatedPart) {
            boolean obscured;
            int y = 2;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                        this.drawLine(g, this.uPoints[0][y][z], this.uPoints[2][y][z]);
                    }
                    ++z;
                }
                ++y;
            }
            int x = 0;
            while (x < D) {
                int z = 0;
                while (z < D) {
                    if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                        this.drawLine(g, this.uPoints[x][1][z], this.uPoints[x][2][z]);
                    }
                    ++z;
                }
                ++x;
            }
            int x2 = 0;
            while (x2 < D) {
                int y2 = 2;
                while (y2 < D) {
                    if (!(x2 == 1 & y2 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x2, y2))) {
                        this.drawLine(g, this.uPoints[x2][y2][0], this.uPoints[x2][y2][2]);
                    }
                    ++y2;
                }
                ++x2;
            }
        } else {
            boolean obscured;
            int y = 0;
            while (y < 2) {
                int z = 0;
                while (z < D) {
                    if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                        this.drawLine(g, this.rPoints[0][y][z], this.rPoints[2][y][z]);
                    }
                    ++z;
                }
                ++y;
            }
            int x = 0;
            while (x < D) {
                int z = 0;
                while (z < D) {
                    if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                        this.drawLine(g, this.rPoints[x][0][z], this.rPoints[x][1][z]);
                    }
                    ++z;
                }
                ++x;
            }
            int x3 = 0;
            while (x3 < D) {
                int y3 = 0;
                while (y3 < 2) {
                    if (!(x3 == 1 & y3 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x3, y3))) {
                        this.drawLine(g, this.rPoints[x3][y3][0], this.rPoints[x3][y3][2]);
                    }
                    ++y3;
                }
                ++x3;
            }
        }
    }

    private void ZhalfPaintLinesLayer(Graphics g, boolean frontLayer) {
        boolean backLayer;
        int D = 3;
        boolean bl = backLayer = !frontLayer;
        if (this.drawingUnrotatedPart) {
            boolean obscured;
            int y = 0;
            while (y < D) {
                int z = 2;
                while (z < D) {
                    if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                        this.drawLine(g, this.uPoints[0][y][z], this.uPoints[2][y][z]);
                    }
                    ++z;
                }
                ++y;
            }
            int x = 0;
            while (x < D) {
                int z = 2;
                while (z < D) {
                    if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                        this.drawLine(g, this.uPoints[x][0][z], this.uPoints[x][2][z]);
                    }
                    ++z;
                }
                ++x;
            }
            int x2 = 0;
            while (x2 < D) {
                int y2 = 0;
                while (y2 < D) {
                    if (!(x2 == 1 & y2 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x2, y2))) {
                        this.drawLine(g, this.uPoints[x2][y2][1], this.uPoints[x2][y2][2]);
                    }
                    ++y2;
                }
                ++x2;
            }
        } else {
            boolean obscured;
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < 2) {
                    if (!(y == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 0, y, z))) {
                        this.drawLine(g, this.rPoints[0][y][z], this.rPoints[2][y][z]);
                    }
                    ++z;
                }
                ++y;
            }
            int x = 0;
            while (x < D) {
                int z = 0;
                while (z < 2) {
                    if (!(x == 1 & z == 1) && backLayer == (obscured = this.setStrokeType(g, 1, z, x))) {
                        this.drawLine(g, this.rPoints[x][0][z], this.rPoints[x][2][z]);
                    }
                    ++z;
                }
                ++x;
            }
            int x3 = 0;
            while (x3 < D) {
                int y3 = 0;
                while (y3 < D) {
                    if (!(x3 == 1 & y3 == 1) && backLayer == (obscured = this.setStrokeType(g, 2, x3, y3))) {
                        this.drawLine(g, this.rPoints[x3][y3][0], this.rPoints[x3][y3][1]);
                    }
                    ++y3;
                }
                ++x3;
            }
        }
    }

    private void halfPaintLinesLayer(Graphics g, boolean frontLayer) {
        switch (this.spinAxis) {
            case 0: {
                this.XhalfPaintLinesLayer(g, frontLayer);
                break;
            }
            case 1: {
                this.YhalfPaintLinesLayer(g, frontLayer);
                break;
            }
            case 2: {
                this.ZhalfPaintLinesLayer(g, frontLayer);
            }
        }
    }

    private boolean faceObscured(int face, int x, int y, int z) {
        boolean obscured = false;
        if (this.numStepsDone < 2 | this.drawingUnrotatedPart) {
            if (face == 0 & x == 1) {
                obscured = true;
            }
            if (face == 1 & y == 1) {
                obscured = true;
            }
            if (face == 2 & z == 1) {
                obscured = true;
            }
        } else {
            switch (this.spinAxis) {
                case 0: {
                    if (face == 0 & x == 1) {
                        obscured = true;
                    }
                    if (face == 1 & y == 0) {
                        obscured = true;
                    }
                    if (!(face == 2 & z == 1)) break;
                    obscured = true;
                    break;
                }
                case 1: {
                    if (face == 0 & x == 1) {
                        obscured = true;
                    }
                    if (face == 1 & y == 1) {
                        obscured = true;
                    }
                    if (!(face == 2 & z == 0)) break;
                    obscured = true;
                    break;
                }
                case 2: {
                    if (face == 0 & x == 0) {
                        obscured = true;
                    }
                    if (face == 1 & y == 1) {
                        obscured = true;
                    }
                    if (!(face == 2 & z == 1)) break;
                    obscured = true;
                }
            }
        }
        return obscured;
    }

    private boolean paintableFace(boolean frontLayer, int face, int x, int y, int z) {
        boolean paintable = true;
        boolean correctHalf = false;
        boolean twistedHalf = false;
        boolean correctLayer = true;
        if (this.twisted) {
            if (this.spinAxis == 0 & x == 0) {
                twistedHalf = true;
            }
            if (this.spinAxis == 1 & y == 0) {
                twistedHalf = true;
            }
            if (this.spinAxis == 2 & z == 0) {
                twistedHalf = true;
            }
            correctHalf = this.drawingUnrotatedPart != twistedHalf;
        } else {
            correctHalf = true;
        }
        correctLayer = frontLayer != this.faceObscured(face, x, y, z);
        paintable = correctHalf & correctLayer;
        return paintable;
    }

    private void facePaint(Graphics g, boolean frontLayer, int face, int x, int y, int z) {
        Coord2D[][][] p = this.drawingUnrotatedPart ? this.uPoints : this.rPoints;
        this.setColour(g, this.cubelet[x][y][z].getColour(face));
        int a = x;
        int b = y;
        int c = z;
        if (this.paintableFace(frontLayer, face, x, y, z)) {
            switch (face) {
                case 0: {
                    a += a;
                    this.paintAFace(g, p[a][b][c], p[a][b + 1][c], p[a][b + 1][c + 1], p[a][b][c + 1]);
                    break;
                }
                case 1: {
                    b += b;
                    this.paintAFace(g, p[a][b][c], p[a][b][c + 1], p[a + 1][b][c + 1], p[a + 1][b][c]);
                    break;
                }
                case 2: {
                    c += c;
                    this.paintAFace(g, p[a][b][c], p[a][b + 1][c], p[a + 1][b + 1][c], p[a + 1][b][c]);
                }
            }
        }
    }

    private void paintFacesLayer(Graphics g, boolean frontLayer) {
        this.drawingObscuredPart = !frontLayer;
        int face = 0;
        while (face < 3) {
            int x = 0;
            while (x < 2) {
                int y = 0;
                while (y < 2) {
                    int z = 0;
                    while (z < 2) {
                        this.facePaint(g, frontLayer, face, x, y, z);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            ++face;
        }
    }

    private void paintHalfCube(Graphics g) {
        this.paintFacesLayer(g, false);
        this.halfPaintLinesLayer(g, false);
        this.drawMask(g);
        this.paintFacesLayer(g, true);
        this.halfPaintLinesLayer(g, true);
    }

    private void paintTwistedCube(Graphics g) {
        this.drawingUnrotatedPart = true;
        this.paintHalfCube(g);
        this.drawingUnrotatedPart = false;
        this.paintHalfCube(g);
    }

    private void paintWholeCube(Graphics g) {
        this.drawingUnrotatedPart = false;
        this.paintFacesLayer(g, false);
        this.paintLinesLayer(g, false);
        this.drawMask(g);
        this.paintFacesLayer(g, true);
        this.paintLinesLayer(g, true);
    }

    public void setTwisted(boolean solidTwisted) {
        this.twisted = solidTwisted;
    }

    public void paint(Graphics g) {
        if (this.twisted) {
            this.paintTwistedCube(g);
        } else {
            this.paintWholeCube(g);
        }
    }

    public void straighten() {
        this.unrotateVertices();
        this.set2DPoints(this.rPoints);
        this.numStepsDone = 0;
    }

    public void setSpinVector(int axis, boolean clockwise) {
        this.spinClockwise = clockwise;
        int factor = clockwise ? 1 : -1;
        int a = 866;
        int b = factor * 500;
        this.spinAxis = axis;
        this.C.reset();
        switch (axis) {
            case 0: {
                this.C.yK[1] = a;
                this.C.yK[2] = b;
                this.C.zK[1] = -b;
                this.C.zK[2] = a;
                break;
            }
            case 1: {
                this.C.xK[0] = a;
                this.C.xK[2] = -b;
                this.C.zK[0] = b;
                this.C.zK[2] = a;
                break;
            }
            case 2: {
                this.C.xK[0] = a;
                this.C.xK[1] = b;
                this.C.yK[0] = -b;
                this.C.yK[1] = a;
            }
        }
    }

    public void doSpin() {
        int D = 2;
        int x = 0;
        while (x < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    this.vertex[x][y][z] = this.C.op(this.vertex[x][y][z]);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.set2DPoints(this.rPoints);
        ++this.numStepsDone;
    }

    private void setSize() {
        int hK = this.screenHeight * 1000;
        hK = hK * 225 / 1000;
        int wK = this.screenWidth * 1000;
        wK = wK * 250 / 1000;
        int K = hK;
        if (wK < hK) {
            K = wK;
        }
        this.cubeletSizeK = K;
    }

    private void allocateArrays() {
        this.cubelet = new Cubelet[2][2][2];
        this.vertex = new Coord3D[2][2][2];
        int D = 2;
        int x = 0;
        while (x < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    this.cubelet[x][y][z] = new Cubelet();
                    this.vertex[x][y][z] = new Coord3D();
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.uPoints = new Coord2D[3][3][3];
        this.rPoints = new Coord2D[3][3][3];
        D = 3;
        int x2 = 0;
        while (x2 < D) {
            int y = 0;
            while (y < D) {
                int z = 0;
                while (z < D) {
                    this.uPoints[x2][y][z] = new Coord2D();
                    this.rPoints[x2][y][z] = new Coord2D();
                    ++z;
                }
                ++y;
            }
            ++x2;
        }
    }

    public void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
    }

    public Cube(int screenWidth, int screenHeight) {
        this.TWISTSTEPS = 3;
        this.SIN_STEP_K = 500;
        this.COS_STEP_K = 866;
        this.COS30K = 866;
        this.SIN30K = 500;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.XORIGIN = screenWidth / 2;
        this.YORIGIN = screenHeight / 2;
        this.allocateArrays();
        this.setSize();
        this.straighten();
        this.set2DPoints(this.uPoints);
    }
}

