/*
 * Decompiled with CFR 0.152.
 */
package Puzzle3D;

import Puzzle3D.HallOfFame;
import Puzzle3D.PuzzleMidlet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class FameScreen
extends Form {
    private StringItem string1 = new StringItem("", "");
    private Command cmOK = new Command("\u0414\u0430\u043b\u0435\u0435", 4, 1);
    private Command cmBack = new Command("\u0421\u0434\u0435\u043b\u0430\u0442\u044c", 2, 1);
    private int numPuzzles;
    private HallOfFame[] hallOfFame;
    private int latestPlacingSecs = 0;
    private int latestHall = 0;
    private int latestPlacing = 0;
    private String defaultName;

    public String getDefaultName() {
        return this.defaultName;
    }

    public boolean placed(int hallNo, long elapsed) {
        this.latestHall = hallNo;
        this.latestPlacingSecs = (int)(elapsed / 1000L);
        this.latestPlacing = 0;
        this.latestPlacing = this.hallOfFame[hallNo].entries;
        int i = this.latestPlacing - 1;
        while (i >= 0) {
            if (this.latestPlacingSecs < this.hallOfFame[hallNo].secs[i]) {
                this.latestPlacing = i;
            }
            --i;
        }
        return this.latestPlacing < 10;
    }

    private String secsToString(int val) {
        int left = val;
        if (val >= 6000) {
            return "**:**";
        }
        int dig = left % 10;
        Integer digit = new Integer(dig);
        String str = digit.toString();
        dig = (left /= 10) % 6;
        digit = new Integer(dig);
        str = ":" + digit.toString() + str;
        dig = (left /= 6) % 10;
        digit = new Integer(dig);
        str = digit.toString() + str;
        dig = (left /= 10) % 10;
        digit = new Integer(dig);
        str = digit.toString() + str;
        return str;
    }

    public void showHall(int hallNo) {
        this.latestHall = hallNo;
        Integer puzzleNo = new Integer(hallNo + 2);
        this.setTitle("\u0412\u0440\u0435\u043c\u044f:" + puzzleNo.toString() + "-\u041f\u0430\u0437\u043b");
        String str = new String("");
        if (this.hallOfFame[hallNo].entries == 0) {
            this.string1.setLabel("");
            str = "" + puzzleNo.toString() + " \u041f\u0430\u0437\u043b \u0435\u0449\u0435 \u043d\u0435 \u0440\u0435\u0448\u0435\u043d";
        } else {
            this.string1.setLabel("\u041c\u0438\u043d:\u0441\u0435\u043a - \u0418\u043c\u044f:\n");
            int i = 0;
            while (i < this.hallOfFame[hallNo].entries) {
                str = str + this.secsToString(this.hallOfFame[hallNo].secs[i]) + "\u00a0- " + this.hallOfFame[hallNo].name[i] + "\n";
                ++i;
            }
        }
        this.string1.setText(str);
        PuzzleMidlet.setScreen((Displayable)this);
        System.gc();
    }

    private void showNextHall() {
        ++this.latestHall;
        if (this.latestHall == this.numPuzzles) {
            this.latestHall = 0;
        }
        this.showHall(this.latestHall);
    }

    public void addName(String name) {
        int hallNo = this.latestHall;
        this.defaultName = name;
        if (name == null | name.length() == 0) {
            name = "\u0421\u043a\u043e\u0440\u043e";
        }
        int i = this.hallOfFame[hallNo].entries;
        while (i > this.latestPlacing) {
            if (i < 10 & i > 0) {
                this.hallOfFame[hallNo].name[i] = this.hallOfFame[hallNo].name[i - 1];
                this.hallOfFame[hallNo].secs[i] = this.hallOfFame[hallNo].secs[i - 1];
            }
            --i;
        }
        if (this.hallOfFame[hallNo].entries < 10) {
            ++this.hallOfFame[hallNo].entries;
        }
        this.hallOfFame[hallNo].name[this.latestPlacing] = name;
        this.hallOfFame[hallNo].secs[this.latestPlacing] = this.latestPlacingSecs;
        this.showHall(hallNo);
    }

    public void this_commandPerformed(Command c, Displayable d) {
        if (c == this.cmOK) {
            this.showNextHall();
        } else if (c == this.cmBack) {
            PuzzleMidlet.setScreen((Displayable)PuzzleMidlet.tetraCanvas);
        }
    }

    public void saveMe(DataOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.defaultName);
        int i = 0;
        while (i < this.numPuzzles) {
            this.hallOfFame[i].saveMe(outputStream);
            ++i;
        }
    }

    public void loadMe(DataInputStream inputStream) throws EOFException, IOException {
        this.defaultName = inputStream.readUTF();
        int i = 0;
        while (i < this.numPuzzles) {
            this.hallOfFame[i].loadMe(inputStream);
            ++i;
        }
    }

    public void initMe() {
        this.defaultName = "";
        int i = 0;
        while (i < this.numPuzzles) {
            this.hallOfFame[i].initMe();
            ++i;
        }
    }

    private void jbInit() throws Exception {
        this.hallOfFame = new HallOfFame[this.numPuzzles];
        int i = 0;
        while (i < this.numPuzzles) {
            this.hallOfFame[i] = new HallOfFame();
            ++i;
        }
        this.addCommand(this.cmOK);
        this.addCommand(this.cmBack);
        this.append((Item)this.string1);
        this.defaultName = new String("");
    }

    public FameScreen(int numberOfPuzzles) {
        super("\u0420\u0435\u043a\u043e\u0440\u0434\u044b");
        this.numPuzzles = numberOfPuzzles;
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                FameScreen.this.this_commandPerformed(c, d);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

