/*
 * Decompiled with CFR 0.152.
 */
package Puzzle3D;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Stopwatch {
    private long completedIntervalsTotal;
    private long currentIntervalStart = System.currentTimeMillis();
    private boolean ticking = false;
    private int CLOCKX = 5;
    private int CLOCKY = 5;
    private Image clockPic;
    private Image counterPic;

    public int getWidth() {
        return this.clockPic.getWidth();
    }

    public int getHeight() {
        return this.clockPic.getHeight();
    }

    private void paintClockDigit(Graphics g, int val, int power) {
        int CHARWIDTH = 7;
        int CHARHEIGHT = 13;
        int GAP = 3;
        int XOFF = this.CLOCKX + 2;
        int YOFF = this.CLOCKY + 2;
        int xPos = XOFF + 7 * (3 - power);
        if (power <= 1) {
            xPos += 3;
        }
        int saveWidth = g.getClipWidth();
        int saveHeight = g.getClipHeight();
        g.setClip(xPos, YOFF, 7, 13);
        g.drawImage(this.counterPic, xPos, YOFF - 13 * val, 20);
        g.setClip(0, 0, saveWidth, saveHeight);
    }

    private void paintClockDigits(Graphics g, int val) {
        int left = val;
        int dig = left % 10;
        this.paintClockDigit(g, dig, 0);
        dig = (left /= 10) % 6;
        this.paintClockDigit(g, dig, 1);
        dig = (left /= 6) % 10;
        this.paintClockDigit(g, dig, 2);
        dig = (left /= 10) % 10;
        this.paintClockDigit(g, dig, 3);
    }

    public void paintTheClock(Graphics g) {
        if (this.elapsed() >= 6000000L) {
            return;
        }
        g.drawImage(this.clockPic, this.CLOCKX, this.CLOCKY, 20);
        int tim = (int)(this.elapsed() / 1000L);
        this.paintClockDigits(g, tim);
        System.gc();
    }

    public long elapsed() {
        if (this.ticking) {
            return this.completedIntervalsTotal + (System.currentTimeMillis() - this.currentIntervalStart);
        }
        return this.completedIntervalsTotal;
    }

    public void pause() {
        this.completedIntervalsTotal = this.elapsed();
        this.ticking = false;
    }

    public void unpause() {
        if (this.ticking) {
            this.pause();
        }
        this.currentIntervalStart = System.currentTimeMillis();
        this.ticking = true;
    }

    public void start() {
        this.completedIntervalsTotal = 0L;
        this.currentIntervalStart = System.currentTimeMillis();
        this.ticking = true;
    }

    public void saveMe(DataOutputStream outputStream) throws IOException {
        if (this.ticking) {
            this.pause();
        }
        outputStream.writeLong(this.completedIntervalsTotal);
    }

    public void loadMe(DataInputStream inputStream) throws EOFException, IOException {
        this.completedIntervalsTotal = inputStream.readLong();
    }

    public void initMe() {
        this.completedIntervalsTotal = 0L;
    }

    public Stopwatch(int x, int y) {
        this.CLOCKX = x;
        this.CLOCKY = y;
        try {
            this.counterPic = Image.createImage((String)"/Puzzle3D/res/counter.png");
        }
        catch (Exception e) {
            System.out.println("Exception reading counter image: " + e);
        }
        try {
            this.clockPic = Image.createImage((String)"/Puzzle3D/res/clock.png");
        }
        catch (Exception e) {
            System.out.println("Exception reading clock image: " + e);
        }
    }
}

