/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import LockemUp.BaseScreen;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class TitleScreen
extends BaseScreen {
    private static final int GAME_SCREEN_WIDTH = 96;
    private static final int GAME_SCREEN_HEIGHT = 80;
    private static final int DISAPPEAR_TIMER = 1;
    private static final String[] titles = new String[]{"res\\lock.bin", "res\\win.bin", "res\\lose.bin", "res\\help1.bin", "res\\help2.bin", "res\\help3.bin"};
    private int mode;
    private int timer;
    private int state;
    private boolean running;
    private boolean readyToPaint;
    private CommandListener listener;
    private byte[][] pixels = new byte[2][];
    private Image gameScreenImage;
    private ExtendedImage gameScreen;
    private boolean onSound;
    private Melody melody;

    public TitleScreen() {
        byte[] byArray;
        try {
            this.gameScreenImage = Image.createImage((int)96, (int)80);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.pixels[0] = this.ReadByteArray(titles[1], 960, 0);
            this.pixels[1] = this.ReadByteArray(titles[2], 960, 0);
            byArray = this.ReadByteArray(titles[0], 960, 0);
            this.gameScreen.setPixels(byArray, 0, 0, 96, 80);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        this.readyToPaint = true;
        this.timer = 1;
        this.mode = 100;
        this.state = 0;
        this.onSound = true;
        byArray = null;
        this.melody = this.createMelody(100);
        this.melody.play();
    }

    public void changeMode(int n, String string, String string2) {
        if (this.mode == 5) {
            return;
        }
        this.mode = n;
        if (this.mode < 2) {
            this.gameScreen.setPixels(this.pixels[n], 0, 0, 96, 80);
            if (this.onSound) {
                this.melody = this.createMelody(n);
                this.melody.play();
            }
            if (this.mode == 0) {
                Font font = Font.getFont((int)0, (int)1, (int)8);
                this.gameScreenImage.getGraphics().setFont(font);
                this.gameScreenImage.getGraphics().drawString(string, 51, 56, 20);
                this.gameScreenImage.getGraphics().drawString(string2, 51, 68, 20);
            }
        } else if (this.mode < 5) {
            byte[] byArray = this.ReadByteArray(titles[this.mode + 1], 960, 0);
            this.gameScreen.setPixels(byArray, 0, 0, 96, 80);
            byArray = null;
        } else {
            this.gameScreen.clear((byte)0);
            Font font = Font.getFont((int)0, (int)1, (int)8);
            this.gameScreenImage.getGraphics().setFont(font);
            int n2 = font.stringWidth("Saving best...");
            int n3 = font.getHeight();
            int n4 = (96 - n2) / 2;
            int n5 = (80 - n3) / 2;
            this.gameScreenImage.getGraphics().drawString("Saving best...", n4, n5, 20);
            this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 3, n3 + 3);
            this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 7, n3 + 7);
        }
        this.gameScreen.blitToScreen(3, 0);
        this.readyToPaint = true;
        this.state = 0;
    }

    public void setOnSound(boolean bl) {
        this.onSound = bl;
    }

    public void Dispose() {
        this.gameScreen = null;
        this.pixels = null;
        this.melody = null;
    }

    public void setStateValue(int n) {
        this.state = n;
        if (this.mode < 100) {
            this.gameScreen.clear((byte)0);
        }
        if (n < 4) {
            Font font = Font.getFont((int)0, (int)1, (int)8);
            this.gameScreenImage.getGraphics().setFont(font);
            if (this.mode < 100) {
                int n2 = font.stringWidth("Please wait...");
                int n3 = font.getHeight();
                int n4 = (96 - n2) / 2;
                int n5 = (80 - n3) / 2;
                this.gameScreenImage.getGraphics().drawString("Please wait...", n4, n5, 20);
                this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 3, n3 + 3);
                this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 7, n3 + 7);
            }
        }
        this.gameScreen.blitToScreen(3, 0);
    }

    public int getReturnValue() {
        return this.state;
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(20L);
                this.repaint();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
            if (this.state != 0) {
                this.running = false;
                continue;
            }
            if (this.mode <= 99 || this.timer <= 0) continue;
            --this.timer;
            if (this.timer > 0) continue;
            this.setStateValue(1);
        }
    }

    public void paint(Graphics graphics) {
        if (this.gameScreen != null && this.readyToPaint) {
            try {
                this.gameScreen.blitToScreen(3, 0);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }

    protected void keyPressed(int n) {
        if (n == -12) {
            this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
            return;
        }
        if (this.mode > 99) {
            this.setStateValue(1);
        } else if (this.mode >= 2 && this.mode <= 4) {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: 
                case 2: {
                    this.prevHelp();
                    break;
                }
                case 5: 
                case 6: {
                    this.nextHelp();
                }
            }
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.listener = commandListener;
    }

    public void nextHelp() {
        if (this.mode < 4) {
            this.changeMode(this.mode + 1, null, null);
        }
    }

    public void prevHelp() {
        if (this.mode > 2) {
            this.changeMode(this.mode - 1, null, null);
        }
    }

    private Melody createMelody(int n) {
        try {
            MelodyComposer melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(132);
            switch (n) {
                case 0: {
                    melodyComposer.appendNote(45, 5);
                    melodyComposer.appendNote(52, 5);
                    melodyComposer.appendNote(48, 5);
                    melodyComposer.appendNote(40, 5);
                    melodyComposer.appendNote(42, 5);
                    melodyComposer.appendNote(49, 5);
                    melodyComposer.appendNote(44, 5);
                    melodyComposer.appendNote(51, 5);
                    break;
                }
                case 1: {
                    melodyComposer.appendNote(24, 5);
                    melodyComposer.appendNote(19, 5);
                    melodyComposer.appendNote(15, 5);
                    melodyComposer.appendNote(14, 5);
                    melodyComposer.appendNote(24, 5);
                    melodyComposer.appendNote(19, 5);
                    melodyComposer.appendNote(15, 5);
                    melodyComposer.appendNote(14, 5);
                    break;
                }
                case 100: {
                    melodyComposer.appendNote(45, 5);
                    melodyComposer.appendNote(52, 5);
                    melodyComposer.appendNote(48, 5);
                    melodyComposer.appendNote(40, 5);
                    melodyComposer.appendNote(42, 5);
                    melodyComposer.appendNote(49, 5);
                    melodyComposer.appendNote(44, 5);
                    melodyComposer.appendNote(51, 5);
                }
            }
            return melodyComposer.getMelody();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return null;
        }
    }
}

