/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sprite;

public class BaseActor {
    private GraphicObjectManager gfxManager;
    private int curAction;
    private int totalActions;
    private int frameCounter;
    private int frameRate;
    private int curFrame;
    private int[] framesCountList;
    private byte[][] animationPixels;
    private byte[][] maskPixels;
    private Sprite[] sprites;
    private int xPos;
    private int yPos;
    private int width;
    private int height;
    private boolean isVisible;
    private boolean isEndOfAction;
    private boolean isRewind;
    private boolean isPlaying;

    public BaseActor(GraphicObjectManager graphicObjectManager, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.gfxManager = graphicObjectManager;
        this.totalActions = n;
        this.width = n2;
        this.height = n3;
        this.isRewind = bl;
        this.isPlaying = bl2;
        this.frameRate = 0;
        this.frameCounter = 0;
        this.curAction = -1;
        this.curFrame = 0;
        this.isVisible = false;
        this.framesCountList = new int[n];
        this.animationPixels = new byte[n][];
        this.maskPixels = new byte[n][];
        this.sprites = new Sprite[n];
    }

    public void Dispose() {
        this.gfxManager.deleteObject((GraphicObject)this.sprites[this.curAction]);
        int n = 0;
        while (n < this.totalActions) {
            this.animationPixels[n] = null;
            this.maskPixels[n] = null;
            ++n;
        }
        this.sprites = null;
        this.framesCountList = null;
    }

    public int appendAction(int n, byte[] byArray, byte[] byArray2, int n2) {
        if (n >= this.totalActions) {
            return 1;
        }
        this.animationPixels[n] = byArray;
        this.maskPixels[n] = byArray2;
        this.framesCountList[n] = n2;
        this.sprites[n] = new Sprite(this.animationPixels[n], 0, this.width, this.height, this.maskPixels[n], 0, n2);
        this.gfxManager.addObject((GraphicObject)this.sprites[n]);
        return 0;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        this.sprites[this.curAction].setVisible(this.isVisible);
    }

    public void setActionCollisionBox(int n, int n2, int n3, int n4, int n5) {
        this.sprites[n].setCollisionRectangle(n2, n3, n4, n5);
    }

    public Sprite getCurSprite() {
        return this.sprites[this.curAction];
    }

    public boolean isCollidedWith(BaseActor baseActor) {
        return this.sprites[this.curAction].isCollidingWith(baseActor.getCurSprite());
    }

    public void setPosition(int n, int n2) {
        this.xPos = n;
        this.yPos = n2;
    }

    public void setPositionX(int n) {
        this.xPos = n;
    }

    public void setPositionY(int n) {
        this.yPos = n;
    }

    public int getPositionX() {
        return this.xPos;
    }

    public int getPositionY() {
        return this.yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCurrentFrame() {
        return this.curFrame;
    }

    public int getCurrentTotalFrames() {
        return this.framesCountList[this.curAction];
    }

    public int getCurrentAction() {
        return this.curAction;
    }

    public int getTotalActions() {
        return this.totalActions;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public int changeToNewAction(int n) {
        if (n >= this.totalActions) {
            return 1;
        }
        if (this.curAction >= 0) {
            this.setVisible(false);
        }
        this.curAction = n;
        this.setVisible(true);
        this.isEndOfAction = false;
        this.curFrame = 0;
        this.sprites[this.curAction].setFrame(this.curFrame);
        return 0;
    }

    public void setCurrentFrame(int n) {
        if (n >= this.framesCountList[this.curAction]) {
            return;
        }
        this.curFrame = n;
        this.sprites[this.curAction].setFrame(this.curFrame);
    }

    public boolean isAnimationEnd() {
        return this.isEndOfAction;
    }

    public void frameActor() {
        if (this.isPlaying) {
            if (this.frameCounter == this.frameRate) {
                if (this.curFrame == this.framesCountList[this.curAction] - 1) {
                    if (this.isRewind) {
                        this.curFrame = 0;
                    }
                    this.isEndOfAction = true;
                } else {
                    this.isEndOfAction = false;
                    ++this.curFrame;
                }
                this.sprites[this.curAction].setFrame(this.curFrame);
                this.frameCounter = 0;
            } else {
                ++this.frameCounter;
            }
        }
        this.sprites[this.curAction].setPosition(this.xPos >> 8, this.yPos >> 8);
    }
}

