/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import LockemUp.BaseScreen;
import LockemUp.GameBoard;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObjectManager;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class GameScreen
extends BaseScreen {
    private static final int GAME_SCREEN_WIDTH = 88;
    private static final int GAME_SCREEN_HEIGHT = 77;
    private static final String MAP_DATA_FILE = "res\\maps.dat";
    private static final String MAP_TILE_FILE = "res\\wall.bin";
    private static final String MAP_TILE_ACTORS = "res\\actors.bin";
    private int mapNumber;
    private int iState;
    private boolean readyToPaint = false;
    private CommandListener listener;
    private boolean repaintBack;
    private Image gameScreenImage;
    private ExtendedImage gameScreen = null;
    private GraphicObjectManager gfxManager;
    private GameBoard back;

    public GameScreen(int n) {
        this.mapNumber = n;
        try {
            this.gameScreenImage = Image.createImage((int)88, (int)77);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.gameScreen.clear((byte)0);
            this.gfxManager = new GraphicObjectManager();
            byte[] byArray = this.ReadByteArray(MAP_DATA_FILE, 4, n * 2);
            int n2 = this.byteToInt(byArray[0]) * 256 + this.byteToInt(byArray[1]);
            int n3 = this.byteToInt(byArray[2]) * 256 + this.byteToInt(byArray[3]) - n2;
            byArray = this.ReadByteArray(MAP_DATA_FILE, n3, n2);
            byte[] byArray2 = this.ReadByteArray(MAP_TILE_FILE, 42, 0);
            byte[] byArray3 = this.ReadByteArray(MAP_TILE_ACTORS, 496, 0);
            switch (this.mapNumber) {
                case 0: 
                case 1: {
                    this.back = new GameBoard(this.gfxManager, byArray, byArray2, byArray3, 0);
                    break;
                }
                case 2: {
                    this.back = new GameBoard(this.gfxManager, byArray, byArray2, byArray3, 1);
                    break;
                }
                case 3: {
                    this.back = new GameBoard(this.gfxManager, byArray, byArray2, byArray3, 2);
                    break;
                }
                default: {
                    this.back = new GameBoard(this.gfxManager, byArray, byArray2, byArray3, 3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        this.readyToPaint = true;
        this.iState = 0;
        this.repaintBack = true;
    }

    public void reInit() {
        this.iState = 0;
        switch (this.mapNumber) {
            case 0: 
            case 1: {
                this.back.reInit(0);
                break;
            }
            case 2: {
                this.back.reInit(1);
                break;
            }
            case 3: {
                this.back.reInit(2);
                break;
            }
            default: {
                this.back.reInit(3);
            }
        }
        this.readyToPaint = true;
        this.repaintBack = true;
    }

    public void setOnSound(boolean bl) {
        this.back.setOnSound(bl);
    }

    public void setOnVibrate(boolean bl) {
        this.back.setOnVibrate(bl);
    }

    public void Dispose() {
        this.gameScreen = null;
        this.gfxManager = null;
        this.back.Dispose();
    }

    public void run() {
        boolean bl = true;
        while (bl) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = this.back.manageMoves();
            try {
                if (n > 0) {
                    this.gameScreen.clear((byte)0);
                } else {
                    this.gameScreen.setPixels(this.back.getBackground(), 0, 0, 88, 77);
                    this.gfxManager.paint(this.gameScreen, 0, 0);
                }
                this.repaint();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
            if (this.iState == 0 && n <= 0) continue;
            if (this.iState == 0) {
                this.iState = n;
            }
            bl = false;
        }
    }

    public void setRepaintFlag(boolean bl) {
        this.repaintBack = bl;
    }

    public int getReturnValue() {
        return this.iState;
    }

    public void setStateValue(int n) {
        this.iState = n;
        if (n > 0) {
            this.gameScreen.clear((byte)0);
            this.gameScreen.blitToScreen(2, 1);
            this.readyToPaint = false;
            this.repaintBack = false;
        }
    }

    public void paint(Graphics graphics) {
        if (this.repaintBack) {
            graphics.drawLine(0, 0, 0, 79);
            graphics.drawLine(90, 0, 90, 79);
            Image image = Image.createImage((int)8, (int)75);
            ExtendedImage extendedImage = new ExtendedImage(image);
            extendedImage.clear((byte)-127);
            byte[] byArray = this.ReadByteArray("res\\right.bin", 75, 0);
            extendedImage.setPixels(byArray, 0, 0, 8, 75);
            extendedImage.blitToScreen(92, 0);
            this.repaintBack = false;
        }
        if (this.gameScreen != null && this.readyToPaint) {
            try {
                this.gameScreen.blitToScreen(2, 1);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.listener = commandListener;
    }

    protected void keyPressed(int n) {
        if (n == -12) {
            this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
            return;
        }
        this.back.turnArrow(n - 48);
    }

    protected void keyReleased(int n) {
    }

    protected void keyRepeated(int n) {
    }

    private int byteToInt(byte n) {
        int n2 = n;
        if (n2 >= 0) {
            return n2;
        }
        return n2 += 256;
    }
}

