/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import LockemUp.BaseScreen;
import LockemUp.GameScreen;
import LockemUp.LevelScreen;
import LockemUp.TitleScreen;
import com.siemens.mp.game.Light;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class LockemUp
extends MIDlet
implements CommandListener {
    private static final String NEXT_COMMAND_LABEL = "Next map";
    private static final String EXIT_COMMAND_LABEL = "Exit";
    private static final String RESUME_COMMAND_LABEL = "Resume";
    private static final String RESTART_COMMAND_LABEL = "Restart";
    private static final String START_COMMAND_LABEL = "Start";
    private static final String MENU_COMMAND_LABEL = "Main menu";
    private static final String SOUND_ON_COMMAND_LABEL = "Sound On";
    private static final String SOUND_OFF_COMMAND_LABEL = "Sound Off";
    private static final String VIVRATE_ON_COMMAND_LABEL = "Vibration On";
    private static final String VIVRATE_OFF_COMMAND_LABEL = "Vibration Off";
    private static final String HELP_COMMAND_LABEL = "Help";
    private static final String NEXT_PAGE_COMMAND_LABEL = "Next page";
    private static final String PREV_PAGE_COMMAND_LABEL = "Prev page";
    private static final String QUIT_HELP_COMMAND_LABEL = "Quit Help";
    protected Command nextCommand;
    protected Command exitCommand = new Command("Exit", 1, 1);
    protected Command restartCommand;
    protected Command startCommand;
    protected Command menuCommand;
    protected Command soundOnCommand;
    protected Command soundOffCommand;
    protected Command vibrateOnCommand;
    protected Command vibrateOffCommand;
    protected Command helpCommand;
    protected Command nextPageCommand;
    protected Command prevPageCommand;
    protected Command quitHelpCommand;
    protected Command resumeCommand = new Command("Resume", 1, 1);
    private Display display;
    private int mapNumber = 0;
    private int oldMapNumber = 100;
    private boolean showLevel = true;
    private boolean onSound = true;
    private boolean onVibrate = true;
    private GameScreen gameScreen = null;
    private TitleScreen titleScreen = null;
    private LevelScreen levelScreen = null;

    public LockemUp() {
        this.nextCommand = new Command(NEXT_COMMAND_LABEL, 1, 1);
        this.restartCommand = new Command(RESTART_COMMAND_LABEL, 1, 1);
        this.startCommand = new Command(START_COMMAND_LABEL, 1, 1);
        this.menuCommand = new Command(MENU_COMMAND_LABEL, 1, 1);
        this.soundOnCommand = new Command(SOUND_ON_COMMAND_LABEL, 1, 1);
        this.soundOffCommand = new Command(SOUND_OFF_COMMAND_LABEL, 1, 1);
        this.vibrateOnCommand = new Command(VIVRATE_ON_COMMAND_LABEL, 1, 1);
        this.vibrateOffCommand = new Command(VIVRATE_OFF_COMMAND_LABEL, 1, 1);
        this.helpCommand = new Command(HELP_COMMAND_LABEL, 1, 1);
        this.nextPageCommand = new Command(NEXT_PAGE_COMMAND_LABEL, 1, 1);
        this.prevPageCommand = new Command(PREV_PAGE_COMMAND_LABEL, 1, 1);
        this.quitHelpCommand = new Command(QUIT_HELP_COMMAND_LABEL, 1, 1);
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (string == EXIT_COMMAND_LABEL || command == List.SELECT_COMMAND) {
            if (displayable == this.levelScreen) {
                this.levelScreen.removeCommand(this.startCommand);
                this.levelScreen.removeCommand(this.helpCommand);
                this.levelScreen.removeCommand(this.exitCommand);
                this.levelScreen.removeCommand(this.soundOnCommand);
                this.levelScreen.removeCommand(this.soundOffCommand);
                this.levelScreen.removeCommand(this.vibrateOnCommand);
                this.levelScreen.removeCommand(this.vibrateOffCommand);
                this.levelScreen.removeCommand(this.resumeCommand);
                this.levelScreen.setCommandListener(null);
            } else if (displayable == this.gameScreen) {
                this.gameScreen.removeCommand(this.menuCommand);
                this.gameScreen.removeCommand(this.exitCommand);
                this.gameScreen.removeCommand(this.soundOnCommand);
                this.gameScreen.removeCommand(this.soundOffCommand);
                this.gameScreen.removeCommand(this.vibrateOnCommand);
                this.gameScreen.removeCommand(this.vibrateOffCommand);
                this.gameScreen.removeCommand(this.resumeCommand);
                this.gameScreen.removeCommand(this.restartCommand);
                this.gameScreen.setCommandListener(null);
            } else if (displayable == this.titleScreen) {
                this.titleScreen.removeCommand(this.restartCommand);
                this.titleScreen.removeCommand(this.nextCommand);
                this.titleScreen.removeCommand(this.menuCommand);
                this.titleScreen.removeCommand(this.exitCommand);
                this.titleScreen.setCommandListener(null);
            }
            if (this.levelScreen != null) {
                this.titleScreen.changeMode(5, null, null);
                this.display.setCurrent((Displayable)this.titleScreen);
            }
            this.destroyApp(true);
        } else if (string == NEXT_COMMAND_LABEL) {
            this.mapNumber = this.levelScreen.getMapNum();
            this.titleScreen.setStateValue(3);
            this.titleScreen.removeCommand(this.nextCommand);
            this.titleScreen.removeCommand(this.menuCommand);
            this.titleScreen.removeCommand(this.exitCommand);
            this.titleScreen.setCommandListener(null);
        } else if (string == RESTART_COMMAND_LABEL) {
            if (displayable == this.titleScreen) {
                this.titleScreen.setStateValue(3);
                this.titleScreen.removeCommand(this.restartCommand);
                this.titleScreen.removeCommand(this.menuCommand);
                this.titleScreen.removeCommand(this.exitCommand);
                this.titleScreen.setCommandListener(null);
            } else if (displayable == this.gameScreen) {
                this.gameScreen.setStateValue(5);
                this.gameScreen.removeCommand(this.menuCommand);
                this.gameScreen.removeCommand(this.exitCommand);
                this.gameScreen.removeCommand(this.soundOnCommand);
                this.gameScreen.removeCommand(this.soundOffCommand);
                this.gameScreen.removeCommand(this.vibrateOnCommand);
                this.gameScreen.removeCommand(this.vibrateOffCommand);
                this.gameScreen.removeCommand(this.resumeCommand);
                this.gameScreen.removeCommand(this.restartCommand);
                this.gameScreen.setCommandListener(null);
            }
        } else if (string == START_COMMAND_LABEL) {
            if (this.levelScreen.getStringOfBestTime() != "LOCKED") {
                this.levelScreen.setStateValue(1);
                this.levelScreen.removeCommand(this.startCommand);
                this.levelScreen.removeCommand(this.helpCommand);
                this.levelScreen.removeCommand(this.exitCommand);
                this.levelScreen.removeCommand(this.soundOnCommand);
                this.levelScreen.removeCommand(this.soundOffCommand);
                this.levelScreen.removeCommand(this.vibrateOnCommand);
                this.levelScreen.removeCommand(this.vibrateOffCommand);
                this.levelScreen.removeCommand(this.resumeCommand);
                this.levelScreen.setCommandListener(null);
            } else {
                this.levelScreen.startBlink();
            }
        } else if (string == SOUND_ON_COMMAND_LABEL) {
            this.onSound = true;
            if (this.gameScreen != null) {
                this.gameScreen.setOnSound(true);
            }
            this.titleScreen.setOnSound(true);
            displayable.removeCommand(this.soundOnCommand);
            displayable.addCommand(this.soundOffCommand);
            if (displayable == this.gameScreen) {
                this.gameScreen.setRepaintFlag(true);
            }
        } else if (string == SOUND_OFF_COMMAND_LABEL) {
            this.onSound = false;
            if (this.gameScreen != null) {
                this.gameScreen.setOnSound(false);
            }
            this.titleScreen.setOnSound(false);
            displayable.removeCommand(this.soundOffCommand);
            displayable.addCommand(this.soundOnCommand);
            if (displayable == this.gameScreen) {
                this.gameScreen.setRepaintFlag(true);
            }
        } else if (string == VIVRATE_ON_COMMAND_LABEL) {
            this.onVibrate = true;
            if (this.gameScreen != null) {
                this.gameScreen.setOnVibrate(true);
            }
            displayable.removeCommand(this.vibrateOnCommand);
            displayable.addCommand(this.vibrateOffCommand);
            if (displayable == this.gameScreen) {
                this.gameScreen.setRepaintFlag(true);
            }
        } else if (string == VIVRATE_OFF_COMMAND_LABEL) {
            this.onVibrate = false;
            if (this.gameScreen != null) {
                this.gameScreen.setOnVibrate(false);
            }
            displayable.removeCommand(this.vibrateOffCommand);
            displayable.addCommand(this.vibrateOnCommand);
            if (displayable == this.gameScreen) {
                this.gameScreen.setRepaintFlag(true);
            }
        } else if (string == MENU_COMMAND_LABEL) {
            this.showLevel = true;
            if (displayable == this.gameScreen) {
                this.gameScreen.setStateValue(5);
                this.gameScreen.removeCommand(this.menuCommand);
                this.gameScreen.removeCommand(this.exitCommand);
                this.gameScreen.removeCommand(this.soundOnCommand);
                this.gameScreen.removeCommand(this.soundOffCommand);
                this.gameScreen.removeCommand(this.vibrateOnCommand);
                this.gameScreen.removeCommand(this.vibrateOffCommand);
                this.gameScreen.removeCommand(this.resumeCommand);
                this.gameScreen.removeCommand(this.restartCommand);
                this.gameScreen.setCommandListener(null);
            } else if (displayable == this.titleScreen) {
                this.titleScreen.removeCommand(this.restartCommand);
                this.titleScreen.removeCommand(this.nextCommand);
                this.titleScreen.removeCommand(this.menuCommand);
                this.titleScreen.removeCommand(this.exitCommand);
                this.titleScreen.setCommandListener(null);
                this.titleScreen.setStateValue(4);
            }
        } else if (string == HELP_COMMAND_LABEL) {
            this.levelScreen.setStateValue(50);
            this.levelScreen.removeCommand(this.startCommand);
            this.levelScreen.removeCommand(this.helpCommand);
            this.levelScreen.removeCommand(this.exitCommand);
            this.levelScreen.removeCommand(this.soundOnCommand);
            this.levelScreen.removeCommand(this.soundOffCommand);
            this.levelScreen.removeCommand(this.vibrateOnCommand);
            this.levelScreen.removeCommand(this.vibrateOffCommand);
            this.levelScreen.removeCommand(this.resumeCommand);
            this.levelScreen.setCommandListener(null);
        } else if (string == NEXT_PAGE_COMMAND_LABEL) {
            this.titleScreen.nextHelp();
        } else if (string == PREV_PAGE_COMMAND_LABEL) {
            this.titleScreen.prevHelp();
        } else if (string == QUIT_HELP_COMMAND_LABEL) {
            this.titleScreen.removeCommand(this.prevPageCommand);
            this.titleScreen.removeCommand(this.nextPageCommand);
            this.titleScreen.removeCommand(this.quitHelpCommand);
            this.titleScreen.setCommandListener(null);
            this.titleScreen.setStateValue(5);
        } else if (string == RESUME_COMMAND_LABEL && displayable == this.gameScreen) {
            this.gameScreen.setRepaintFlag(true);
        }
    }

    public int startScreen(BaseScreen baseScreen) {
        this.display.setCurrent((Displayable)baseScreen);
        Thread thread = new Thread(baseScreen);
        thread.start();
        while (thread.isAlive()) {
        }
        this.display.setCurrent(null);
        thread = null;
        int n = baseScreen.getReturnValue();
        return n;
    }

    protected void destroyApp(boolean bl) {
        if (bl && this.levelScreen != null) {
            this.levelScreen.saveRecords();
        }
        this.notifyDestroyed();
    }

    protected void pauseApp() {
        this.notifyPaused();
    }

    protected void startApp() {
        int n = 0;
        this.display = Display.getDisplay((MIDlet)this);
        Light.setLightOn();
        this.titleScreen = new TitleScreen();
        this.titleScreen.setCommandListener(this);
        this.startScreen(this.titleScreen);
        this.levelScreen = new LevelScreen();
        this.levelScreen.loadRecords();
        while (true) {
            if (this.showLevel) {
                this.levelScreen.addCommand(this.startCommand);
                this.levelScreen.addCommand(this.resumeCommand);
                this.levelScreen.addCommand(this.helpCommand);
                this.levelScreen.addCommand(this.exitCommand);
                if (this.onSound) {
                    this.levelScreen.addCommand(this.soundOffCommand);
                } else {
                    this.levelScreen.addCommand(this.soundOnCommand);
                }
                if (this.onVibrate) {
                    this.levelScreen.addCommand(this.vibrateOffCommand);
                } else {
                    this.levelScreen.addCommand(this.vibrateOnCommand);
                }
                this.levelScreen.setCommandListener(this);
                this.levelScreen.resetStateValue();
                this.mapNumber = this.startScreen(this.levelScreen);
                if (this.mapNumber < 40) {
                    this.showLevel = false;
                    continue;
                }
                this.titleScreen.changeMode(2, null, null);
                this.titleScreen.addCommand(this.quitHelpCommand);
                this.titleScreen.addCommand(this.nextPageCommand);
                this.titleScreen.addCommand(this.prevPageCommand);
                this.titleScreen.setCommandListener(this);
                this.startScreen(this.titleScreen);
                continue;
            }
            if (this.oldMapNumber == this.mapNumber) {
                this.gameScreen.reInit();
            } else {
                if (this.gameScreen != null) {
                    this.gameScreen.Dispose();
                    this.gameScreen = null;
                }
                System.gc();
                this.gameScreen = new GameScreen(this.mapNumber);
                this.gameScreen.setOnSound(this.onSound);
                this.gameScreen.setOnVibrate(this.onVibrate);
            }
            this.gameScreen.addCommand(this.resumeCommand);
            this.gameScreen.addCommand(this.restartCommand);
            this.gameScreen.addCommand(this.menuCommand);
            this.gameScreen.addCommand(this.exitCommand);
            if (this.onSound) {
                this.gameScreen.addCommand(this.soundOffCommand);
            } else {
                this.gameScreen.addCommand(this.soundOnCommand);
            }
            if (this.onVibrate) {
                this.gameScreen.addCommand(this.vibrateOffCommand);
            } else {
                this.gameScreen.addCommand(this.vibrateOnCommand);
            }
            this.gameScreen.setCommandListener(this);
            this.levelScreen.startTimer();
            n = this.startScreen(this.gameScreen);
            this.oldMapNumber = this.mapNumber;
            switch (n) {
                case 3: {
                    this.levelScreen.stopTimer();
                    this.levelScreen.saveRecords();
                    this.titleScreen.changeMode(0, this.levelScreen.getTimeOfThisTurn(), this.levelScreen.getStringOfBestTime());
                    this.levelScreen.nextMap();
                    this.titleScreen.addCommand(this.nextCommand);
                    this.titleScreen.addCommand(this.menuCommand);
                    this.titleScreen.addCommand(this.exitCommand);
                    this.titleScreen.setCommandListener(this);
                    if (this.startScreen(this.titleScreen) < 3) break;
                    n = 0;
                    break;
                }
                case 4: {
                    this.titleScreen.changeMode(1, null, null);
                    this.titleScreen.addCommand(this.restartCommand);
                    this.titleScreen.addCommand(this.menuCommand);
                    this.titleScreen.addCommand(this.exitCommand);
                    this.titleScreen.setCommandListener(this);
                    if (this.startScreen(this.titleScreen) < 3) break;
                    n = 0;
                    break;
                }
                case 5: {
                    n = 0;
                }
            }
            System.gc();
            if (n != 0) break;
        }
        Light.setLightOff();
        this.destroyApp(false);
    }
}

